library Set_Push;

uses
  Windows,
  messages,
  Commctrl,
  System.SysUtils;
type
  TName = Record
    Settings            :AnsiString;
    Notification        :AnsiString;
    Allow_Notification  :AnsiString;
  end;
const Names_window:array[0..1] of TName=( //Engl
                                          (Settings: 'Options';
                                           Notification:'Notifications';
                                           Allow_Notification:'Enable Push Notifications'),
                                           //Rus
                                          (Settings: '';
                                           Notification:'';
                                           Allow_Notification:' Push-')
                                         );
var
   windows_name:string;
   class_name:string;
   Hnd:hwnd;


{$R *.res}
{$Warnings off}
{$hints on}
{
procedure SaveToFile(str:string);
var
 f:TextFile;
 FileDir:String;
begin
 FileDir:='d:\file.txt';
AssignFile(f,FileDir);
if not FileExists(FileDir) then
 begin
  Rewrite(f);
  CloseFile(f);
 end;
Append(f);
Writeln(f,str);
Flush(f);
CloseFile(f);
end;   }
//--------------------------------------------------------------------------/
function FindFunc(h:hwnd; L:LPARAM): BOOL; stdcall;
var buff: ARRAY [0..255] OF WideChar;
begin
   result:=true;
   Hnd := 0;
   GetWindowText(h, buff, sizeof(buff));
   //SaveToFile(StrPas(buff));
   if((windows_name='') or (pos(windows_name, StrPas(buff))> 0)) then  begin
      GetClassName(h, buff, sizeof(buff));
      //SaveToFile(StrPas(buff));
      if ((class_name='') or (pos(class_name, StrPas(buff))> 0)) then begin
         Hnd := h;
         result:=false;
      end;
   end;
end;
function FindFuncOK(h:hwnd; L:LPARAM): BOOL; stdcall;
var buff: ARRAY [0..255] OF WideChar;
begin
   result:=true;
   Hnd := 0;
   GetClassName(h, buff, sizeof(buff));
   if (pos('Button', StrPas(buff))> 0) then begin
      GetWindowText(h, buff, sizeof(buff));
      if(Length(StrPas(buff))=2) then  begin
         Hnd := h;
         result:=false;
      end;
   end;
end;
//--------------------------------------------------------------------------/
function Find_Tab(AccountNumber:integer; Language:integer):Hwnd;
var
  HndButton, HndP:HWnd;
  HndMen :HMenu;
  i, idMen, IdBtn  :integer;
  WChars:array[0..255] of WideChar;
begin
   result:=0;
   //______searching for the window by an account number_________
   windows_name:=IntToStr(AccountNumber);
   class_name:='MetaTrader';
   EnumWindows(@FindFunc, 0);
   if (Hnd<>0) then begin
      windows.SetForegroundWindow(Hnd);
      //_____going through the menu________
      HndMen:=GetMenu(Hnd);
      if (GetMenuItemCount(HndMen)=7) then
          HndMen:=GetSubMenu(HndMen,4)
      else
          HndMen:=GetSubMenu(HndMen,5);
      idMen:=GetMenuItemID(HndMen,6);
      if idMen<>0 then begin
          PostMessage(Hnd,WM_COMMAND,idMen,0);
          //______searching for the child window______
          for i := 0 to 10000 do begin
             hnd:=FindWindow(nil, StringToWideChar(Names_window[Language].Settings, WChars, 256));
          end;
          if (Hnd<>0) then begin
            //______searching for the Notifications tab and the OK button______
             HndP:=Hnd;
             EnumChildWindows(HndP, @FindFuncOK, 0);
             result:=Hnd;
             Hnd:=FindWindowEx(HndP, 0, 'SysTabControl32', nil);
             SendMessage(Hnd, TCM_SETCURFOCUS, 5, 0);
             Hnd:=GetParent(Hnd);
             Hnd:=FindWindowEx(Hnd, 0, '#32770', StringToWideChar(Names_window[Language].Notification, WChars, 256));
          end;
      end;
   end;
end;
//--------------------------------------------------------------------------/
//                         Enable the option                                /
//--------------------------------------------------------------------------/
function Set_Check(AccountNumber:integer; Language:integer):boolean; export; stdcall;
var
  HndButton, HndP:HWnd;
  i:integer;
  WChars:array[0..255] of WideChar;
begin
   result:=false;
   HndButton:=Find_Tab(AccountNumber, Language);
   if ((HndButton<>0) and (Hnd<>0)) then begin
      Hnd:=FindWindowEx(Hnd, 0, 'Button', StringToWideChar(Names_window[Language].Allow_Notification, WChars, 256));
      if(Hnd<>0) then begin
         if (SendMessage(Hnd,BM_GETCHECK,0,0)<>BST_CHECKED) then
             SendMessage(Hnd,BM_SETCHECK,BST_CHECKED,0);
      end;
      I:=GetDlgCtrlID(HndButton);
      if I<>0 then begin
         SendMessage(GetParent(HndButton),WM_Command,MakeWParam(I,BN_CLICKED),HndButton);
         result:=Hnd<>0;
      end;
   end;
end;
//--------------------------------------------------------------------------/
//              Set ID values for sending notifications                    /
//--------------------------------------------------------------------------/
function Set_MetaQuotesID(AccountNumber:integer; Language:integer; Str_Set:string):boolean; export; stdcall;
var
  HndButton:HWnd;
  i:integer;
begin
   result:=false;
   HndButton:=Find_Tab(AccountNumber, Language);
   if ((HndButton<>0) and (Hnd<>0)) then begin
      Hnd:=FindWindowEx(Hnd, 0, 'Edit', nil);
      if (Hnd<>0) then begin
         SendMessage(Hnd, WM_Settext,0,Integer(Str_Set));
         I:=GetDlgCtrlID(HndButton);
         if I<>0 then begin
            SendMessage(GetParent(HndButton),WM_Command,MakeWParam(I,BN_CLICKED),HndButton);
            result:=true;
         end;
      end;
   end;
end;


//--------------------------------------------------------------------------/
Exports Set_Check, Set_MetaQuotesID;

begin
end.
