#property strict

#include "LogLevels.mqh"
#include <Arrays/ArrayObj.mqh> // For managing handlers

//+------------------------------------------------------------------+
//| Interface: ILogHandler                                           |
//| Description: Defines the contract for log handling mechanisms.   |
//|              Each handler is responsible for processing and      |
//|              outputting log messages in a specific way (e.g., to |
//|              console, file, database).                           |
//+------------------------------------------------------------------+
interface ILogHandler
  {
//--- Method to configure the handler with specific settings
   virtual bool      Setup(const string settings="");

//--- Method to process and output a log message
   virtual void      Log(const datetime time, const LogLevel level, const string origin, const string message, const long expert_id=0);

//--- Method to perform any necessary cleanup
   virtual void      Shutdown();
  };
//+------------------------------------------------------------------+
