//+------------------------------------------------------------------+
//|                                                 asyncwinhttp.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"

//
// status manifests for WinHttp status callback
//

#define WINHTTP_CALLBACK_STATUS_RESOLVING_NAME              0x00000001
#define WINHTTP_CALLBACK_STATUS_NAME_RESOLVED               0x00000002
#define WINHTTP_CALLBACK_STATUS_CONNECTING_TO_SERVER        0x00000004
#define WINHTTP_CALLBACK_STATUS_CONNECTED_TO_SERVER         0x00000008
#define WINHTTP_CALLBACK_STATUS_SENDING_REQUEST             0x00000010
#define WINHTTP_CALLBACK_STATUS_REQUEST_SENT                0x00000020
#define WINHTTP_CALLBACK_STATUS_RECEIVING_RESPONSE          0x00000040
#define WINHTTP_CALLBACK_STATUS_RESPONSE_RECEIVED           0x00000080
#define WINHTTP_CALLBACK_STATUS_CLOSING_CONNECTION          0x00000100
#define WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED           0x00000200
#define WINHTTP_CALLBACK_STATUS_HANDLE_CREATED              0x00000400
#define WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING              0x00000800
#define WINHTTP_CALLBACK_STATUS_DETECTING_PROXY             0x00001000
#define WINHTTP_CALLBACK_STATUS_REDIRECT                    0x00004000
#define WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE       0x00008000
#define WINHTTP_CALLBACK_STATUS_SECURE_FAILURE              0x00010000
#define WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE           0x00020000
#define WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE              0x00040000
#define WINHTTP_CALLBACK_STATUS_READ_COMPLETE               0x00080000
#define WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE              0x00100000
#define WINHTTP_CALLBACK_STATUS_REQUEST_ERROR               0x00200000
#define WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE        0x00400000

#define WINHTTP_CALLBACK_STATUS_DEFAULT                      0x3389


#define WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE     0x01000000
#define WINHTTP_CALLBACK_STATUS_CLOSE_COMPLETE              0x02000000
#define WINHTTP_CALLBACK_STATUS_SHUTDOWN_COMPLETE           0x04000000
#define WINHTTP_CALLBACK_STATUS_GETPROXYSETTINGS_COMPLETE   0x08000000
#define WINHTTP_CALLBACK_STATUS_SETTINGS_WRITE_COMPLETE     0x10000000
#define WINHTTP_CALLBACK_STATUS_SETTINGS_READ_COMPLETE      0x20000000

// API Enums for WINHTTP_CALLBACK_STATUS_REQUEST_ERROR:
#define API_RECEIVE_RESPONSE        (1)
#define API_QUERY_DATA_AVAILABLE    (2)
#define API_READ_DATA               (3)
#define API_WRITE_DATA              (4)
#define API_SEND_REQUEST            (5)
#define API_GET_PROXY_FOR_URL       (6)
#define API_GET_PROXY_SETTINGS      (7)

#define WINHTTP_CALLBACK_FLAG_RESOLVE_NAME              (WINHTTP_CALLBACK_STATUS_RESOLVING_NAME | WINHTTP_CALLBACK_STATUS_NAME_RESOLVED)
#define WINHTTP_CALLBACK_FLAG_CONNECT_TO_SERVER         (WINHTTP_CALLBACK_STATUS_CONNECTING_TO_SERVER | WINHTTP_CALLBACK_STATUS_CONNECTED_TO_SERVER)
#define WINHTTP_CALLBACK_FLAG_SEND_REQUEST              (WINHTTP_CALLBACK_STATUS_SENDING_REQUEST | WINHTTP_CALLBACK_STATUS_REQUEST_SENT)
#define WINHTTP_CALLBACK_FLAG_RECEIVE_RESPONSE          (WINHTTP_CALLBACK_STATUS_RECEIVING_RESPONSE | WINHTTP_CALLBACK_STATUS_RESPONSE_RECEIVED)
#define WINHTTP_CALLBACK_FLAG_CLOSE_CONNECTION          (WINHTTP_CALLBACK_STATUS_CLOSING_CONNECTION | WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED)
#define WINHTTP_CALLBACK_FLAG_HANDLES                   (WINHTTP_CALLBACK_STATUS_HANDLE_CREATED | WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING)
#define WINHTTP_CALLBACK_FLAG_DETECTING_PROXY           WINHTTP_CALLBACK_STATUS_DETECTING_PROXY
#define WINHTTP_CALLBACK_FLAG_REDIRECT                  WINHTTP_CALLBACK_STATUS_REDIRECT
#define WINHTTP_CALLBACK_FLAG_INTERMEDIATE_RESPONSE     WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE
#define WINHTTP_CALLBACK_FLAG_SECURE_FAILURE            WINHTTP_CALLBACK_STATUS_SECURE_FAILURE
#define WINHTTP_CALLBACK_FLAG_SENDREQUEST_COMPLETE      WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE
#define WINHTTP_CALLBACK_FLAG_HEADERS_AVAILABLE         WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE
#define WINHTTP_CALLBACK_FLAG_DATA_AVAILABLE            WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE
#define WINHTTP_CALLBACK_FLAG_READ_COMPLETE             WINHTTP_CALLBACK_STATUS_READ_COMPLETE
#define WINHTTP_CALLBACK_FLAG_WRITE_COMPLETE            WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE
#define WINHTTP_CALLBACK_FLAG_REQUEST_ERROR             WINHTTP_CALLBACK_STATUS_REQUEST_ERROR


#define WINHTTP_CALLBACK_FLAG_GETPROXYFORURL_COMPLETE   WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE
#define WINHTTP_CALLBACK_FLAG_GETPROXYSETTINGS_COMPLETE WINHTTP_CALLBACK_STATUS_GETPROXYSETTINGS_COMPLETE

#define WINHTTP_CALLBACK_FLAG_ALL_COMPLETIONS           (WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE       \
                                                        | WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE         \
                                                        | WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE            \
                                                        | WINHTTP_CALLBACK_STATUS_READ_COMPLETE             \
                                                        | WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE            \
                                                        | WINHTTP_CALLBACK_STATUS_REQUEST_ERROR             \
                                                        | WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE   \
                                                        | WINHTTP_CALLBACK_STATUS_GETPROXYSETTINGS_COMPLETE)

#define WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS         0xffffffff


#define WINHTTP_ERROR_BASE                          12000
#define ERROR_WINHTTP_OUT_OF_HANDLES           (WINHTTP_ERROR_BASE + 1)
#define ERROR_WINHTTP_TIMEOUT                  (WINHTTP_ERROR_BASE + 2)
#define ERROR_WINHTTP_INTERNAL_ERROR           (WINHTTP_ERROR_BASE + 4)
#define ERROR_WINHTTP_INVALID_URL              (WINHTTP_ERROR_BASE + 5)
#define ERROR_WINHTTP_UNRECOGNIZED_SCHEME      (WINHTTP_ERROR_BASE + 6)
#define ERROR_WINHTTP_NAME_NOT_RESOLVED        (WINHTTP_ERROR_BASE + 7)
#define ERROR_WINHTTP_INVALID_OPTION           (WINHTTP_ERROR_BASE + 9)
#define ERROR_WINHTTP_OPTION_NOT_SETTABLE      (WINHTTP_ERROR_BASE + 11)
#define ERROR_WINHTTP_SHUTDOWN                 (WINHTTP_ERROR_BASE + 12)


#define ERROR_WINHTTP_LOGIN_FAILURE            (WINHTTP_ERROR_BASE + 15)
#define ERROR_WINHTTP_OPERATION_CANCELLED      (WINHTTP_ERROR_BASE + 17)
#define ERROR_WINHTTP_INCORRECT_HANDLE_TYPE    (WINHTTP_ERROR_BASE + 18)
#define ERROR_WINHTTP_INCORRECT_HANDLE_STATE   (WINHTTP_ERROR_BASE + 19)
#define ERROR_WINHTTP_CANNOT_CONNECT           (WINHTTP_ERROR_BASE + 29)
#define ERROR_WINHTTP_CONNECTION_ERROR         (WINHTTP_ERROR_BASE + 30)
#define ERROR_WINHTTP_RESEND_REQUEST           (WINHTTP_ERROR_BASE + 32)

#define ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED  (WINHTTP_ERROR_BASE + 44)


#define ERROR_WINHTTP_CANNOT_CALL_BEFORE_OPEN (WINHTTP_ERROR_BASE + 100)
#define ERROR_WINHTTP_CANNOT_CALL_BEFORE_SEND (WINHTTP_ERROR_BASE + 101)
#define ERROR_WINHTTP_CANNOT_CALL_AFTER_SEND (WINHTTP_ERROR_BASE + 102)
#define ERROR_WINHTTP_CANNOT_CALL_AFTER_OPEN (WINHTTP_ERROR_BASE + 103)

#define ERROR_WINHTTP_HEADER_NOT_FOUND             (WINHTTP_ERROR_BASE + 150)
#define ERROR_WINHTTP_INVALID_SERVER_RESPONSE      (WINHTTP_ERROR_BASE + 152)
#define ERROR_WINHTTP_INVALID_HEADER               (WINHTTP_ERROR_BASE + 153)
#define ERROR_WINHTTP_INVALID_QUERY_REQUEST        (WINHTTP_ERROR_BASE + 154)
#define ERROR_WINHTTP_HEADER_ALREADY_EXISTS        (WINHTTP_ERROR_BASE + 155)
#define ERROR_WINHTTP_REDIRECT_FAILED              (WINHTTP_ERROR_BASE + 156)


#define ERROR_WINHTTP_AUTO_PROXY_SERVICE_ERROR  (WINHTTP_ERROR_BASE + 178)
#define ERROR_WINHTTP_BAD_AUTO_PROXY_SCRIPT     (WINHTTP_ERROR_BASE + 166)
#define ERROR_WINHTTP_UNABLE_TO_DOWNLOAD_SCRIPT (WINHTTP_ERROR_BASE + 167)
#define ERROR_WINHTTP_UNHANDLED_SCRIPT_TYPE     (WINHTTP_ERROR_BASE + 176)
#define ERROR_WINHTTP_SCRIPT_EXECUTION_ERROR    (WINHTTP_ERROR_BASE + 177)
#define ERROR_WINHTTP_NOT_INITIALIZED          (WINHTTP_ERROR_BASE + 172)
#define ERROR_WINHTTP_SECURE_FAILURE           (WINHTTP_ERROR_BASE + 175)


#define ERROR_WINHTTP_SECURE_CERT_DATE_INVALID    (WINHTTP_ERROR_BASE + 37)
#define ERROR_WINHTTP_SECURE_CERT_CN_INVALID      (WINHTTP_ERROR_BASE + 38)
#define ERROR_WINHTTP_SECURE_INVALID_CA           (WINHTTP_ERROR_BASE + 45)
#define ERROR_WINHTTP_SECURE_CERT_REV_FAILED      (WINHTTP_ERROR_BASE + 57)
#define ERROR_WINHTTP_SECURE_CHANNEL_ERROR        (WINHTTP_ERROR_BASE + 157)
#define ERROR_WINHTTP_SECURE_INVALID_CERT         (WINHTTP_ERROR_BASE + 169)
#define ERROR_WINHTTP_SECURE_CERT_REVOKED         (WINHTTP_ERROR_BASE + 170)
#define ERROR_WINHTTP_SECURE_CERT_WRONG_USAGE     (WINHTTP_ERROR_BASE + 179)


#define ERROR_WINHTTP_AUTODETECTION_FAILED                  (WINHTTP_ERROR_BASE + 180)
#define ERROR_WINHTTP_HEADER_COUNT_EXCEEDED                 (WINHTTP_ERROR_BASE + 181)
#define ERROR_WINHTTP_HEADER_SIZE_OVERFLOW                  (WINHTTP_ERROR_BASE + 182)
#define ERROR_WINHTTP_CHUNKED_ENCODING_HEADER_SIZE_OVERFLOW (WINHTTP_ERROR_BASE + 183)
#define ERROR_WINHTTP_RESPONSE_DRAIN_OVERFLOW               (WINHTTP_ERROR_BASE + 184)
#define ERROR_WINHTTP_CLIENT_CERT_NO_PRIVATE_KEY            (WINHTTP_ERROR_BASE + 185)
#define ERROR_WINHTTP_CLIENT_CERT_NO_ACCESS_PRIVATE_KEY     (WINHTTP_ERROR_BASE + 186)

#define ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED_PROXY         (WINHTTP_ERROR_BASE + 187)
#define ERROR_WINHTTP_SECURE_FAILURE_PROXY                  (WINHTTP_ERROR_BASE + 188)
#define ERROR_WINHTTP_RESERVED_189                          (WINHTTP_ERROR_BASE + 189)
#define ERROR_WINHTTP_HTTP_PROTOCOL_MISMATCH                (WINHTTP_ERROR_BASE + 190)

#define WINHTTP_ERROR_LAST                                  (WINHTTP_ERROR_BASE + 188)

#define WEBSOCKET_ERROR_FIRST                       WINHTTP_ERROR_LAST+1000
#define WEBSOCKET_ERROR_INVALID_HANDLE              WEBSOCKET_ERROR_FIRST+1
#define WEBSOCKET_ERROR_FAILED_OPERATION            WEBSOCKET_ERROR_FIRST+2
#define WEBSOCKET_ERROR_CLOSING_ACTIVE_CONNECTION   WEBSOCKET_ERROR_FIRST+3
#define WEBSOCKET_ERROR_INVALID_PARAMETER           WEBSOCKET_ERROR_FIRST+4
#define WEBSOCKET_ERROR_EMPTY_SEND_BUFFER           WEBSOCKET_ERROR_FIRST+5
#define WEBSOCKET_ERROR_NOT_CONNECTED               WEBSOCKET_ERROR_FIRST+6

#define WORD  ushort
#define HINTERNET long
#define DWORD ulong
#define BYTE  uchar
#define INTERNET_PORT WORD
//+------------------------------------------------------------------+
//|   client state enumeration                                       |
//+------------------------------------------------------------------+

// client state
enum ENUM_WEBSOCKET_STATE
  {
   CLOSED = 0,
   CLOSING = 1,
   CONNECTING = 2,
   CONNECTED = 3,
   SENDING = 4,
   POLLING = 5
  };

//+------------------------------------------------------------------+
//| the close status                                                 |
//+------------------------------------------------------------------+
enum _WINHTTP_WEB_SOCKET_CLOSE_STATUS
  {
   WINHTTP_WEB_SOCKET_SUCCESS_CLOSE_STATUS = 1000,
   WINHTTP_WEB_SOCKET_ENDPOINT_TERMINATED_CLOSE_STATUS = 1001,
   WINHTTP_WEB_SOCKET_PROTOCOL_ERROR_CLOSE_STATUS = 1002,
   WINHTTP_WEB_SOCKET_INVALID_DATA_TYPE_CLOSE_STATUS = 1003,
   WINHTTP_WEB_SOCKET_EMPTY_CLOSE_STATUS = 1005,
   WINHTTP_WEB_SOCKET_ABORTED_CLOSE_STATUS = 1006,
   WINHTTP_WEB_SOCKET_INVALID_PAYLOAD_CLOSE_STATUS = 1007,
   WINHTTP_WEB_SOCKET_POLICY_VIOLATION_CLOSE_STATUS = 1008,
   WINHTTP_WEB_SOCKET_MESSAGE_TOO_BIG_CLOSE_STATUS = 1009,
   WINHTTP_WEB_SOCKET_UNSUPPORTED_EXTENSIONS_CLOSE_STATUS = 1010,
   WINHTTP_WEB_SOCKET_SERVER_ERROR_CLOSE_STATUS = 1011,
   WINHTTP_WEB_SOCKET_SECURE_HANDSHAKE_ERROR_CLOSE_STATUS = 1015
  };

//+------------------------------------------------------------------+
//| frame type enumeration                                           |
//+------------------------------------------------------------------+

enum WINHTTP_WEB_SOCKET_BUFFER_TYPE
  {
   WINHTTP_WEB_SOCKET_BINARY_MESSAGE_BUFFER_TYPE       = 0,
   WINHTTP_WEB_SOCKET_BINARY_FRAGMENT_BUFFER_TYPE      = 1,
   WINHTTP_WEB_SOCKET_UTF8_MESSAGE_BUFFER_TYPE         = 2,
   WINHTTP_WEB_SOCKET_UTF8_FRAGMENT_BUFFER_TYPE        = 3,
   WINHTTP_WEB_SOCKET_CLOSE_BUFFER_TYPE                = 4
  };
//+------------------------------------------------------------------+
//|  imported functions from asyncwinhttpwebsockets.dll              |
//+------------------------------------------------------------------+
#import "asyncwinhttpwebsockets.dll"
DWORD client_connect(string,INTERNET_PORT,DWORD,HINTERNET&);
void client_disconnect(HINTERNET);
DWORD client_send(HINTERNET, WINHTTP_WEB_SOCKET_BUFFER_TYPE,BYTE&[], DWORD length);
DWORD client_read(HINTERNET,BYTE&[],DWORD,WINHTTP_WEB_SOCKET_BUFFER_TYPE&);
DWORD client_poll(HINTERNET);
DWORD client_lasterror(HINTERNET);
DWORD client_readable(HINTERNET);
ENUM_WEBSOCKET_STATE client_status(HINTERNET);
HINTERNET client_websocket_handle(HINTERNET);
DWORD client_lastcallback_notification(HINTERNET);
void client_reset(HINTERNET);
#import
//+------------------------------------------------------------------+
