//+------------------------------------------------------------------+
//|                          Project8 Harmonic Pattern Indicator.mq5 |
//|                                 Abioye Israel Pelumi (Forex YMN) |
//|                             https://linktr.ee/abioyeisraelpelumi |
//+------------------------------------------------------------------+
#property copyright "Abioye Israel Pelumi (Forex YMN)"
#property link      "https://linktr.ee/abioyeisraelpelumi"
#property version   "1.00"

#property indicator_chart_window

// Input parameters
input int LookbackBars = 10; // Number of bars to look back/forward for swing points
input int bars_check  = 1000; // Number of bars to check for swing points
input bool overlap = true; //Allow Overlaping


// CHART ID
long chart_id = ChartID(); // Get the ID of the current chart to manage objects (lines, text, etc.)

//X
double X; // Price of the swing low (X).
datetime X_time; // Time of the swing low (X).
string X_line; // Unique name for the trend line object.
string X_letter; // Unique name for the text label object.

//A
double A; // Price of the swing high (A).
datetime A_time; // Time of the swing high (A).
string A_line; // Unique name for the trend line object.
string A_letter; // Unique name for the text label object.

//B
double B; // Price of the swing low (B).
datetime B_time; // Time of the swing low (B).
string B_line; // Unique name for the trend line object.
string B_letter; // Unique name for the text label object.

//C
double C; // Price of the swing high (C).
datetime C_time; // Time of the swing high (C).
string C_line; // Unique name for the trend line object.
string C_letter; // Unique name for the text label object.

//D
double D; // Price of the swing low (D).
datetime D_time; // Time of the swing low (D).
string D_line; // Unique name for the trend line object.
string D_letter; // Unique name for the text label object.

//Trend
string XA_line; // Unique name for XA trend line object.
string AB_line; // Unique name for AB trend line object.
string BC_line; // Unique name for BC trend line object.
string CD_line; // Unique name for CD trend line object.

//X
int x_a_bars; // Number of bars between XA
int x_lowest_index; // Index of the lowest bar
double x_a_ll; // Price of the lowest bar
datetime x_a_ll_t; // Time of the lowest bar
int x_highest_index;   // Stores the index of the highest price point (X) in the pattern
double x_a_hh;         // Holds the price value of the swing high at point X
datetime x_a_hh_t;     // Stores the timestamp of when the swing high at X occurred

//A
int a_b_bars; // Number of bars between AB
int a_highest_index; // Index of the highest bar
double a_b_hh; // Price of the highest bar
datetime a_b_hh_t; // Time of the highest bar
int a_lowest_index;   // Stores the index of the lowest price point (A) in the pattern
double a_b_ll;        // Holds the price value of the swing low at point A
datetime a_b_ll_t;    // Stores the timestamp of when the swing low at A occurred

//B
int b_c_bars; // Number of bars between BC
int b_lowest_index; // Index of the lowest bar
double b_c_ll; // Price of the lowest bar
datetime b_c_ll_t; // Time of the lowest bar
int b_highest_index;   // Stores the index of the highest price point (B) in the pattern
double b_c_hh;         // Holds the price value of the swing high at point B
datetime b_c_hh_t;     // Stores the timestamp of when the swing high at B occurred

//C
int c_d_bars; // Number of bars between CD
int c_highest_index; // Index of the highest bar
double c_d_hh; // Price of the highest bar
datetime c_d_hh_t; // Time of the highest bar
int c_lowest_index;   // Stores the index of the lowest price point (C) in the pattern
double c_d_ll;        // Holds the price value of the swing low at point C
datetime c_d_ll_t;    // Stores the timestamp of when the swing low at C occurred

//Fibo
string XA_fibo; // Unique name for XA fibo
double lvl_61_8; // Level 61.8
double lvl_78_6; // Level 78.6
string fibo_618_786; // Unique name for the object that marks 61.8 and 78.6.
string fibo_78_6_txt; // Unique name for text "78.6" cause its not available by default

//Triangle
string X_A_B;  // Stores the unique name for the triangle marking the XAB leg in the pattern
string B_C_D;  // Stores the unique name for the triangle marking the BCD leg in the pattern

//Signal
string buy_txt;   // Stores the unique name for the text object indicating a buy signal
string sell_txt;  // Stores the unique name for the text object indicating a sell signal
string entry_line; // Stores the unique name for the trend line marking the entry point
string tp_line;    // Stores the unique name for the trend line marking the take profit (TP) level
string sl_line;    // Stores the unique name for the trend line marking the stop loss (SL) level
string tp_txt;     // Stores the unique name for the text object displaying the "TP" label
string sl_txt;     // Stores the unique name for the text object displaying the "SL" label
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping

//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
// This function is called when the indicator is removed or the chart is closed.
// Delete all objects (lines, text, etc.) from the chart to clean up.
   ObjectsDeleteAll(chart_id);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---


   if(rates_total >= bars_check)
     {

      for(int i = rates_total - bars_check; i < rates_total - LookbackBars; i++)
        {
         if(IsSwingLow(low, i, LookbackBars))
           {
            // If a swing low is found, store its price, time, and create a name for the objects to mark the X.
            X = low[i]; // Price of the swing low (X).
            X_time = time[i]; // Time of the swing low (X).
            X_line = StringFormat("XLow%d", i); // Unique name for the trend line object.
            X_letter = StringFormat("X%d", i); // Unique name for the text label object.


            for(int j = i; j < rates_total - LookbackBars; j++)
              {
               if(IsSwingHigh(high, j, LookbackBars) && time[j] > X_time)
                 {

                  A = high[j]; // Price of the swing high (A).
                  A_time = time[j]; // Time of the swing high (A).
                  A_line = StringFormat("AHigh%d", j); // Unique name for the trend line object.
                  A_letter = StringFormat("A%d", j); // Unique name for the text label object.


                  for(int k = j; k < rates_total - LookbackBars; k++)
                    {
                     if(IsSwingLow(low, k, LookbackBars) && time[k] > A_time)
                       {

                        // If a swing low is found, store its price, time, and create a name for the object.
                        B = low[k]; // Price of the swing low (B).
                        B_time = time[k]; // Time of the swing low (B).
                        B_line = StringFormat("BLow%d", k); // Unique name for the trend line object.
                        B_letter = StringFormat("B%d", k); // Unique name for the text label object.



                        for(int l = j ; l < rates_total - LookbackBars; l++)
                          {
                           if(IsSwingHigh(high, l, LookbackBars) && time[l] > B_time)
                             {
                              C = high[l]; // Price of the swing high (C).
                              C_time = time[l]; // Time of the swing high (C).
                              C_line = StringFormat("CHigh%d", l); // Unique name for the trend line object.
                              C_letter = StringFormat("C%d", l); // Unique name for the text label object.


                              for(int m = l; m < rates_total - (LookbackBars / 2); m++)
                                {
                                 if(IsSwingLow(low, m, LookbackBars / 2) && time[m] > C_time)
                                   {
                                    D = low[m]; // Price of the swing low (D).
                                    D_time = time[m]; // Time of the swing low (D).
                                    D_line = StringFormat("DLow%d", m); // Unique name for the trend line object.
                                    D_letter = StringFormat("D%d", m); // Unique name for the text label object.



                                    // C - D Segment: Find the highest high between C and D
                                    c_d_bars = Bars(_Symbol, PERIOD_CURRENT, C_time, D_time); // Count bars between C and D
                                    c_highest_index = ArrayMaximum(high, l, c_d_bars); // Find the index of the highest high

                                    c_d_hh = high[c_highest_index]; // Store the highest high (C - D highest point)
                                    c_d_hh_t = time[c_highest_index]; // Store the corresponding time

                                    // B - C Segment: Find the lowest low between B and C
                                    b_c_bars = Bars(_Symbol, PERIOD_CURRENT, B_time, c_d_hh_t); // Count bars between B and C
                                    b_lowest_index = ArrayMinimum(low, k, b_c_bars); // Find the index of the lowest low

                                    b_c_ll = low[b_lowest_index]; // Store the lowest low (B - C lowest point)
                                    b_c_ll_t = time[b_lowest_index]; // Store the corresponding time

                                    // A - B Segment: Find the highest high between A and B
                                    a_b_bars = Bars(_Symbol, PERIOD_CURRENT, A_time, b_c_ll_t); // Count bars between A and B
                                    a_highest_index = ArrayMaximum(high, j, a_b_bars); // Find the index of the highest high

                                    a_b_hh = high[a_highest_index]; // Store the highest high (A - B highest point)
                                    a_b_hh_t = time[a_highest_index]; // Store the corresponding time

                                    // X - A Segment: Find the lowest low between X and A
                                    x_a_bars = Bars(_Symbol, PERIOD_CURRENT, X_time, a_b_hh_t); // Count bars between X and A
                                    x_lowest_index = ArrayMinimum(low, i, x_a_bars); // Find the index of the lowest low

                                    x_a_ll = low[x_lowest_index]; // Store the lowest low (X - A lowest point)
                                    x_a_ll_t = time[x_lowest_index]; // Store the corresponding time

                                    lvl_61_8 = a_b_hh - ((61.8/100) * (a_b_hh - x_a_ll)); // Calculating level 61.8
                                    lvl_78_6 = a_b_hh - ((78.6/100) * (a_b_hh - x_a_ll)); // Calculating level 78.6

                                    if((b_c_ll <= lvl_61_8 && b_c_ll >= lvl_78_6) && (D < x_a_ll))
                                      {

                                       //D
                                       ObjectCreate(chart_id, D_letter, OBJ_TEXT, 0, D_time, D); // Create text object for D
                                       ObjectSetString(chart_id, D_letter, OBJPROP_TEXT, "D"); // Set the text to "D".
                                       ObjectSetInteger(chart_id,D_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,D_line,OBJ_TREND,0,D_time,D,time[m],D); // Create line to mark D
                                       ObjectSetInteger(chart_id,D_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown

                                       //C
                                       ObjectCreate(chart_id, C_letter, OBJ_TEXT, 0, c_d_hh_t, c_d_hh); // Create text object for C
                                       ObjectSetString(chart_id, C_letter, OBJPROP_TEXT, "C"); // Set the text to "C".
                                       ObjectSetInteger(chart_id,C_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,C_line,OBJ_TREND,0,c_d_hh_t,C,time[c_highest_index+LookbackBars],c_d_hh); // Create line to mark C
                                       ObjectSetInteger(chart_id,C_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown

                                       //B
                                       ObjectCreate(chart_id, B_letter, OBJ_TEXT, 0, b_c_ll_t, b_c_ll); // Create text object for B
                                       ObjectSetString(chart_id, B_letter, OBJPROP_TEXT, "B"); // Set the text to "B".
                                       ObjectSetInteger(chart_id,B_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,B_line,OBJ_TREND,0,b_c_ll_t,b_c_ll,time[b_lowest_index+LookbackBars],b_c_ll); // Create line to mark B
                                       ObjectSetInteger(chart_id,B_line,OBJPROP_COLOR,clrMidnightBlue); // Set line color to MidnightBlue

                                       //A
                                       ObjectCreate(chart_id, A_letter, OBJ_TEXT, 0, a_b_hh_t, a_b_hh); // Create text object for A
                                       ObjectSetString(chart_id, A_letter, OBJPROP_TEXT, "A"); // Set the text to "A".
                                       ObjectSetInteger(chart_id,A_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,A_line,OBJ_TREND,0,a_b_hh_t,a_b_hh,time[a_highest_index+LookbackBars],a_b_hh); // Create line to mark A
                                       ObjectSetInteger(chart_id,A_line,OBJPROP_COLOR,clrGreen); // Set line color to green

                                       //X
                                       ObjectCreate(chart_id, X_letter, OBJ_TEXT, 0, x_a_ll_t, x_a_ll); // Create text object for X
                                       ObjectSetString(chart_id, X_letter, OBJPROP_TEXT, "X"); // Set the text to "X".
                                       ObjectCreate(chart_id,X_line,OBJ_TREND,0,x_a_ll_t,x_a_ll,time[x_lowest_index+LookbackBars],x_a_ll); // Create line to mark X


                                       XA_line = StringFormat("XA Line%d", m); // Unique name for the XA line.
                                       ObjectCreate(chart_id,XA_line,OBJ_TREND,0,x_a_ll_t,x_a_ll,a_b_hh_t,a_b_hh); // Create line to connect XA
                                       ObjectSetInteger(chart_id,XA_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,XA_line,OBJPROP_WIDTH,3); // Line width

                                       AB_line = StringFormat("AB Line%d", m); // Unique name for the AB line.
                                       ObjectCreate(chart_id,AB_line,OBJ_TREND,0,a_b_hh_t,a_b_hh,b_c_ll_t,b_c_ll); // Create line to connect AB
                                       ObjectSetInteger(chart_id,AB_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,AB_line,OBJPROP_WIDTH,3); // Line width

                                       BC_line = StringFormat("BC Line%d", m); // Unique name for the BC line.
                                       ObjectCreate(chart_id,BC_line,OBJ_TREND,0,b_c_ll_t,b_c_ll,c_d_hh_t,c_d_hh); // Create line to connect BC
                                       ObjectSetInteger(chart_id,BC_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,BC_line,OBJPROP_WIDTH,3); // Line width

                                       CD_line = StringFormat("CD Line%d", m); // Unique name for the CD line.
                                       ObjectCreate(chart_id,CD_line,OBJ_TREND,0,c_d_hh_t,c_d_hh,D_time,D); // Create line to connect CD
                                       ObjectSetInteger(chart_id,CD_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,CD_line,OBJPROP_WIDTH,3); // Line width

                                       //XA FIBO
                                       XA_fibo = StringFormat("XA FIB0 %d", i);
                                       ObjectCreate(chart_id,XA_fibo,OBJ_FIBO,0,x_a_ll_t,x_a_ll,a_b_hh_t,a_b_hh); // Create XA fibo
                                       ObjectSetInteger(chart_id,XA_fibo,OBJPROP_LEVELS,6); // Number of default levels
                                       for(int i = 1; i <= 6; i++)
                                         {

                                          ObjectSetInteger(chart_id,XA_fibo,OBJPROP_LEVELCOLOR,i,clrSaddleBrown); // Set each level color to SaddleBrown

                                         }


                                       fibo_618_786 = StringFormat("Fibo 78.6 - 61.8 %d", i);
                                       fibo_78_6_txt = StringFormat("Fibo 78.6 Text %d", i);

                                       ObjectCreate(chart_id,fibo_618_786,OBJ_RECTANGLE,0,x_a_ll_t, lvl_61_8,b_c_ll_t,lvl_78_6); // Create rectangle object marking 61.8 and 78.6
                                       ObjectSetInteger(chart_id,fibo_618_786,OBJPROP_COLOR,clrSaddleBrown); // Set color to clrSaddleBrown

                                       ObjectCreate(chart_id,fibo_78_6_txt,OBJ_TEXT,0,b_c_ll_t,lvl_78_6); // Create text for level 78.6
                                       ObjectSetString(chart_id,fibo_78_6_txt,OBJPROP_TEXT,"78.6"); // Text to be displayed
                                       ObjectSetInteger(chart_id,fibo_78_6_txt,OBJPROP_COLOR,clrSaddleBrown); // Set text color
                                       ObjectSetInteger(chart_id,fibo_78_6_txt,OBJPROP_FONTSIZE,8); // Set text size



                                       // Creating the first triangle (XAB) to mark the X-A-B swing points
                                       X_A_B = StringFormat("XAB %d", m);
                                       ObjectCreate(chart_id, X_A_B, OBJ_TRIANGLE, 0, x_a_ll_t, x_a_ll, a_b_hh_t, a_b_hh, b_c_ll_t, b_c_ll);
                                       ObjectSetInteger(chart_id, X_A_B, OBJPROP_COLOR, clrCornflowerBlue);
                                       ObjectSetInteger(chart_id, X_A_B, OBJPROP_FILL, true);

                                       // Creating the second triangle (BCD) to mark the B-C-D swing points
                                       B_C_D = StringFormat("BCD %d", m);
                                       ObjectCreate(chart_id, B_C_D, OBJ_TRIANGLE, 0, b_c_ll_t, b_c_ll, c_d_hh_t, c_d_hh, D_time, D);
                                       ObjectSetInteger(chart_id, B_C_D, OBJPROP_COLOR, clrCornflowerBlue);
                                       ObjectSetInteger(chart_id, B_C_D, OBJPROP_FILL, true);

                                       // Creating a text object to label the buy signal
                                       buy_txt = StringFormat("Buy %d", i);
                                       ObjectCreate(chart_id, buy_txt, OBJ_TEXT, 0, time[m + (LookbackBars / 2)], open[m + (LookbackBars / 2)]);
                                       ObjectSetString(chart_id, buy_txt, OBJPROP_TEXT, "BUY");
                                       ObjectSetInteger(chart_id, buy_txt, OBJPROP_COLOR, clrCornflowerBlue);
                                       ObjectSetInteger(chart_id, buy_txt, OBJPROP_FONTSIZE, 10);

                                       // Creating a trend line for the buy entry point
                                       entry_line = StringFormat("Buy Entry Line %d", i);
                                       ObjectCreate(chart_id, entry_line, OBJ_TREND, 0, time[m + (LookbackBars / 2)], open[m + (LookbackBars / 2)], c_d_hh_t, open[m + (LookbackBars / 2)]);
                                       ObjectSetInteger(chart_id, entry_line, OBJPROP_WIDTH, 3);
                                       ObjectSetInteger(chart_id, entry_line, OBJPROP_COLOR, clrCornflowerBlue);

                                       // Creating a text object to label the stop loss (SL) level
                                       sl_txt = StringFormat("Buy SL %d", i);
                                       ObjectCreate(chart_id, sl_txt, OBJ_TEXT, 0, time[m + (LookbackBars / 2)], D);
                                       ObjectSetString(chart_id, sl_txt, OBJPROP_TEXT, "SL");
                                       ObjectSetInteger(chart_id, sl_txt, OBJPROP_COLOR, clrCornflowerBlue);
                                       ObjectSetInteger(chart_id, sl_txt, OBJPROP_FONTSIZE, 10);

                                       // Creating a trend line for the stop loss level
                                       sl_line = StringFormat("Buy SL Line %d", i);
                                       ObjectCreate(chart_id, sl_line, OBJ_TREND, 0, time[m + (LookbackBars / 2)], D, c_d_hh_t, D);
                                       ObjectSetInteger(chart_id, sl_line, OBJPROP_WIDTH, 3);
                                       ObjectSetInteger(chart_id, sl_line, OBJPROP_COLOR, clrCornflowerBlue);

                                       // Creating a text object to label the take profit (TP) level
                                       tp_txt = StringFormat("Buy TP %d", i);
                                       ObjectCreate(chart_id, tp_txt, OBJ_TEXT, 0, time[m + (LookbackBars / 2)], c_d_hh);
                                       ObjectSetString(chart_id, tp_txt, OBJPROP_TEXT, "TP");
                                       ObjectSetInteger(chart_id, tp_txt, OBJPROP_COLOR, clrCornflowerBlue);
                                       ObjectSetInteger(chart_id, tp_txt, OBJPROP_FONTSIZE, 10);

                                       // Creating a trend line for the take profit level
                                       tp_line = StringFormat("Buy TP Line %d", i);
                                       ObjectCreate(chart_id, tp_line, OBJ_TREND, 0, time[m + (LookbackBars / 2)], c_d_hh, c_d_hh_t, c_d_hh);
                                       ObjectSetInteger(chart_id, tp_line, OBJPROP_WIDTH, 3);
                                       ObjectSetInteger(chart_id, tp_line, OBJPROP_COLOR, clrCornflowerBlue);



                                      }



                                    if(overlap == false)
                                      {
                                       i = m;
                                      }
                                    if(overlap == true)
                                      {
                                       i = i;
                                      }
                                    break;


                                   }
                                }



                              break;

                             }
                          }

                        break;

                       }
                    }

                  break;
                 }
              }

           }
        }
     }


   if(rates_total >= bars_check)
     {
      for(int i = rates_total - bars_check; i < rates_total - LookbackBars; i++)
        {
         if(IsSwingHigh(high, i, LookbackBars))
           {

            X = high[i];                   // Assign the highest price at index 'i' to X
            X_time = time[i];              // Assign the corresponding time value to X_time
            X_line = StringFormat("XHigh%d", i);  // Create a unique string identifier for the X-high trendline
            X_letter = StringFormat("XB%d", i);   // Create a unique string identifier for the X-high label

            for(int j = i; j < rates_total - LookbackBars; j++)
              {
               if(IsSwingLow(low, j, LookbackBars) && time[j] > X_time)
                 {
                  A = low[j];                    // Assign the lowest price at index 'j' to A
                  A_time = time[j];               // Assign the corresponding time value to A_time
                  A_line = StringFormat("ALow%d", j);  // Create a unique string identifier for the A-low trendline
                  A_letter = StringFormat("AB%d", j);  // Create a unique string identifier for the A-low label


                  for(int k = j; k < rates_total - LookbackBars; k++)
                    {
                     if(IsSwingHigh(high, k, LookbackBars) && time[k] > A_time)
                       {

                        B = high[k];                    // Assign the highest price at index 'k' to B
                        B_time = time[k];                // Assign the corresponding time value to B_time
                        B_line = StringFormat("BHigh%d", k);  // Create a unique string identifier for the B-high trendline
                        B_letter = StringFormat("BB%d", k);   // Create a unique string identifier for the B-high label

                        for(int l = k; l < rates_total - LookbackBars; l++)
                          {
                           if(IsSwingLow(low, l, LookbackBars) && time[l] > B_time)
                             {

                              C = low[l];                      // Assign the lowest price at index 'l' to C
                              C_time = time[l];                // Assign the corresponding time value to C_time
                              C_line = StringFormat("CLow%d", l);  // Create a unique string identifier for the C-low trendline
                              C_letter = StringFormat("CB%d", l);   // Create a unique string identifier for the C-low label

                              for(int m = l; m < rates_total - (LookbackBars / 2); m++)
                                {
                                 if(IsSwingHigh(high, m, LookbackBars / 2) && time[m] > C_time)
                                   {
                                    D = high[m];                      // Assign the highest price at index 'm' to D
                                    D_time = time[m];                 // Assign the corresponding time value to D_time
                                    D_line = StringFormat("DHigh%d", m);  // Create a unique string identifier for the D-high trendline
                                    D_letter = StringFormat("DB%d", m);   // Create a unique string identifier for the D-high label

                                    // C - D Segment: Find the lowest low between C and D
                                    c_d_bars = Bars(_Symbol, PERIOD_CURRENT, C_time, D_time); // Count the number of bars between C and D
                                    c_lowest_index = ArrayMinimum(low, l, c_d_bars); // Find the index of the lowest low in the range

                                    c_d_ll = low[c_lowest_index]; // Store the lowest low (C - D lowest point)
                                    c_d_ll_t = time[c_lowest_index]; // Store the corresponding time for C - D

                                    // B - C Segment: Find the highest high between B and C
                                    b_c_bars = Bars(_Symbol, PERIOD_CURRENT, B_time, c_d_ll_t); // Count the number of bars between B and C
                                    b_highest_index = ArrayMaximum(high, k, b_c_bars); // Find the index of the highest high in the range

                                    b_c_hh = high[b_highest_index]; // Store the highest high (B - C highest point)
                                    b_c_hh_t = time[b_highest_index]; // Store the corresponding time for B - C

                                    // A - B Segment: Find the lowest low between A and B
                                    a_b_bars = Bars(_Symbol, PERIOD_CURRENT, A_time, b_c_hh_t); // Count the number of bars between A and B
                                    a_lowest_index = ArrayMinimum(low, j, a_b_bars); // Find the index of the lowest low in the range

                                    a_b_ll = low[a_lowest_index]; // Store the lowest low (A - B lowest point)
                                    a_b_ll_t = time[a_lowest_index]; // Store the corresponding time for A - B

                                    // X - A Segment: Find the highest high between X and A
                                    x_a_bars = Bars(_Symbol, PERIOD_CURRENT, X_time, a_b_ll_t); // Count the number of bars between X and A
                                    x_highest_index = ArrayMaximum(high, i, x_a_bars); // Find the index of the highest high in the range

                                    x_a_hh = high[x_highest_index]; // Store the highest high (X - A highest point)
                                    x_a_hh_t = time[x_highest_index]; // Store the corresponding time for X - A

                                    // Fibonacci Retracement Levels: Calculate 61.8% and 78.6% retracement levels from X to A
                                    lvl_61_8 = a_b_ll + ((61.8 / 100) * (x_a_hh - a_b_ll)); // 61.8% retracement level
                                    lvl_78_6 = a_b_ll + ((78.6 / 100) * (x_a_hh - a_b_ll)); // 78.6% retracement level

                                    if((b_c_hh >= lvl_61_8 && b_c_hh <= lvl_78_6) && (D > x_a_hh))
                                      {
                                       //D
                                       ObjectCreate(chart_id, D_letter, OBJ_TEXT, 0, D_time, D); // Create text object for D
                                       ObjectSetString(chart_id, D_letter, OBJPROP_TEXT, "D"); // Set the text to "D".
                                       ObjectSetInteger(chart_id,D_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,D_line,OBJ_TREND,0,D_time,D,time[m],D); // Create line to mark D
                                       ObjectSetInteger(chart_id,D_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown

                                       //C
                                       ObjectCreate(chart_id, C_letter, OBJ_TEXT, 0, c_d_ll_t, c_d_ll); // Create text object for C
                                       ObjectSetString(chart_id, C_letter, OBJPROP_TEXT, "C"); // Set the text to "C".
                                       ObjectSetInteger(chart_id,C_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,C_line,OBJ_TREND,0,c_d_ll_t,C,time[c_lowest_index+LookbackBars],c_d_ll); // Create line to mark C
                                       ObjectSetInteger(chart_id,C_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown

                                       //B
                                       ObjectCreate(chart_id, B_letter, OBJ_TEXT, 0, b_c_hh_t, b_c_hh); // Create text object for B
                                       ObjectSetString(chart_id, B_letter, OBJPROP_TEXT, "B"); // Set the text to "B".
                                       ObjectSetInteger(chart_id,B_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,B_line,OBJ_TREND,0,b_c_hh_t,b_c_hh,time[b_highest_index+LookbackBars],b_c_hh); // Create line to mark B
                                       ObjectSetInteger(chart_id,B_line,OBJPROP_COLOR,clrMidnightBlue); // Set line color to MidnightBlue

                                       //A
                                       ObjectCreate(chart_id, A_letter, OBJ_TEXT, 0, a_b_ll_t, a_b_ll); // Create text object for A
                                       ObjectSetString(chart_id, A_letter, OBJPROP_TEXT, "A"); // Set the text to "A".
                                       ObjectSetInteger(chart_id,A_letter,OBJPROP_COLOR,clrGreen); // Set text color to green
                                       ObjectCreate(chart_id,A_line,OBJ_TREND,0,a_b_ll_t,a_b_ll,time[a_lowest_index+LookbackBars],a_b_ll); // Create line to mark A
                                       ObjectSetInteger(chart_id,A_line,OBJPROP_COLOR,clrGreen); // Set line color to green

                                       //X
                                       ObjectCreate(chart_id, X_letter, OBJ_TEXT, 0, x_a_hh_t, x_a_hh); // Create text object for X
                                       ObjectSetString(chart_id, X_letter, OBJPROP_TEXT, "X"); // Set the text to "X".
                                       ObjectCreate(chart_id,X_line,OBJ_TREND,0,x_a_hh_t,x_a_hh,time[x_highest_index+LookbackBars],x_a_hh); // Create line to mark X



                                       XA_line = StringFormat("XA LineB%d", m); // Unique name for the XA line.
                                       ObjectCreate(chart_id,XA_line,OBJ_TREND,0,x_a_hh_t,x_a_hh,a_b_ll_t,a_b_ll); // Create line to connect XA
                                       ObjectSetInteger(chart_id,XA_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,XA_line,OBJPROP_WIDTH,3); // Line width

                                       AB_line = StringFormat("AB LineB%d", m); // Unique name for the AB line.
                                       ObjectCreate(chart_id,AB_line,OBJ_TREND,0,a_b_ll_t,a_b_ll,b_c_hh_t,b_c_hh); // Create line to connect AB
                                       ObjectSetInteger(chart_id,AB_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,AB_line,OBJPROP_WIDTH,3); // Line width

                                       BC_line = StringFormat("BC LineB%d", m); // Unique name for the BC line.
                                       ObjectCreate(chart_id,BC_line,OBJ_TREND,0,b_c_hh_t,b_c_hh,c_d_ll_t,c_d_ll); // Create line to connect BC
                                       ObjectSetInteger(chart_id,BC_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,BC_line,OBJPROP_WIDTH,3); // Line width

                                       CD_line = StringFormat("CD LineB%d", m); // Unique name for the CD line.
                                       ObjectCreate(chart_id,CD_line,OBJ_TREND,0,c_d_ll_t,c_d_ll,D_time,D); // Create line to connect CD
                                       ObjectSetInteger(chart_id,CD_line,OBJPROP_COLOR,clrSaddleBrown); // Set line color to SaddleBrown
                                       ObjectSetInteger(chart_id,CD_line,OBJPROP_WIDTH,3); // Line width


                                       //XA FIBO
                                       XA_fibo = StringFormat("XA FIB0 B%d", i);
                                       ObjectCreate(chart_id,XA_fibo,OBJ_FIBO,0,x_a_hh_t,x_a_hh,a_b_ll_t,a_b_ll); // Create XA fibo
                                       ObjectSetInteger(chart_id,XA_fibo,OBJPROP_LEVELS,6); // Number of default levels
                                       for(int i = 1; i <= 6; i++)
                                         {

                                          ObjectSetInteger(chart_id,XA_fibo,OBJPROP_LEVELCOLOR,i,clrSaddleBrown); // Set each level color to SaddleBrown

                                         }


                                       fibo_618_786 = StringFormat("Fibo 78.6 - 61.8 B%d", i);
                                       fibo_78_6_txt = StringFormat("Fibo 78.6 Text B%d", i);

                                       ObjectCreate(chart_id,fibo_618_786,OBJ_RECTANGLE,0,x_a_hh_t, lvl_61_8,b_c_hh_t,lvl_78_6); // Create rectangle object marking 61.8 and 78.6
                                       ObjectSetInteger(chart_id,fibo_618_786,OBJPROP_COLOR,clrSaddleBrown); // Set color to clrSaddleBrown

                                       ObjectCreate(chart_id,fibo_78_6_txt,OBJ_TEXT,0,b_c_hh_t,lvl_78_6); // Create text for level 78.6
                                       ObjectSetString(chart_id,fibo_78_6_txt,OBJPROP_TEXT,"78.6"); // Text to be displayed
                                       ObjectSetInteger(chart_id,fibo_78_6_txt,OBJPROP_COLOR,clrSaddleBrown); // Set text color
                                       ObjectSetInteger(chart_id,fibo_78_6_txt,OBJPROP_FONTSIZE,8); // Set text size
                                       // Create and format the first bearish harmonic pattern (XAB)
                                       X_A_B = StringFormat("XAB B%d", m);
                                       ObjectCreate(chart_id, X_A_B, OBJ_TRIANGLE, 0, x_a_hh_t, x_a_hh, a_b_ll_t, a_b_ll, b_c_hh_t, b_c_hh);
                                       ObjectSetInteger(chart_id, X_A_B, OBJPROP_COLOR, clrMistyRose); // Set color for the pattern
                                       ObjectSetInteger(chart_id, X_A_B, OBJPROP_FILL, true); // Fill the triangle shape

                                       // Create and format the second bearish harmonic pattern (BCD)
                                       B_C_D = StringFormat("BCD B%d", m);
                                       ObjectCreate(chart_id, B_C_D, OBJ_TRIANGLE, 0, b_c_hh_t, b_c_hh, c_d_ll_t, c_d_ll, D_time, D);
                                       ObjectSetInteger(chart_id, B_C_D, OBJPROP_COLOR, clrMistyRose);
                                       ObjectSetInteger(chart_id, B_C_D, OBJPROP_FILL, true);

                                       // Create and format the SELL text at the entry position
                                       sell_txt = StringFormat("Sell %d", i);
                                       ObjectCreate(chart_id, sell_txt, OBJ_TEXT, 0, time[m + (LookbackBars / 2)], open[m + (LookbackBars / 2)]);
                                       ObjectSetString(chart_id, sell_txt, OBJPROP_TEXT, "SELL");
                                       ObjectSetInteger(chart_id, sell_txt, OBJPROP_COLOR, clrMagenta); // Set text color
                                       ObjectSetInteger(chart_id, sell_txt, OBJPROP_FONTSIZE, 10); // Set font size

                                       // Create and format the SELL entry line
                                       entry_line = StringFormat("Sell Entry Line %d", i);
                                       ObjectCreate(chart_id, entry_line, OBJ_TREND, 0, time[m + (LookbackBars / 2)], open[m + (LookbackBars / 2)], c_d_ll_t, open[m + (LookbackBars / 2)]);
                                       ObjectSetInteger(chart_id, entry_line, OBJPROP_WIDTH, 3); // Set line thickness
                                       ObjectSetInteger(chart_id, entry_line, OBJPROP_COLOR, clrMagenta); // Set line color

                                       // Create and format the Stop Loss (SL) text
                                       sl_txt = StringFormat("Sell SL %d", i);
                                       ObjectCreate(chart_id, sl_txt, OBJ_TEXT, 0, time[m + (LookbackBars / 2)], D);
                                       ObjectSetString(chart_id, sl_txt, OBJPROP_TEXT, "SL");
                                       ObjectSetInteger(chart_id, sl_txt, OBJPROP_COLOR, clrMagenta);
                                       ObjectSetInteger(chart_id, sl_txt, OBJPROP_FONTSIZE, 10);

                                       // Create and format the Stop Loss (SL) line
                                       sl_line = StringFormat("Sell SL Line %d", i);
                                       ObjectCreate(chart_id, sl_line, OBJ_TREND, 0, time[m + (LookbackBars / 2)], D, c_d_ll_t, D);
                                       ObjectSetInteger(chart_id, sl_line, OBJPROP_WIDTH, 3);
                                       ObjectSetInteger(chart_id, sl_line, OBJPROP_COLOR, clrMagenta);

                                       // Create and format the Take Profit (TP) text
                                       tp_txt = StringFormat("Sell TP %d", i);
                                       ObjectCreate(chart_id, tp_txt, OBJ_TEXT, 0, time[m + (LookbackBars / 2)], c_d_ll);
                                       ObjectSetString(chart_id, tp_txt, OBJPROP_TEXT, "TP");
                                       ObjectSetInteger(chart_id, tp_txt, OBJPROP_COLOR, clrMagenta);
                                       ObjectSetInteger(chart_id, tp_txt, OBJPROP_FONTSIZE, 10);

                                       // Create and format the Take Profit (TP) line
                                       tp_line = StringFormat("Sell TP Line %d", i);
                                       ObjectCreate(chart_id, tp_line, OBJ_TREND, 0, time[m + (LookbackBars / 2)], c_d_ll, c_d_ll_t, c_d_ll);
                                       ObjectSetInteger(chart_id, tp_line, OBJPROP_WIDTH, 3);
                                       ObjectSetInteger(chart_id, tp_line, OBJPROP_COLOR, clrMagenta);


                                       if(overlap == false)
                                         {
                                          i = m;
                                         }
                                       if(overlap == true)
                                         {
                                          i = i;
                                         }
                                       break;



                                      }


                                    break;

                                   }
                                }


                              break;

                             }
                          }

                        break;

                       }
                    }

                  break;

                 }
              }




           }

        }

     }



//--- return value of prev_calculated for next call
   return(rates_total);
  }


//+------------------------------------------------------------------+
//| FUNCTION FOR SWING LOW                                           |
//+------------------------------------------------------------------+
bool IsSwingLow(const double &low[], int index, int lookback)
  {
// This function checks if the bar at the given index is a swing low.
// A swing low is a bar where the low is lower than the lows of the bars before and after it.
   for(int i = 1; i <= lookback; i++)
     {
      if(low[index] > low[index - i] || low[index] > low[index + i])
         return false; // If the current low is not the lowest, return false.
     }
   return true; // If the current low is the lowest, return true.
  }


//+------------------------------------------------------------------+
//| FUNCTION FOR SWING HIGH                                          |
//+------------------------------------------------------------------+
bool IsSwingHigh(const double &high[], int index, int lookback)
  {
// This function checks if the bar at the given index is a swing high.
// A swing high is a bar where the high is higher than the highs of the bars before and after it.
   for(int i = 1; i <= lookback; i++)
     {
      if(high[index] < high[index - i] || high[index] < high[index + i])
         return false; // If the current high is not the highest, return false.
     }
   return true; // If the current high is the highest, return true.
  }
//+------------------------------------------------------------------+
