//+------------------------------------------------------------------+
//|                                                   EnhancedML.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

//+------------------------------------------------------------------+
//|                          Includes                                |
//+------------------------------------------------------------------+
#include <WinAPI\winapi.mqh>
#include <Trade\Trade.mqh>
CTrade              trade;

//+------------------------------------------------------------------+
//|                          Global Vars                             |
//+------------------------------------------------------------------+
int stopLoss = 350;
int takeProfit = 500;

string Address = "127.0.0.1";
int port = 9999;
int socket = SocketCreate();

double Bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);
double Ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit(){

    if (!SocketConnect(socket, Address, port, 1000)){  // Corrected to check for successful connection
        Print("Successfully connected to ", Address, ":", port);
    } else {
        Print("Connection to ", Address, ":", port, " failed, error ", GetLastError());
        return INIT_FAILED;
    }

   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason){

   
}
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick(){
   
   
   uint len=SocketIsReadable(socket);

   char buffer[16];
   int bytes = SocketRead(socket, buffer, len, 23);
   
   if (bytes > 0){
   
      string action_str = CharArrayToString(buffer);
      
      int action = StringToInteger(action_str);
      //int action = atoi(buffer);
      
      // Execute a trade based on action
      if(action == 1){
         //buy trade
         MBuy();
         Print("Buy action received...");
      } else if(action == 2){
         //sell trade
         MSell();
         Print("Sell action received...");
      }
   }
   
}
//+------------------------------------------------------------------+

// Buy function
void MBuy(){

   static int digits = (int)SymbolInfoInteger(_Symbol, SYMBOL_DIGITS);

   double Lots = 0.02;
   double sl = NormalizeDouble(SymbolInfoDouble(_Symbol, SYMBOL_BID) - stopLoss, digits);
   double tp = NormalizeDouble(SymbolInfoDouble(_Symbol,SYMBOL_ASK) + takeProfit * _Point, digits);
   trade.PositionOpen(_Symbol, ORDER_TYPE_BUY, Lots, Ask, sl, tp);
}

// Sell function
void MSell(){
   static int digits = (int)SymbolInfoInteger(_Symbol, SYMBOL_DIGITS);

   double Lots = 0.02;
   double sl = NormalizeDouble(SymbolInfoDouble(_Symbol, SYMBOL_ASK) + stopLoss, digits);
   double tp = NormalizeDouble(SymbolInfoDouble(_Symbol,SYMBOL_BID) - takeProfit * _Point, digits);
   trade.PositionOpen(_Symbol, ORDER_TYPE_SELL, Lots, Bid, sl, tp);
}