//+------------------------------------------------------------------+
//|                                                 Panel_OCO_EA.mq5 |
//|                                           Copyright 2014, denkir |
//|                           https://login.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, denkir"
#property link      "https://login.mql5.com/ru/users/denkir"
#property version   "1.00"
//---
#define ON_OCO (101) //  " -" 

//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
#include "CiOcoObject.mqh"
#include <Arrays\List.mqh>
#include <Controls\Dialog.mqh>
#include <Controls\ComboBox.mqh>
#include <Controls\Label.mqh>
#include <Controls\Button.mqh>

//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
CiOcoObject gOco;                // -
SOrderProperties gOrdersProps[2];//    
CList gOcoList;                  //   -

//--- .
CAppDialog myDialog;
//--- 
CPanel myPanels[2];

//---  
int X1=20,X2=440,Y1=20,Y2=380;

//---  
CLabel myLabels[6];
string gLabelTexts[]={"","","","","",""};
int gLabelFontSize=10;
color gLabelColor=clrDarkBlue;

//--- 
CComboBox myCombos[2]; //  
CEdit myEdits[10];     //   
int gEditsHalfLen;     // 1/2   myEdits[]
color gEditColors[]={clrAliceBlue,clrBisque}; // 

CButton myButton;    // 
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---  1/2   myEdits[]
   gEditsHalfLen=ArraySize(myEdits)/2;

//---  
   if(!myDialog.Create(0," OCO-",0,X1,Y1,X2,Y2))
     {
      Print("   .");
      return INIT_FAILED;
     }

   int x_border_indent=5; //      X
   int y_border_indent=5; //      Y   

//---    
   int lbl_x=X1+x_border_indent;
   int lbl_y=Y1+4*y_border_indent;

//---   
   for(int idx=0;idx<ArraySize(gLabelTexts);idx++)
     {
      //--- 
      string curr_label_name="myLabel"+IntegerToString(idx+1);
      //--- 
      if(!myLabels[idx].Create(0,curr_label_name,0,lbl_x,lbl_y,0,0))
        {
         Print("   .");
         return INIT_FAILED;
        }
      //--- 
      myLabels[idx].Color(gLabelColor);
      myLabels[idx].FontSize(gLabelFontSize);
      myLabels[idx].Text(gLabelTexts[idx]);
      //---    Y
      lbl_y+=y_border_indent*6;
      //---  
      myDialog.Add(myLabels[idx]);
     }

//---===  ===---
   int panel_x1,panel_x2,panel_y1,panel_y2;  // 
   panel_x1=X1+17*x_border_indent;
   panel_x2=(int)(0.5*X2-x_border_indent);
   panel_y1=Y1+y_border_indent;
   panel_y2=(int)(0.6*Y2);
   int panel_width=panel_x2-panel_x1;
//---
   color panel_clrs[]={C'239,237,248',clrBeige};

//---   [start]
   for(int pnl_idx=0;pnl_idx<ArraySize(myPanels);pnl_idx++)
     {
      string panel_name="MyPanel"+IntegerToString(pnl_idx+1);
      //---
      if(!myPanels[pnl_idx].Create(0,panel_name,0,panel_x1,panel_y1,panel_x2,panel_y2))
        {
         Print("  .");
         return INIT_FAILED;
        }
      myPanels[pnl_idx].ColorBackground(panel_clrs[pnl_idx]);
      //---  
      myDialog.Add(myPanels[pnl_idx]);

      //---       
      int obj_x1=panel_x1+1*x_border_indent;
      int obj_y1=panel_y1+3*y_border_indent;
      int obj_x2=obj_x1+100;
      int obj_y2=obj_y1+20;
      //---
      for(int idx=0;idx<ArraySize(myLabels);idx++)
        {
         //--- 1-  -  
         if(!idx)
           {
            if(!myCombos[pnl_idx].Create(0,"myCombo"+IntegerToString(pnl_idx+1)+"_",
               0,obj_x1,obj_y1,obj_x2,obj_y2))
              {
               Print("   .");
               return INIT_FAILED;
              }
            //---    
            string pending_types_str[]=
              {
               "Buy-limit","Sell-limit","Buy-stop",
               "Sell-stop","Buy-stop-limit","Sell-stop-limit"
              };
            //---    
            myCombos[pnl_idx].ListViewItems(ArraySize(pending_types_str));

            //---   
            for(int type_idx=0;type_idx<ArraySize(pending_types_str);type_idx++)
               //---  
               if(!myCombos[pnl_idx].AddItem(pending_types_str[type_idx],type_idx))
                 {
                  Print("  !");
                  return INIT_FAILED;
                 }
            //---
            myCombos[pnl_idx].Select(pnl_idx);
            //---  
            myDialog.Add(myCombos[pnl_idx]);
            obj_x1+=15;
            obj_x2-=15;
           }
         //--- 2-    -  
         else
           {
            //---   
            int jdx=(idx-1)+pnl_idx*gEditsHalfLen;
            //---
            if(!myEdits[jdx].Create(0,"myEdit"+IntegerToString(jdx+1),0,obj_x1,obj_y1,
               obj_x2,obj_y2))
              {
               Print("   .");
               return INIT_FAILED;
              }
            //---
            myEdits[jdx].ColorBackground(gEditColors[pnl_idx]);
            myEdits[jdx].TextAlign(ALIGN_CENTER);
            //---  
            myDialog.Add(myEdits[jdx]);
           }
         //---      
         obj_y1+=y_border_indent*6;
         obj_y2=obj_y1+y_border_indent*4;
        }
      //---     
      panel_x1=panel_x2+5*x_border_indent;
      panel_x2=panel_x1+panel_width;
     }
//---   [end]

//---   [start]
//--- 
   int btn_width=100;
   int btn_height=30;
//--- 
   int btn_x1=(int)(X1+17*x_border_indent+(panel_width-btn_width)/2.);
   int btn_y1=panel_y2+4*y_border_indent;
//--- 
   if(!myButton.Create(0,"myFireButton",0,btn_x1,btn_y1,0,0))
     {
      Print("  .");
      return INIT_FAILED;
     }
//---  
   myButton.Width(btn_width);
   myButton.Height(btn_height);
//---  
   myButton.Locking(true);
//---  
   myDialog.Add(myButton);
//---  
   Reset();
//---   [end]

//---  
   bool is_run=myDialog.Run();
//---      
   gOcoList.FreeMode(true);
//---
   return INIT_SUCCEEDED;
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   myDialog.Destroy();
  }
//+------------------------------------------------------------------+
//| Trade function                                                   |
//+------------------------------------------------------------------+
void OnTrade()
  {
//---  
   for(int node_idx=0;node_idx<gOcoList.Total();node_idx++)
     {
      CiOcoObject *ptr_curr_oco=gOcoList.GetNodeAtIndex(node_idx);
      //---   
      if(ptr_curr_oco!=NULL)
        {
         //---   -
         if(ptr_curr_oco.Deinit())
           {
            uint curr_oco_id=ptr_curr_oco.Id();
            //---   
            if(gOcoList.Delete(node_idx))
              {
               PrintFormat(" -: %I32u",curr_oco_id);
               break;
              }
           }
        }
     }
  }
//+------------------------------------------------------------------+
//| ChartEvent function                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
//---      
   myDialog.ChartEvent(id,lparam,dparam,sparam);

//---   
   if(id==CHARTEVENT_CUSTOM+ON_CHANGE)
     {
      //---    
      if(!StringCompare(StringSubstr(sparam,0,7),"myCombo"))
        {
         static ENUM_PENDING_ORDER_TYPE prev_vals[2];
         //---  
         int combo_idx=(int)StringToInteger(StringSubstr(sparam,7,1))-1;

         ENUM_PENDING_ORDER_TYPE curr_val=(ENUM_PENDING_ORDER_TYPE)(myCombos[combo_idx].Value()+2);
         //---    
         if(prev_vals[combo_idx]!=curr_val)
           {
            prev_vals[combo_idx]=curr_val;
            gOrdersProps[combo_idx].order_type=curr_val;
           }
        }
     }

//---   
   else if(id==CHARTEVENT_OBJECT_ENDEDIT)
     {
      //---     
      if(!StringCompare(StringSubstr(sparam,0,6),"myEdit"))
        {
         //---  
         for(int idx=0;idx<ArraySize(myEdits);idx++)
           {
            string curr_edit_obj_name=myEdits[idx].Name();
            long curr_edit_obj_id=myEdits[idx].Id();
            //---   
            if(!StringCompare(sparam,curr_edit_obj_name))
              {
               //---    
               double value=StringToDouble(myEdits[idx].Text());
               //---    gOrdersProps[]
               int order_num=(idx<gEditsHalfLen)?0:1;
               //---     gOrdersProps
               int jdx=idx;
               if(order_num)
                  jdx=idx-gEditsHalfLen;
               //---    gOrdersProps
               switch(jdx)
                 {
                  case 0: // 
                    {
                     gOrdersProps[order_num].volume=value;
                     break;
                    }
                  case 1: // 
                    {
                     gOrdersProps[order_num].price_offset=(uint)value;
                     break;
                    }
                  case 2: // 
                    {
                     gOrdersProps[order_num].limit_offset=(uint)value;
                     break;
                    }
                  case 3: // 
                    {
                     gOrdersProps[order_num].sl=(uint)value;
                     break;
                    }
                  case 4: // 
                    {
                     gOrdersProps[order_num].tp=(uint)value;
                     break;
                    }
                 }
              }
           }
         //---   -
         bool is_to_fire_oco=true;
         //---    
         for(int idx=0;idx<ArraySize(gOrdersProps);idx++)
           {
            //---      
            if(gOrdersProps[idx].order_type!=WRONG_VALUE)
               //---      
               if(gOrdersProps[idx].volume!=WRONG_VALUE)
                  //---       
                  if(gOrdersProps[idx].price_offset!=(uint)WRONG_VALUE)
                     //---       
                     if(gOrdersProps[idx].limit_offset!=(uint)WRONG_VALUE)
                        //---    stop loss
                        if(gOrdersProps[idx].sl!=(uint)WRONG_VALUE)
                           //---    take profit
                           if(gOrdersProps[idx].tp!=(uint)WRONG_VALUE)
                              continue;

            //---    - 
            is_to_fire_oco=false;
            break;
           }
         //---  -?
         if(is_to_fire_oco)
           {
            //---   
            for(int ord_idx=0;ord_idx<ArraySize(gOrdersProps);ord_idx++)
               gOrdersProps[ord_idx].comment=StringFormat("OCO Order %d",ord_idx+1);
            //---   
            myButton.Text(" ");
            myButton.Color(clrDarkBlue);
            myButton.ColorBackground(clrLightBlue);
            //---     
            myButton.Enable();
           }
        }
     }
//---    
   else if(id==CHARTEVENT_OBJECT_CLICK)
     {
      //---     -
      if(!StringCompare(StringSubstr(sparam,0,6),"myFire"))
         //---     
         if(myButton.IsEnabled())
           {
            //---   " -"
            EventChartCustom(0,ON_OCO,0,0.0,"OCO_fire");
            Print("     .");
           }
     }
//---       
   else if(id==CHARTEVENT_CUSTOM+ON_OCO)
     {
      //---  -
      if(gOco.Init(gOrdersProps,gOcoList.Total()+1))
        {
         PrintFormat("Id  -: %I32u",gOco.Id());
         //---  
         CiOcoObject *ptr_new_oco=new CiOcoObject(gOco);
         if(CheckPointer(ptr_new_oco)==POINTER_DYNAMIC)
           {
            //---   
            int node_idx=gOcoList.Add(ptr_new_oco);
            if(node_idx>-1)
               PrintFormat(" : %d",gOcoList.Total());
            else
               PrintFormat("  - %I32u  !",gOco.Id());
           }
        }
      else
         Print("  -!");

      //---  
      Reset();
     }
  }
//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+
void Reset(void)
  {
//---     
   for(int idx=0;idx<ArraySize(gOrdersProps);idx++)
     {
      SOrderProperties new_props;
      gOrdersProps[idx]=new_props;
     }
//---   
   for(int idx=0;idx<ArraySize(myEdits);idx++)
      myEdits[idx].Text("");

//---  
   myButton.Text(" ");
   myButton.Color(clrLightCoral);
   myButton.ColorBackground(clrWhite);
//---      
   myButton.Disable();
  }
//+------------------------------------------------------------------+
