//+------------------------------------------------------------------+
//|                                                  CiOcoObject.mqh |
//|                                           Copyright 2014, denkir |
//|                           https://login.mql5.com/ru/users/denkir |
//+------------------------------------------------------------------+
#property copyright "Copyright 2014, denkir"
#property link      "https://login.mql5.com/ru/users/denkir" 
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Trade\Trade.mqh>
#include "CRandom.mqh"
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
enum ENUM_BASE_PENDING_TYPE
  {
   BASE_PENDING_TYPE_LIMIT=0,
   BASE_PENDING_TYPE_STOP=1,
   BASE_PENDING_TYPE_STOPLIMIT=2,
  };
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
enum ENUM_PENDING_ORDER_TYPE
  {
   PENDING_ORDER_TYPE_BUY_LIMIT=2,       // Buy-limit
   PENDING_ORDER_TYPE_SELL_LIMIT=3,      // Sell-limit
   PENDING_ORDER_TYPE_BUY_STOP=4,        // Buy-stop
   PENDING_ORDER_TYPE_SELL_STOP=5,       // Sell-stop
   PENDING_ORDER_TYPE_BUY_STOP_LIMIT=6,  // Buy-stop-limit
   PENDING_ORDER_TYPE_SELL_STOP_LIMIT=7, // Sell-stop-limit
  };
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
struct SOrderProperties
  {
   double            volume;           //     
   string            symbol;           // 
   ENUM_PENDING_ORDER_TYPE order_type; //     
   uint              price_offset;     //    ,
   uint              limit_offset;     //    ,
   uint              sl;               // stop loss,
   uint              tp;               // take profit,
   ENUM_ORDER_TYPE_TIME type_time;     //   
   datetime          expiration;       // 
   string            comment;          // 
   //--- 
   void SOrderProperties::SOrderProperties(void)
     {
      symbol=_Symbol;
      order_type=WRONG_VALUE;
      volume=WRONG_VALUE; // SymbolInfoDouble(symbol,SYMBOL_VOLUME_MIN);
      price_offset=limit_offset=sl=tp=WRONG_VALUE;
      type_time=ORDER_TIME_GTC;
      expiration=0;
      comment=NULL;
     }
   //---  
   void SOrderProperties::SOrderProperties(const SOrderProperties &_ord_src)
     {
      symbol=_ord_src.symbol;
      order_type=_ord_src.order_type;
      volume=_ord_src.volume;
      price_offset=_ord_src.price_offset;
      limit_offset=_ord_src.limit_offset;
      sl=_ord_src.sl;
      tp=_ord_src.tp;
      type_time=_ord_src.type_time;
      expiration=_ord_src.expiration;
      comment=_ord_src.comment;
     }
   //---  
   void SOrderProperties::operator=(const SOrderProperties &_ord_src)
     {
      symbol=_ord_src.symbol;
      order_type=_ord_src.order_type;
      volume=_ord_src.volume;
      price_offset=_ord_src.price_offset;
      limit_offset=_ord_src.limit_offset;
      sl=_ord_src.sl;
      tp=_ord_src.tp;
      type_time=_ord_src.type_time;
      expiration=_ord_src.expiration;
      comment=_ord_src.comment;
     }
  };
//+------------------------------------------------------------------+
//| Class CiOcoObject                                                |
//| Purpose: a class for OCO-orders                                  |            
//+------------------------------------------------------------------+
class CiOcoObject : public CObject
  {
   //--- === Data members === --- 
private:
   //---  
   ulong             m_order_tickets[2];
   //---  
   bool              m_is_init;
   //--- id
   uint              m_id;

   //--- === Methods === --- 
public:
   //--- /
   void              CiOcoObject(void){m_is_init=false;};
   void             ~CiOcoObject(void){};
   //---  
   void              CiOcoObject(const CiOcoObject &_src_oco);
   //---  
   void              operator=(const CiOcoObject &_src_oco);

   //--- /
   bool              Init(const SOrderProperties &_orders[],const uint _bunch_cnt=1);
   bool              Deinit(void);
   //---  id
   uint              Id(void) const {return m_id;};

private:
   //---  
   ENUM_ORDER_TYPE   BaseOrderType(const ENUM_ORDER_TYPE _ord_type);
   ENUM_BASE_PENDING_TYPE PendingType(const ENUM_PENDING_ORDER_TYPE _pend_type);
   //---  id
   void              Id(const uint _id){m_id=_id;};
  };
//+------------------------------------------------------------------+
//|                                            |
//+------------------------------------------------------------------+
void CiOcoObject::CiOcoObject(const CiOcoObject &_src_oco)
  {
   ArrayCopy(this.m_order_tickets,_src_oco.m_order_tickets);
   this.m_is_init=_src_oco.m_is_init;
   this.m_id=_src_oco.m_id;
  }
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
void CiOcoObject::operator=(const CiOcoObject &_src_oco)
  {
   ArrayCopy(this.m_order_tickets,_src_oco.m_order_tickets);
   this.m_is_init=_src_oco.m_is_init;
   this.m_id=_src_oco.m_id;
  }
//+------------------------------------------------------------------+
//|                                               |
//+------------------------------------------------------------------+
bool CiOcoObject::Init(const SOrderProperties &_orders_props[],const uint _bunch_cnt=1)
  {
//---     
   if(ArraySize(_orders_props)!=2)
      return false;

//---
   for(int ord_idx=0;ord_idx<ArraySize(this.m_order_tickets);ord_idx++)
     {
      //---   
      SOrderProperties curr_order_props=_orders_props[ord_idx];
      //---  
      MqlTick last_tick;
      if(SymbolInfoTick(_Symbol,last_tick))
        {
         //--- 
         double curr_ord_vol=curr_order_props.volume;
         //---  
         ENUM_ORDER_TYPE curr_ord_type=(ENUM_ORDER_TYPE)curr_order_props.order_type;
         //---   
         ENUM_ORDER_TYPE base_ord_type=this.BaseOrderType(curr_ord_type);
         //---    
         ENUM_BASE_PENDING_TYPE base_pend_type=this.PendingType(curr_order_props.order_type);
         //---  
         double base_pr=(base_ord_type==ORDER_TYPE_BUY)?last_tick.ask:last_tick.bid;
         //---  
         double open_pr,sl_pr,tp_pr,limit_pr;
         open_pr=sl_pr=tp_pr=limit_pr=0.;
         //---   
         ENUM_ORDER_TYPE_TIME  curr_ord_type_time=curr_order_props.type_time;
         //---  
         datetime curr_ord_expiration=curr_order_props.expiration;
         //--- 
         string curr_ord_comment=" "+IntegerToString(_bunch_cnt)
                                 +": "+curr_order_props.comment;

         //---       
         int coeff=1.;
         //---      
         if(curr_ord_type==ORDER_TYPE_BUY_LIMIT || curr_ord_type==ORDER_TYPE_SELL_STOP_LIMIT ||
            curr_ord_type==ORDER_TYPE_SELL_STOP)
            coeff=-1.;

         //---  
         if(base_ord_type==ORDER_TYPE_BUY)
           {
            //---  
            open_pr=base_pr+coeff*(curr_order_props.price_offset*_Point);
            //---  
            sl_pr=open_pr-curr_order_props.sl*_Point;
            //---  
            tp_pr=open_pr+curr_order_props.tp*_Point;
           }
         //---  
         else if(base_ord_type==ORDER_TYPE_SELL)
           {
            //---  
            open_pr=base_pr+coeff*(curr_order_props.price_offset*_Point);
            //---  
            sl_pr=open_pr+curr_order_props.sl*_Point;
            //---  
            tp_pr=open_pr-curr_order_props.tp*_Point;
           }

         //---   
         if(base_pend_type==BASE_PENDING_TYPE_STOPLIMIT)
           {
            if(curr_order_props.limit_offset>0)
              {
               limit_pr=open_pr-coeff*(curr_order_props.limit_offset*_Point);
               limit_pr=NormalizeDouble(limit_pr,_Digits);
               sl_pr=limit_pr-coeff*(curr_order_props.sl*_Point);
               tp_pr=limit_pr+coeff*(curr_order_props.tp*_Point);
              }
            else
              {
               Print("     .");
               return false;
              }
           }
         //--- 
         open_pr=NormalizeDouble(open_pr,_Digits);
         if(curr_order_props.sl>0)
            sl_pr=NormalizeDouble(sl_pr,_Digits);
         else
            sl_pr=0.;
         if(curr_order_props.tp>0)
            tp_pr=NormalizeDouble(tp_pr,_Digits);
         else
            tp_pr=0.;
         //---
         CTrade trade_obj;
         //---
         ResetLastError();
         //---   
         if(trade_obj.OrderOpen(_Symbol,curr_ord_type,curr_ord_vol,limit_pr,open_pr,
            sl_pr,tp_pr,curr_ord_type_time,curr_ord_expiration,curr_ord_comment))
           {
            //---    
            uint res_code=trade_obj.ResultRetcode();
            PrintFormat("   : %d",res_code);
            //---   
            if(res_code==TRADE_RETCODE_DONE || res_code==TRADE_RETCODE_PLACED)
              {
               //---  
               ulong  res_order=trade_obj.ResultOrder();
               PrintFormat("  : %d",res_order);
               //---  
               if(res_order>0)
                  this.m_order_tickets[ord_idx]=res_order;
              }
            //--- 
            Sleep(75);
           }
         else
           {
            PrintFormat("   , : %d",GetLastError());
            return false;
           }
        }
     }
//--- 
   CRandom myRandom;
   myRandom.randomSet(rand());
//---  id
   this.Id(myRandom.int32());
//---
   this.m_is_init=true;

//---
   return true;
  }
//+------------------------------------------------------------------+
//|                                             |
//+------------------------------------------------------------------+
bool CiOcoObject::Deinit(void)
  {
//---   
   if(this.m_is_init)
     {
      //---    
      for(int ord_idx=0;ord_idx<ArraySize(this.m_order_tickets);ord_idx++)
        {
         //---   
         ulong curr_ord_ticket=this.m_order_tickets[ord_idx];
         //---   
         int other_ord_idx=!ord_idx;
         ulong other_ord_ticket=this.m_order_tickets[other_ord_idx];

         //---
         COrderInfo order_obj;

         //---    
         if(!order_obj.Select(curr_ord_ticket))
           {
            PrintFormat(" #%d     .",curr_ord_ticket);
            //---                     
            if(order_obj.Select(other_ord_ticket))
              {
               CTrade trade_obj;
               //---
               if(trade_obj.OrderDelete(other_ord_ticket))
                  return true;
              }
           }
        }
     }
//---
   return false;
  }
//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
ENUM_ORDER_TYPE CiOcoObject::BaseOrderType(const ENUM_ORDER_TYPE _ord_type)
  {
   ENUM_ORDER_TYPE base_ord_type=WRONG_VALUE;
//---
   if(_ord_type==ORDER_TYPE_BUY || _ord_type==ORDER_TYPE_BUY_STOP ||
      _ord_type==ORDER_TYPE_BUY_LIMIT || _ord_type==ORDER_TYPE_BUY_STOP_LIMIT)
     {base_ord_type=ORDER_TYPE_BUY;}
   else if(_ord_type==ORDER_TYPE_SELL || _ord_type==ORDER_TYPE_SELL_STOP || 
      _ord_type==ORDER_TYPE_SELL_LIMIT || _ord_type==ORDER_TYPE_SELL_STOP_LIMIT)
        { base_ord_type=ORDER_TYPE_SELL;}
//---
   return base_ord_type;
  }
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
ENUM_BASE_PENDING_TYPE CiOcoObject::PendingType(const ENUM_PENDING_ORDER_TYPE _pend_type)
  {
   ENUM_BASE_PENDING_TYPE base_pend_type=WRONG_VALUE;
//---
   if(_pend_type==PENDING_ORDER_TYPE_BUY_STOP || _pend_type==PENDING_ORDER_TYPE_SELL_STOP)
      base_pend_type=BASE_PENDING_TYPE_STOP;
   else if(_pend_type==PENDING_ORDER_TYPE_BUY_LIMIT || _pend_type==PENDING_ORDER_TYPE_SELL_LIMIT)
      base_pend_type=BASE_PENDING_TYPE_LIMIT;
   else if(_pend_type==PENDING_ORDER_TYPE_BUY_STOP_LIMIT || 
      _pend_type==PENDING_ORDER_TYPE_SELL_STOP_LIMIT)
      base_pend_type=BASE_PENDING_TYPE_STOPLIMIT;
//---
   return base_pend_type;
  }
//+------------------------------------------------------------------+
