//+------------------------------------------------------------------+
//|                                                      Network.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#include <My\Cmlp-.mqh>
//+------------------------------------------------------------------+
//| Unconventional RBM that uses:                                    |
//| reconstruction-error instead of free-energy                      |
//| and back-propagation instead of contrastive divergence           |
//+------------------------------------------------------------------+
class C_u_rbm : public Cmlp
{
protected:

public:
   void              GetPositive();
   void              GetNegative();
   
   void              BackPropagate(double LearningRate = 0.1);

   double            Get(ENUM_REGRESSION_METRIC R)
   {                 return(label.RegressionMetric(inputs, R));
   }

   void              C_u_rbm(Smlp &MLP) : Cmlp(MLP)
   {  validated = false;
      int _layers =    ArraySize(MLP.arch);
      if(_layers == 2 && MLP.arch[0] > MLP.arch[1])
      {  ArrayResize(biases, _layers);
         //
         ArrayResize(gradients, _layers);
         ArrayResize(gradients_1st_moment, _layers);
         ArrayResize(gradients_2nd_moment, _layers);
         ArrayResize(sum_gradients, _layers);
         ArrayResize(sum_gradients_update, _layers);
         //
         ArrayResize(deltas, _layers);
         ArrayResize(deltas_1st_moment, _layers);
         ArrayResize(deltas_2nd_moment, _layers);
         ArrayResize(sum_deltas, _layers);
         ArrayResize(sum_deltas_update, _layers);
         //
         hidden_layers = 0;
         bool _norm_validated = true;
         for(int i = 0; i < _layers; i++)
         {  int _rows = MLP.arch[_layers - 1 - i], _columns = MLP.arch[i];
            //
            biases[i].Init(_rows);
            biases[i].Fill(MLP.initial_bias);
            //
            gradients[i].Init(_rows, _columns);
            gradients[i].Fill(0.0);
            //
            gradients_1st_moment[i].Init(_rows, _columns);
            gradients_1st_moment[i].Fill(0.0);
            gradients_2nd_moment[i].Init(_rows, _columns);
            gradients_2nd_moment[i].Fill(0.0);
            //
            sum_gradients[i].Init(_rows, _columns);
            sum_gradients[i].Fill(0.0);
            sum_gradients_update[i].Init(_rows, _columns);
            sum_gradients_update[i].Fill(0.0);
            //
            deltas[i].Init(_rows);
            deltas[i].Fill(0.0);
            deltas_1st_moment[i].Init(_rows);
            deltas_1st_moment[i].Fill(0.0);
            deltas_2nd_moment[i].Init(_rows);
            deltas_2nd_moment[i].Fill(0.0);
            sum_deltas[i].Init(_rows);
            sum_deltas[i].Fill(0.0);
            sum_deltas_update[i].Init(_rows);
            sum_deltas_update[i].Fill(0.0);
         }
         validated = true;
      }
      else
      {  printf(__FUNCSIG__ +
                " invalid network arch! Settings size is: %i, Max layer size is: %i, Min layer size is: %i, and activation is %s ",
                _layers, MLP.arch[ArrayMaximum(MLP.arch)], MLP.arch[ArrayMinimum(MLP.arch)], EnumToString(MLP.activation)
               );
      }
   };
   void              ~C_u_rbm(void) { };
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void C_u_rbm::GetPositive(void)
{  vector _positive = weights[0].MatMul(inputs), _output;
   _positive += biases[0];
   _positive.Activation(_output, THIS.activation);
   output = _output;
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void C_u_rbm::GetNegative(void)
{  vector _negative = output.MatMul(weights[0]), _output;
   _negative += biases[1];
   _negative.Activation(_output, THIS.activation);
   label = _output;
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void C_u_rbm::BackPropagate(double LearningRate = 0.1)
{  
//COMPUTE DELTAS
   vector _loss = label.LossGradient(inputs, THIS.loss);
   //
   vector _negative = output.MatMul(weights[0]), _negative_derivative;
   _negative.Derivative(_negative_derivative, THIS.activation);
   deltas[1] = Hadamard(_loss, _negative_derivative);
   //
   vector _positive = weights[0].MatMul(inputs), _positive_derivative;
   _positive.Derivative(_positive_derivative, THIS.activation);
   matrix _weights;
   _weights.Copy(weights[0]);
   _weights.Transpose();
   vector _product = _weights.MatMul(deltas[1]);
   deltas[0] = Hadamard(_product, _positive_derivative);
//COMPUTE GRADIENTS
   gradients[0] = TransposeCol(deltas[0]).MatMul(TransposeRow(inputs));
   gradients[1] = TransposeCol(deltas[1]).MatMul(TransposeRow(output));
   
// UPDATE WEIGHTS AND BIASES
   for(int h = 1; h >= 0;  h--)
   {  matrix _gradients;
      _gradients.Copy(gradients[h]);
      if(h == 1)
      {  _gradients = _gradients.Transpose();
      }
      weights[0] -= LearningRate * _gradients;
      biases[h] -= LearningRate * deltas[h];
   }
}
//+------------------------------------------------------------------+
