//+------------------------------------------------------------------+
//|                                          Test Moving Average.mq4 |
//+------------------------------------------------------------------+
//   Moving Average  MetaQuotes Software Corp.(http://www.metaquotes.net/).
//      /. 
//            

// : 
//  MovingPeriodStepsNumber  MovingShiftStepsNumber    TestsNumber.
//          Counter,
//      1  TestsNumber   1.
//     .
//          .
//     ,  init()  deinit()  .
//      .     :
//    //  .
//         .
//         ,     .

#define MAGICMA  20050610

extern int Counter                    = 1;    //   
extern int TestsNumber                = 200;  //   -   
extern int MovingPeriodStepsNumber    = 20;   //     MovingPeriod 
extern int MovingShiftStepsNumber     = 10;   //     MovingShift
extern double MovingPeriodLow         = 150;  //      MovingPeriod
extern double MovingShiftLow          = 1;    //      MovingShift
extern double MovingPeriodStep        = 1;    //    MovingPeriod 
extern double MovingShiftStep         = 1;    //    MovingShift

//    Moving Average
extern double MovingPeriod            = 12;
extern double MovingShift             = 6;
extern double Lots                    = 0.1;
extern double MaximumRisk             = 0.02;
extern double DecreaseFactor          = 3;

//int TestsCnt;               //   
int FilePtr;               //    
double Criterion;          //   
int h;                     //   
double Data[][4];          //      
double StartBalance;       //   
double MaxEqu;             //   
double MaxDD;              //   
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init() {
//           
//        .
  if (IsTesting() && TestsNumber > 0) {
//         
//     FilePtr 
//      .
    if (GlobalVariableCheck("FilePtr")==false || Counter == 1) {
      FilePtr = 0; 
      GlobalVariableSet("FilePtr",0); 
    } else {
      FilePtr = GlobalVariableGet("FilePtr"); 
    }
/*
//    
    if (GlobalVariableCheck("TestsCnt")==false || Counter == 1) {
      TestsCnt = 0; 
      GlobalVariableSet("TestsCnt",0); 
    } else {
      TestsCnt = GlobalVariableGet("TestsCnt"); 
    }
*/    
//      ,         
    MovingPeriod = MovingPeriodLow+((Counter-1)/MovingShiftStepsNumber)*MovingPeriodStep;
    MovingShift = MovingShiftLow+((Counter-1)%MovingShiftStepsNumber)*MovingShiftStep;
// ,  ,     
    StartBalance = AccountBalance();
    MaxEqu = 0;
    MaxDD = 0;
  }   
  return(0);
}
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit() {
//      ,  ,
//          .
  if (IsTesting() && TestsNumber > 0) {
/*
//    
    TestsCnt++;
    GlobalVariableSet("TestsCnt",TestsCnt); 
*/    
//     
    if (AccountEquity() > MaxEqu) MaxEqu = AccountEquity();
    if (MaxEqu-AccountEquity() > MaxDD) MaxDD = MaxEqu-AccountEquity();
    Criterion = (AccountBalance()-StartBalance)/MaxDD;
//    .     
//       .
//     :  ,     .
//         (Counter).
    if (Counter == 1) {
//  , /  .
      h=FileOpen("test.txt",FILE_CSV|FILE_WRITE,';');
      FileWrite(h,Criterion,MovingPeriod,MovingShift,Counter);
//         
      FilePtr = FileTell(h); 
      GlobalVariableSet("FilePtr",FilePtr);
      FileClose(h); 
    } else {
//       ,     
      h=FileOpen("test.txt",FILE_CSV|FILE_READ|FILE_WRITE,';');
//         
      FilePtr = GlobalVariableGet("FilePtr");
      FileSeek(h,FilePtr, SEEK_SET);
      FileWrite(h,Criterion,MovingPeriod,MovingShift,Counter);
//      
      FilePtr = FileTell(h); 
      GlobalVariableSet("FilePtr",FilePtr);
//     
      if (Counter == TestsNumber) {
//    
//    
        ArrayResize(Data,TestsNumber); 
//            
        FileSeek(h,0,SEEK_SET);
//      
        int i = 0;
        while (i<TestsNumber && FileIsEnding(h)== false) {
          for (int j=0;j<4;j++) {
            Data[i][j]=FileReadNumber(h); 
          }
          i++;
        } 
//       
        ArraySort(Data,WHOLE_ARRAY,0,MODE_DESCEND);
//    .             
        FileClose(h); 
        h=FileOpen("test.txt",FILE_CSV|FILE_WRITE,' ');
        FileWrite(h,"  ","     MovingPeriod"," MovingShift"," ");
        for (i=0;i<TestsNumber;i++) {
          FileWrite(h,DoubleToStr(Data[i][0],10),"        ",Data[i][1],"        ",Data[i][2],"        ",Data[i][3]);
        }
//    
        GlobalVariableDel("FilePtr");
/*
//    
        GlobalVariableDel("TestsCnt"); 
*/
      }
      FileClose(h); 
    }
  }
  return(0);
}
//+------------------------------------------------------------------+
//| Calculate open positions                                         |
//+------------------------------------------------------------------+
int CalculateCurrentOrders(string symbol)
  {
   int buys=0,sells=0;
//----
   for(int i=0;i<OrdersTotal();i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) break;
      if(OrderSymbol()==Symbol() && OrderMagicNumber()==MAGICMA)
        {
         if(OrderType()==OP_BUY)  buys++;
         if(OrderType()==OP_SELL) sells++;
        }
     }
//---- return orders volume
   if(buys>0) return(buys);
   else       return(-sells);
  }
//+------------------------------------------------------------------+
//| Calculate optimal lot size                                       |
//+------------------------------------------------------------------+
double LotsOptimized()
  {
   double lot=Lots;
   int    orders=HistoryTotal();     // history orders total
   int    losses=0;                  // number of losses orders without a break
//---- select lot size
   lot=NormalizeDouble(AccountFreeMargin()*MaximumRisk/1000.0,1);
//---- calcuulate number of losses orders without a break
   if(DecreaseFactor>0)
     {
      for(int i=orders-1;i>=0;i--)
        {
         if(OrderSelect(i,SELECT_BY_POS,MODE_HISTORY)==false) { Print("Error in history!"); break; }
         if(OrderSymbol()!=Symbol() || OrderType()>OP_SELL) continue;
         //----
         if(OrderProfit()>0) break;
         if(OrderProfit()<0) losses++;
        }
      if(losses>1) lot=NormalizeDouble(lot-lot*losses/DecreaseFactor,1);
     }
//---- return lot size
   if(lot<0.1) lot=0.1;
   return(lot);
  }
//+------------------------------------------------------------------+
//| Check for open order conditions                                  |
//+------------------------------------------------------------------+
void CheckForOpen()
  {
   double ma;
   int    res;
//---- go trading only for first tiks of new bar
   if(Volume[0]>1) return;
//---- get Moving Average 
   ma=iMA(NULL,0,MovingPeriod,MovingShift,MODE_SMA,PRICE_CLOSE,0);
//---- sell conditions
   if(Open[1]>ma && Close[1]<ma)  
     {
      res=OrderSend(Symbol(),OP_SELL,LotsOptimized(),Bid,3,0,0,"",MAGICMA,0,Red);
      return;
     }
//---- buy conditions
   if(Open[1]<ma && Close[1]>ma)  
     {
      res=OrderSend(Symbol(),OP_BUY,LotsOptimized(),Ask,3,0,0,"",MAGICMA,0,Blue);
      return;
     }
//----
  }
//+------------------------------------------------------------------+
//| Check for close order conditions                                 |
//+------------------------------------------------------------------+
void CheckForClose()
  {
   double ma;
//---- go trading only for first tiks of new bar
   if(Volume[0]>1) return;
//---- get Moving Average 
   ma=iMA(NULL,0,MovingPeriod,MovingShift,MODE_SMA,PRICE_CLOSE,0);
//----
   for(int i=0;i<OrdersTotal();i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false)        break;
      if(OrderMagicNumber()!=MAGICMA || OrderSymbol()!=Symbol()) continue;
      //---- check order type 
      if(OrderType()==OP_BUY)
        {
         if(Open[1]>ma && Close[1]<ma) OrderClose(OrderTicket(),OrderLots(),Bid,3,White);
         break;
        }
      if(OrderType()==OP_SELL)
        {
         if(Open[1]<ma && Close[1]>ma) OrderClose(OrderTicket(),OrderLots(),Ask,3,White);
         break;
        }
     }
//----
  }
//+------------------------------------------------------------------+
//| Start function                                                   |
//+------------------------------------------------------------------+
void start()
  {
  if (IsTesting() && TestsNumber > 0) {
//            
    if (AccountEquity() > MaxEqu) MaxEqu = AccountEquity();
    if (MaxEqu-AccountEquity() > MaxDD) MaxDD = MaxEqu-AccountEquity();
  }
//---- check for history and trading
   if(Bars<100 || IsTradeAllowed()==false) return;
//---- calculate open orders by current symbol
   if(CalculateCurrentOrders(Symbol())==0) CheckForOpen();
   else                                    CheckForClose();
//----
  }
//+------------------------------------------------------------------+