//+------------------------------------------------------------------+
//|                                                        combi.mqh |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include "linearmodel.mqh"
//+------------------------------------------------------------------+
//| Class implementing combinatorial COMBI algorithm                 |
//+------------------------------------------------------------------+
class COMBI:public LinearModel
  {
private: 
    Combination getBest(CVector &combinations)
          {
            double proxys[];
            int best[];       
             
            ArrayResize(best,combinations.size());
            ArrayResize(proxys,combinations.size()); 
            
             for(int k = 0; k<combinations.size(); k++)
               {
                 best[k]=k;
                 proxys[k]=combinations[k].evaluation();
               }
               
           MathQuickSortAscending(proxys,best,0,int(proxys.Size()-1));  
           
           return combinations[best[0]];   
                  
          } 
protected:

  virtual void removeExtraCombinations(void) override
    {
      CVector2d realBestCombinations;
      CVector n;
      Combination top;
      for(int i = 0 ; i<bestCombinations.size(); i++)
         {        
           top = getBest(bestCombinations[i]);
           n.push_back(top);
         }
      
      top = getBest(n);
      
      CVector sorted;
            
      sorted.push_back(top);
      
      realBestCombinations.push_back(sorted);
      
      bestCombinations = realBestCombinations;
    }
    
   virtual bool preparations(SplittedData &data, CVector &_bestCombinations) override
    {
      lastLevelEvaluation = DBL_MAX;
      return (bestCombinations.push_back(_bestCombinations) && ulong(level+1) < data.xTrain.Cols());
    }

   void              generateCombinations(int n_cols,vector &out[])  override
     {
      GmdhModel::nChooseK(n_cols,level,out);
      return;
     }

public:
                     COMBI(void):LinearModel()
     {
      modelName = "COMBI";
     }

   bool fit(vector &time_series,int lags,double testsize=0.5,CriterionType criterion=stab)
     {
 
      if(lags < 1)
        {
         Print(__FUNCTION__," lags must be >= 1");
         return false;
        }
        
       PairMVXd transformed = timeSeriesTransformation(time_series,lags);

       SplittedData splited = splitData(transformed.first,transformed.second,testsize);
       
       Criterion criter(criterion);
      
      int pAverage = 1;
      double limit  = 0;
      int kBest = pAverage;
      
      if(validateInputData(testsize, pAverage, limit, kBest))
         return false;
      
      return GmdhModel::gmdhFit(splited.xTrain, splited.yTrain, criter, kBest, testsize, pAverage, limit);
     }
     
   bool  fit(matrix &vars,vector &targets,double testsize=0.5,CriterionType criterion=stab)
      {
 
       if(vars.Cols() < 1)
        {
         Print(__FUNCTION__," columns in vars must be >= 1");
         return false;
        }
        
       if(vars.Rows() != targets.Size())
        {
         Print(__FUNCTION__, " vars dimensions donot correspond with targets");
         return false;
        } 
        
       SplittedData splited = splitData(vars,targets,testsize);
       
       Criterion criter(criterion);
        
       int pAverage = 1;
       double limit  = 0;
       int kBest = pAverage;

       if(validateInputData(testsize, pAverage, limit, kBest))
         return false;
      
      return GmdhModel::gmdhFit(splited.xTrain, splited.yTrain, criter, kBest, testsize, pAverage, limit);
     }


  };
//+------------------------------------------------------------------+
