//+------------------------------------------------------------------+
//|                                                         RAVI.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Red 
//----    
extern int Period1=7; 
extern int Period2=65; 
extern int MA_Metod=0;
extern int PRICE=0;
//----  
double ExtBuffer[]; 
//+------------------------------------------------------------------+ 
//| RAVI initialization function                                     | 
//+------------------------------------------------------------------+ 
int init() 
  { 
//----   
   SetIndexStyle(0,DRAW_LINE); 
//----   
   SetIndexBuffer(0,ExtBuffer); 
//----       
   IndicatorShortName("RAVI (" + Period1+ ","+Period2+")"); 
   SetIndexLabel(0,"RAVI"); 
//----  
   return(0); 
  } 
//+------------------------------------------------------------------+ 
//| RAVI iteration function                                          | 
//+------------------------------------------------------------------+ 
int start() 
  {
int MinBars=MathMax(Period1, Period2); 
//----       
if (Bars<MinBars)
     return(0);
//----+      
double MA1,MA2,result; 
//----+        
int MaxBar,bar,limit,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)
    return(-1);
//----       
if (counted_bars>0)
    counted_bars--;
//----     , 
                 //        
MaxBar=Bars-1-MinBars;
//----     , 
                //        
limit=Bars-counted_bars-1; 
//----  
if (limit>MaxBar)
    {
     for (int ii=Bars-1; ii>=MaxBar; ii--)ExtBuffer[ii]=0.0;
     limit=MaxBar;
    }
 
//----   
for(bar=0; bar<=limit; bar++) 
   { 
     MA1=iMA(NULL,0,Period1,0,MA_Metod,PRICE,bar); 
     MA2=iMA(NULL,0,Period2,0,MA_Metod,PRICE,bar); 
     //---- 
     result=((MA1-MA2)/MA2)*100; 
     ExtBuffer[bar]=result; 
   }  
//---- 
   return(0); 
  } 
//+------------------------------------------------------------------+

