//+------------------------------------------------------------------+
//|                                               Get_RAVISeries.mqh |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
bool Get_RAVISeries(int Number, string symbol,int timeframe, 
                    bool NullBarRecount, int Period1, int Period2, 
                    int MA_Metod, int  PRICE, double& InputBuffer[])    
  {
//----     
   int IBARS = iBars(symbol, timeframe);  
//----        
   if(IBARS < MathMax(Period1, Period2))
       return(false);
//----   
   if(ArraySize(InputBuffer) < IBARS)
     {
       ArraySetAsSeries(InputBuffer, false);
       //----  
       ArrayResize(InputBuffer, IBARS); 
       //----
       ArraySetAsSeries(InputBuffer, true);
     } 
//----+     
   static int IndCounted[]; 
//----+    
   if(ArraySize(IndCounted) < Number + 1)
     {
       ArrayResize(IndCounted, Number + 1); 
     }
 //----+   
   int LastCountBar;
//----+     
   if(!NullBarRecount)
      LastCountBar = 1;
//----+      
   double MA1,MA2,result; 
//----+         
   int MaxBar, bar, limit, counted_bars = IndCounted[Number];
//----+     
   IndCounted[Number] = IBARS - 1;
//----     , 
//        
   limit = IBARS - counted_bars - 1; 
   // Print(IBARS - counted_bars); 
//----     , 
//        
   MaxBar = IBARS - 1 - MathMax(Period1, Period2); 
//----   
   if(limit > MaxBar)
     {
       limit = MaxBar;
       for(bar = IBARS - 1; bar >= 0; bar--)
         {
           InputBuffer[bar] = 0.0;
         }
     } 
//----+     
   for(bar = limit; bar >= LastCountBar; bar--)
     { 
       MA1 = iMA(symbol, timeframe, Period1, 0, MA_Metod, PRICE, bar); 
       MA2 = iMA(symbol, timeframe, Period2, 0, MA_Metod, PRICE, bar); 
       //---- 
       result = ((MA1 - MA2) / MA2)*100; 
       InputBuffer[bar] = result; 
     } 
//----+  
   return(true);
  }
//+------------------------------------------------------------------+


