//+------------------------------------------------------------------+
//|                                                my_perceptron.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Include                                                          |
//+------------------------------------------------------------------+
#include <Expert\Expert.mqh>
//--- available signals
#include <Expert\Signal\My\SignalPerceptron.mqh>
//--- available trailing
#include <Expert\Trailing\TrailingNone.mqh>
//--- available money management
#include <Expert\Money\MoneyFixedMargin.mqh>
//+------------------------------------------------------------------+
//| Inputs                                                           |
//+------------------------------------------------------------------+
//--- inputs for expert
input string Expert_Title                       = "my_perceptron"; // Document name
ulong        Expert_MagicNumber                 = 8292;           //
bool         Expert_EveryTick                   = false;          //
//--- inputs for main signal
input int    Signal_ThresholdOpen               = 10;             // Signal threshold value to open [0...100]
input int    Signal_ThresholdClose              = 10;             // Signal threshold value to close [0...100]
input double Signal_PriceLevel                  = 0.0;            // Price level to execute a deal
input double Signal_StopLevel                   = 50.0;           // Stop Loss level (in points)
input double Signal_TakeLevel                   = 50.0;           // Take Profit level (in points)
input int    Signal_Expiration                  = 4;              // Expiration of pending orders (in bars)
input int    Signal_Perceptron_Features         = 8;              // Perceptron(8,1,5,3,4,2,1,1,...) Features
input int    Signal_Perceptron_Hidden           = 1;              // Perceptron(8,1,5,3,4,2,1,1,...) Hidden Layers
input int    Signal_Perceptron_Hidden_1_Size    = 5;              // Perceptron(8,1,5,3,4,2,1,1,...) Hidden Layer 1 Size
input int    Signal_Perceptron_Hidden_2_Size    = 3;              // Perceptron(8,1,5,3,4,2,1,1,...) Hidden Layer 2 Size
input int    Signal_Perceptron_Training_Points  = 4;              // Perceptron(8,1,5,3,4,2,1,1,...) Training Points
input int    Signal_Perceptron_Training_Restarts = 2;             // Perceptron(8,1,5,3,4,2,1,1,...) Training Restarts
input int    Signal_Perceptron_ActivationType   = 1;              // Perceptron(8,1,5,3,4,2,1,1,...) Activation Type Index (0 - 3)
input double Signal_Perceptron_Hidden_1_Bias    = 1;              // Perceptron(8,1,5,3,4,2,1,1,...) Hidden Layer 1 Bias
input double Signal_Perceptron_Hidden_2_Bias    = 1;              // Perceptron(8,1,5,3,4,2,1,1,...) Hidden Layer 2 Bias
input double Signal_Perceptron_Output_Bias      = 1;              // Perceptron(8,1,5,3,4,2,1,1,...) Output Layer Bias
input double Signal_Perceptron_Weight           = 1.0;            // Perceptron(8,1,5,3,4,2,1,1,...) Weight [0...1.0]
//--- inputs for money
input double Money_FixMargin_Percent            = 10.0;           // Percentage of margin
//+------------------------------------------------------------------+
//| Global expert object                                             |
//+------------------------------------------------------------------+
CExpert ExtExpert;
//+------------------------------------------------------------------+
//| Initialization function of the expert                            |
//+------------------------------------------------------------------+
int OnInit()
{
//--- Initializing expert
   if(!ExtExpert.Init(Symbol(), Period(), Expert_EveryTick, Expert_MagicNumber))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing expert");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Creating signal
   CExpertSignal *signal = new CExpertSignal;
   if(signal == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating signal");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//---
   ExtExpert.InitSignal(signal);
   signal.ThresholdOpen(Signal_ThresholdOpen);
   signal.ThresholdClose(Signal_ThresholdClose);
   signal.PriceLevel(Signal_PriceLevel);
   signal.StopLevel(Signal_StopLevel);
   signal.TakeLevel(Signal_TakeLevel);
   signal.Expiration(Signal_Expiration);
//--- Creating filter CSignalPerceptron
   CSignalPerceptron *filter0 = new CSignalPerceptron;
   if(filter0 == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating filter0");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
   signal.AddFilter(filter0);
//--- Set filter parameters
   filter0.Features(Signal_Perceptron_Features);
   filter0.Hidden(Signal_Perceptron_Hidden);
   filter0.Hidden_1_Size(Signal_Perceptron_Hidden_1_Size);
   filter0.Hidden_2_Size(Signal_Perceptron_Hidden_2_Size);
   filter0.Training_Points(Signal_Perceptron_Training_Points);
   filter0.Training_Restarts(Signal_Perceptron_Training_Restarts);
   filter0.ActivationType(Signal_Perceptron_ActivationType);
   filter0.Hidden_1_Bias(Signal_Perceptron_Hidden_1_Bias);
   filter0.Hidden_2_Bias(Signal_Perceptron_Hidden_2_Bias);
   filter0.Output_Bias(Signal_Perceptron_Output_Bias);
   filter0.Weight(Signal_Perceptron_Weight);
//--- Creation of trailing object
   CTrailingNone *trailing = new CTrailingNone;
   if(trailing == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Add trailing to expert (will be deleted automatically))
   if(!ExtExpert.InitTrailing(trailing))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing trailing");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Set trailing parameters
//--- Creation of money object
   CMoneyFixedMargin *money = new CMoneyFixedMargin;
   if(money == NULL)
   {  //--- failed
      printf(__FUNCTION__ + ": error creating money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Add money to expert (will be deleted automatically))
   if(!ExtExpert.InitMoney(money))
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing money");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Set money parameters
   money.Percent(Money_FixMargin_Percent);
//--- Check all trading objects parameters
   if(!ExtExpert.ValidationSettings())
   {  //--- failed
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- Tuning of all necessary indicators
   if(!ExtExpert.InitIndicators())
   {  //--- failed
      printf(__FUNCTION__ + ": error initializing indicators");
      ExtExpert.Deinit();
      return(INIT_FAILED);
   }
//--- ok
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Deinitialization function of the expert                          |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{  ExtExpert.Deinit();
}
//+------------------------------------------------------------------+
//| "Tick" event handler function                                    |
//+------------------------------------------------------------------+
void OnTick()
{  ExtExpert.OnTick();
}
//+------------------------------------------------------------------+
//| "Trade" event handler function                                   |
//+------------------------------------------------------------------+
void OnTrade()
{  ExtExpert.OnTrade();
}
//+------------------------------------------------------------------+
//| "Timer" event handler function                                   |
//+------------------------------------------------------------------+
void OnTimer()
{  ExtExpert.OnTimer();
}
//+------------------------------------------------------------------+
