//+------------------------------------------------------------------+.
//|                                    Moving Averages Statistic.mq5 |
//+------------------------------------------------------------------+.
//|                                              Moving Averages.mq5 |
//|              Copyright Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+.
#property copyright "Copyright 2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+.
//|                                                                  |
//+------------------------------------------------------------------+.  
#include <Trade\Trade.mqh>

#include <Bulaschev_Statistic.mqh>
input Enum_Efficiency result=0;// 

input double MaximumRisk        = 0.02;    // հٷֱ
input double DecreaseFactor     = 3;       // ϵ
input int    MovingPeriod       = 12;      // ƶƽ
input int    MovingShift        = 6;       // ƶƽת

//---
int   ExtHandle=0;
//+------------------------------------------------------------------+.
//| Ż                                       |
//+------------------------------------------------------------------+.
double TradeSizeOptimized(void)
  {
//--- ѡ
   double lot=NormalizeDouble(AccountInfoDouble(ACCOUNT_FREEMARGIN)*MaximumRisk/1000.0,2);
//--- 
   if(DecreaseFactor>0)
     {
      //--- ѡʷ
      HistorySelect(0,TimeCurrent());
      //---
      int    orders=HistoryDealsTotal();  // ʷ
      int    losses=0;                    // Ķ

      for(int i=orders-1;i>=0;i--)
        {
         ulong ticket=HistoryDealGetTicket(i);
         if(ticket==0)
           {
            Print("HistoryDealGetTicket ʧ, ûнʷ");
            break;
           }
         //--- 齻Ʒ
         if(HistoryDealGetString(ticket,DEAL_SYMBOL)!=_Symbol) continue;
         //--- 
         double profit=HistoryDealGetDouble(ticket,DEAL_PROFIT);
         if(profit>0.0) break;
         if(profit<0.0) losses++;
        }
      //---
      if(losses>1) lot=NormalizeDouble(lot-lot*losses/DecreaseFactor,1);
     }
//--- 淶
   double stepvol=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_STEP);
   lot=stepvol*NormalizeDouble(lot/stepvol,0);

   double minvol=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);
   if(lot<minvol) lot=minvol;

   double maxvol=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MAX);
   if(lot>maxvol) lot=maxvol;
//--- ؽ
   return(lot);
  }
//+------------------------------------------------------------------+.
//| 鿪                                  |
//+------------------------------------------------------------------+.
void CheckForOpen()
  {
   MqlRates rt[2];
//--- ֻȵĶн
   if(CopyRates(_Symbol,_Period,0,2,rt)!=2)
     {
      Print("CopyRates  ",_Symbol," ʧ, ûʷ");
      return;
     }
   if(rt[1].tick_volume>1) return;
//--- ȡõǰƶƽֵ 
   double   ma[1];
   if(CopyBuffer(ExtHandle,0,0,1,ma)!=1)
     {
      Print("CopyBuffer  iMA ʧ, û");
      return;
     }
//--- ź
   ENUM_ORDER_TYPE signal=WRONG_VALUE;

   if(rt[0].open>ma[0] && rt[0].close<ma[0]) signal=ORDER_TYPE_SELL;    // 
   else
      if(rt[0].open<ma[0] && rt[0].close>ma[0]) signal=ORDER_TYPE_BUY;  // 
//--- ļ
   if(signal!=WRONG_VALUE)
      if(TerminalInfoInteger(TERMINAL_TRADE_ALLOWED))
         if(Bars(_Symbol,_Period)>100)
           {
            CTrade trade;
            trade.PositionOpen(_Symbol,signal,TradeSizeOptimized(),
                               SymbolInfoDouble(_Symbol,signal==ORDER_TYPE_SELL ? SYMBOL_BID:SYMBOL_ASK),
                               0,0);
           }
//---
  }
//+------------------------------------------------------------------+.
//| ƽ                                 |
//+------------------------------------------------------------------+.
void CheckForClose()
  {
   MqlRates rt[2];
//--- ֻȵĶн
   if(CopyRates(_Symbol,_Period,0,2,rt)!=2)
     {
      Print("CopyRates  ",_Symbol," ʧ, ûʷ");
      return;
     }
   if(rt[1].tick_volume>1) return;
//--- ȡõǰƶƽֵ 
   double   ma[1];
   if(CopyBuffer(ExtHandle,0,0,1,ma)!=1)
     {
      Print("CopyBuffer  iMA ʧ, û");
      return;
     }
//--- ֮ǰѾѡ˲λ
   bool signal=false;
   long type=PositionGetInteger(POSITION_TYPE);

   if(type==(long)POSITION_TYPE_BUY   && rt[0].open>ma[0] && rt[0].close<ma[0]) signal=true;
   if(type==(long)POSITION_TYPE_SELL  && rt[0].open<ma[0] && rt[0].close>ma[0]) signal=true;
//--- ļ
   if(signal)
      if(TerminalInfoInteger(TERMINAL_TRADE_ALLOWED))
         if(Bars(_Symbol,_Period)>100)
           {
            CTrade trade;
            trade.PositionClose(_Symbol,3);
           }
//---
  }
//+------------------------------------------------------------------+.
//| EAʼ                                   |
//+------------------------------------------------------------------+.
int OnInit()
  {
//---
   ExtHandle=iMA(_Symbol,_Period,MovingPeriod,MovingShift,MODE_SMA,PRICE_CLOSE);
//---
   return(0);
  }
//+------------------------------------------------------------------+.
//| EA                                             |
//+------------------------------------------------------------------+.
void OnTick()
  {
//---
   if(PositionSelect(_Symbol)) CheckForClose();
   else                         CheckForOpen();   
//---  
  }
//+------------------------------------------------------------------+.
//| EA                                                  |
//+------------------------------------------------------------------+.
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+.
//|                                                                  |
//+------------------------------------------------------------------+.

C_PosStat  start;
//+------------------------------------------------------------------+.
//| EAŻ                                     |
//+------------------------------------------------------------------+.
double OnTester()
  {
   start.OnPosStat();
   start.OnTradesStat();

   double res;
   switch(result)
     {
      case 0: res=start.avg.enter_efficiency;   break;
      case 1: res=-start.stdev.enter_efficiency; break;
      case 2: res=start.avg.exit_efficiency;    break;
      case 3: res=-start.stdev.exit_efficiency;  break;
      case 4: res=start.avg.trade_efficiency;   break;
      case 5: res=-start.stdev.trade_efficiency; break;
      default : res=0; break;
     }
   return(res);
  }
//+------------------------------------------------------------------+.
//| EAȥʼ                                 |
//+------------------------------------------------------------------+.
void OnDeinit(const int reason)
  {
   if(!(bool)MQL5InfoInteger(MQL5_OPTIMIZATION))
     {
      start.WriteFileDeals();
      start.WriteFileTrades();
      start.WriteFileTrades_all();
      start.WriteFileDealsHTML2();
      start.WriteFileTradesHTML2();
     }
  }
//+------------------------------------------------------------------+.
