//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
#define _ToRadians(A) (A * (M_PI / 180.0))
#define _SizeLine 200
//+------------------------------------------------------------------+
CCanvas canvas;
//+------------------------------------------------------------------+
struct st_00
{
    int     x,
            y;
    double  Angle,
            Const_B;
}global;
//+------------------------------------------------------------------+
void PlotText(const uchar line, const string sz0)
{
    uint w, h;

    TextGetSize(sz0, w, h);
    canvas.TextOut(global.x - (w / 2), global.y + _SizeLine + (line * h) + 5, sz0, ColorToARGB(clrBlack));   
}
//+------------------------------------------------------------------+
void Func_01(void)
{
	int A[]={
              	-100, -150,
                -80,  -50,
                 30,   80,
                100,  120
            };

    int vx, vy;
    double ly, err;
    string s0 = "";

    canvas.LineVertical(global.x, global.y - _SizeLine, global.y + _SizeLine, ColorToARGB(clrRoyalBlue, 255));
    canvas.LineHorizontal(global.x - _SizeLine, global.x + _SizeLine, global.y, ColorToARGB(clrRoyalBlue, 255));

    err = 0;
    for (uint c0 = 0, c1 = 0; c1 < A.Size(); c0++)
    {
        vx = A[c1++];
        vy = A[c1++];
        canvas.FillCircle(global.x + vx, global.y - vy, 5, ColorToARGB(clrRed, 255));
        ly = vy - (vx * -MathTan(_ToRadians(global.Angle))) - global.Const_B;
        s0 += StringFormat("%.4f || ", MathAbs(ly));
        canvas.LineVertical(global.x + vx, global.y - vy, global.y + (int)(ly - vy), ColorToARGB(clrPurple));
        err += MathPow(ly, 2);
    }
    PlotText(3, StringFormat("Error: %.8f", err));
    PlotText(4, s0);
}
//+------------------------------------------------------------------+
void NewAngle(const char direct, const char updow, const double step = 0.1)
{
	canvas.Erase(ColorToARGB(clrWhite, 255));

    global.Angle = (MathAbs(global.Angle + (step * direct)) < 90 ? global.Angle + (step * direct) : global.Angle);
    global.Const_B += (step * updow);  
    PlotText(1, StringFormat("Angle in graus => %.2f", MathAbs(global.Angle)));
    PlotText(2, StringFormat("f(x) = %.4fx %c %.4f", -MathTan(_ToRadians(global.Angle)), (global.Const_B < 0 ? '-' : '+'), MathAbs(global.Const_B)));
    canvas.LineAA(
                global.x - (int)(_SizeLine * cos(_ToRadians(global.Angle))), 
                (global.y - (int)global.Const_B) - (int)(_SizeLine * sin(_ToRadians(global.Angle))), 
                global.x + (int)(_SizeLine * cos(_ToRadians(global.Angle))), 
                (global.y - (int)global.Const_B) + (int)(_SizeLine * sin(_ToRadians(global.Angle))), 
                ColorToARGB(clrForestGreen)
            );
   	
    Func_01();

	canvas.Update(true);
}
//+------------------------------------------------------------------+
int OnInit()
{	
    global.Angle = 0;
	global.x = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS, 0);
	global.y = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS, 0);

	canvas.CreateBitmapLabel("BL", 0, 0, global.x, global.y, COLOR_FORMAT_ARGB_NORMALIZE);
    global.x /= 2;
    global.y /= 2;
		
    NewAngle(0, 0);

	canvas.Update(true);
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
    switch (id)
    {
        case CHARTEVENT_KEYDOWN:
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_LEFT))
                NewAngle(-1, 0);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_RIGHT))
                NewAngle(1, 0);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_UP))
                NewAngle(0, 1);
            if (TerminalInfoInteger(TERMINAL_KEYSTATE_DOWN))
                NewAngle(0, -1);
            break;
    }
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	canvas.Destroy();
}
//+------------------------------------------------------------------+