//+---------------------------------------------------------------------------+
//|                                            Client.cpp                     |
//|                      Copyright  2012, http://www.mql4.com/ru/users/more  |
//|                                       tradertobe@gmail.com                |
//+---------------------------------------------------------------------------+

// Client.cpp

#include <winsock2.h>
#pragma comment(lib, "ws2_32")
#pragma comment(lib, "NetEventsProcDLL") // NetEventsProcDLL.lib placed in ...\FastStart\Client\ 
#include <iostream>

#include  "cNetEventsProcDLL.h"

// LocalIp = 0x6401a8c0 -> 192.168.1.100
// Returns a list of all local IP's on this computer (multiple IP's if multiple network adapters)
DWORD GetLocalIPs(char s8_IpList[][20], int &s32_IpCount);

/* This is the simple Client.
   It connects to Echo Server, send your input to Echo Server and read Echo from Server.

   ATTENTION !!! If your want to connect to local Server do not use  "127.0.0.1" !!!ATTENTION !!! 
   You may get all your local IP's by means of GetLocalIPs(...) function, here is call example:
   // Local IP's list
	char s8_IpList[10][20];

	int s32_IpCount;
	DWORD u32_Err = GetLocalIPs(s8_IpList, s32_IpCount);

	if (u32_Err)
	{
		printf("Get local IP's error !, no local IP means no network available...");
		return 1;
	}

	printf("\nLocal IP's list:\n");

	for (int i = 0; i<s32_IpCount; i++)
		printf("\n%s\n",s8_IpList[i]);
	//
*/

// This is the Server we want to connect to...
#define SERVER_IP   "192.168.1.5"  //this is mine local IP's get by means of GetLocalIPs(...) function,
                                   // do not use so called loopback  "127.0.0.1" address !!! 
#define PORT         2000

int main()
{
	// Local IP's list
	char s8_IpList[10][20];

	int s32_IpCount;
	DWORD u32_Err = GetLocalIPs(s8_IpList, s32_IpCount);

	if (u32_Err)
	{
		printf("Get local IP's error !, no local IP means no network available...");
		return 1;
	}

	printf("\nLocal IP's list:\n");

	for (int i = 0; i<s32_IpCount; i++)
		printf("\n%s\n",s8_IpList[i]);
	//

	char s8_ServerIP[] = SERVER_IP;
	int  s32_Port      = PORT;
	int  ph_Client[1];

	int  h_Client;

	DWORD u32_Error = cNetEventsProcDLL::ConnectTo(SERVER_IP, PORT, ph_Client);

	if (u32_Error)
	{
		printf("\nConnectTo(...) failed with error: %d\n", u32_Error);
		return 1;
	}
	else
		printf("\nConnectTo(...) OK, ph_Client[0] = : %d\n", ph_Client[0]);

	h_Client = ph_Client[0];

	// Connection is established successfully ! Let's  have some SendTo(...) data on this connection...
	char  ps8_SendData[200];
	int   s32_SendDataLen;;

	char   ps8_ReadBuf[1025];
	DWORD  s32_ReadBufLen = 1025;
	int    ps32_ReadLen[1];

	while(true)
	{
		std::cout << "\nEnter something to send to Server or quit 'q':\n" << std::endl;

		std::cin.getline(ps8_SendData, 200);

		s32_SendDataLen = strlen(ps8_SendData);

		OemToCharBuff(ps8_SendData, ps8_SendData, s32_SendDataLen);

		if (ps8_SendData[0] == 'q')
			break;

		u32_Error = cNetEventsProcDLL::SendToString(h_Client, ps8_SendData, s32_SendDataLen);	

		switch (u32_Error)
		{
		case 0:
			printf("\nSendTo(...) OK");
			printf("\nSendTo(%d...) sent %d bytes\n", h_Client, s32_SendDataLen);
			CharToOemBuff(ps8_SendData, ps8_SendData, s32_SendDataLen);
			printf("\nSendTo(%d...) Sent Data: %s\n",h_Client, ps8_SendData);
			printf("Waiting now for Echo....");
			break;
		case ERROR_INVALID_PARAMETER:
			printf("\nSendTo(%d...) return is: ERROR_INVALID_PARAMETER(%d)\n",h_Client, u32_Error);
			printf("\nERROR_INVALID_PARAMETER -> One of this parms or more: h_Client, ps8_SendData, u32_SendDataLen is invalid...\n");
			break;
		case WSAEWOULDBLOCK:
			printf("\nSendTo(%d...) return is: WSAEWOULDBLOCK(%d)\n",h_Client, u32_Error);
			printf("\nWSAEWOULDBLOCK -> The data will be send after the next FD_WRITE event, do nouthing\n");
			break;

		case WSA_IO_PENDING:
			printf("\nSendTo(%d...) return is: WSA_IO_PENDING(%d)\n",h_Client, u32_Error);
			printf("\nWSA_IO_PENDING -> Error: A previous Send operation is still pending. This data will not be sent, try latter\n");
			break;

		default:
			printf("\nSendTo(%d...)failed with severe error: %d\n",h_Client, u32_Error);
			// Severe error -> abort event loop
			printf("\nConnection was closed !\n");
			break;
		};
		
		if (u32_Error == 0 || u32_Error == WSAEWOULDBLOCK)
		{
			int ReadLen = 0;

			while(!ReadLen)
			{
				u32_Error = cNetEventsProcDLL::ReadFromString(h_Client, ps8_ReadBuf, s32_ReadBufLen, ps32_ReadLen);

				if (u32_Error)
				{
					printf("\nReadFromString(%d...) failed with error: %d\n", h_Client, u32_Error);
					break;
				}

				ReadLen = ps32_ReadLen[0];
			}
			if (u32_Error)
			{
				printf("\nReadFromString(%d...) failed with error: %d\n", h_Client, u32_Error);
			}
			else
			{
				printf("\nReadFromString(%d...) OK, read %d  bytes\n", h_Client, ReadLen);
			}
				
			if (ReadLen > 0)
			{
				CharToOemBuff(ps8_ReadBuf, ps8_ReadBuf, s32_SendDataLen);
				ps8_ReadBuf[ReadLen] = 0;
				printf("\nReadFromString(%d...) Read Data: %s\n", h_Client, ps8_ReadBuf);
			}

		}

	}

	u32_Error = cNetEventsProcDLL::ConnectClose(h_Client);

	if (u32_Error)
		printf("\nConnectClose(...) failed with error: %d\n", u32_Error);
	else
		printf("\nConnectClose(...) OK.\n");

	Sleep(10000);

	return 0;
}

// LocalIp = 0x6401a8c0 -> 192.168.1.100
// Returns a list of all local IP's on this computer (multiple IP's if multiple network adapters)
DWORD GetLocalIPs(char s8_IpList[][20], int &s32_IpCount)
{
	// Winsock version 2.0 is available on ALL Windows operating systems 
	// except Windows 95 which comes with Winsock 1.1
	WSADATA k_Data;
	DWORD u32_Error = WSAStartup(MAKEWORD(2,0), &k_Data);
	if (u32_Error)
		return u32_Error;

	int ps32_IpList[20];

	char s8_Host[500];
	if (gethostname(s8_Host, sizeof(s8_Host)) == SOCKET_ERROR)
		return WSAGetLastError();
	
	struct hostent* pk_Host = gethostbyname(s8_Host);
	if (!pk_Host)
		return WSAGetLastError();

	s32_IpCount = 0;

	for (DWORD i=0; TRUE; i++)
	{
		if (!pk_Host->h_addr_list[i])
			break; // The IP list is zero terminated

		ps32_IpList[i] = *((DWORD*)pk_Host->h_addr_list[i]);

		s32_IpCount++;
	}

	if (!s32_IpCount)
		return WSAENETDOWN; // no local IP means no network available

	for (int i = 0; i<s32_IpCount; i++)
	{
		BYTE* pu8_Addr = (BYTE*)&ps32_IpList[i];
	
		sprintf(s8_IpList[i],"%d.%d.%d.%d",pu8_Addr[0], pu8_Addr[1], pu8_Addr[2], pu8_Addr[3]);
	}
	return 0;
}
