//+------------------------------------------------------------------+
//|                                                   AnglesRays.mq5 |
//|                                       Oleg Fedorov (aka certain) |
//|                                   mailto:coder.fedorov@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Oleg Fedorov (aka certain)"
#property link      "mailto:coder.fedorov@gmail.com"
#property version   "1.00"
//#property script_show_inputs

#include <Shortcuts\Defines.mqh>
#include <Shortcuts\Utilites.mqh>

//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
 {
//---
  int left_side_bars = 3;         // How many bars has fractal from left
  int right_side_bars=3;          // How many bars has fractal from right
  color ray4color=clrRosyBrown;   // Ray 4 color (it is possible to reverce after it)
  int fanLinesWidth=1;            // Fan lines width
  ENUM_LINE_STYLE fanLinesStyle=  // Fan lines style
    STYLE_SOLID;
  string prefix=                  // Fan lines name prefix - you can form it as you like
    "and_fan_"+CUtilites::GetTimeframeSymbolName()+"_";
  color fanColor=                 // Fan lines color - you can form it as you like
    CUtilites::GetTimeFrameColor(CUtilites::GetAllLowerTimeframes());
//---
  int x = ChartXOnDropped();
  int y = ChartYOnDropped();
  double price;
  datetime time;
  bool is_up;
  int subwindow=0;
  double fanStartPrice,fanEndPrice;
  datetime fanStartTime,fanEndTime;
  int bar;
  double half;
  int i;
  string rayName="";
  int fanNumber=0;
  int angleBeginNumber,angleEndNumber,angleIncrement;
  int dircetionSign=1;

//---
  ChartXYToTimePrice(0,x,y,subwindow,time,price);
  bar = iBarShift(NULL,PERIOD_CURRENT,time);
  half = iHigh(NULL,PERIOD_CURRENT,bar)-iLow(NULL,PERIOD_CURRENT,bar);
  half=half/2+iLow(NULL,PERIOD_CURRENT,bar);

  if(price > half)
   {
    is_up = true;
   }
  else
   {
    is_up=false;
    dircetionSign=-1;
   }
  bar = CUtilites::GetNearesExtremumSearchAround(
          bar,
          is_up,
          left_side_bars,
          right_side_bars
        );

  fanStartTime = iTime(NULL,0,bar);

  angleBeginNumber=10;
  angleEndNumber=80;
  angleIncrement=10;
  if(is_up)
   {
    fanStartPrice=iHigh(NULL,0,bar);
   }
  else
   {
    fanStartPrice=iLow(NULL,0,bar);
   }


//fanNumber=CUtilites::GetNextObjectNumber(
//            prefix,
//            OBJ_TREND,
//            true
//          );
  for(i=angleBeginNumber; MathAbs(i)<=MathAbs(angleEndNumber) && !IsStopped(); i+=angleIncrement)
   {
    CalculateSecondPoint(
      fanStartTime,
      fanStartPrice,
      i*dircetionSign,
      fanEndTime,
      fanEndPrice
      );
    rayName=prefix;

    rayName+=IntegerToString(fanNumber);
    rayName+="_"+IntegerToString((i-90)*dircetionSign);
    if(ObjectFind(0,rayName)!=0){
    ObjectCreate(
      0,
      rayName,
      OBJ_TREND,
      0,
      fanStartTime,
      fanStartPrice,
      fanEndTime,
      fanEndPrice
    );
    }
    else {
      ObjectMove(0,rayName,0,fanStartTime,fanStartPrice);
      ObjectMove(0,rayName,1,fanEndTime,fanEndPrice);
    }
    if(i!=50)
     {
      ObjectSetInteger(0,rayName,OBJPROP_COLOR,fanColor);
     }
    else
     {
      ObjectSetInteger(0,rayName,OBJPROP_COLOR,ray4color);
     }
    ObjectSetInteger(0,rayName,OBJPROP_WIDTH,1);
    ObjectSetInteger(0,rayName,OBJPROP_STYLE,STYLE_SOLID);
    ObjectSetInteger(0,rayName,OBJPROP_RAY_RIGHT,true);
   }
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double DegreesToRadians(int degree)
 {
  return (MathArccos(0)/90*degree);
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateSecondPoint(
  datetime time1,
  double price1,
  int angleInDegrees,
  datetime &time2,
  double &price2
)
 {
  int x,y;
  int subwindow = 0;
  int length = 16;//CUtilites::GetBarsPixelDistance();//ChartGetInteger(0,CHART_SCALE_PT_PER_BAR);

  ChartTimePriceToXY(0,0,time1,price1,x,y);
  double angleInRadians = DegreesToRadians(angleInDegrees);
  int heigh = (int)MathRound(length*MathTan(angleInRadians));
  ChartXYToTimePrice(0,x+length,y+heigh,subwindow,time2,price2);
  
//---
  //return(price);
 }
//+------------------------------------------------------------------+
