//+------------------------------------------------------------------+
//|                                           C_Object_BtnBitMap.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "C_Object_Base.mqh"
//+------------------------------------------------------------------+
#define def_BtnClose				"Images\\NanoEA-SIMD\\Btn_Close.bmp"
#define def_BtnCheckEnabled	"Images\\NanoEA-SIMD\\CheckBoxEnabled.bmp"
#define def_BtnCheckDisabled	"Images\\NanoEA-SIMD\\CheckBoxDisabled.bmp"
//+------------------------------------------------------------------+
#resource "\\" + def_BtnClose
#resource "\\" + def_BtnCheckEnabled
#resource "\\" + def_BtnCheckDisabled
//+------------------------------------------------------------------+
class C_Object_BtnBitMap : public C_Object_Base
{
	public	:
//+------------------------------------------------------------------+
		void Create(ulong ticket, string szObjectName, string szResource1, string szResource2 = NULL)
			{
				C_Object_Base::Create(szObjectName, OBJ_BITMAP_LABEL, ticket);
				ObjectSetString(Terminal.Get_ID(), szObjectName, OBJPROP_BMPFILE, 0, "::" + szResource1);
				ObjectSetString(Terminal.Get_ID(), szObjectName, OBJPROP_BMPFILE, 1, "::" + (szResource2 == NULL ? szResource1 : szResource2));
				SetStateButton(szObjectName, false);
			};
//+------------------------------------------------------------------+
		bool GetStateButton(string szObjectName) const
			{
				return (bool) ObjectGetInteger(Terminal.Get_ID(), szObjectName, OBJPROP_STATE);
			}
//+------------------------------------------------------------------+
inline void SetStateButton(string szObjectName, bool bState)
			{
				ObjectSetInteger(Terminal.Get_ID(), szObjectName, OBJPROP_STATE, bState);
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
