//+---------------------------------------------------------------------+
//|                                              Aggressiveness.mq4     |
//|                                         Copyright  Trofimov 2009   |
//+---------------------------------------------------------------------+
//|                                                        |
//|                                                                     |
//| :                 |
//|     ,   MyPeriod      |
//|    !                                        |
//|                                                                     |
//|      , 2009     |
//+---------------------------------------------------------------------+


#property copyright "Copyright  Trofimov Evgeniy Vitalyevich, 2009"
#property link      "http://TrofimovVBA.narod.ru/"

//----  
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Blue
#property indicator_width1 1

//----  
extern int MyPeriod=22;
extern double Lot=0; // 0 -  
                     // >0 -   

bool ReDraw=true; //- ,        
//  ,      ,    () 
double Buff_line1[];
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
int init()
  {
//---- x  ,   
   IndicatorBuffers(1);
   IndicatorDigits(0); 
//----   (  )
   SetIndexDrawBegin(0,MyPeriod);
//---- x   
   SetIndexBuffer(0,Buff_line1);
//----      
   if(Lot==0) {
      IndicatorShortName("Aggressiveness("+MyPeriod+"), (pips) = ");
   } else {
      IndicatorShortName("Aggressiveness("+MyPeriod+"), ("+AccountCurrency()+""+DoubleToStr(Lot,2)+") = ");
   }
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
int start() {
   int limit, RD;
   if(ReDraw) RD=1;
   //  
   int counted_bars=IndicatorCounted();
//----   
   if(counted_bars<0) return(-1);
//----          
   limit=Bars-counted_bars-1+RD;

//---- out of range fix
   if(counted_bars==0) limit-=RD+MyPeriod;
 
//----  
   double B;
//----  
   for(int t=limit-RD; t>-RD; t--) {
      B=0;
      for(int x=t+MyPeriod-1; x>=t; x--) { 
         if(Close[x]>Open[x]) {
            // 
            B=B+(Close[x]-Close[x+1]);
            
         }else{
            // 
            B=B+(Close[x+1]-Close[x]);
         }
      }//Next x
      Buff_line1[t]=B/Point/MyPeriod;
      if(Lot>0) Buff_line1[t]=Buff_line1[t]*MarketInfo(Symbol(),MODE_TICKVALUE)*Lot;
      if(!ReDraw && t==1) Buff_line1[0]=Buff_line1[1];
   }//Next t
   return(0);
}
//+------------------------------------------------------------------+

