//+------------------------------------------------------------------+
//|                                                    b-Account.mqh |
//|                                             . aka KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|   19.12.2005       .       |
//|                                                                  |
//|     :                              |
//|  -   start() : WriteAccountInfo();                       |
//|  -   deinit(): WriteLastAccountInfo();                   |
//+------------------------------------------------------------------+

//-------    -----------------------------------
extern string _Parameters_b_Account = "----------   ";
extern bool   acUseWrite    = False;
extern string acOutFileName = "Account.csv";
extern int    acOutGroup    = 1;    // 1-, 2-, 3-, 4-

//-------    -------------------------------
bool   acFirstRun=True;
double acPrevBalance;
int    acPrevDay, acPrevMonth, acPrevQuarter, acPrevYear;
int    acPrevTimeBar;


//+------------------------------------------------------------------+
//|         .                |
//+------------------------------------------------------------------+
void WriteAccountInfo()
{
  string text="";

  if (IsTesting() && acUseWrite && acPrevTimeBar!=Time[0])
  {
    if (acFirstRun)
    {
      text=";;;";
      WritingLineInFile(acOutFileName, text);
      acPrevBalance=AccountBalance();
      acPrevDay=Day();
      acPrevMonth=Month();
      acPrevQuarter=Quarter();
      acPrevYear=Year();
      acFirstRun=False;
    }
    if (acOutGroup==1)
    {
      if (acPrevDay!=Day())
      {
        text=acPrevYear+"."+acPrevMonth+"."+acPrevDay;
        WriteInFile(text);
        acPrevBalance=AccountBalance();
      }
    }
    if (acOutGroup==2)
    {
      if (acPrevMonth!=Month())
      {
        text=acPrevYear+"."+acPrevMonth;
        WriteInFile(text);
        acPrevBalance=AccountBalance();
      }
    }
    if (acOutGroup==3)
    {
      if (acPrevQuarter!=Quarter())
      {
        text=acPrevYear+" ."+acPrevQuarter;
        WriteInFile(text);
        acPrevBalance=AccountBalance();
      }
    }
    if (acOutGroup==4)
    {
      if (acPrevYear!=Year())
      {
        text=acPrevYear;
        WriteInFile(text);
        acPrevBalance=AccountBalance();
      }
    }
    acPrevDay=Day();
    acPrevMonth=Month();
    acPrevQuarter=Quarter();
    acPrevYear=Year();
  }
  acPrevTimeBar=Time[0];
}

//+------------------------------------------------------------------+
//|          .   |
//+------------------------------------------------------------------+
void WriteLastAccountInfo()
{
  string text="";

  if (IsTesting() && acUseWrite)
  {
    if (acOutGroup==1)
    {
      text=Year()+"."+Month()+"."+Day();
      WriteInFile(text);
    }
    if (acOutGroup==2)
    {
      text=Year()+"."+Month();
      WriteInFile(text);
    }
    if (acOutGroup==3)
    {
      text=acPrevYear+" ."+acPrevQuarter;
      WriteInFile(text);
    }
    if (acOutGroup==4)
    {
      text=acPrevYear;
      WriteInFile(text);
    }
  }
}

//+------------------------------------------------------------------+
void WriteInFile(string text)
{
  text=text+";"+(AccountBalance()-acPrevBalance)+";"+AccountBalance()+";"+AccountEquity();
  WritingLineInFile(acOutFileName, text);
}

//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
int Quarter()
{
  if (Month()>0 && Month()<4)  return(1);
  if (Month()>3 && Month()<7)  return(2);
  if (Month()>6 && Month()<10) return(3);
  if (Month()>9 && Month()<13) return(4);
}

//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+
void WritingLineInFile(string FileName, string text)
{
  int file_handle=FileOpen(FileName, FILE_READ|FILE_WRITE, " ");

	if (file_handle>0)
	{
		FileSeek(file_handle, 0, SEEK_END);
		FileWrite(file_handle, text);
		FileClose(file_handle);
	}
}
//+------------------------------------------------------------------+

