//+------------------------------------------------------------------+
//|                                               UserErrorDescr.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "2010, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#include <ErrorDescription.mqh>
//+------------------------------------------------------------------+
//|  returns runtime error code description,                         |
//|  with user defined errors                                        |
//+------------------------------------------------------------------+
string ErrorDescriptionExt(int err_code,string&user_errors[])
  {
   if(err_code>=0 && err_code<ERR_USER_ERROR_FIRST) return(ErrorDescription(err_code));
//--- user defined runtime errors
   err_code-=ERR_USER_ERROR_FIRST;
   if(err_code<=ArraySize(user_errors)) return(user_errors[err_code]);
//---
   return("Unknown error");
  };

//--- an array with description of the user defined runtime errors
string MyErrors[]=
  {
   "User error 1",
   "User error 2",
   "User error 3"
  };
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   for(int i=0;i<=2;i++)
     {
      SetUserError(ushort(i));
      Print("User defined error code: ",i," ",ErrorDescriptionExt(GetLastError(),MyErrors));
     }
  }
//+------------------------------------------------------------------+
