//+---------------------------------------------------------------------+
//|                                                          NRatio.mq5 | 
//|                                              Copyright  2006, Rosh | 
//|                                     http://konkop.narod.ru/nrma.htm | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, Rosh"
#property link "http://konkop.narod.ru/nrma.htm"
//----   
#property version   "1.01"
//---     
#property indicator_separate_window
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 80.0
#property indicator_level2 50.0
#property indicator_level3 20.0
#property indicator_levelcolor clrBlue
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       MediumOrchid 
#property indicator_color1 clrMediumOrchid
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "NRatio"

//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method=MODE_SMA; // 
input int XLength=3; //                     
input int XPhase=15; // ,
                     // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;// 
input double Kf=1;
input double Fast=2;
input double Sharp=2;
input int    Shift=0; //      
//+----------------------------------------------+

//----   ,    
//      
double IndBuffer[];

//----      
double dF;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=XMA1.GetStartBars(XMA_Method,XLength,XPhase)+1;
//----       
   XMA1.XMALengthCheck("XLength",XLength);
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//----  
   dF=2.0/(1.0+Fast);

//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(XMA_Method);
   StringConcatenate(shortname,"NRatio(",XLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double price,NRTR0,LPrice,HPrice,Oscil,xOscil;
   static double NRTR1;
//----        
   int first,bar,Trend0;
   static int Trend1;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=1; //      
      bar=first-1;
      price=PriceSeries(IPC,bar,open,low,high,close);
      if(close[first]>open[first])
        {
         Trend1=+1;
         NRTR1=NormalizeDouble(price*(1.0-Kf*0.01),_Digits);
        }
      else
        {
         Trend1=-1;
         NRTR1=NormalizeDouble(price*(1.0+Kf*0.01),_Digits);
        }
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price
      price=PriceSeries(IPC,bar,open,low,high,close);
      NRTR0=NRTR1;
      Trend0=Trend1;

      if(Trend1>=0)
        {
         if(price<NRTR1)
           {
            Trend0=-1;
            NRTR0=NormalizeDouble(price*(1.0+Kf*0.01),_Digits);
           }
         else
           {
            Trend0=+1;
            LPrice=NormalizeDouble(price*(1.0-Kf*0.01),_Digits);
            if(LPrice>NRTR1) NRTR0=LPrice;
            else NRTR0=NRTR1;
           }
        }

      if(Trend1<=0)
        {
         if(price>NRTR1)
           {
            Trend0=+1;
            NRTR0=NormalizeDouble(price*(1.0-Kf*0.01),_Digits);
           }
         else
           {
            Trend0=-1;
            HPrice=NormalizeDouble(price*(1.0+Kf*0.01),_Digits);
            if(HPrice<NRTR1) NRTR0=HPrice;
            else NRTR0=NRTR1;
           }
        }

      Oscil=(100.0*MathAbs(price-NRTR0)/price)/Kf;
      xOscil=XMA1.XMASeries(1,prev_calculated,rates_total,XMA_Method,XPhase,XLength,Oscil,bar,false);
      IndBuffer[bar]=100*MathPow(xOscil,Sharp);
      if(bar<rates_total-1)
        {
         Trend1=Trend0;
         NRTR1=NRTR0;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
