//+------------------------------------------------------------------+
//|                                       Test_BullsBearsOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 6
#property indicator_plots   2
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrDeepSkyBlue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrRed
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- input parameters
input int            BuBePeriod  =  13;
input ENUM_MA_METHOD BuBeMethod  =  MODE_EMA;
//--- indicator buffers
double         BUBuffer[];
double         BEBuffer[];
double         MABuffer[];
double         DataHigh[];
double         DataLow[];
double         DataClose[];

#include <IncOnArray/IncBullsBearsOnArray.mqh>
CBullsBearsOnArray bube;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   bube.Init(BuBePeriod,BuBeMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,BUBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,BEBuffer,INDICATOR_DATA);

   SetIndexBuffer(2,MABuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,DataLow,INDICATOR_CALCULATIONS);
   SetIndexBuffer(5,DataClose,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,bube.BarsRequired());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,bube.BarsRequired());

   PlotIndexSetString(0,PLOT_LABEL,bube.BuName());
   PlotIndexSetString(1,PLOT_LABEL,bube.BeName());

   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
      DataClose[i]=close[i];
     }

   bube.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,MABuffer,BUBuffer,BEBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
