//+------------------------------------------------------------------+
//|                                         IncBullsBearsOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            BuBePeriod  =  13;
   input ENUM_MA_METHOD BuBeMethod  =  MODE_EMA;

   Declaration:
   #include <IncOnArray/IncBullsBearsOnArray.mqh>
   CBullsBearsOnArray bube;

   In OnInit:  
   bube.Init(BuBePeriod,BuBeMethod);

   In OnCalculate:
   bube.Solve(rates_total,prev_calculated,DataHigh,DataLow,DataClose,MABuffer,BUBuffer,BEBuffer);   
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CBullsBearsOnArray                                               |
//+------------------------------------------------------------------+
class CBullsBearsOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   string            m_BuName;
   string            m_BeName;
   CMAOnArray        m_MA;
   int               m_br;
public:
   void Init(int aPeriod=13,ENUM_MA_METHOD aMethod=MODE_EMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_MA.Init(m_Period,m_Method);
      m_BuName="Bulls("+IntegerToString(m_Period)+","+m_MA.NameMethod()+")";
      m_BeName="Bears("+IntegerToString(m_Period)+","+m_MA.NameMethod()+")";
      m_br=m_MA.BarsRequired();
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aDataCose[],
              double  &aMA[],
              double  &aBulls[],
              double  &aBears[]
              )
     {
      m_MA.Solve(aRatesTotal,aPrevCalc,aDataCose,aMA);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aMA[i]!=0 && aMA[i]!=EMPTY_VALUE && aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aBulls[i]=aDataHigh[i]-aMA[i];
         aBears[i]=aDataLow[i]-aMA[i];
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string BuName()
     {
      return(m_BuName);
     }
   string BeName()
     {
      return(m_BeName);
     }
   string About()
     {
      return("Integer's BullsBearsOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
