//+------------------------------------------------------------------+
//|                                                IncADXOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            ADXPeriod      =  14;
   input ENUM_MA_METHOD ADXMethod      =  MODE_EMA;

   Declaration:
   #include <IncOnArray/IncADXOnArray.mqh>
   CADXOnArray adx;
   
   In OnInit:
   adx.Init(ADXPeriod,ADXMethod);

   In OnCalculate:
   adx.Solve(rates_total,prev_calculated,DataClose,DataHigh,DataLow,PBuffer,MBuffer,PDIBuffer,MDIBuffer,ADXRBuffer,ADXBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CADXOnArray                                                      |
//+------------------------------------------------------------------+
class CADXOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   string            m_Name;
   string            m_PDIName;
   string            m_MDIName;
   CMAOnArray        m_pma;
   CMAOnArray        m_mma;
   CMAOnArray        m_ama;
   int               m_bra;
   int               m_brpm;
   void SolvePD(int i,double  &aDataClose[],double  &aDataHigh[],double  &aDataLow[],double  &aP[],double  &aM[])
     {
      double m_h=aDataHigh[i];
      double m_ph=aDataHigh[i-1];
      double m_l=aDataLow[i];
      double m_pl=aDataLow[i-1];
      double m_pc=aDataClose[i-1];
      double m_pd=m_h-m_ph;
      double m_md=m_pl-m_l;
      if(m_pd<0.0)
        {
         m_pd=0.0;
        }
      if(m_md<0.0)
        {
         m_md=0.0;
        }
      if(m_pd>m_md)
        {
         m_md=0.0;
        }
      else
        {
         if(m_pd<m_md)
           {
            m_pd=0.0;
           }
         else
           {
            m_pd=0.0;
            m_md=0.0;
           }
        }
      double m_tr=MathMax(MathMax(MathAbs(m_h-m_l),MathAbs(m_h-m_pc)),MathAbs(m_l-m_pc));
      if(m_tr!=0.0)
        {
         aP[i]=100.0*m_pd/m_tr;
         aM[i]=100.0*m_md/m_tr;
        }
      else
        {
         aP[i]=0.0;
         aM[i]=0.0;
        }
     }
public:
   void Init(int aPeriod=14,ENUM_MA_METHOD aMethod=MODE_EMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_ama.Init(m_Period,m_Method);
      m_pma.Init(m_Period,m_Method);
      m_mma.Init(m_Period,m_Method);
      m_Name="("+IntegerToString(m_Period)+","+m_pma.NameMethod()+")";
      m_PDIName="PDI"+m_Name;
      m_MDIName="MDI"+m_Name;
      m_Name="ADX"+m_Name;
      m_bra=m_pma.BarsRequired()*2;
      m_brpm=m_pma.BarsRequired()+1;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataClose[],
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aP[],
              double  &aM[],
              double  &aPDI[],
              double  &aMDI[],
              double  &aADXR[],
              double  &aADX[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE)
              {
               Start=i+1;
               break;
              }
           }
         SolvePD(Start,aDataClose,aDataHigh,aDataLow,aP,aM);
         if(aP[Start]==0)aP[Start]=0.00000001;
         if(aM[Start]==0)aM[Start]=0.00000001;
         Start++;
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         SolvePD(i,aDataClose,aDataHigh,aDataLow,aP,aM);
        }
      m_pma.Solve(aRatesTotal,aPrevCalc,aP,aPDI);
      m_mma.Solve(aRatesTotal,aPrevCalc,aM,aMDI);
      for(int i=Start;i<aRatesTotal;i++)
        {
         double m_sum=aPDI[i]+aMDI[i];
         if(m_sum!=0.0)
           {
            aADXR[i]=100.0*MathAbs((aPDI[i]-aMDI[i])/m_sum);
           }
         else
           {
            aADXR[i]=0.0;
           }
        }
      m_ama.Solve(aRatesTotal,aPrevCalc,aADXR,aADX);
     }
   int BarsRequiredADX()
     {
      return(m_bra);
     }
   int BarsRequiredPDIMDI()
     {
      return(m_brpm);
     }
   string Name()
     {
      return(m_Name);
     }
   string PDIName()
     {
      return(m_PDIName);
     }
   string MDIName()
     {
      return(m_MDIName);
     }
   string About()
     {
      return("Integer's ADXOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
