//+------------------------------------------------------------------+
//|                                             BrainTrendSignal.mqh |
//|                                                    2011, etrader |
//|                                             http://efftrading.ru |
//+------------------------------------------------------------------+
#property copyright "2011, etrader"
#property link      "http://efftrading.ru"
//+------------------------------------------------------------------+
//| Include files                                                    |
//+------------------------------------------------------------------+
#property tester_indicator "BrainTrend1.ex5"
#include <Expert\ExpertSignal.mqh>

// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signal based on BrainTrend indicator                       |
//| Type=SignalAdvanced                                              |
//| Name=BRainTrend                                                  |
//| Class=CBrainTrendSignal                                          |
//| Page=                                                            |
//| Parameter=ATR_Period,int,7,ATR period                            |
//| Parameter=STO_Period,int,9,Stochastic period                     |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| CBrainTrendSignal class                                          |
//| Purpose: Trade Signals class, based on BrainTrend1 indicator     |
//|          http://www.mql5.com/en/code/391                         |
//+------------------------------------------------------------------+
class CBrainTrendSignal : public CExpertSignal{
  private:
    CiCustom m_indicator; // object of BrainTrend custom indicator
    int m_atr_period;     // ATR period of BrainTrend indicator
    int m_sto_period;     // Stochastic period of BrainTrend indicator
  public:
   virtual int       ShortCondition();      // checks conditions to open a short position
   virtual int       LongCondition();       // checks conditions to open a long position
   void CBrainTrendSignal(){ 
     m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE+USE_SERIES_TIME;
     m_atr_period = 7;  
     m_sto_period = 9;
   }
   void ATR_Period( int passedperiod ){ m_atr_period = passedperiod;  }  // sets the value of ATR_Period
   void STO_Period( int passedperiod  ){ m_sto_period = passedperiod;  } // sets the value of STO_Period
   virtual bool      InitIndicators(CIndicators* indicators);            // initialization of indicators
   bool              InitBrainTrend(CIndicators* indicators);            // initialization of BrainTrend indicator
};


//+------------------------------------------------------------------+
//| Initialization of indicators                                     |
//| INPUT:  indicators - pointer to indicators collection            |
//| OUTPUT: true if successful, otherwise false                      |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
bool CBrainTrendSignal::InitIndicators(CIndicators* indicators){
//--- checking of pointer
   if(indicators==NULL)                           return(false);
//--- initialization of indicators, timeseries and additional filters
   if(!CExpertSignal::InitIndicators(indicators)) return(false);
//--- creation and initialization of BrainTrend indicator
   if(!InitBrainTrend(indicators))                return(false);
//--- ok
   return(true);
}


//+------------------------------------------------------------------+
//| Initialization of BrainTrend indicator                           |
//| INPUT: indicators - pointer to indicators collection             |
//| OUTPUT: true if successful, otherwise false                      |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
bool CBrainTrendSignal::InitBrainTrend(CIndicators* indicators) {
//--- checking of pointer
   if(indicators==NULL) return(false);
//--- adding of object to collection
   if(!indicators.Add(GetPointer(m_indicator))){
      printf(__FUNCTION__+": error in adding of object to collection");
      return(false);
   }
//--- setting input parameters of BrainTrend indicator
   MqlParam parameters[3];
   parameters[0].type = TYPE_STRING;
   parameters[0].string_value = "BrainTrend1.ex5";
   parameters[1].type = TYPE_INT;
   parameters[1].integer_value = m_atr_period;
   parameters[2].type = TYPE_INT;
   parameters[2].integer_value = m_sto_period;
//--- object initialization
   if(!m_indicator.Create(m_symbol.Name(),m_period,IND_CUSTOM, 3, parameters )){
      printf(__FUNCTION__+": error in object initialization");
      return(false);
   }
//--- ok
   return(true);
}


//+------------------------------------------------------------------+
//| Checks conditions to open a short position                       |
//| INPUT:  none                                                     |
//| OUTPUT: Voting weight from 0 to 100                              |
//| REMARK: none.                                                    |
//+------------------------------------------------------------------+
int CBrainTrendSignal::ShortCondition(){
//--- Trend Direction is defined by the 4th buffer of BrainTrend indicator
//--- 0 - flat
//--- 1 - trend upward
//--- 2 - trend downward
   if( m_indicator.GetData( 4, 1 ) == 2 ) return( 100 );
//--- condition is not satisfied
   return(0); 
   
}


//+------------------------------------------------------------------+
//| Checks conditions to open a long position                        |
//| INPUT:  none                                                     |
//| OUTPUT: Voting weight from 0 to 100                              |
//| REMARK: none.                                                    |
//+------------------------------------------------------------------+
int CBrainTrendSignal::LongCondition(){
//--- Trend Direction is defined by the 4th buffer of BrainTrend indicator
//--- 0 - flat
//--- 1 - trend upward
//--- 2 - trend downward
  if( m_indicator.GetData( 4, 1 ) == 1 ) return( 100 );
//--- condition is not satisfied
   return(0);  
}

//+------------------------------------------------------------------+