//+------------------------------------------------------------------+
//|                                           NewBarEventExample.mq5 |
//|                                      Copyright 2022, Yuriy Bykov |
//|                               https://www.mql5.com/ru/code/38100 |
//+------------------------------------------------------------------+
#property description "Examlple for usage CNewBarEvent class"
#property copyright "Copyright 2022, Yuriy Bykov"
#property link      "https://www.mql5.com/ru/code/38100/"
#property version   "1.4"

//--- 0. Include library with CNewBarEvent class
#include <NewBarEvent.mqh>

//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick() {
//--- 1. IMPORTANT! Call UpdateNewBar() function at begin of OnTick()
   UpdateNewBar();

//--- 2.1 Check events
   if(IsNewBar(Symbol(), Period()))   { Print("New Bar at " + EnumToString(Period()) + " for " + Symbol()); }
   
   if(IsNewBar("EURGBP", PERIOD_M15)) { Print("New Bar at PERIOD_M15 for EURGBP"); }
   if(IsNewBar("USDCAD", PERIOD_M15)) { Print("New Bar at PERIOD_M15 for USDCAD"); }
   if(IsNewBar("USDCHF", PERIOD_M15)) { Print("New Bar at PERIOD_M15 for USDCHF"); }
   
   if(IsNewBar("EURGBP", PERIOD_H1))  { Print("New Bar at PERIOD_H1  for EURGBP"); }
   if(IsNewBar("USDCAD", PERIOD_H1))  { Print("New Bar at PERIOD_H1  for USDCAD"); }
   if(IsNewBar("USDCHF", PERIOD_H1))  { Print("New Bar at PERIOD_H1  for USDCHF"); }

//--- Perform some actions...
   Sleep(1500);

//--- 2.2 Check events again if needed
   if(IsNewBar(Symbol(), Period()))   { Print("New Bar at " + EnumToString(Period()) + " for " + Symbol() + " second time at the same tick"); }
   
   if(IsNewBar("EURGBP", PERIOD_M15)) { Print("New Bar at PERIOD_M15 for EURGBP second time at the same tick"); }
   if(IsNewBar("USDCAD", PERIOD_M15)) { Print("New Bar at PERIOD_M15 for USDCAD second time at the same tick"); }
   if(IsNewBar("USDCHF", PERIOD_M15)) { Print("New Bar at PERIOD_M15 for USDCHF second time at the same tick"); }
   
   if(IsNewBar("EURGBP", PERIOD_H1))  { Print("New Bar at PERIOD_H1  for EURGBP second time at the same tick"); }
   if(IsNewBar("USDCAD", PERIOD_H1))  { Print("New Bar at PERIOD_H1  for USDCAD second time at the same tick"); }
   if(IsNewBar("USDCHF", PERIOD_H1))  { Print("New Bar at PERIOD_H1  for USDCHF second time at the same tick"); }
}
//+------------------------------------------------------------------+
