//+---------------------------------------------------------------------+
//|                                              Chaikin_Volatility.mq5 |
//|                         Copyright  2007, MetaQuotes Software Corp. |
//|                                           http://www.metaquotes.net |
//+---------------------------------------------------------------------+ 
//|          xrangeAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---   
#property indicator_buffers 1 
//---     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_LINE
//---       Salmon 
#property indicator_color1 clrSalmon
//---   -  
#property indicator_style1  STYLE_SOLID
//---     1
#property indicator_width1  1
//---   
#property indicator_label1  "Chaikin_Volatility"
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//---    CXMA   xrangeAlgorithms.mqh
CXMA XMA1;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     xrangeAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA    //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_EMA; //  
input int XLength=10;                    //                      
input int XPhase=15;                     //  ,
//---  JJMA    -100 ... +100,     ;
//---  VIDIA   CMO,  AMA    
input uint ROCPeriod=10;                 //    
input int Shift=0;                       //      
//+-----------------------------------+
//---   ,   
//---      
double IndBuffer[];
//---      
int min_rates_total,min_rates_1;
//---   ,   
//---      
int Count[];
double xrange[];
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos(int &CoArr[]) //        
  {
//---
   int numb,Max1,Max2;
   static int count=1;

   Max2=7;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//---
  }
//+------------------------------------------------------------------+   
//| Chaikin_Volatility indicator initialization function             | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//---     
   min_rates_1=XMA1.GetStartBars(XMA_Method,XLength,XPhase);
   min_rates_total=min_rates_1+int(ROCPeriod+1);
//---       
   XMA1.XMALengthCheck("XLength",XLength);
//---       
   XMA1.XMAPhaseCheck("XPhase",XPhase,XMA_Method);
//---       
   ArrayResize(Count,ROCPeriod+1);
   ArrayResize(xrange,ROCPeriod+1);
   ArrayInitialize(Count,0);
   ArrayInitialize(xrange,0);
//---   
   ArrayInitialize(xrange,0.0);
//---      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"Chaikin_Volatility");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
  }
//+------------------------------------------------------------------+ 
//| Chaikin_Volatility iteration function                            | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(0);
//---       
   double range,xrangeX,ratio;
//---        
   int first,bar;
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      range=high[bar]-low[bar];
      xrange[Count[0]]=XMA1.XMASeries(0,prev_calculated,rates_total,XMA_Method,XPhase,XLength,range,bar,false);
      //---
      xrangeX=xrange[Count[ROCPeriod]];
      if(xrangeX) ratio=(xrange[Count[0]]-xrangeX)/xrangeX*100;
      else ratio=1;
      IndBuffer[bar]=ratio;
      if(bar<rates_total-1) Recount_ArrayZeroPos(Count);
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
