#property strict

#ifndef MAX_BARS
  #define MAX_BARS 1000
#endif // MAX_BARS

struct PRICEST_BASE
{
protected:
  int period;
  double Prices[MAX_BARS];

  datetime NextBarTime;

  double Current;
  int CurrentPos;

  double Price;
  int PricePos;

  int BarInterval;

  datetime GetNextTime( const MqlTick &Tick )
  {
    return(this.BarInterval ? Tick.time - (Tick.time % this.BarInterval) + this.BarInterval : 0);
  }

public:
  PRICEST_BASE( void ) : period(1), CurrentPos(0), PricePos(0), Price(0), Current(0), NextBarTime(0), BarInterval(::PeriodSeconds(PERIOD_CURRENT))
  {
  }

  PRICEST_BASE( const int iPeriod ) : period((iPeriod < 1) ? 1 : ((iPeriod > MAX_BARS) ? MAX_BARS : iPeriod)),
                                 CurrentPos(0), PricePos(0), Price(0), Current(0), NextBarTime(0), BarInterval(::PeriodSeconds(PERIOD_CURRENT))
  {
  }

  double Get( void ) const
  {
    return(this.Price);
  }

  int GetPeriod( void ) const
  {
    return(this.period);
  }

  int GetBarInterval( void ) const
  {
    return(this.BarInterval);
  }

  void SetBarInterval( const int iBarInterval )
  {
    this.BarInterval = (iBarInterval > 0) ? iBarInterval : 0;
  }
};