//    PriceChannel

input int inPeriod = 1;            //  
sinput bool inPriceChannel = true; // /.  PriceChannel  

#define PRICECHANNEL_LOW_PRICE bid  // bid/ask/last  Low 
#include <fxsaber\PriceChannel\PriceChannel.mqh> // https://www.mql5.com/ru/code/23418

//     iPeriod 
double GetHigh( const int iPeriod )
{
  static double Highs[];

  CopyHigh(_Symbol, PERIOD_CURRENT, 0, iPeriod, Highs);

  return(Highs[ArrayMaximum(Highs)]);
}

//     iPeriod 
double GetLow( const int iPeriod )
{
  static double Lows[];

  CopyLow(_Symbol, PERIOD_CURRENT, 0, iPeriod, Lows);

  return(Lows[ArrayMinimum(Lows)]);
}

double Sum = 0;

void OnTick()
{
  static const int BarInterval = PeriodSeconds(PERIOD_CURRENT);
  static PRICECHANNEL PriceChannel(inPeriod); //  PriceChannel-   

  static int CountBars = 0;
  static datetime PrevTime = 0;

  if (inPriceChannel)
    PriceChannel.NewTick(); //   

  if (TimeCurrent() / BarInterval != PrevTime / BarInterval) //  
    CountBars++;

  if (CountBars > MAX_BARS) //  ,    .
    Sum += inPriceChannel ? PriceChannel.GetHigh() - PriceChannel.GetLow() //  PriceChannel  
                          :   GetHigh(inPeriod) - GetLow(inPeriod);        //  PriceChannel  

  PrevTime = TimeCurrent();
}

double OnTester()
{
  return(Sum);
}