//+------------------------------------------------------------------+
//|                                              Rj_SlidingRange.mq5 |
//|                            Copyright  2011,RJ Rjabkov Alexander |
//|                                                     rj-a@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011,RJ Rjabkov Alexander"
#property link      "rj-a@mail.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 4 
//----    
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrLime
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Upper Rj_SlidingRange"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type2   DRAW_COLOR_LINE
//----      
#property indicator_color2  clrOrange,clrBlue
//----   -  
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//----   
#property indicator_label2  "Middle Rj_SlidingRange"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3 clrMagenta
//----   -  
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//----   
#property indicator_label3  "Lower Rj_SlidingRange"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint CalcPeriodRange=5;
input int Shift=0;  //      
//+-----------------------------------+
//----  
double UpperBuffer[];
double MiddleBuffer[];
double LowerBuffer[];
double ColorMiddleBuffer[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+    
//| Rj_SlidingRange Channel indicator initialization function        | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----  
   min_rates_total=int(CalcPeriodRange+1);

//----      
   SetIndexBuffer(0,UpperBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(UpperBuffer,true);


//----      
   SetIndexBuffer(1,MiddleBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(MiddleBuffer,true);
//----     ,     
   SetIndexBuffer(2,ColorMiddleBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorMiddleBuffer,true);

//----      
   SetIndexBuffer(3,LowerBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//----       Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       
   ArraySetAsSeries(LowerBuffer,true);

//----      
   string shortname;
   StringConcatenate(shortname,"Rj_SlidingRange(",CalcPeriodRange,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+  
//| Rj_SlidingRange Channel iteration function                       | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----   
   int limit;

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated;  //       

//----         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      int iii=bar+int(CalcPeriodRange)-1;
      double b1=0,b2=0;
      while(iii>=bar)
        {
         b1+=High[ArrayMaximum(High,iii,CalcPeriodRange)];
         b2+=Low[ArrayMinimum(Low,iii,CalcPeriodRange)];
         iii--;
        }
        
      UpperBuffer[bar]=b1/CalcPeriodRange;
      LowerBuffer[bar]=b2/CalcPeriodRange;     
      MiddleBuffer[bar]=NormalizeDouble((UpperBuffer[bar]+LowerBuffer[bar])/2,_Digits);
     }

   if(prev_calculated>rates_total || prev_calculated<=0) limit--;
//----     
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      if(MiddleBuffer[bar+1]<MiddleBuffer[bar]) ColorMiddleBuffer[bar]=1;
      if(MiddleBuffer[bar+1]>MiddleBuffer[bar]) ColorMiddleBuffer[bar]=0;
     }
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
