//+------------------------------------------------------------------+
//|                                                  CSeriesTest.mq4 |
//|                                     Copyright 2018, S.Aukscionis |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018, S.Aukscionis"
#property version   "1.00"
#property strict
#include <CSeries.mqh>
CSeries price;
int maPeriodx=1000;// Moving average period
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
// New price
   double newPrice=NormalizeDouble(0.5*(Ask+Bid),Digits);
// If container is empty or new price is different from the last price fill the container with the value of new price
// While container is not fully filled return
   if(!price.length() || NormalizeDouble(price[0]-newPrice,Digits))
     {
      if(price.add(newPrice,maPeriodx+1)) return; // true means that we successfully added record
     }
   else return;
// Get the z score 
// Once we've filled the array up to maPeriodx+1 elements, z score calculation begins
   double z=price.z(maPeriodx);
//Open new order accordingly to the level of z score
   if(z<=-2.5)
     {
      if(!OrdersTotal())
      if(OrderSend(NULL,OP_BUY,0.01,Ask,0,Bid-30*Point,Ask+30*Point)) {}
     }
   else if(z>=2.5)
     {
      if(!OrdersTotal())
      if(OrderSend(NULL,OP_SELL,0.01,Bid,0,Ask+30*Point,Bid-30*Point)) {}
     }
  }
//+------------------------------------------------------------------+
