#property strict

#property indicator_chart_window
#property indicator_buffers 0
#property indicator_plots   0

int OnCalculate ( const int, const int, const int, const double &[] )
{
  return(0);
}

#include <fxsaber\Clock.mqh>

sinput string Folder = "Clocks\\";
sinput int X0 = 100;
sinput int Y0 = 100;
sinput bool SmallInterval = false;

const string ObjName = __FILE__;
const string ResourceName = "::" + ObjName;

CLOCK* Clock = NULL;

#define KEY_UP   38
#define KEY_DOWN 40

void OnInit()
{
  if (ObjectCreate(0, ObjName, OBJ_BITMAP_LABEL, 0, 0, 0))
  {
    ObjectSetInteger(0, ObjName, OBJPROP_XDISTANCE, X0);
    ObjectSetInteger(0, ObjName, OBJPROP_YDISTANCE, Y0);
  }

  const long lparam = KEY_UP;
  const double dparam = 0;
  const string sparam = NULL;

  OnChartEvent(CHARTEVENT_KEYDOWN, lparam, dparam, sparam);

  if (SmallInterval)
    EventSetMillisecondTimer(100);
  else
    EventSetTimer(1);
}

void OnDeinit( const int )
{
  EventKillTimer();

  ObjectDelete(0, ObjName);
  ChartRedraw();

  if (Clock)
    delete Clock;
}

ulong TimeLocalMs( void )
{
  static ulong PrevStartTime = GetMicrosecondCount();
  static datetime PrevTimeCurrent = TimeLocal();

  const datetime NewTimeCurrent = TimeLocal();
  const ulong NowTime = GetMicrosecondCount();

  if (PrevTimeCurrent < NewTimeCurrent)
  {
    PrevTimeCurrent = NewTimeCurrent;

    PrevStartTime = NowTime;
  }

  return(PrevTimeCurrent * 1000 + (NowTime - PrevStartTime) / 1000);
}

void OnTimer()
{
  if (Clock)
  {
    Clock.SetTime(TimeLocalMs());
//    Comment(TimeLocal());

    ChartRedraw();
  }
}

void SetClock( const string FileName, const string Name )
{
  if (Clock)
    delete Clock;

  Clock = new CLOCK(FileName, Name);

  const int X = (int)ObjectGetInteger(0, ObjName, OBJPROP_XDISTANCE);
  const int Y = (int)ObjectGetInteger(0, ObjName, OBJPROP_YDISTANCE);

  ObjectDelete(0, ObjName); // https://www.mql5.com/ru/forum/1111/page2086#comment_6035442

  if (ObjectCreate(0, ObjName, OBJ_BITMAP_LABEL, 0, 0, 0))
  {
    ObjectSetInteger(0, ObjName, OBJPROP_XDISTANCE, X);
    ObjectSetInteger(0, ObjName, OBJPROP_YDISTANCE, Y);

    ObjectSetString(0, ObjName, OBJPROP_BMPFILE, 0, ResourceName);

    ObjectSetInteger(0, ObjName, OBJPROP_SELECTABLE, true);

    OnTimer();
  }
}

void OnChartEvent( const int id, const long &lparam, const double&, const string& )
{
  static int i = -1;

  if ((id == CHARTEVENT_KEYDOWN) && ((lparam == KEY_UP) || (lparam == KEY_DOWN)))
  {
    string FileNames[];
    const int Amount = FILE::GetFileNames(FileNames, Folder + "*.ini");

    if ((Amount > 1) || ((Amount >= 1) && (i == -1) && (lparam == KEY_UP)))
    {
      i = (i + ((lparam == KEY_UP) ? 1 : (i ? 0 : Amount) - 1)) % Amount;

      SetClock(FileNames[i], ResourceName);
    }
  }
}