#include "Pixel.mqh"

struct SETTINGS
{
private:
  string GetString( const int handle ) const
  {
    string Str = NULL;

    while (!::StringLen(Str) && !::FileIsEnding(handle))
    {
      Str = ::FileReadString(handle);

      ::StringReplace(Str, " ", NULL);
    }

    return(Str);
  }

  string GetValue( const int handle, const string Delimeter = "=" ) const
  {
    const string Str = this.GetString(handle);
    const int Pos = ::StringFind(Str, Delimeter);

    return(::StringSubstr(Str,  (Pos == -1) ? 0 : Pos + ::StringLen(Delimeter)));
  }

public:
  string FileName;

  PIXEL Bound;
  PIXEL Center;

  double Rotate;

  uchar A, R, G, B;

  SETTINGS( void ) : FileName(NULL), Rotate(0), A(100), R(100), G(100), B(100)
  {
  }

  SETTINGS( const int handle ) : FileName(this.GetValue(handle))
  {
    this.Bound.X = (int)this.GetValue(handle);
    this.Bound.Y = (int)this.GetValue(handle);

    this.Center.X = (int)this.GetValue(handle);
    this.Center.Y = (int)this.GetValue(handle);

    this.Rotate = (double)this.GetValue(handle);

    this.A = (uchar)this.GetValue(handle);
    this.R = (uchar)this.GetValue(handle);
    this.G = (uchar)this.GetValue(handle);
    this.B = (uchar)this.GetValue(handle);
  }
};