#include "Color.mqh"

class LAYER
{
protected:
  // !
  static void Rotate( const int x_cent, const int y_cent, //rotation around this point
                      const double ang,  //the rotation angle
                      const int Width,
                      const uint &In[],
                      uint &Out[] )
  {
    ::ArrayCopy(Out, In);

    if (!ang)
      return;

    const int Height = ArraySize(In) / Width;
    int y320[];

    ::ArrayResize(y320, Height);

    for(int n=0;n<Height;n++) y320[n]=n*Width;

    ::ArrayResize(Out, ::ArraySize(In));
    ::ArrayInitialize(Out, 0);

    const double Sin = ::MathSin(-ang);
    const double Cos = ::MathCos(-ang);

    int scn = 0;

    for (int y = 0; y < Height; y++)
    {
      for (int x=0;x<Width; x++)
      {
        const int x2 = x - x_cent;
        const int y2 = y - y_cent;

        const int x1 = (int)(Cos * x2 - Sin * y2) + x_cent;
        const int y1 = (int)(Sin * x2 + Cos * y2) + y_cent;

        Out[scn + x]= ((x1<0) || (x1>=Width) || (y1<0) || (y1>=Height)) ? 0 : In[x1+y320[y1]];
      }

      scn += Width;
    }
  }

  static void Multiply( uint &Pixels[], const uchar A = 100, const uchar R = 100, const uchar G = 100, const uchar B = 100 )
  {
    if ((A < 100) || (B < 100) || (G < 100) || (B < 100))
      for (int i = ::ArraySize(Pixels) - 1; i >= 0; i--)
        COLOR::Change(Pixels[i], A, R, G, B);

    return;
  }

public:
  uint Template[];
  uint Data[];
  int Width;

  double Angle;

  LAYER( void ) : Width(0), Angle(0)
  {
  }

  void operator +=( const LAYER* const Layer )
  {
    for (int i = ::ArraySize(this.Data) - 1; i >= 0; i--)
      this.Data[i] = COLOR::Mix(this.Data[i], Layer.Data[i]);

    return;
  }

  virtual void operator =( const LAYER* const Layer )
  {
    this.Width = Layer.Width;

    ::ArrayCopy(this.Template, Layer.Template);

    return;
  }

  virtual const LAYER* const Action( void )
  {
    ::ArrayCopy(this.Data, this.Template);

    return(&this);
  }
};
