#include "Layer.mqh"

class IMAGE
{
protected:
  //      
  template <typename T>
  static void AddArrayElement( T &Array[], T Value, const int Reserve = 0 ) // https://www.mql5.com/ru/forum/1111/page2085#comment_6019715
  {
    const int Size = ::ArraySize(Array);

    ::ArrayResize(Array, Size + 1, Reserve);

    Array[Size] = Value;
  }

  LAYER* Layers[];
  LAYER* Complete;

public:
  IMAGE( void ) : Complete(NULL)
  {
  }

  void Release( void )
  {
    if (this.Complete)
    {
      this.Complete.Action();

      const int Size = ::ArraySize(this.Layers);

      for (int i = 0; i < Size; i++)
        this.Complete += Layers[i].Action();
    }

  }

  bool ToResource( const string Name )
  {
    return(this.Complete ? ::ResourceCreate(Name, this.Complete.Data, this.Complete.Width,
                                            this.Complete.Width ? ::ArraySize(this.Complete.Data) / this.Complete.Width :
                                                                ::ArraySize(this.Complete.Data),
                                            0, 0, this.Complete.Width, COLOR_FORMAT_ARGB_NORMALIZE)
                         : false);
  }
};