#include <Canvas\Canvas.mqh>

class COLOR
{
private:
  static uchar Mix( const uchar Bottom, const uchar Top, const uchar BottomA, const uchar TopA )
  {
    return((uchar)((double)Top * TopA / 0xFF + (double)Bottom * BottomA * (0xFF - TopA) / (0xFF * 0xFF)));
  }

  static uchar Multiply( const uchar Component, const int Value )
  {
    return((uchar)(Value * Component / 100));
  }

public:
  static uint Mix( const uint Bottom, const uint Top )
  {
    const uchar TopA = GETRGBA(Top);

    if (TopA == UCHAR_MAX)
      return(Top);

    static uint PrevBottom = 0;
    static uint PrevTop = 0;
    static uint PrevResult = 0;

    if ((Bottom == PrevBottom) && (Top == PrevTop))
      return(PrevResult);

    PrevBottom = Bottom;
    PrevTop = Top;

    const uchar BottomA = GETRGBA(Bottom);

    PrevResult = ARGB(TopA + (double)BottomA * (0xFF - TopA) / 0xFF,
                      COLOR::Mix(GETRGBR(Bottom), GETRGBR(Top), BottomA, TopA),
                      COLOR::Mix(GETRGBG(Bottom), GETRGBG(Top), BottomA, TopA),
                      COLOR::Mix(GETRGBB(Bottom), GETRGBB(Top), BottomA, TopA));

    return(PrevResult);
  }

  static void Change( uint &Color, const uchar A = 100, const uchar R = 100, const uchar G = 100, const uchar B = 100 )
  {
    Color = ARGB(COLOR::Multiply(GETRGBA(Color), A), COLOR::Multiply(GETRGBR(Color), R),
                 COLOR::Multiply(GETRGBG(Color), G), COLOR::Multiply(GETRGBB(Color), B));

    return;
  }
};