#include "Canvas.mqh"

#include "Settings.mqh"
#include "Layer.mqh"

class CLOCK_LAYER : public LAYER
{
public:
  SETTINGS Settings;

  CLOCK_LAYER( const SETTINGS &inSettings, const CLOCK_LAYER* const BaseLayer = NULL )
  {
    if (BaseLayer)
    {
      const CLOCK_LAYER Layer(inSettings);

      this = BaseLayer;
      this.Settings = inSettings;

      const int Size = ::ArraySize(this.Template);
      const int Height = ::ArraySize(Layer.Template) / Layer.Width;
      const PIXEL Begin = this.Settings.Center - this.Settings.Bound;

      for (int Y = 0, i = Begin.GetOffset(this.Width), j = 0; Y < Height; Y++, i += Begin.X + ((i % this.Width != 0) ? this.Width - (i % this.Width) : 0))
        for (int X = 0; X < Layer.Width; X++, j++, i++)
          if ((i >= 0) && (i < Size))
            this.Template[i] = Layer.Template[j];
    }
    else
    {
      CANVAS::BMPToArray(inSettings.FileName, this.Template, this.Width);

      LAYER::Multiply(this.Template, inSettings.A, inSettings.R, inSettings.G, inSettings.B);
    }
  }

  virtual void operator =( const LAYER* const Layer )
  {
    this.Width = Layer.Width;

    ::ArrayResize(this.Template, ::ArraySize(Layer.Template));

    ::ArrayInitialize(this.Template, 0);

    return;
  }

  virtual const LAYER* const Action( void )
  {
    if (this.Settings.Rotate)
      LAYER::Rotate(this.Settings.Center.X, this.Settings.Center.Y, this.Angle / this.Settings.Rotate, this.Width, this.Template, this.Data);
    else
      LAYER::Action();

    return(&this);
  }
};