#include "Clock\File.mqh"

#include "Clock\Clock_Layer.mqh"
#include "Clock\Image.mqh"

class CLOCK : public IMAGE
{
protected:
  static const SETTINGS GetSettings( const string FileName, const int handle )
  {
    SETTINGS Settings(handle);

    Settings.FileName = FILE::GetDirectory(FileName) + Settings.FileName;

    return(Settings);
  }

public:
  const string Resource;

  CLOCK( const string FileName, const string inResource = NULL ) : Resource(inResource)
  {
    const int handle = ::FileOpen(FileName, FILE_READ | FILE_TXT);

    if (handle != INVALID_HANDLE)
    {
      const SETTINGS BaseSettings = CLOCK::GetSettings(FileName, handle);

      this.Complete = new CLOCK_LAYER(BaseSettings);

      while (!::FileIsEnding(handle))
      {
        const SETTINGS Settings = CLOCK::GetSettings(FileName, handle);;

        IMAGE::AddArrayElement(this.Layers, (LAYER*)(new CLOCK_LAYER(Settings, this.Complete))); // https://www.mql5.com/ru/forum/1111/page2085#comment_6019736
      }

      ::FileClose(handle);
    }
  }

  void SetTime( ulong time )
  {
    time %= 24 * 3600 * 1000;

    for (int i = ::ArraySize(this.Layers) - 1; i >= 0; i--)
      this.Layers[i].Angle = time * M_PI / 3e4;

    this.Release();

    if (this.Resource != NULL)
      this.ToResource(this.Resource);
  }

  void SetTime( const datetime time )
  {
    this.SetTime((ulong)time * 1000);
  }

  ~CLOCK( void )
  {
    if (this.Complete)
      delete(this.Complete);

    for (int i = 0; i < ::ArraySize(this.Layers); i++)
      delete this.Layers[i];

    if (this.Resource != NULL)
      ::ResourceFree(this.Resource);
  }
};