//+----------------------------------------------------------------------------------------------+
//|                                                                          TVLa_HiLo_vx.yy.mq4 |
//|                                                                Copyright 2017, TVLautomation |
//|                                                                      TVLautomation@gmail.com |
//+----------------------------------------------------------------------------------------------+
/*
||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
||                                  DO NOT DELETE THIS HEADER                                   ||
||                         DELETING THIS HEADER IS COPYRIGHT INFRIGMENT                         ||
||                                                                                              ||
||                                Copyright @2017, TVLautomation                                ||
||                        T V L a u t o m a t i o n @ g m a i l . c o m                         ||
||                         https:||www.mql5.com/en/users/TVLautomation                          ||
||                                                                                              ||
||                                                                                              ||
||                               TERMS AND CONDITIONS (FREE CODE)                               ||
||                               --------------------------------                               ||
|| Please note that for all the FREE indicators, EA's, scripts, etc supplied by TVLautomation,  ||
|| the following terms and conditions apply:                                                    ||
||                                                                                              ||
|| 1. "Take it or leave it".                                                                    ||
||   The code is offered "AS-IS". If the MQ4 source is supplied, feel welcome to modify it      ||
||   yourself. The code was originally written for my own use, and is shared freely on the      ||
||   chance that it might also be helpful to others. But please don't expect me to modify it    ||
||   to suit your personal requirements for free. All code may be freely used by anybody,       ||
||   provided that it is not sold or distributed commercially without my prior written consent. ||
||                                                                                              ||
|| 2. "Do it yourself".                                                                         ||
||   I don't have time to write full operating instructions. ALWAYS experiment this code first  ||
||   on a demo account yourself.                                                                ||
||                                                                                              ||
|| 3. "Use it at your own risk".                                                                ||
||   TVLautomation accept NO LIABILITY for any financial losses or computer related damage,     ||
||   that might occur from either correct or incorrect use of the code. If you download and     ||
||   use it, you do so AT YOUR OWN RISK. Some of the indicators and EA's write data to files,   ||
||   and therefore might not work correctly on your station. If there are bugs in my code,      ||
||   you'll need to fix them yourself, or find something else that does a similar job.          ||
||                                                                                              ||
||                                  DO NOT DELETE THIS HEADER                                   ||
||                         DELETING THIS HEADER IS COPYRIGHT INFRIGMENT                         ||
||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
*/
#property copyright     "Copyright 2017, TVLautomation"
#property link          "https://www.mql5.com/en/users/TVLautomation"
#property version       "2.00"
#property description   "This indicator can show you the weekly/daily/hourly/... progress on a lower timeframe." 
#property description   "High, low, middle and/or open-lines can be configured individually."
#property description   " "
#property description   "Let my code work for you!"
#property description   " "  
#property description   "----- TVLautomation -----"  
#property strict

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 clrGray
#property indicator_style1 STYLE_SOLID
#property indicator_color2 clrGray
#property indicator_style2 STYLE_SOLID
#property indicator_color3 clrGray
#property indicator_style3 STYLE_DASHDOT
#property indicator_color4 clrBlue
#property indicator_style4 STYLE_SOLID
//+----------------------------------------------------------------------------------------------+
//| Declare combobox for external variable                                                       |
//+----------------------------------------------------------------------------------------------+                     
enum ENUM_WIDTH         //Line width
  {
   WIDTH_1=1,            // 1
   WIDTH_2=2,            // 2
   WIDTH_3=3,            // 3
   WIDTH_4=4,            // 4
   WIDTH_5=5             // 5  
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum ENUM_MID_TYPE       //Middle line type
  {
   MID_TYPE_NONE=0,      // None
   MID_TYPE_MEDIAN=1,    // Median, (high + low)/2
   MID_TYPE_TYPICAL=2,   // Typical, (high + low + close)/3
   MID_TYPE_WEIGHTED=3   // Average, (high + low + close + close)/4
  };
//+----------------------------------------------------------------------------------------------+
//| Declare external variable                                                                    |
//+----------------------------------------------------------------------------------------------+
sinput  string                Info_1                  ="**********DATA WINDOW**********";
extern  ENUM_TIMEFRAMES       iTimeframe              = PERIOD_D1;                  //Timeframe
extern  int                   iCount                  = 1;                          //Number of bars (>=1)
extern  int                   iShift                  = 0;                          //Shift bars, relative to the current bar (>=0)
extern  int                   iHistory                = 10000;                      //Look back in history (0=full, but slower)

sinput  string                Info_2                  ="**********FORMAT LINES**********";
sinput  bool                  iHighLine_Visible       = true;                       //High line visible
sinput  ENUM_WIDTH            iHighLine_Width         = 1;                          //High line width
sinput  ENUM_LINE_STYLE       iHighLine_Style         = STYLE_SOLID;                //High line style (only valid when width=1)
sinput  color                 iHighLine_Color         = clrGray;                    //High line color
sinput  bool                  iLowLine_Visible        = true;                       //Low line visible
sinput  ENUM_WIDTH            iLowLine_Width          = 1;                          //Low line width
sinput  ENUM_LINE_STYLE       iLowLine_Style          = STYLE_SOLID;                //Low line style (only valid when width=1)
sinput  color                 iLowLine_Color          = clrGray;                    //Low line color
sinput  ENUM_MID_TYPE         iMidLine_Type           = MID_TYPE_MEDIAN;            //Middle line type
sinput  ENUM_WIDTH            iMidLine_Width          = 1;                          //Middle line width
sinput  ENUM_LINE_STYLE       iMidLine_Style          = STYLE_DASHDOT;              //Middle line style (only valid when width=1)
sinput  color                 iMidLine_Color          = clrGray;                    //Middle line color
sinput  bool                  iOpenLine_Visible       = true;                       //Open line visible
sinput  ENUM_WIDTH            iOpenLine_Width         = 1;                          //Open line width
sinput  ENUM_LINE_STYLE       iOpenLine_Style         = STYLE_SOLID;                //Open line style (only valid when width=1)
sinput  color                 iOpenLine_Color         = clrBlue;                    //Open line color
//+----------------------------------------------------------------------------------------------+
//| Global variable (Only setted first time or by reset or by comp.)                             |
//+----------------------------------------------------------------------------------------------+
double HighBuff[];
double LowBuff[];
double MidBuff[];
double OpenBuff[];

int i,limit;
int xHTF_Shift,xHTF_Shift_Prev;
int xLTF,xLTF_Count;
bool RemoveIndicator;
//+----------------------------------------------------------------------------------------------+
//| Custom indicator initialization function                                                     |
//+----------------------------------------------------------------------------------------------+
int OnInit(void)
  {
//Check/correct input parameters
   xLTF=_Period;
   if(iTimeframe<=0)iTimeframe=xLTF;
   if(iTimeframe<xLTF)RemoveIndicator=true;
   else RemoveIndicator=false;
   if(iShift<0)iShift=0;
   if(iCount<1)iCount=1;
   xHTF_Shift_Prev=-1;

//Indicator buffers mapping
   IndicatorBuffers(4);
   IndicatorDigits(_Digits);
   IndicatorShortName("TVLa_HiLo("+IntegerToString(iTimeframe)+","+IntegerToString(iCount)+","+IntegerToString(iShift)+")");

   SetIndexBuffer(0,HighBuff);
   SetIndexLabel(0,"High line");
   SetIndexShift(0,iShift);
   if(iHighLine_Visible)SetIndexStyle(0,DRAW_LINE,iHighLine_Style,iHighLine_Width,iHighLine_Color);
   else SetIndexStyle(0,DRAW_NONE);

   SetIndexBuffer(1,LowBuff);
   SetIndexLabel(1,"Low line");
   SetIndexShift(1,iShift);
   if(iLowLine_Visible)SetIndexStyle(1,DRAW_LINE,iLowLine_Style,iLowLine_Width,iLowLine_Color);
   else SetIndexStyle(1,DRAW_NONE);

   SetIndexBuffer(2,MidBuff);
   SetIndexLabel(2,"Middle line");
   SetIndexShift(2,iShift);
   if(iMidLine_Type>0)SetIndexStyle(2,DRAW_LINE,iMidLine_Style,iMidLine_Width,iMidLine_Color);
   else SetIndexStyle(2,DRAW_NONE);

   SetIndexBuffer(3,OpenBuff);
   SetIndexLabel(3,"Open line");
   SetIndexShift(3,iShift);
   if(iOpenLine_Visible>0)SetIndexStyle(3,DRAW_LINE,iOpenLine_Style,iOpenLine_Width,iOpenLine_Color);
   else SetIndexStyle(3,DRAW_NONE);

//Place logo
   LogoCreator(ANCHOR_LEFT_LOWER,5,5,false);

//OnInit is succeeded
   return(INIT_SUCCEEDED);
  }
//+----------------------------------------------------------------------------------------------+
//| Custor indicator deinitialization function                                                   |
//+----------------------------------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//Remove logo
   LogoCreator(0,0,0,true);
   return;
  }
//+----------------------------------------------------------------------------------------------+
//| Custom indicator iteration function                                                          |
//+----------------------------------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total<=0 || RemoveIndicator)return(0);

//---- 
   limit=rates_total-prev_calculated;
   if(limit>iHistory && iHistory>0)limit=iHistory;
   if(prev_calculated<=0)
     {
      Print("prev_calculated=0");
      limit--;
      ArrayInitialize(HighBuff,EMPTY_VALUE);
      ArrayInitialize(LowBuff,EMPTY_VALUE);
      ArrayInitialize(MidBuff,EMPTY_VALUE);
      ArrayInitialize(OpenBuff,EMPTY_VALUE);
     }

   for(i=limit;i>=0;i--)
     {
      //iBarShift returns the nearest bar into the PAST (to the left)!
      xHTF_Shift=iBarShift(_Symbol,iTimeframe,time[i],false);
      //Newest bar not available in history
      if(xHTF_Shift<0)continue;
      //Oldest bar not available in history
      if((xHTF_Shift+iCount)>iBars(_Symbol,iTimeframe))continue;

      if(xHTF_Shift!=xHTF_Shift_Prev)
        {
         xHTF_Shift_Prev=xHTF_Shift;
         xLTF_Count=iBarShift(_Symbol,0,iTime(_Symbol,iTimeframe,xHTF_Shift+iCount-1),false)-i+1;
         HighBuff[i]=high[iHighest(_Symbol,xLTF,MODE_HIGH,xLTF_Count,i)];
         LowBuff[i]=low[iLowest(_Symbol,xLTF,MODE_LOW,xLTF_Count,i)];
         OpenBuff[i]=open[i+xLTF_Count-1];
        }
      else
        {
         if(high[i]>=HighBuff[i+1])HighBuff[i]=high[i];
         else HighBuff[i]=HighBuff[i+1];
         if(low[i]<=LowBuff[i+1])LowBuff[i]=low[i];
         else LowBuff[i]=LowBuff[i+1];
         OpenBuff[i]=OpenBuff[i+1];
        }
      //calculate the middle line
      switch(iMidLine_Type)
        {
         case MID_TYPE_NONE:break;
         case MID_TYPE_MEDIAN:MidBuff[i]=NormalizeDouble((HighBuff[i]+LowBuff[i])/2,_Digits);break;
         case MID_TYPE_TYPICAL:MidBuff[i]=NormalizeDouble((HighBuff[i]+LowBuff[i]+close[i])/3,_Digits);break;
         case MID_TYPE_WEIGHTED:MidBuff[i]=NormalizeDouble((HighBuff[i]+LowBuff[i]+2*close[i])/4,_Digits);break;
         default:break;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+----------------------------------------------------------------------------------------------+
//| INSERT TVLautomation LOGO                                                                    |
//+----------------------------------------------------------------------------------------------+
bool LogoCreator(ENUM_ANCHOR_POINT AnchorPoint,int X,int Y,bool Clear)
  {
   ENUM_BASE_CORNER BaseCorner=-1;
   bool X_Mid=false,Y_Mid=false;
   long Chart_Height,Chart_Width;

//--- Sets the value of the predefined variable _LastError into zero
   ResetLastError();

//--- Remove object if it already exists
//--- Name must start with ::
   string objname="::"+"TVLautomation_LogoCreator_v1.00";
   if(ObjectFind(objname)>=0)
     {
      if(!ObjectDelete(objname))
        {
         Print(__FUNCTION__,": failed to delete object<",objname,">! Error code = ",_LastError);
         return(false);
        }
     }
   if(Clear)return(true);
//--- Check Anchorpoint
   switch(AnchorPoint)
     {
      case ANCHOR_LEFT_UPPER:
         BaseCorner=CORNER_LEFT_UPPER;
         break;
      case ANCHOR_LEFT:
         BaseCorner=CORNER_LEFT_UPPER;
         Y_Mid=true;
         break;
      case ANCHOR_LEFT_LOWER:
         BaseCorner=CORNER_LEFT_LOWER;
         break;
      case ANCHOR_LOWER:
         BaseCorner=CORNER_LEFT_LOWER;
         X_Mid=true;
         break;
      case ANCHOR_RIGHT_LOWER:
         BaseCorner=CORNER_RIGHT_LOWER;
         break;
      case ANCHOR_RIGHT:
         BaseCorner=CORNER_RIGHT_UPPER;
         Y_Mid=true;
         break;
      case ANCHOR_RIGHT_UPPER:
         BaseCorner=CORNER_RIGHT_UPPER;
         break;
      case ANCHOR_UPPER:
         BaseCorner=CORNER_LEFT_UPPER;
         X_Mid=true;
         break;
      case ANCHOR_CENTER:
         BaseCorner=CORNER_LEFT_UPPER;
         X_Mid=true;
         Y_Mid=true;
         break;
         //REMOVE OBJECT
      default:return(true);
     }
//--- Calculate the middle of x width
   if(X_Mid)
     {
      if(!ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0,Chart_Width))
        {
         //--- display the error message in Experts journal 
         Print(__FUNCTION__+", Error code = ",_LastError);
         return(false);
        }
      X+=(int)Chart_Width/2;
     }
//--- Calculate the middle of y height
   if(Y_Mid)
     {
      if(!ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0,Chart_Height))
        {
         //--- display the error message in Experts journal 
         Print(__FUNCTION__+", Error code = ",_LastError);
         return(false);
        }
      Y+=(int)Chart_Height/2;
     }
//--- Digital value from the bmp file
   uint m_width=101;
   uint m_height=32;
   uint m_pixels[3232]={0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0xFF1CEBEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFF0000,0xFFFF0000,0xFFFF0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0xFF90A4AE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
//--- Creates an image resource based on a data set (m_pixels)
   if(!ResourceCreate(objname,m_pixels,m_width,m_height,0,0,0,COLOR_FORMAT_ARGB_NORMALIZE))
     {
      Print(__FUNCTION__,": failed to create resource! Error code = ",_LastError);
      return(false);
     }
//--- create attached object
   if(!ObjectCreate(0,objname,OBJ_BITMAP_LABEL,0,0,0))
     {
      Print(__FUNCTION__,": failed to create bitmap object! Error code = ",_LastError);
      return(false);
     }
//--- set the chart's corner, relative to which point coordinates are defined  
   if(!ObjectSetInteger(0,objname,OBJPROP_CORNER,BaseCorner))
     {
      Print(__FUNCTION__,": failed to set the chart's corner! Error code = ",_LastError);
      return(false);
     }
//--- set anchor type
   if(!ObjectSetInteger(0,objname,OBJPROP_ANCHOR,AnchorPoint))
     {
      Print(__FUNCTION__,": failed to change the anchor of the object <",objname,">! Error code = ",_LastError);
      return(false);
     }
//--- set x distance
   if(!ObjectSetInteger(0,objname,OBJPROP_XDISTANCE,X))
     {
      Print(__FUNCTION__,": failed to set the X-distance of the object <",objname,">! Error code = ",_LastError);
      return(false);
     }
//--- set y distance
   if(!ObjectSetInteger(0,objname,OBJPROP_YDISTANCE,Y))
     {
      Print(__FUNCTION__,": failed to set the Y-distance of the object <",objname,">! Error code = ",_LastError);
      return(false);
     }
//--- set name of BMP-file for Bitmap Label
   if(!ObjectSetString(0,objname,OBJPROP_BMPFILE,objname))
     {
      Print(__FUNCTION__,": failed to set the name of BMP-file for Bitmap Label of the object <",objname,">! Error code = ",_LastError);
      return(false);
     }
   return(true);
  }
//+----------------------------------------------------------------------------------------------+