//+------------------------------------------------------------------+
//|                                 BinaryOptionsStrategyLibrary.mqh |
//|                                       Copyright 2016, __martin__ |
//|                         https://www.mql5.com/en/users/__martin__ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, __martin__"
#property link      "https://www.mql5.com/en/users/__martin__"
#property version   "1.01"
#property strict

//Import Strategy-Tester to place trades and messages
#import "..\\Experts\\Market\\Binary Options Strategy Tester.ex4"
   void StrategyTesterPlaceTrade(int);
   void PrintDebugValue(string,string,int,int);
#import

//---- Enum for input Parameters
enum YesNo
  {
   YES =  1,
   NO  = -1
  };

//---- Input parameters
input YesNo oneTradePerCandle                      = YES;      //Just one SELL/BUY Trade per candle
input YesNo shouldCheckOnlyAtBeginningOfNewCandle  = YES;      //Check only at beginning of new candles (not on every tick)

//---- Internal variables
int  lastCandlePlacedSell                          = Bars;     //Value to store current/last Candle where SELL is placed
int  lastCandlePlacedBuy                           = Bars;     //Value to store current/last Candle where SELL is placed
int  lastCandleWatched                             = Bars;     //Value of last watched Candle
bool firstRun                                      = true;     //Value to check if it is the first call of the library

//+------------------------------------------------------------------+
//| Function to place orders for Strategy-Tester.                    |
//| Input parameter: OP_SELL or OP_BUY                               |
//+------------------------------------------------------------------+
void PlaceTrade(int _tradeOperation)
  {
   if((_tradeOperation==OP_SELL && oneTradePerCandle==NO)
   || (_tradeOperation==OP_SELL && oneTradePerCandle==YES && IsNewCandle(OP_SELL))) //Check if SELL-Trade should be placed for Strategy-Tester
     {
      StrategyTesterPlaceTrade(OP_SELL); //Place trade in Strategy-Tester
      lastCandlePlacedSell=Bars; //Store current Candle
     }
   if((_tradeOperation==OP_BUY && oneTradePerCandle==NO)
   || (_tradeOperation==OP_BUY && oneTradePerCandle==YES && IsNewCandle(OP_BUY))) // Check if BUY-Trade should be placed for Strategy-Tester
     {
      StrategyTesterPlaceTrade(OP_BUY); //Place trade in Strategy-Tester
      lastCandlePlacedBuy=Bars; //Store current Candle
     }
  }

//+------------------------------------------------------------------+
//| Function to check if we have a new candle or if we have already  |
//| placed a trade on the current candle                             |
//+------------------------------------------------------------------+
bool IsNewCandle(int _tradeOperation)
  {
   if(_tradeOperation==OP_SELL && lastCandlePlacedSell!=Bars) //Check if we have a new candle for SELL
     {
      lastCandlePlacedSell=Bars; //Store last candle where SELL is placed
      return true; //Return true if candle is "new"
     }
   if(_tradeOperation==OP_BUY && lastCandlePlacedBuy!=Bars) //Check if we have a new candle for BUY
     {
      lastCandlePlacedBuy=Bars; //Store last candle where BUY is placed
      return true; //Return true if candle is "new"
     }
   return false; //Return false if candle is not "new"
  }

//+------------------------------------------------------------------+
//| Function to decide if we have to check for our rules or not.     |
//| Call this function in OnCalculate-event of your indicator.       |
//+------------------------------------------------------------------+
void CallStrategy()
  {
   if(firstRun)
   {
      if(!IsLibrariesAllowed())
      {
         Print("++++++ ERROR: Allow external experts input is disabled!");
         Print("++++++ ERROR-SOLUTION: Enable \"Allow external experts input\" on tab \"Common\" in Strategy-Indicator.");
      }
      firstRun=false;
   }
   else if(shouldCheckOnlyAtBeginningOfNewCandle==NO
       || (shouldCheckOnlyAtBeginningOfNewCandle==YES && lastCandleWatched!=Bars)) //Check if we have to check for our rules
     {
      CheckMyRules(); //Check for our rules 
     }
   lastCandleWatched=Bars; //Store last candle watched
  }

//+------------------------------------------------------------------+
//| Function to print out debug-values                               |
//+------------------------------------------------------------------+
void PrintDebugValue(string _labelText="", string _valueText="", int _row=0)
  {
   PrintDebugValue(_labelText, _valueText, _row, ChartWindowFind());
  }
//+------------------------------------------------------------------+
  