//+------------------------------------------------------------------+
//|                                 Normalized_Volume_Oscillator.mq5 |
//|                                Copyright  2008, Vadim Shumiloff |
//|                                                shumiloff@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2008, Vadim Shumiloff"
#property link "shumiloff@mail.ru"
//----   
#property version   "1.02"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1  clrGray,clrBlue,clrPurple,clrRed,clrYellow
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Normalized_Volume_Oscillator"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint VolumePeriod=10;
input ENUM_APPLIED_VOLUME VolumeType=VOLUME_TICK;  //  
input int Shift=0; //      
//+-----------------------------------+

//----   ,    
//      
double IndBuffer[];
double ColorIndBuffer[];
//----      
int min_rates_total,min_rates_1;
//+------------------------------------------------------------------+   
//| Bears indicator initialization function                          | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_total=int(VolumePeriod);
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----     ,     
   SetIndexBuffer(1,ColorIndBuffer,INDICATOR_COLOR_INDEX);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"Normalized_Volume_Oscillator(",VolumePeriod,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----      5  
   IndicatorSetInteger(INDICATOR_LEVELS,4);
//----       
   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,0.0);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,38.2);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,2,61.8);
   IndicatorSetDouble(INDICATOR_LEVELVALUE,3,100.0);
//----             
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,clrBlue);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,clrTeal);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,2,clrRed);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,3,clrOrange);
//----       -  
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,2,STYLE_DASHDOTDOT);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,3,STYLE_DASHDOTDOT);
//----  
  }
//+------------------------------------------------------------------+ 
//| Bears iteration function                                         | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double nvo;
//----        
   int first,bar,clr;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++) IndBuffer[bar]=NormalizedVolume(VolumeType,tick_volume,volume,bar)*100-100;

//----     
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      nvo=IndBuffer[bar];
      if(nvo<0)
        {
         clr=0;
        }
      else
        {
         if(nvo<38.2)
           {
            clr=1;
           }
         else
           {
            if(nvo<61.8)
              {
               clr=2;
              }
            else
              {
               if(nvo<100)
                 {
                  clr=3;
                 }
               else clr=4;
              }
           }
        }
      ColorIndBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double NormalizedVolume(ENUM_APPLIED_VOLUME type,
                        const long &Tick_Volume[],
                        const long &Volume[],
                        int index)
  {
//----
   double nv=0.0,vol;
   if(type==VOLUME_TICK)
     {
      for(int kkk=0; kkk<int(VolumePeriod); kkk++) nv+=double(Tick_Volume[index-kkk]);
      nv=nv/VolumePeriod;
      vol=Tick_Volume[index]/nv;
     }
   else
     {
      for(int kkk=0; kkk<int(VolumePeriod); kkk++) nv+=double(Volume[index-kkk]);
      nv=nv/VolumePeriod;
      vol=Volume[index]/nv;
     }
//----
   return(vol);
  }
//+------------------------------------------------------------------+
