//+------------------------------------------------------------------+
//|                                                IncGUI_BitPic.mqh |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+

#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"

/*

   Added the SetColorFormat(ENUM_COLOR_FORMAT aColorFormat=COLOR_FORMAT_ARGB_NORMALIZE) method
   
   Parameter: aColorFormat - color format of ENUM_COLOR_FORMAT
   
   In the Init() method the aColorFormat parameter is added.
   
   All methods of setting the color have the new parameter aA, 
   values from 0 to 255. 0 - transparent painting, 
   255 - nontransparent. Default is 255.
   
   
   
*/




class CBitPic{
   private: 
      int m_Left,m_Top,m_Width,m_Height,m_SubWindow;
      bool m_Visible;
      string m_Name,m_RName,m_Tag;
      uint m_Data[];
      int m_DataSize;
      int m_dotc[6];
      int m_dotxy[6][21][2];
      uint m_DrawColor;
      uint m_FillColor;
      uint m_BGColor;
      bool m_Filled;
      int m_DrawWidth;
      int TmpBuf2[][2];
      int TmpBuf1[];
      int m_Size;
      int m_Space;
      int m_PA[];
      int m_WA[];
      int m_XA[];
      int m_YA[];   
      string m_Font;   
      int m_FontSize;
      ENUM_COLOR_FORMAT m_colorformat;
      void Create(){
         ObjectCreate(0,m_Name,OBJ_BITMAP_LABEL,m_SubWindow,0,0);
         ResourceCreate(m_RName,m_Data,m_Width,m_Height,0,0,0,m_colorformat);
         ObjectSetInteger(0,m_Name,OBJPROP_XDISTANCE,m_Left);
         ObjectSetInteger(0,m_Name,OBJPROP_YDISTANCE,m_Top);
         ObjectSetString(0,m_Name,OBJPROP_BMPFILE,m_RName);
      }         
      void Delete(){
         ObjectDelete(0,m_Name);
      }
      void PrepareDot(){
         m_dotc[0]=0;m_dotc[1]=1;m_dotc[2]=4;m_dotc[3]=5;m_dotc[4]=12;m_dotc[5]=21;   
         m_dotxy[1][0][0]=0;m_dotxy[1][0][1]=0;   
         m_dotxy[2][0][0]=0;m_dotxy[2][0][1]=0;m_dotxy[2][1][0]=0;m_dotxy[2][1][1]=1;
         m_dotxy[2][2][0]=1;m_dotxy[2][2][1]=0;m_dotxy[2][3][0]=1;m_dotxy[2][3][1]=1;  
         m_dotxy[3][0][0]=0;m_dotxy[3][0][1]=0;m_dotxy[3][1][0]=0;m_dotxy[3][1][1]=-1;
         m_dotxy[3][2][0]=0;m_dotxy[3][2][1]=1;m_dotxy[3][3][0]=-1;m_dotxy[3][3][1]=0;
         m_dotxy[3][4][0]=1;m_dotxy[3][4][1]=0;m_dotxy[4][0][0]=-1;m_dotxy[4][0][1]=0;         
         m_dotxy[4][1][0]=-1;m_dotxy[4][1][1]=1;m_dotxy[4][2][0]=0;m_dotxy[4][2][1]=-1;
         m_dotxy[4][3][0]=0;m_dotxy[4][3][1]=0;m_dotxy[4][4][0]=0;m_dotxy[4][4][1]=1;
         m_dotxy[4][5][0]=0;m_dotxy[4][5][1]=2;m_dotxy[4][6][0]=1;m_dotxy[4][6][1]=-1;
         m_dotxy[4][7][0]=1;m_dotxy[4][7][1]=0;m_dotxy[4][8][0]=1;m_dotxy[4][8][1]=1;
         m_dotxy[4][9][0]=1;m_dotxy[4][9][1]=2;m_dotxy[4][10][0]=2;m_dotxy[4][10][1]=0;         
         m_dotxy[4][11][0]=2;m_dotxy[4][11][1]=1;m_dotxy[5][0][0]=-2;m_dotxy[5][0][1]=-1;         
         m_dotxy[5][1][0]=-2;m_dotxy[5][1][1]=0;m_dotxy[5][2][0]=-2;m_dotxy[5][2][1]=1;
         m_dotxy[5][3][0]=-1;m_dotxy[5][3][1]=-2;m_dotxy[5][4][0]=-1;m_dotxy[5][4][1]=-1;
         m_dotxy[5][5][0]=-1;m_dotxy[5][5][1]=0;m_dotxy[5][6][0]=-1;m_dotxy[5][6][1]=1;
         m_dotxy[5][7][0]=-1;m_dotxy[5][7][1]=2;m_dotxy[5][8][0]=0;m_dotxy[5][8][1]=-2;
         m_dotxy[5][9][0]=0;m_dotxy[5][9][1]=-1;m_dotxy[5][10][0]=0;m_dotxy[5][10][1]=0;
         m_dotxy[5][11][0]=0;m_dotxy[5][11][1]=1;m_dotxy[5][12][0]=0;m_dotxy[5][12][1]=2;
         m_dotxy[5][13][0]=1;m_dotxy[5][13][1]=-2;m_dotxy[5][14][0]=1;m_dotxy[5][14][1]=-1;
         m_dotxy[5][15][0]=1;m_dotxy[5][15][1]=0;m_dotxy[5][16][0]=1;m_dotxy[5][16][1]=1;
         m_dotxy[5][17][0]=1;m_dotxy[5][17][1]=2;m_dotxy[5][18][0]=2;m_dotxy[5][18][1]=-1;
         m_dotxy[5][19][0]=2;m_dotxy[5][19][1]=0;m_dotxy[5][20][0]=2;m_dotxy[5][20][1]=1;
      }    
      double Arctan2(double Y,double X){
         if(Y==0){
            if(X<0)return(M_PI);
            return(0);
         }
         else{
            if(X>0)return(MathArctan(Y/X));
            if(X<0){
               if(Y>0)return(MathArctan(Y/X)+M_PI);
               return(MathArctan(Y/X)-M_PI);
            }         
            else{
               if(Y<0)return(-M_PI_2);
               return(M_PI_2);
            }
         }
      }    
      double Arctan22(double Y,double X){
         double ang=Arctan2(Y,X);
         if(ang<0)ang+=2.0*M_PI;
         return(ang);
      }
      void SolidTriangle(int aX1,int aY1,int aX2,int aY2,int aX3,int aY3){
         int mnx=MathMin(aX1,MathMin(aX2,aX3));
         int mxx=MathMax(aX1,MathMax(aX2,aX3));
         int mny=MathMin(aY1,MathMin(aY2,aY3));
         int mxy=MathMax(aY1,MathMax(aY2,aY3));
            for(int y=mny;y<=mxy;y++){
               for(int x=mnx;x<=mxx;x++){
                  int r1=PixPos(x,y,aX1,aY1,aX2,aY2)*PixPos(aX3,aY3,aX1,aY1,aX2,aY2);
                  int r2=PixPos(x,y,aX3,aY3,aX2,aY2)*PixPos(aX1,aY1,aX3,aY3,aX2,aY2);
                  int r3=PixPos(x,y,aX1,aY1,aX3,aY3)*PixPos(aX2,aY2,aX1,aY1,aX3,aY3);
                     if(r1>=0 && r2>=0 && r3>=0){
                        if(x>=0 && x<m_Width && y>=0 && y<m_Height){
                           m_Data[y*m_Width+x]=m_FillColor;
                        }                           
                     }
               }
            }      
      }  
      int PixPos(int x,int y,int x1,int y1,int x2,int y2){
         int s=(x-x1)*(y2-y1)-(y-y1)*(x2-x1);
         if(s>0)return(1);
         if(s<0)return(-1);
         return(0);
      }  
      void FillAddDot(int x,int y,uint RepColor,int & Size){
         if(x>=0 && x<m_Width && y>=0 && y<m_Height){
            if(TmpBuf1[y*m_Width+x]==0){
               if(m_Data[y*m_Width+x]==RepColor){
                  TmpBuf1[y*m_Width+x]=1;
                  TmpBuf2[Size][0]=x;
                  TmpBuf2[Size][1]=y;
                  Size++; 
               }
            }
         }
      }
      void LineOfXY(int aX1,int aY1,int aX2,int aY2,int aO1,int aO2,int & aOX1,int & aOY1,int & aOX2,int & aOY2){
            if(MathAbs(aX1-aX2)>MathAbs(aY1-aY2)){ // wider
                  if(aX1<aX2){
                     aOX1=aX1+aO1;
                     aOX2=aX2-aO2;
                  }
                  else{
                     aOX1=aX1-aO1;
                     aOX2=aX2+aO2;
                  }
               aOY1=(int)MathRound(aY1+(double)(aOX1-aX1)/(aX2-aX1)*(aY2-aY1));
               aOY2=(int)MathRound(aY1+(double)(aOX2-aX1)/(aX2-aX1)*(aY2-aY1));
            }
            else{ // higher
                  if(aY1<aY2){
                     aOY1=aY1+aO1;
                     aOY2=aY2-aO2;
                  }
                  else{
                     aOY1=aY1-aO1;
                     aOY2=aY2+aO2;
                  }
               aOX1=(int)MathRound(aX1+(double)(aOY1-aY1)/(aY2-aY1)*(aX2-aX1));
               aOX2=(int)MathRound(aX1+(double)(aOY2-aY1)/(aY2-aY1)*(aX2-aX1));
            }
      }   
      
      void CopyFonts(int & aPA[],int & aWA[],int & aXA[],int & aYA[]){
         ArrayResize(m_PA,ArraySize(aPA));
         ArrayResize(m_WA,ArraySize(aWA));
         ArrayResize(m_XA,ArraySize(aXA));
         ArrayResize(m_YA,ArraySize(aYA));
         ArrayCopy(m_PA,aPA);
         ArrayCopy(m_WA,aWA);
         ArrayCopy(m_XA,aXA);
         ArrayCopy(m_YA,aYA);         
      }

     
            
   public:
      void Init(string aName="CBitPic",int aWidth=300,int aHeight=200,ENUM_COLOR_FORMAT aColorFormat=COLOR_FORMAT_ARGB_NORMALIZE){
         m_colorformat=aColorFormat;
         m_Name=aName;
         m_RName="::"+aName;
         m_Width=aWidth;
         m_Height=aHeight;
         m_Left=0;
         m_Top=0;
         m_SubWindow=0;
         m_DataSize=m_Width*m_Height;
         ArrayResize(m_Data,m_DataSize);
         ArrayResize(TmpBuf2,m_DataSize);
         ArrayResize(TmpBuf1,m_DataSize);
         m_DrawWidth=1;
         PrepareDot();
         SetDrawColor(clrYellow);
         SetFillColor(clrRed);
         SetBGColor(clrBlue); 
         SetFilled(true);  
         SetFont(3);
         Clear();
      }
      void SetPos(int aLeft,int aTop){
         m_Left=aLeft;
         m_Top=aTop;
      }
      void SetPosLeft(int aLeft){
         m_Left=aLeft;
      }   
      void SetPosTop(int aTop){
         m_Top=aTop;
      }  
      int Left(){
         return(m_Left);
      }
      int Top(){
         return(m_Top);
      }
      int Width(){
         return(m_Width);
      }
      int Height(){
         return(m_Height);
      }
      void Show(){
         m_Visible=true;
         Create();
         Redraw();
      }
      void Show(int aLeft,int aTop){
         SetPos(aLeft,aTop);
         Show();
      }
      void Hide(){
         m_Visible=false;
         Delete();
         ChartRedraw();
      }  
      void Refresh(){
         if(m_Visible){
            Delete();
            Create();
            ChartRedraw();
         }            
      }  
      void SetColorFormat(ENUM_COLOR_FORMAT aColorFormat=COLOR_FORMAT_ARGB_NORMALIZE){
         m_colorformat=aColorFormat;
      }
      void Redraw(){
         ResourceCreate(m_RName,m_Data,m_Width,m_Height,0,0,0,m_colorformat);
         ChartRedraw();
      }   
      int Event(const int id,const long & lparam,const double & dparam,const string & sparam){ // event handling
         
         return(0);
      }
      void SetSubWindow(int aNumber){ // Setting the subwindow by number
         int m_itmp=(int)MathMax(aNumber,0); // If the subwindow number is negative, 0 will be used, i.e. a price chart
            if(m_itmp!=m_SubWindow){ // The subwindow number specified does not match the subwindow number where the control is located
               m_SubWindow=m_itmp; // Registration of the new subwindow number
               Refresh(); // Recreating graphical objects
            }
      }  
      void SetSubWindow(string aName){ // Setting the subwindow by name
         SetSubWindow(ChartWindowFind(0,aName)); // Determining the subwindow number and setting the subwindow by the number
      }
      void SetTag(string aValue){ // Set the tag
         m_Tag=aValue;
      }
      string Tag(){ // Get the tag
         return(m_Tag);
      }  
      bool Visible(){
         return(m_Visible);
      }
      void SetDrawColor(uchar aR=255,uchar aG=255,uchar aB=0,uchar aA=255){
         m_DrawColor=(uint)(((aA<<24)|(aR<<16)|(aG<<8)|aB));
      }
      void SetDrawColor(color aColor=clrYellow,uchar aA=255){
         uint r=(aColor&0xff);
         uint g=((aColor>>8)&0xff);
         uint b=((aColor>>16)&0xff);  
         m_DrawColor=(uint)(((aA<<24)|(r<<16)|(g<<8)|b));
      }
      void SetFillColor(uchar aR=255,uchar aG=0,uchar aB=0,uchar aA=255){
         m_FillColor=(uint)(((aA<<24)|(aR<<16)|(aG<<8)|aB));
      }
      void SetFillColor(color aColor=clrRed,uchar aA=255){
         uint r=(aColor&0xff);
         uint g=((aColor>>8)&0xff);
         uint b=((aColor>>16)&0xff);  
         m_FillColor=(uint)(((aA<<24)|(r<<16)|(g<<8)|b));
      }
      void SetBGColor(uchar aR=0,uchar aG=0,uchar aB=255,uchar aA=255){
         m_BGColor=(uint)(((aA<<24)|(aR<<16)|(aG<<8)|aB));
      }
      void SetBGColor(color aColor=clrBlue,uchar aA=255){
         uint r=(aColor&0xff);
         uint g=((aColor>>8)&0xff);
         uint b=((aColor>>16)&0xff);  
         m_BGColor=(uint)(((aA<<24)|(r<<16)|(g<<8)|b));
      }      
      void Clear(){
         ArrayInitialize(m_Data,m_BGColor);
      }  
      void SetFilled(bool aFilled=true){
         m_Filled=aFilled;
      }
      void SetDrawWidth(int aWidth){
         m_DrawWidth=MathMax(MathMin(aWidth,5),1);
      }
      void DrawDot(int aX,int aY){
         int i,x,y;
            for(i=0;i<m_dotc[m_DrawWidth];i++){
               x=aX+m_dotxy[m_DrawWidth][i][0];
               y=aY+m_dotxy[m_DrawWidth][i][1];
                  if(x>=0 && x<m_Width && y>=0 && y<m_Height){
                     m_Data[y*m_Width+x]=m_DrawColor;
                  }            
            }
      }
      void DrawLine(int aX1,int aY1,int aX2,int aY2){
            if(aX1==aX2 && aY1==aY2){
               DrawDot(aX1,aY1);
               return;
            }
         int x1=aX1;
         int y1=aY1;
         int x2=aX2;
         int y2=aY2;         
            if(MathAbs(aX1-aX2)>MathAbs(aY1-aY2)){ // wider
               if(aX1>aX2){
                  x1=aX2;
                  y1=aY2;
                  x2=aX1;
                  y2=aY1;
               }
               for(int x=x1;x<=x2;x++){
                  DrawDot(x,(int)MathRound(y1+(double)(x-x1)/(x2-x1)*(y2-y1)));
               }
            }
            else{
               if(aY1>aY2){
                  x1=aX2;
                  y1=aY2;
                  x2=aX1;
                  y2=aY1;
               }   
               for(int y=y1;y<=y2;y++){
                  DrawDot((int)MathRound(x1+(double)(y-y1)/(y2-y1)*(x2-x1)),y);
               }                           
            }
      }
      void DrawLineByAngle(int aX1,int aY1,double aAngle,int aLength){
         int x2=aX1+(int)MathRound(MathCos(aAngle)*aLength);
         int y2=aY1+(int)MathRound(MathSin(aAngle)*aLength);
         DrawLine(aX1,aY1,x2,y2);
      }
      void DrawArrow(int aX1,int aY1,int aX2,int aY2,int aBoth=false){
            if(aX1==aX2 && aY1==aY2){
               DrawDot(aX1,aY1);
               return;
            }      
         int l[]={0,8,9,12,14,17};
         int o[]={0,1,1,2,2,3};
         double ang=Arctan22(aY2-aY1,aX2-aX1);
         int x1,y1,x2,y2;
         LineOfXY(aX1,aY1,aX2,aY2,o[m_DrawWidth],aBoth*o[m_DrawWidth],x1,y1,x2,y2);          
         DrawLine(x1,y1,x2,y2);
         DrawLineByAngle(x1,y1,ang+0.3,l[m_DrawWidth]);
         DrawLineByAngle(x1,y1,ang-0.3,l[m_DrawWidth]);
            if(aBoth){
               DrawLineByAngle(x2,y2,M_PI+ang+0.3,l[m_DrawWidth]);
               DrawLineByAngle(x2,y2,M_PI+ang-0.3,l[m_DrawWidth]);               
            }
      }
      void DrawRectangle(int aX1,int aY1,int aX2,int aY2){
            if(m_Filled){
               SolidTriangle(aX1,aY1,aX2,aY2,aX1,aY2);
               SolidTriangle(aX1,aY1,aX2,aY2,aX2,aY1);
            }         
         DrawLine(aX1,aY1,aX1,aY2);
         DrawLine(aX1,aY1,aX2,aY1);         
         DrawLine(aX2,aY2,aX2,aY1);
         DrawLine(aX2,aY2,aX1,aY2);            
      }
      void DrawTriangle(int aX1,int aY1,int aX2,int aY2,int aX3,int aY3){
            if(m_Filled){
               SolidTriangle(aX1,aY1,aX2,aY2,aX3,aY3);
            }   
         DrawLine(aX1,aY1,aX2,aY2);
         DrawLine(aX3,aY3,aX2,aY2);
         DrawLine(aX1,aY1,aX3,aY3);
      }
      void DrawCircle(int aX,int aY,int aR,double aR2K=0,double aFromAngle=0,double aToAngle=0,double aRatio=1,double aRotateAngle=0){
         int Limit=(int)MathCeil(MathMax(aRatio,1)*aR)+1;
         int TmpBufSize=Limit*2+1;
         uint TmpBuf[];
         ArrayResize(TmpBuf,TmpBufSize*TmpBufSize);
         ArrayInitialize(TmpBuf,m_BGColor);
         int aR2=(int)MathRound(aR2K*aR);
         for(int y=-Limit;y<Limit;y++){
            for(int x=-Limit;x<Limit;x++){
               double xx=cos(aRotateAngle)*x-sin(aRotateAngle)*y;
               double yy=sin(aRotateAngle)*x+cos(aRotateAngle)*y;
               double r=xx*xx+yy*yy;
               r=MathRound(r);
               double f=Arctan22(yy,xx);
               f=NormalizeDouble(f,4);
                  if((aFromAngle<aToAngle && f>=aFromAngle && f<=aToAngle) || (aFromAngle>aToAngle && (f>aFromAngle || f<aToAngle)) || aFromAngle==aToAngle){
                     if(MathAbs(xx)<=aR){
                        bool dd=true;
                        double R=pow(xx,2)+pow(aRatio,2)*(pow(aR,2)-pow(xx,2));
                        R=MathRound(R);
                           if(MathAbs(xx)<=aR2){
                              double R2=pow(xx,2)+pow(aRatio,2)*(pow(aR2,2)-pow(xx,2));
                              R2=MathRound(R2);
                              if(r<R2)dd=false;
                           }
                           if(r<R && dd){
                              int dx=Limit+x;
                              int dy=Limit+y;                           
                                 if(dx>=0 && dx<TmpBufSize && dy>=0 && dy<TmpBufSize){
                                    TmpBuf[dy*TmpBufSize+dx]=m_FillColor;
                                 }                              
                           }
                     }
                  }
            }
         }
         for(int x=-Limit;x<=Limit;x++){
            uint pc=m_BGColor;
               for(int y=-Limit;y<Limit;y++){
                  int dx=Limit+x;
                  int dy=Limit+y;
                  uint cc=TmpBuf[dy*TmpBufSize+dx];
                     if(cc!=pc){
                        if(cc!=m_BGColor)TmpBuf[dy*TmpBufSize+dx]=m_DrawColor;
                        if(pc!=m_BGColor)TmpBuf[(dy-1)*TmpBufSize+dx]=m_DrawColor;
                     }
                  pc=cc;
               }   
         }
         for(int y=-Limit;y<Limit;y++){
            uint pc=m_BGColor;
               for(int x=-Limit;x<=Limit;x++){
                  int dx=Limit+x;
                  int dy=Limit+y;               
                  uint cc=TmpBuf[dy*TmpBufSize+dx];
                     if(cc!=pc && cc!=m_DrawColor && pc!=m_DrawColor){
                        if(cc!=m_BGColor)TmpBuf[dy*TmpBufSize+dx]=m_DrawColor;
                        if(pc!=m_BGColor)TmpBuf[dy*TmpBufSize+dx-1]=m_DrawColor;
                     }
                  pc=cc;
               }   
         } 
         if(m_Filled){
            for(int y=-Limit;y<Limit;y++){
               for(int x=-Limit;x<Limit;x++){
                  int dx=Limit+x;
                  int dy=Limit+y;  
                     if(TmpBuf[dy*TmpBufSize+dx]==m_FillColor){
                        int xx=aX+x;
                        int yy=aY+y;
                           if(xx>=0 && xx<m_Width && yy>=0 && yy<m_Height){
                              m_Data[yy*m_Width+xx]=m_FillColor;
                           }                           
                     }
               }         
            }    
         }
         for(int y=-Limit;y<Limit;y++){
            for(int x=-Limit;x<Limit;x++){
               int dx=Limit+x;
               int dy=Limit+y;  
                  if(TmpBuf[dy*TmpBufSize+dx]==m_DrawColor){
                     DrawDot(aX+x,aY+y);
                  }                  
            }         
         }                    
      }  
      void Fill(int aX,int aY){
         if(aX>=0 && aX<m_Width && aY>=0 && aY<m_Height){
            if(m_Data[aY*m_Width+aX]!=m_FillColor){
               uint RepColor=m_Data[aY*m_Width+aX];
               int Size=0;
               ArrayInitialize(TmpBuf1,0);
               TmpBuf2[Size][0]=aX;
               TmpBuf2[Size][1]=aY;
               Size++;
                  for(int i=0;i<Size;i++){
                     m_Data[TmpBuf2[i][1]*m_Width+TmpBuf2[i][0]]=m_FillColor;
                     FillAddDot(TmpBuf2[i][0]-1,TmpBuf2[i][1],RepColor,Size);
                     FillAddDot(TmpBuf2[i][0]+1,TmpBuf2[i][1],RepColor,Size);
                     FillAddDot(TmpBuf2[i][0],TmpBuf2[i][1]-1,RepColor,Size);
                     FillAddDot(TmpBuf2[i][0],TmpBuf2[i][1]+1,RepColor,Size);
                  }
            }
         }
      }
      
      void TypeText(int aX,int aY,string aText,int aDirection=0,int aAlign=1){
         int k1=0,k2=0,k3=0,k4=0,k5=0,k6=0;
            if(aAlign==0){
               switch(aDirection){
                  case 0:
                     k1=1;
                     k3=1;
                     k5=1;      
                  break;
                  case 1:         
                     k2=1;
                     k4=-1;
                     k6=1;
                  break;
                  case 2:
                     k1=-1;
                     k3=-1;
                     k5=-1;            
                  break;               
                  case 3:         
                     k2=-1;
                     k4=1;
                     k6=-1;
                  break;
               }                     
               for(int j=0;j<StringLen(aText);j++){
                  string TypeChar=StringSubstr(aText,j,1);
                     if(TypeChar==" "){
                        aX+=k1*m_Space;
                        aY+=k2*m_Space;
                     }
                     else{
                           uchar a[];
                           StringToCharArray(TypeChar,a); 
                           int Pointer=a[0]-33;
                           for(int i=m_PA[Pointer];i<m_PA[Pointer+1];i++){
                              int x=aX+k3*m_XA[i]+k4*m_YA[i];
                              int y=aY+k5*m_YA[i]+k6*m_XA[i];
                                 if(x>=0 && x<m_Width && y>=0 && y<m_Height){
                                    m_Data[y*m_Width+x]=m_DrawColor;
                                 }                              
                           }
                           if(ArraySize(m_WA)==1){
                              aX+=k1*m_Space;
                              aY+=k2*m_Space;                           
                           }
                           else{
                              aX+=k1*(m_WA[Pointer]+1);
                              aY+=k2*(m_WA[Pointer]+1);
                           }

                     }
               } 
            }  
            else if(aAlign==1){
               switch(aDirection){
                  case 0:
                     k1=-1;
                     k3=1;
                     k5=1;      
                  break;
                  case 1:         
                     k2=1;
                     k4=1;
                     k6=-1;
                  break;
                  case 2:
                     k1=1;
                     k3=-1;
                     k5=-1;            
                  break;               
                  case 3:         
                     k2=-1;
                     k4=-1;
                     k6=1;
                  break;
               }                     
               for(int j=StringLen(aText)-1;j>=0;j--){
                  string TypeChar=StringSubstr(aText,j,1);
                     if(TypeChar==" "){
                        aX+=k1*m_Space;
                        aY+=k2*m_Space;
                     }
                     else{
                        uchar a[];
                        StringToCharArray(TypeChar,a); 
                        int Pointer=a[0]-33;
                           if(ArraySize(m_WA)==1){
                              aX+=k1*m_Space;
                              aY+=k2*m_Space;                           
                           }
                           else{
                              aX+=k1*(m_WA[Pointer]+1);
                              aY+=k2*(m_WA[Pointer]+1);
                           }
                           for(int i=m_PA[Pointer];i<m_PA[Pointer+1];i++){
                              int x=aX+k3*m_XA[i]+k4*m_YA[i];
                              int y=aY+k5*m_YA[i]+k6*m_XA[i];
                                 if(x>=0 && x<m_Width && y>=0 && y<m_Height){
                                    m_Data[y*m_Width+x]=m_DrawColor;
                                 }                              
                           }
                     }
               } 
            }
            
      }     
       
      void SetFont(int aType=3){
         if(aType==0){
               m_Font="Small Fonts";
               m_FontSize=6;
               m_Space=2;
               int m_SF6_PA[]={0,5,9,27,40,52,63,65,73,81,85,90,92,94,95,101,113,120,132,142,154,164,176,184,196,208,210,213,218,224,229,236,256,267,285,297,313,327,338,353,367,373,381,393,401,423,441,455,467,482,498,508,518,531,541,555,565,573,585,594,600,609,612,617,619,626,638,644,656,662,669,682,692,697,704,714,720,733,741,749,761,773,778,784,790,798,804,814,820,829,837,844,851,858,862,868,882,893,895,903,907,910,918,928,928,946,964,967,987,1001,1015,1032,1046,1047,1048,1050,1052,1054,1056,1059,1059,1072,1083,1086,1098,1108,1120,1130,1130,1147,1159,1167,1172,1182,1188,1200,1217,1230,1244,1250,1255,1256,1269,1276,1277,1285,1291,1296,1303,1314,1331,1332,1340,1365,1372,1378,1385,1395,1401,1407,1418,1435,1453,1462,1481,1495,1517,1527,1545,1565,1577,1590,1612,1626,1640,1654,1666,1678,1688,1701,1719,1729,1745,1756,1778,1802,1815,1833,1845,1859,1878,1894,1901,1913,1923,1929,1942,1948,1960,1967,1976,1987,1995,2003,2014,2023,2031,2040,2052,2058,2064,2073,2088,2094,2105,2112,2126,2142,2150,2161,2168,2175,2186,2194};
               int m_SF6_WA[]={1,3,5,3,4,4,1,2,2,2,3,1,2,1,2,4,2,4,4,4,3,4,3,4,4,1,1,3,3,3,4,7,5,5,5,5,4,4,5,4,1,3,4,3,7,5,5,4,5,5,4,5,5,5,7,5,5,4,2,2,2,3,5,2,3,4,3,4,3,2,4,3,1,1,3,1,5,3,4,4,4,2,3,2,3,3,5,3,3,3,2,1,2,4,1,6,4,1,3,3,5,3,3,1,8,6,2,7,4,6,5,3,1,1,3,3,1,2,3,1,6,5,2,5,3,3,3,1,4,3,3,3,4,1,3,4,5,5,4,4,1,5,3,1,3,1,1,3,4,3,1,3,8,3,4,1,4,3,3,5,5,5,4,6,4,7,4,5,5,4,4,7,4,5,4,4,5,5,4,7,5,5,4,7,8,5,6,4,5,6,5,3,4,4,3,5,3,5,3,3,3,3,3,5,3,4,3,4,3,3,3,5,3,4,3,5,6,4,5,3,3,5,3};
               int m_SF6_XA[]={0,0,0,0,0,0,2,0,2,1,3,0,1,2,3,4,1,3,1,3,0,1,2,3,4,1,3,1,0,1,2,0,1,1,1,2,0,1,2,1,0,1,0,1,3,2,1,0,2,3,2,3,1,0,2,1,0,2,3,0,2,1,3,0,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,1,0,1,1,0,1,2,1,0,0,0,1,0,1,1,1,0,0,0,1,2,0,3,0,3,0,3,0,3,1,2,1,0,1,1,1,1,1,1,2,0,3,3,1,2,0,0,1,2,3,1,2,0,3,2,3,0,3,1,2,2,1,2,1,2,0,2,0,1,2,3,2,0,1,2,0,0,1,2,2,0,1,1,2,0,0,1,2,0,3,0,3,1,2,0,1,2,2,1,1,1,1,1,2,0,3,1,2,0,3,0,3,1,2,1,2,0,3,1,2,3,3,0,3,1,2,0,0,0,0,0,2,1,0,1,2,0,1,2,0,1,2,0,1,2,1,0,1,2,0,3,2,1,1,2,3,4,1,5,0,3,6,0,2,4,6,0,3,4,5,1,2,3,4,2,2,1,3,1,2,3,0,4,0,4,0,1,2,3,0,4,0,1,2,3,0,4,0,4,0,1,2,3,1,2,3,0,4,0,0,0,4,1,2,3,0,1,2,3,0,4,0,4,0,4,0,4,0,1,2,3,0,1,2,3,0,0,1,2,0,0,0,1,2,3,0,1,2,3,0,0,1,2,0,0,0,1,2,3,0,4,0,0,3,4,0,4,1,2,3,4,0,3,0,3,0,1,2,3,0,3,0,3,0,3,0,0,0,0,0,0,2,2,2,2,0,2,0,1,0,3,0,2,0,1,0,1,0,2,0,3,0,0,0,0,0,0,1,2,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,3,6,0,3,6,0,1,4,0,1,4,0,2,4,0,2,4,0,3,4,0,3,4,1,2,3,0,4,0,4,0,4,0,4,1,2,3,0,1,2,0,3,0,3,0,1,2,0,0,1,2,3,0,4,0,4,0,2,4,0,3,1,2,4,0,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,1,2,0,3,1,2,0,3,1,2,0,1,2,3,4,2,2,2,2,2,0,4,0,4,0,4,0,4,0,4,1,2,3,0,4,0,4,1,3,1,3,2,2,0,6,0,6,1,3,5,1,3,5,2,4,2,4,0,4,1,3,2,2,1,3,0,4,0,4,1,3,2,2,2,2,0,1,2,3,3,2,1,0,0,1,2,3,0,1,0,0,0,0,0,0,1,0,0,0,1,1,1,0,1,1,1,1,1,1,0,1,1,0,2,0,1,2,3,4,0,1,0,1,2,0,2,1,2,0,0,0,1,2,0,3,0,3,0,1,2,1,2,0,0,1,2,3,3,1,2,3,0,3,0,3,1,2,3,1,0,2,0,1,2,1,0,0,1,0,0,0,1,2,3,0,3,0,3,1,2,3,3,1,2,0,0,0,1,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,2,0,2,0,0,0,0,0,0,0,1,2,3,0,2,4,0,2,4,0,2,4,0,1,0,2,0,2,0,2,1,2,0,3,0,3,1,2,0,1,2,0,3,0,3,0,1,2,0,0,1,2,3,0,3,0,3,1,2,3,3,3,0,1,0,0,0,1,2,0,2,0,1,0,0,1,0,0,1,0,2,0,2,0,2,1,2,0,2,0,2,1,1,0,2,4,0,2,4,1,3,1,3,0,2,1,1,0,2,0,2,0,2,0,2,1,1,0,0,1,2,2,0,0,1,2,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,3,0,2,0,0,0,0,0,0,0,1,2,3,4,2,2,2,3,4,2,5,2,4,3,2,0,1,2,3,0,0,0,0,0,0,0,2,1,0,1,2,0,0,0,0,2,0,2,0,2,4,1,0,1,2,1,1,1,1,1,0,1,2,1,0,1,2,1,1,1,2,5,1,2,4,3,2,1,3,4,6,7,0,3,4,6,7,1,2,0,2,0,2,3,4,0,2,5,0,2,5,0,2,3,4,1,0,1,0,3,0,3,0,1,2,3,4,5,0,3,6,0,3,6,0,3,4,5,2,1,0,3,0,2,0,1,0,1,0,2,0,3,0,1,2,3,4,2,2,2,3,4,2,5,2,5,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,2,2,0,1,2,0,0,1,0,2,0,2,0,2,2,1,0,0,0,2,0,2,0,0,0,1,0,1,2,0,1,2,3,4,5,1,3,4,5,1,3,5,1,2,0,2,3,0,2,4,0,2,3,0,1,0,0,2,0,1,2,3,0,2,4,0,2,3,2,1,0,2,0,1,0,2,0,2,0,1,2,0,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,1,2,1,0,3,1,2,0,3,0,3,0,1,2,3,3,0,3,1,2,0,2,1,0,2,0,2,0,2,1,1,0,2,2,2,2,0,2,0,1,0,2,1,0,2,3,0,1,2,3,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,1,0,2,1,2,0,2,1,0,3,0,1,2,3,0,0,1,2,3,0,0,0,1,2,3,1,2,3,0,4,0,2,4,0,4,1,2,3,1,2,3,0,4,0,1,2,0,0,4,1,2,3,1,3,0,2,1,3,0,1,2,3,3,0,1,2,3,0,4,0,2,4,0,4,1,2,3,0,2,1,1,1,1,1,0,1,0,1,2,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,2,0,1,2,0,0,0,0,2,0,2,0,2,0,1,3,0,0,1,2,0,1,2,0,1,2,0,1,2,1,2,1,2,1,2,0,0,2,1,0,2,0,1,2,0,1,4,6,0,1,4,5,7,0,2,4,6,0,2,4,0,3,4,5,6,7,0,3,4,1,2,0,1,0,1,2,0,2,1,3,0,2,0,0,0,0,0,0,0,1,2,0,3,1,2,0,3,1,2,1,2,0,2,0,1,0,2,1,1,1,1,2,2,1,3,1,2,3,0,4,0,4,0,1,2,3,0,0,1,2,3,0,4,0,4,0,1,2,3,0,1,2,3,0,4,0,1,2,3,0,4,0,4,0,1,2,3,0,1,2,3,0,0,0,0,0,2,3,4,1,4,1,4,1,4,1,4,0,1,2,3,4,5,0,5,0,1,2,3,0,0,1,2,0,0,0,1,2,3,0,1,3,5,6,1,3,5,2,3,4,2,3,4,1,3,5,0,1,3,5,6,1,2,0,3,2,3,0,3,1,2,0,3,4,0,3,4,0,2,4,0,2,4,0,1,4,0,1,4,3,2,0,3,4,0,3,4,0,2,4,0,2,4,0,1,4,0,1,4,0,3,0,2,0,1,0,1,0,2,0,3,1,2,3,0,3,0,3,0,3,0,3,0,3,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,3,6,0,3,6,0,3,0,3,0,1,2,3,0,3,0,3,0,3,1,2,3,0,4,0,4,0,4,0,4,1,2,3,0,1,2,3,0,3,0,3,0,3,0,3,0,3,0,1,2,0,3,0,3,0,1,2,0,0,1,2,3,0,4,0,0,0,4,1,2,3,0,1,2,3,4,2,2,2,2,2,0,3,0,3,0,1,2,3,3,0,3,1,2,3,1,2,3,4,5,0,3,6,0,3,6,1,2,3,4,5,3,0,4,1,3,2,2,1,3,0,4,0,3,0,3,0,3,0,3,0,3,0,1,2,3,4,4,0,3,0,3,0,1,2,3,3,3,3,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,0,1,1,1,2,3,1,4,1,4,1,2,3,0,5,0,5,0,1,2,5,0,3,5,0,3,5,0,1,2,5,0,0,0,1,2,0,3,0,3,0,1,2,1,2,3,0,4,2,3,4,4,0,4,1,2,3,0,3,4,0,2,5,0,1,2,5,0,2,5,0,2,5,0,3,4,1,2,3,4,0,4,0,4,1,2,3,4,1,4,0,4,0,1,2,0,2,1,2,1,2,0,0,1,2,0,3,0,3,1,2,0,1,2,0,3,0,3,0,1,2,0,1,2,0,0,0,2,3,1,3,1,3,0,1,2,3,4,0,4,1,0,2,0,1,2,0,2,4,1,2,3,1,2,3,0,2,4,0,1,1,2,2,0,1,0,2,0,2,0,1,2,0,2,2,1,0,2,0,2,0,1,2,0,2,0,2,0,1,0,2,0,2,1,2,0,2,0,2,0,2,0,4,0,1,3,4,0,2,4,0,4,0,2,0,1,2,0,2,0,2,1,2,0,3,0,3,1,2,0,1,2,0,2,0,2,0,2,0,1,2,0,3,0,3,0,1,2,0,0,1,2,0,0,1,2,0,1,2,1,1,1,0,2,0,2,0,2,1,1,0,3,2,4,2,1,2,3,0,2,4,1,2,3,2,2,0,2,1,1,0,2,0,2,0,2,0,2,0,1,2,3,3,0,2,0,2,1,2,2,0,2,4,0,2,4,0,2,4,0,1,2,3,4,0,2,4,0,2,4,0,2,4,0,1,2,3,4,5,5,0,1,1,2,1,3,1,2,0,4,0,1,4,0,2,4,0,1,4,0,0,1,0,2,0,1,0,1,1,2,2,0,1,0,3,0,1,2,4,0,2,4,0,3,1,2,0,2,1,2,0,2};
               int m_SF6_YA[]={2,3,4,5,7,2,2,3,3,2,2,3,3,3,3,3,4,4,5,5,6,6,6,6,6,7,7,2,3,3,3,4,4,5,6,6,7,7,7,8,2,2,3,3,3,4,5,6,6,6,7,7,2,3,3,4,5,5,5,6,6,7,7,2,3,2,3,4,5,6,7,8,9,2,3,4,5,6,7,8,9,2,2,3,3,4,5,5,5,6,7,8,5,5,7,2,3,4,5,6,7,2,2,3,3,4,4,5,5,6,6,7,7,2,3,3,4,5,6,7,2,2,3,3,4,5,5,6,7,7,7,7,2,2,3,3,4,5,6,6,7,7,2,3,3,4,4,5,5,6,6,6,6,7,2,2,2,3,4,4,5,6,7,7,2,2,3,4,4,4,5,5,6,6,7,7,2,2,2,3,4,5,6,7,2,2,3,3,4,4,5,5,6,6,7,7,2,2,3,3,4,4,4,5,6,6,7,7,4,7,4,7,8,3,4,5,6,7,4,4,4,6,6,6,3,4,5,6,7,2,2,3,3,4,5,7,2,2,2,3,3,4,4,4,5,5,5,5,6,6,6,6,7,8,8,8,2,3,4,4,5,5,5,6,6,7,7,2,2,2,2,3,3,4,4,4,4,5,5,6,6,7,7,7,7,2,2,2,3,3,4,5,6,6,7,7,7,2,2,2,2,3,3,4,4,5,5,6,6,7,7,7,7,2,2,2,2,3,4,4,4,5,6,7,7,7,7,2,2,2,2,3,4,4,4,5,6,7,2,2,2,3,3,4,5,5,5,6,6,7,7,7,7,2,2,3,3,4,4,4,4,5,5,6,6,7,7,2,3,4,5,6,7,2,3,4,5,6,6,7,7,2,2,3,3,4,4,5,5,6,6,7,7,2,3,4,5,6,7,7,7,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,7,7,7,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,2,2,2,3,3,4,4,5,5,6,6,7,7,7,2,2,2,3,3,4,4,5,5,5,6,7,2,2,2,3,3,4,4,5,5,5,6,6,7,7,7,2,2,2,2,3,3,4,4,5,5,5,5,6,6,7,7,2,2,3,3,4,5,6,6,7,7,2,2,2,2,2,3,4,5,6,7,2,2,3,3,4,4,5,5,6,6,7,7,7,2,2,3,3,4,4,5,5,6,7,2,2,3,3,4,4,4,5,5,5,6,6,7,7,2,2,3,3,4,5,6,6,7,7,2,2,3,3,4,5,6,7,2,2,2,2,3,4,5,6,7,7,7,7,2,2,3,4,5,6,7,8,8,2,3,4,5,6,7,2,2,3,4,5,6,7,8,8,2,3,3,8,8,8,8,8,1,2,4,4,5,6,6,7,7,2,3,4,4,4,5,5,6,6,7,7,7,4,4,5,6,7,7,2,3,4,4,4,5,5,6,6,7,7,7,4,5,5,6,7,7,2,3,4,4,5,6,7,4,4,4,5,5,6,6,7,7,7,8,9,9,2,3,4,4,5,5,6,6,7,7,2,4,5,6,7,2,4,5,6,7,8,9,2,3,4,4,5,5,6,6,7,7,2,3,4,5,6,7,4,4,4,4,5,5,5,6,6,6,7,7,7,4,4,5,5,6,6,7,7,4,4,5,5,6,6,7,7,4,4,4,5,5,6,6,7,7,7,8,9,4,4,4,5,5,6,6,7,7,7,8,9,4,4,5,6,7,4,4,5,6,7,7,3,4,4,5,6,7,4,4,5,5,6,6,7,7,4,4,5,5,6,7,4,4,4,5,5,5,6,6,7,7,4,4,5,6,7,7,4,4,5,5,6,6,7,8,9,4,4,4,5,6,7,7,7,2,3,4,5,6,7,8,2,3,4,5,6,7,8,2,3,4,5,6,7,8,1,1,2,2,2,3,4,5,6,7,2,2,2,2,2,3,4,5,5,5,6,6,7,7,0,1,2,2,2,2,3,4,5,6,7,7,8,1,2,4,4,4,5,6,7,7,7,8,8,7,7,7,2,3,3,3,4,5,6,7,2,3,3,3,4,5,5,5,6,7,2,2,2,3,3,3,4,5,6,6,6,6,6,7,7,7,7,7,2,2,3,3,4,4,4,4,5,5,5,6,6,6,7,7,7,7,5,6,7,2,2,3,3,4,4,4,4,4,4,5,5,5,6,6,6,7,7,7,7,0,1,2,2,3,3,4,4,5,5,6,6,7,7,2,2,2,2,2,3,4,5,5,5,6,6,7,7,2,2,3,3,4,4,5,5,6,6,7,7,7,7,7,8,9,2,2,2,3,4,4,5,5,6,6,7,7,8,9,2,2,2,2,2,2,4,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,7,5,6,7,4,4,5,5,5,5,6,6,6,7,7,7,1,2,4,4,5,5,6,6,7,7,2,2,2,3,4,4,5,5,6,6,7,7,4,4,5,5,6,6,7,7,7,8,0,0,1,1,2,2,3,3,4,4,4,4,5,6,6,7,7,1,1,2,4,4,5,5,6,6,7,8,9,2,3,4,5,6,6,7,7,2,2,3,4,4,1,2,2,2,2,3,4,5,6,7,2,3,4,6,7,8,2,3,3,4,4,5,5,6,6,7,7,8,0,0,2,2,2,2,3,4,4,4,4,5,6,7,7,7,7,2,2,2,3,3,4,4,4,5,5,6,6,6,2,2,2,3,3,4,4,4,5,6,6,7,7,7,5,5,6,6,7,7,5,5,5,5,6,5,2,2,2,3,3,4,4,4,5,5,6,6,6,1,1,3,4,5,6,7,2,4,5,5,5,6,7,7,7,2,3,4,5,6,7,2,4,5,6,7,3,4,4,4,5,6,7,4,4,5,5,6,6,7,7,7,8,9,2,2,3,3,3,4,4,4,5,5,5,6,6,7,7,8,8,4,2,2,4,5,5,6,7,7,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,6,6,6,6,6,6,7,7,7,4,4,5,5,6,7,7,5,5,6,6,7,7,2,4,5,6,7,8,9,2,2,3,3,4,5,6,6,7,7,4,4,5,6,7,7,2,2,4,5,6,7,2,3,4,4,5,5,5,6,6,7,7,2,2,2,2,3,4,4,4,4,5,5,6,6,7,7,7,7,2,2,2,2,3,3,4,4,4,4,5,5,6,6,7,7,7,7,2,2,2,2,3,4,5,6,7,2,2,2,3,3,4,4,5,5,6,6,7,7,7,7,7,7,8,8,2,2,2,2,3,4,4,4,5,6,7,7,7,7,2,2,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,7,7,2,2,3,3,4,5,6,6,7,7,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,0,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,2,2,3,3,4,4,5,5,6,6,7,7,2,2,2,3,3,4,4,5,5,6,6,7,7,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,7,7,7,2,2,3,3,4,4,4,4,5,5,6,6,7,7,2,2,2,3,3,4,4,5,5,6,6,7,7,7,2,2,2,2,3,3,4,4,5,5,6,6,7,7,2,2,2,3,3,4,4,5,5,5,6,7,2,2,2,3,3,4,5,6,6,7,7,7,2,2,2,2,2,3,4,5,6,7,2,2,3,3,4,4,4,4,5,6,6,7,7,2,3,3,3,3,3,4,4,4,5,5,5,6,6,6,6,6,7,2,2,3,3,4,5,6,6,7,7,2,2,3,3,4,4,5,5,6,6,7,7,7,7,7,8,2,2,3,3,4,4,4,4,5,6,7,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,7,7,7,7,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,7,7,7,7,7,8,2,2,3,4,4,4,5,5,6,6,7,7,7,2,2,3,3,4,4,4,4,5,5,5,6,6,6,7,7,7,7,2,3,4,4,4,5,5,6,6,7,7,7,2,2,2,3,3,4,4,4,5,6,6,7,7,7,2,2,2,3,3,3,4,4,4,4,5,5,5,6,6,6,7,7,7,2,2,2,2,3,3,4,4,5,5,5,5,6,6,7,7,4,4,5,6,6,7,7,2,2,3,4,4,4,5,5,6,6,7,7,4,4,4,5,5,6,6,7,7,7,4,4,4,5,6,7,4,4,5,5,6,6,7,7,7,7,7,8,8,4,5,5,6,7,7,4,4,4,5,5,5,6,6,6,7,7,7,4,4,5,5,6,7,7,4,4,5,5,6,6,6,7,7,1,2,4,4,5,5,6,6,6,7,7,4,4,5,5,6,6,7,7,4,4,5,5,6,6,7,7,4,4,5,5,5,5,6,6,6,7,7,4,4,5,5,5,6,6,7,7,4,4,5,5,6,6,7,7,4,4,4,5,5,6,6,7,7,4,4,4,5,5,6,6,7,7,7,8,9,4,4,5,6,7,7,4,4,4,5,6,7,4,4,5,5,6,6,7,8,9,1,2,2,4,5,5,5,6,6,6,7,7,7,8,9,4,4,5,6,7,7,4,4,5,5,6,6,7,7,7,7,8,4,4,5,5,6,6,7,4,4,4,5,5,5,6,6,6,7,7,7,7,7,4,4,4,5,5,5,6,6,6,7,7,7,7,7,7,8,4,4,5,5,6,6,7,7,4,4,5,5,5,6,6,6,7,7,7,4,5,5,6,6,7,7,4,4,5,5,6,7,7,4,4,5,5,5,5,6,6,6,7,7,4,4,5,5,6,6,7,7};
               CopyFonts(m_SF6_PA,m_SF6_WA,m_SF6_XA,m_SF6_YA);         
         }
         else if(aType==1){
               m_Font="Small Fonts";
               m_FontSize=7;
               m_Space=3;
               int m_SF7_PA[]={0,6,10,30,48,62,76,78,87,96,100,105,107,109,110,118,132,140,152,163,176,191,205,215,229,243,245,248,253,259,264,272,299,315,338,353,373,391,405,425,443,450,460,474,484,510,531,549,566,587,607,622,633,648,660,676,689,699,714,725,732,743,746,751,753,764,778,787,801,812,820,836,849,855,863,875,882,900,911,923,937,951,957,967,974,985,995,1007,1016,1029,1038,1048,1055,1064,1068,1075,1091,1104,1106,1115,1119,1122,1133,1146,1146,1164,1185,1188,1211,1227,1243,1261,1278,1280,1282,1286,1290,1292,1294,1297,1297,1310,1326,1329,1346,1358,1373,1387,1387,1406,1422,1432,1440,1452,1460,1474,1476,1492,1510,1516,1521,1522,1537,1546,1547,1555,1562,1568,1576,1587,1606,1607,1620,1648,1659,1665,1673,1688,1698,1705,1723,1744,1767,1778,1800,1818,1839,1853,1874,1899,1913,1928,1954,1972,1990,2008,2025,2040,2051,2067,2086,2099,2118,2131,2156,2183,2200,2222,2239,2257,2281,2301,2312,2327,2341,2348,2365,2376,2391,2400,2412,2426,2436,2447,2460,2472,2484,2496,2510,2519,2526,2539,2558,2567,2581,2590,2609,2630,2641,2656,2666,2677,2693,2705};
               int m_SF7_WA[]={1,3,5,5,6,5,1,2,2,2,3,1,2,1,2,4,2,4,4,4,4,4,4,4,4,1,1,3,3,3,4,8,6,6,6,6,5,5,6,6,1,4,5,4,8,6,6,6,6,6,5,5,5,5,7,5,5,5,2,2,2,3,5,2,4,4,4,4,4,2,4,4,1,1,4,1,7,4,5,4,4,2,4,2,4,4,5,3,3,3,2,1,2,4,1,6,5,1,3,3,5,5,5,1,9,8,2,8,5,6,5,4,2,2,4,4,1,2,3,1,6,7,2,7,4,4,5,1,5,3,4,4,5,1,4,3,6,4,4,4,1,6,3,1,3,1,1,3,4,3,1,4,9,4,4,1,5,4,3,5,6,6,5,7,5,7,5,6,6,5,5,8,6,6,6,6,6,5,5,7,5,6,5,7,8,7,7,6,6,7,6,4,4,4,3,6,4,7,4,4,4,4,4,5,4,5,4,4,4,3,3,7,3,5,4,7,8,5,6,4,4,6,4};
               int m_SF7_XA[]={0,0,0,0,0,0,0,2,0,2,1,3,1,3,0,1,2,3,4,1,3,0,1,2,3,4,1,3,1,3,2,1,2,3,0,2,4,1,2,2,3,0,2,4,1,2,3,2,0,1,5,0,1,4,3,2,1,4,5,0,4,5,1,0,2,1,0,2,4,0,3,0,3,1,2,4,0,0,1,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,1,0,1,1,0,1,2,1,0,0,0,1,0,1,1,1,0,1,0,0,0,1,2,0,3,0,3,0,3,0,3,0,3,1,2,1,0,1,1,1,1,1,1,1,2,0,3,3,2,1,0,0,1,2,3,1,2,0,3,3,2,3,0,3,1,2,2,1,2,1,2,0,2,0,1,2,3,2,2,0,1,2,3,0,0,1,2,0,3,3,0,3,1,2,1,2,0,3,0,0,1,2,0,3,0,3,1,2,0,1,2,3,3,2,2,1,1,1,1,2,0,3,0,3,1,2,0,3,0,3,1,2,1,2,0,3,0,3,1,2,3,3,0,3,1,2,0,0,0,0,0,2,1,0,1,2,0,1,2,0,1,2,0,1,2,1,0,1,2,0,3,3,2,1,1,2,3,4,5,1,6,0,3,4,7,0,2,4,7,0,2,4,7,0,3,5,6,1,2,3,4,5,2,3,2,3,1,4,1,4,1,2,3,4,0,5,0,5,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,5,0,5,0,1,2,3,4,1,2,3,4,0,5,0,0,0,0,5,1,2,3,4,0,1,2,3,4,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,0,1,2,3,4,0,0,0,1,2,3,0,0,0,1,2,3,4,0,1,2,3,4,0,0,0,1,2,3,0,0,0,1,2,3,4,0,5,0,0,3,4,5,0,5,0,4,5,1,2,3,5,0,5,0,5,0,5,0,1,2,3,4,5,0,5,0,5,0,5,0,0,0,0,0,0,0,3,3,3,3,0,3,0,3,1,2,0,4,0,3,0,2,0,1,0,2,0,3,0,4,0,0,0,0,0,0,0,1,2,3,0,1,6,7,0,1,6,7,0,2,5,7,0,2,5,7,0,3,4,7,0,3,4,7,0,7,0,1,5,0,1,5,0,2,5,0,2,5,0,3,5,0,3,5,0,4,5,1,2,3,4,0,5,0,5,0,5,0,5,0,5,1,2,3,4,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,0,0,1,2,3,4,0,5,0,5,0,5,0,3,5,0,4,5,1,2,3,4,5,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,5,0,5,0,5,1,2,3,0,4,0,1,2,3,4,0,4,1,2,3,0,1,2,3,4,2,2,2,2,2,2,0,4,0,4,0,4,0,4,0,4,0,4,1,2,3,0,4,0,4,1,3,1,3,1,3,2,2,0,6,0,6,1,5,1,3,5,1,3,5,2,4,2,4,0,4,0,4,1,3,2,1,3,0,4,0,4,0,4,0,4,1,3,2,2,2,2,0,1,2,3,4,4,3,2,1,0,0,1,2,3,4,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,2,0,1,2,3,4,0,1,1,2,3,1,2,3,0,3,1,2,3,0,0,0,1,2,0,3,0,3,0,3,0,1,2,1,2,0,3,0,0,3,1,2,3,3,1,2,3,0,3,0,3,0,3,1,2,3,1,2,0,3,0,1,2,3,0,1,2,1,0,0,0,1,0,0,0,1,2,3,0,3,0,3,0,3,1,2,3,3,0,1,2,0,0,0,2,0,1,3,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,1,0,2,0,3,0,0,0,0,0,0,0,0,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,0,3,0,3,0,3,0,3,1,2,3,0,4,0,4,0,4,1,2,3,0,1,2,0,3,0,3,0,3,0,1,2,0,0,1,2,3,0,3,0,3,0,3,1,2,3,3,3,0,1,0,0,0,0,1,2,3,0,1,2,3,0,1,2,0,0,1,0,0,0,1,0,3,0,3,0,3,0,3,1,2,3,0,3,0,3,0,3,1,2,1,2,0,4,0,2,4,0,2,4,1,3,1,3,0,2,0,2,1,0,2,0,2,0,2,0,2,0,2,0,2,1,2,2,0,1,0,1,2,2,1,0,0,1,2,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,3,0,2,0,0,0,0,0,0,0,0,1,2,3,4,2,2,2,3,4,2,5,2,5,2,4,3,2,0,1,2,3,4,0,0,0,0,0,0,0,0,2,1,0,1,2,0,0,0,0,0,2,0,2,0,2,4,2,2,0,1,2,3,4,2,2,2,2,2,2,0,1,2,3,4,2,1,2,3,2,2,0,1,5,0,1,4,3,2,1,4,5,7,8,0,4,5,7,8,2,3,4,1,4,0,4,0,4,5,6,0,4,7,0,4,7,0,4,5,6,1,0,1,0,4,0,4,0,4,0,1,2,3,4,5,6,0,4,7,0,4,7,0,4,5,6,3,2,0,4,0,3,0,2,0,1,0,2,0,3,0,4,0,1,2,3,4,2,2,2,3,4,2,5,2,5,2,5,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,2,0,1,2,0,0,2,0,1,3,0,3,0,3,0,3,2,1,1,0,1,0,1,3,0,2,1,3,0,2,0,0,0,1,0,1,2,0,1,2,3,4,5,1,3,4,5,1,3,5,1,2,3,0,3,0,3,4,5,0,3,6,0,3,4,5,0,1,0,0,3,0,3,0,1,2,3,4,5,0,3,6,0,3,4,5,3,2,0,3,0,2,0,1,0,2,0,3,0,1,2,0,0,2,0,1,3,0,3,0,3,0,3,0,4,0,4,0,4,0,4,0,1,2,3,4,2,1,3,2,0,4,0,4,0,4,1,2,3,4,4,0,4,1,2,3,0,2,1,0,2,0,2,0,2,0,2,1,2,2,0,1,3,3,3,3,0,3,0,3,1,2,0,3,1,2,1,2,0,3,4,0,1,2,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,3,1,0,2,1,3,2,0,3,1,2,0,2,2,3,1,4,0,2,3,5,0,2,3,5,1,4,2,3,0,3,0,1,2,3,0,0,0,1,2,3,0,0,0,1,2,3,1,3,0,2,1,3,0,1,2,3,3,0,2,3,1,4,0,2,3,5,0,2,5,1,4,2,3,0,2,1,1,1,1,1,1,1,0,1,0,1,2,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,2,0,0,0,0,0,2,0,2,0,2,0,1,3,0,0,1,2,0,1,2,0,1,2,0,1,2,1,2,1,2,1,2,1,2,0,0,3,1,2,0,3,0,1,2,3,0,1,2,0,1,5,7,0,1,5,6,8,0,2,5,7,0,2,5,0,3,5,6,7,8,0,3,5,0,4,5,1,2,3,0,0,1,2,0,1,2,3,0,2,1,3,0,2,0,0,0,0,0,0,0,0,1,2,3,0,4,0,1,2,3,4,0,4,1,2,3,1,2,3,0,1,2,3,0,1,2,0,2,1,1,1,1,1,2,3,4,1,4,0,4,0,4,0,1,2,3,4,0,4,0,4,0,1,2,3,4,0,0,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,1,2,3,4,0,0,0,0,0,0,3,4,5,2,5,1,5,1,5,1,5,1,5,0,1,2,3,4,5,6,0,6,0,1,2,3,4,0,0,0,1,2,3,0,0,0,1,2,3,4,0,3,6,1,3,5,2,3,4,2,3,4,1,3,5,1,3,5,0,3,6,1,2,3,0,4,4,2,3,4,0,4,1,2,3,0,4,5,0,4,5,0,3,5,0,3,5,0,2,5,0,2,5,0,1,5,1,4,2,3,0,4,5,0,4,5,0,3,5,0,3,5,0,2,5,0,2,5,0,1,5,0,4,0,3,0,2,0,1,0,2,0,3,0,4,2,3,4,1,4,0,4,0,4,0,4,0,4,0,4,0,1,6,7,0,1,6,7,0,2,5,7,0,2,5,7,0,3,4,7,0,3,4,7,0,7,0,5,0,5,0,5,0,1,2,3,4,5,0,5,0,5,0,5,1,2,3,4,0,5,0,5,0,5,0,5,0,5,1,2,3,4,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,0,0,1,2,3,4,0,5,0,0,0,0,5,1,2,3,4,0,1,2,3,4,2,2,2,2,2,2,0,4,0,4,0,4,1,2,3,4,4,0,4,1,2,3,3,1,2,3,4,5,0,3,6,0,3,6,1,2,3,4,5,3,3,0,4,0,4,1,3,2,1,3,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,5,5,0,4,0,4,0,4,1,2,3,4,4,4,4,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,0,1,2,2,2,2,3,4,5,2,6,2,6,2,3,4,5,0,6,0,6,0,6,0,1,2,3,6,0,4,6,0,4,6,0,1,2,3,6,0,0,0,0,1,2,3,4,0,5,0,5,0,1,2,3,4,1,2,3,4,0,5,5,2,3,4,5,5,0,5,1,2,3,4,0,3,4,5,0,2,6,0,2,6,0,1,2,6,0,2,6,0,2,6,0,3,4,5,1,2,3,4,5,0,5,0,5,1,2,3,4,5,2,5,1,5,0,5,1,2,3,1,2,3,0,3,1,2,3,1,2,3,0,0,1,2,0,3,0,3,0,3,1,2,0,1,2,0,3,0,1,2,3,0,3,0,1,2,0,1,2,0,0,0,0,2,3,4,1,4,1,4,1,4,0,1,2,3,4,5,0,5,1,2,0,3,0,1,2,3,0,1,2,0,3,6,1,3,5,2,3,4,1,3,5,0,3,6,1,2,0,3,2,0,3,1,2,0,3,0,3,0,2,3,0,1,3,0,3,3,2,0,3,0,3,0,2,3,0,1,3,0,3,0,3,0,2,0,1,0,2,0,3,1,2,3,0,3,0,3,0,3,0,3,0,4,0,4,0,1,3,4,0,2,4,0,4,0,3,0,3,0,1,2,3,0,3,0,3,1,2,3,0,4,0,4,0,4,1,2,3,0,1,2,3,0,3,0,3,0,3,0,3,0,1,2,0,3,0,3,0,3,0,1,2,0,0,1,2,0,3,0,0,3,1,2,0,1,2,1,1,1,1,0,2,0,2,0,2,0,2,1,2,2,0,1,3,1,2,3,4,5,0,3,6,0,3,6,1,2,3,4,5,3,3,0,2,0,2,1,0,2,0,2,0,3,0,3,0,3,0,3,0,1,2,3,4,4,0,3,0,3,1,2,3,3,3,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,0,1,1,1,2,3,1,4,1,2,3,0,5,0,5,0,1,2,5,0,3,5,0,1,2,5,0,0,0,1,2,0,3,0,1,2,0,1,2,3,1,2,3,3,0,1,2,0,3,4,0,2,5,0,1,2,5,0,2,5,0,3,4,1,2,3,0,3,1,2,3,1,3,0,3};
               int m_SF7_YA[]={2,3,4,5,6,8,2,2,3,3,2,2,3,3,4,4,4,4,4,5,5,6,6,6,6,6,7,7,8,8,2,3,3,3,4,4,4,5,5,6,6,7,7,7,8,8,8,9,3,3,3,4,4,4,5,6,7,7,7,8,8,8,2,3,3,4,5,5,5,6,6,7,7,8,8,8,2,3,2,3,4,5,6,7,8,9,10,2,3,4,5,6,7,8,9,10,2,2,3,3,5,6,6,6,7,8,9,6,6,8,2,3,4,5,5,6,7,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,3,3,4,5,6,7,8,2,2,3,3,4,5,6,7,8,8,8,8,2,2,3,3,4,5,6,7,7,8,8,2,3,3,4,4,5,5,6,6,6,6,7,8,2,2,2,2,3,4,4,4,5,5,6,7,7,8,8,2,2,3,3,4,5,5,5,6,6,7,7,8,8,2,2,2,2,3,4,5,6,7,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,2,3,3,4,4,5,5,5,6,7,7,8,8,5,8,5,8,9,4,5,6,7,8,5,5,5,7,7,7,4,5,6,7,8,2,2,3,3,4,5,6,8,2,2,2,2,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,9,9,9,9,2,2,3,3,4,4,5,5,6,6,6,6,7,7,8,8,2,2,2,2,2,3,3,4,4,5,5,5,5,5,6,6,7,7,8,8,8,8,8,2,2,2,2,3,3,4,5,6,7,7,8,8,8,8,2,2,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,2,2,2,2,2,3,4,5,5,5,5,6,7,8,8,8,8,8,2,2,2,2,2,3,4,5,5,5,5,6,7,8,2,2,2,2,3,3,4,5,5,5,5,6,6,7,7,7,8,8,8,8,2,2,3,3,4,4,5,5,5,5,5,5,6,6,7,7,8,8,2,3,4,5,6,7,8,2,3,4,5,6,6,7,7,8,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,3,4,5,6,7,8,8,8,8,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,2,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,8,2,2,2,2,2,3,3,4,4,5,5,5,5,5,6,7,8,2,2,2,2,3,3,4,4,5,5,6,6,6,7,7,7,8,8,8,8,9,2,2,2,2,2,3,3,4,4,5,5,5,5,5,6,6,7,7,8,8,2,2,2,3,3,4,5,5,5,6,7,7,8,8,8,2,2,2,2,2,3,4,5,6,7,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,2,2,3,3,4,4,5,5,6,6,7,8,2,2,3,3,4,4,5,5,5,6,6,6,7,7,8,8,2,2,3,3,4,4,5,6,6,7,7,8,8,2,2,3,3,4,4,5,6,7,8,2,2,2,2,2,3,4,5,6,7,8,8,8,8,8,2,2,3,4,5,6,7,8,9,10,10,3,4,5,6,6,7,8,2,2,3,4,5,6,7,8,9,10,10,2,3,3,10,10,10,10,10,2,3,4,4,5,6,6,6,7,7,8,8,8,2,3,4,4,4,5,5,6,6,7,7,8,8,8,4,4,5,5,6,7,7,8,8,2,3,4,4,4,5,5,6,6,7,7,8,8,8,4,4,5,5,6,6,6,6,7,8,8,2,3,4,5,5,6,7,8,4,4,4,5,5,6,6,7,7,8,8,8,9,10,10,10,2,3,4,4,5,5,5,6,6,7,7,8,8,2,4,5,6,7,8,2,4,5,6,7,8,9,10,2,3,4,4,5,5,6,6,7,7,8,8,2,3,4,5,6,7,8,4,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,4,4,4,5,5,6,6,7,7,8,8,4,4,4,5,5,6,6,7,7,8,8,8,4,4,4,5,5,6,6,7,7,8,8,8,9,10,4,4,4,5,5,6,6,7,7,8,8,8,9,10,4,4,5,6,7,8,4,4,4,5,6,6,7,8,8,8,3,4,4,5,6,7,8,4,4,5,5,6,6,7,7,8,8,8,4,4,5,5,6,6,7,7,8,8,4,4,5,5,5,6,6,6,7,7,8,8,4,4,5,5,6,7,7,8,8,4,4,5,5,6,6,7,7,8,8,9,10,10,4,4,4,5,6,7,8,8,8,2,3,4,5,6,6,7,8,9,10,3,4,5,6,7,8,9,2,3,4,5,6,7,8,9,10,3,3,4,4,3,4,5,6,7,8,9,2,2,2,2,2,3,4,5,5,5,6,6,7,7,8,8,0,1,2,2,2,2,2,3,4,5,6,7,8,8,9,1,2,4,4,4,5,6,7,8,8,8,9,9,8,8,8,2,3,4,4,4,4,4,5,6,7,8,2,3,4,4,4,4,4,5,6,6,6,7,8,3,3,3,4,4,4,5,6,7,7,7,7,7,8,8,8,8,8,2,2,2,3,3,4,4,5,5,5,5,6,6,6,7,7,7,8,8,8,8,6,7,8,2,2,3,3,4,4,5,5,5,5,5,5,5,6,6,6,7,7,7,8,8,8,8,0,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,2,2,2,2,3,4,5,5,5,6,6,7,7,8,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,9,2,2,2,3,4,4,5,5,5,6,6,7,7,8,8,9,10,3,4,3,4,3,3,4,4,3,3,4,4,5,6,6,6,6,6,6,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,6,6,6,6,7,7,7,8,8,8,8,6,7,8,4,4,5,5,6,6,6,6,6,6,7,7,7,8,8,8,8,1,2,4,4,5,5,6,6,7,7,8,8,2,2,2,3,4,4,5,5,5,6,6,7,7,8,8,4,4,5,5,6,6,7,7,8,8,8,8,8,9,0,0,1,2,2,3,3,4,4,5,5,5,5,6,7,7,8,8,8,1,1,2,4,4,5,5,6,6,7,7,8,8,9,10,10,2,3,4,5,6,6,7,7,8,8,2,2,3,3,4,4,5,5,1,2,2,2,2,2,3,4,5,6,7,8,2,3,4,5,7,8,9,10,2,2,3,3,4,5,5,6,6,7,8,8,9,9,3,3,2,2,3,3,4,4,4,4,5,5,5,5,6,6,7,7,0,0,2,2,2,2,3,4,5,5,5,5,6,7,8,8,8,8,6,6,7,7,8,8,6,6,6,6,7,6,2,2,3,3,4,4,4,4,5,5,5,6,6,7,7,0,0,2,3,4,5,6,7,8,3,4,5,5,5,6,8,8,8,2,3,4,5,6,7,8,2,4,5,6,7,8,3,4,4,4,5,6,7,8,5,5,6,6,7,7,8,8,8,9,10,2,2,3,3,3,4,4,4,5,5,5,6,6,7,7,8,8,9,9,5,2,2,4,4,5,5,6,6,6,6,7,8,8,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,6,6,6,6,6,6,7,7,7,8,8,8,4,4,4,5,6,6,6,7,8,8,8,6,6,7,7,8,8,2,4,5,6,7,8,9,10,2,2,2,3,3,4,5,5,5,6,7,7,8,8,8,4,4,4,5,6,6,7,8,8,8,2,2,4,5,6,7,8,2,2,2,3,3,4,4,5,5,6,6,6,6,6,7,7,8,8,2,2,2,2,2,3,4,5,5,5,5,5,6,6,7,7,8,8,8,8,8,2,2,2,2,2,3,3,4,4,5,5,5,5,5,6,6,7,7,8,8,8,8,8,2,2,2,2,2,3,4,5,6,7,8,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,8,8,9,9,2,2,2,2,2,3,4,5,5,5,5,6,7,8,8,8,8,8,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,2,2,2,3,3,4,5,5,6,7,7,8,8,8,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,0,0,1,1,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,2,2,3,3,4,4,5,5,5,5,5,5,6,6,7,7,8,8,2,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,8,2,2,2,2,2,2,3,3,4,4,5,5,6,6,7,7,8,8,2,2,2,2,2,3,3,4,4,5,5,5,5,5,6,7,8,2,2,2,2,3,3,4,5,6,7,7,8,8,8,8,2,2,2,2,2,3,4,5,6,7,8,2,2,3,3,4,4,5,5,5,5,6,7,7,8,8,8,2,3,3,3,3,3,4,4,4,5,5,5,6,6,6,6,6,7,8,2,2,3,3,4,4,5,6,6,7,7,8,8,2,2,3,3,4,4,5,5,6,6,7,7,8,8,8,8,8,8,9,2,2,3,3,4,4,5,5,5,5,6,7,8,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,8,8,8,8,2,2,2,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,8,8,8,8,8,9,2,2,2,3,4,5,5,5,5,6,6,7,7,8,8,8,8,2,2,3,3,4,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,8,8,2,3,4,5,5,5,5,5,6,6,7,7,8,8,8,8,8,2,2,2,2,3,3,4,5,5,5,5,6,7,7,8,8,8,8,2,2,2,2,3,3,3,4,4,4,5,5,5,5,6,6,6,7,7,7,8,8,8,8,2,2,2,2,2,3,3,4,4,5,5,5,5,5,6,6,7,7,8,8,4,4,5,6,6,6,7,7,8,8,8,2,2,2,3,4,4,4,5,5,6,6,7,7,8,8,4,4,4,5,5,6,6,6,6,7,7,8,8,8,4,4,4,5,6,7,8,4,4,4,5,5,6,6,7,7,8,8,8,8,8,8,9,9,4,4,5,5,6,6,6,6,7,8,8,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,4,4,5,5,6,7,7,8,8,4,4,5,5,6,6,6,7,7,7,8,8,1,2,4,4,5,5,6,6,6,7,7,7,8,8,4,4,5,5,6,6,7,7,8,8,4,4,4,5,5,6,6,7,7,8,8,4,4,5,5,6,6,6,6,7,7,7,8,8,4,4,5,5,6,6,6,6,7,7,8,8,4,4,4,5,5,6,6,7,7,8,8,8,4,4,4,4,5,5,6,6,7,7,8,8,4,4,4,5,5,6,6,7,7,8,8,8,9,10,4,4,5,5,6,7,7,8,8,4,4,4,5,6,7,8,4,4,5,5,6,6,7,7,8,8,9,10,10,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,8,8,9,10,4,4,5,5,6,7,7,8,8,4,4,5,5,6,6,7,7,8,8,8,8,8,9,4,4,5,5,6,6,6,7,8,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,8,8,8,8,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,8,8,8,8,8,9,4,4,5,6,6,6,7,7,8,8,8,4,4,5,5,6,6,6,6,7,7,7,8,8,8,8,4,5,6,6,6,7,7,8,8,8,4,4,4,5,6,6,6,7,8,8,8,4,4,4,5,5,5,6,6,6,6,7,7,7,8,8,8,4,4,4,5,5,6,6,6,7,7,8,8};
               CopyFonts(m_SF7_PA,m_SF7_WA,m_SF7_XA,m_SF7_YA);  
         }
         else if(aType==2){
               m_Font="Small Fonts";
               m_FontSize=8;
               m_Space=3;         
               int m_SF8_PA[]={0,7,13,35,58,78,96,99,109,119,126,135,138,140,141,149,165,175,188,201,217,231,247,258,274,290,292,296,303,311,318,327,365,381,403,419,437,457,470,489,508,516,527,544,555,584,606,622,639,658,678,695,707,723,738,767,783,794,810,822,830,842,849,854,856,870,886,896,912,925,935,953,968,975,984,998,1006,1027,1040,1052,1068,1084,1092,1103,1113,1126,1137,1158,1168,1180,1192,1202,1212,1224,1231,1247,1267,1280,1282,1292,1297,1300,1314,1332,1350,1376,1404,1409,1436,1455,1474,1495,1515,1518,1520,1526,1531,1537,1542,1551,1567,1588,1607,1612,1630,1644,1661,1677,1677,1693,1708,1719,1731,1743,1751,1769,1791,1815,1832,1842,1848,1850,1878,1888,1892,1906,1914,1921,1931,1947,1975,1976,1991,2022,2034,2044,2053,2070,2081,2089,2105,2125,2147,2158,2184,2204,2230,2244,2266,2291,2308,2327,2356,2375,2391,2410,2427,2443,2455,2468,2492,2508,2531,2546,2574,2605,2622,2645,2660,2678,2704,2724,2738,2755,2770,2778,2798,2811,2829,2838,2854,2873,2885,2899,2920,2934,2946,2960,2976,2986,2995,3007,3033,3043,3060,3071,3093,3118,3131,3149,3161,3173,3192,3206};
               int m_SF8_WA[]={1,3,5,5,7,5,1,2,2,3,5,2,2,1,3,4,3,4,4,5,4,4,4,4,4,1,2,4,4,4,4,8,5,5,6,5,5,4,6,5,1,4,5,4,7,6,6,5,6,6,5,5,6,5,7,6,5,5,2,3,2,3,5,2,4,4,4,4,4,2,4,4,1,1,4,1,7,4,4,4,4,3,4,2,4,5,7,5,5,4,2,1,3,5,3,7,4,1,3,3,7,5,5,4,10,9,3,8,5,7,5,4,2,1,4,3,2,5,9,3,8,7,3,6,4,4,4,1,5,5,4,4,3,1,4,5,7,6,5,4,2,7,3,3,5,1,1,3,4,6,1,4,9,4,5,1,5,4,3,5,5,5,4,6,5,7,4,5,5,5,5,7,5,6,5,5,6,5,5,7,6,7,5,7,8,6,6,4,6,8,6,4,4,4,3,5,4,6,3,4,4,4,4,5,4,4,4,4,4,4,5,7,5,5,4,7,8,5,6,4,4,6,4};
               int m_SF8_XA[]={0,0,0,0,0,0,0,0,2,0,2,0,2,1,3,1,3,0,1,2,3,4,1,3,0,2,0,1,2,3,4,0,2,0,2,2,1,2,3,0,2,4,0,2,1,2,3,2,4,2,4,0,2,4,1,2,3,2,1,5,0,2,4,0,2,4,1,3,3,5,3,4,6,2,4,6,2,5,2,1,3,1,3,2,0,1,2,4,0,3,4,0,3,4,1,2,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,0,1,2,1,0,2,2,2,0,1,2,3,4,2,2,1,1,0,0,1,0,2,2,2,1,1,0,0,0,1,2,0,3,0,3,0,3,0,3,0,3,0,3,1,2,2,1,2,0,2,2,2,2,2,2,1,2,0,3,3,3,2,1,0,0,1,2,3,1,2,0,3,3,1,2,3,3,0,3,1,2,3,2,3,1,3,1,3,0,3,0,1,2,3,4,3,3,1,2,3,1,0,0,1,2,3,3,0,3,1,2,1,2,0,3,0,0,2,0,1,3,0,3,0,3,1,2,0,1,2,3,3,2,2,2,1,1,1,1,2,0,3,0,3,1,2,0,3,0,3,0,3,1,2,1,2,0,3,0,3,0,2,3,1,3,3,0,3,1,2,0,0,1,1,1,0,3,1,2,0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3,1,2,0,1,2,0,3,3,2,1,1,1,3,4,5,2,6,1,3,4,6,7,0,2,5,7,0,2,5,7,0,2,5,7,0,2,5,7,0,3,4,5,6,1,7,2,6,3,4,5,2,1,3,1,3,1,3,1,3,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,2,3,4,1,5,0,5,0,0,0,5,1,5,2,3,4,0,1,2,0,3,0,4,0,4,0,4,0,4,0,3,0,1,2,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,0,1,2,3,0,0,0,1,2,0,0,0,0,2,3,4,1,5,0,5,0,0,3,4,5,0,5,1,5,2,3,4,0,4,0,4,0,4,0,1,2,3,4,0,4,0,4,0,4,0,4,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,3,1,2,0,4,0,3,0,2,0,1,2,0,2,0,3,0,3,0,4,0,0,0,0,0,0,0,0,1,2,3,0,6,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,5,0,1,5,0,2,5,0,2,5,0,3,5,0,3,5,0,4,5,0,5,2,3,1,4,0,5,0,5,0,5,0,5,1,4,2,3,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,0,0,2,3,1,4,0,5,0,5,0,5,0,5,1,3,4,2,3,5,5,0,1,2,3,0,4,0,4,0,1,2,3,0,2,0,3,0,4,0,5,1,2,3,0,4,0,1,2,3,4,0,4,0,4,1,2,3,0,1,2,3,4,2,2,2,2,2,2,2,0,5,0,5,0,5,0,5,0,5,0,5,1,4,2,3,0,4,0,4,1,3,1,3,1,3,1,3,1,3,2,0,3,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,1,5,0,5,1,4,1,4,2,3,2,3,1,4,1,4,0,5,0,4,1,3,1,3,2,2,2,2,2,0,1,2,3,4,4,3,2,2,1,0,0,1,2,3,4,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,2,2,0,1,1,1,1,1,1,1,1,1,0,1,1,0,2,0,2,0,2,0,1,2,3,4,0,1,0,1,2,3,1,2,3,0,3,0,3,1,2,3,0,0,0,2,0,1,3,0,3,0,3,0,1,3,0,2,1,2,0,3,0,0,0,3,1,2,3,3,1,3,0,2,3,0,3,0,3,0,2,3,1,3,1,2,0,3,0,1,2,3,0,0,3,1,2,0,1,0,0,1,0,0,0,0,0,1,3,0,2,3,0,3,0,3,0,2,3,1,3,3,0,1,2,0,0,0,2,0,1,3,0,3,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,0,1,0,2,0,3,0,3,0,0,0,0,0,0,0,0,0,2,5,6,0,1,3,4,6,0,3,6,0,3,6,0,3,6,0,3,6,0,2,0,1,3,0,3,0,3,0,3,0,3,1,2,0,3,0,3,0,3,0,3,1,2,0,2,0,1,3,0,3,0,3,0,1,3,0,2,0,0,1,3,0,2,3,0,3,0,3,0,2,3,1,3,3,3,0,2,0,1,0,0,0,0,0,1,2,0,3,1,2,0,3,1,2,0,0,0,1,0,0,0,0,0,1,0,3,0,3,0,3,0,3,0,2,3,1,3,0,4,0,4,1,3,1,3,1,3,2,0,3,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,1,5,0,4,1,3,2,2,1,3,0,4,0,4,1,3,1,3,1,3,2,2,2,1,0,1,2,3,3,2,1,0,0,1,2,3,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,1,1,1,1,0,1,0,1,2,4,0,2,3,0,1,2,0,2,0,2,0,2,0,2,0,2,0,1,2,0,1,2,3,4,2,2,2,3,4,5,2,6,2,6,2,6,2,4,5,2,1,0,1,2,3,0,0,0,0,0,0,0,0,0,2,1,0,1,2,0,0,0,0,0,0,2,0,2,1,0,3,6,2,2,0,1,2,3,4,2,2,2,2,2,2,2,2,2,0,1,2,3,4,2,2,2,2,0,1,2,3,4,2,2,1,2,3,0,0,1,2,3,0,0,1,2,3,0,0,1,2,3,1,5,0,2,4,0,2,4,1,3,3,5,8,3,4,6,7,9,2,4,6,7,9,2,5,8,1,2,3,4,1,4,1,4,1,4,5,6,7,1,4,8,1,4,8,1,4,8,0,1,4,5,6,7,2,1,0,1,2,0,3,0,3,0,3,0,1,2,3,4,5,6,0,3,7,0,3,7,0,3,7,0,3,4,5,6,3,2,0,3,4,0,3,0,2,0,1,0,2,0,3,0,3,0,4,0,1,2,3,4,2,2,2,3,4,5,2,6,2,6,2,6,2,6,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,2,2,0,0,1,2,0,1,2,0,3,0,3,0,3,0,3,0,3,3,2,3,1,0,0,0,0,1,3,0,2,0,2,0,2,0,2,1,0,1,0,1,0,1,0,1,2,3,4,0,1,2,3,4,5,6,7,8,0,1,2,0,2,0,2,0,2,0,2,0,2,0,1,2,0,1,2,3,4,6,7,1,3,4,6,7,1,3,4,6,7,1,3,5,7,1,2,3,4,1,4,1,4,5,1,4,6,1,4,6,0,1,4,5,0,1,2,1,0,0,3,0,3,0,1,2,3,4,0,3,5,0,3,5,0,3,4,2,1,0,3,0,2,0,2,0,1,0,2,0,3,0,0,1,2,0,1,2,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,1,2,3,2,2,1,3,2,0,4,0,4,1,3,1,3,1,3,2,2,1,1,3,2,0,4,1,3,1,3,1,3,2,2,2,1,3,3,3,3,3,0,3,0,3,1,2,0,1,2,3,0,3,0,3,0,1,2,3,2,2,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,3,0,1,2,0,3,0,3,1,2,3,0,3,1,2,2,4,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,2,3,4,1,5,0,3,4,6,0,2,6,0,2,4,6,0,3,6,1,5,2,3,4,2,3,1,4,5,0,5,0,1,2,0,0,5,1,4,2,3,2,4,1,3,0,2,1,3,2,4,0,1,2,3,3,3,0,1,2,3,4,1,5,0,2,3,4,6,0,2,4,6,0,2,3,4,6,0,2,4,6,1,5,2,3,4,0,2,0,0,0,0,0,0,0,0,1,0,2,1,2,2,0,1,2,3,4,2,2,0,1,2,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,1,2,0,0,0,0,0,0,3,0,3,0,3,0,3,0,1,2,3,0,3,0,0,1,2,3,4,5,0,1,2,4,0,1,2,4,1,2,4,2,4,2,4,2,4,2,4,2,4,2,4,0,1,3,1,2,0,3,0,1,2,3,0,0,3,1,2,0,4,0,1,4,0,1,4,7,0,2,4,6,8,0,2,4,6,8,0,3,4,7,0,3,4,0,4,6,7,8,1,2,0,3,0,1,0,3,0,3,1,2,0,2,1,3,2,4,1,3,0,2,0,0,0,0,0,0,0,0,0,1,2,3,0,4,0,1,2,3,4,0,4,0,4,1,2,3,0,1,2,0,3,1,2,0,3,1,2,0,2,0,0,0,0,0,0,2,1,3,1,3,1,3,1,3,1,2,3,0,4,0,4,0,1,2,3,0,0,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,1,2,3,0,0,0,0,0,0,0,1,2,3,4,1,4,1,4,1,4,1,4,1,4,1,4,0,1,2,3,4,5,0,5,0,5,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,0,1,3,5,6,1,3,5,1,3,5,2,3,4,1,3,5,1,3,5,1,3,5,0,3,6,1,2,0,3,0,3,2,3,0,3,0,3,1,2,0,4,0,3,4,0,3,4,0,2,4,0,2,4,0,1,4,0,1,4,0,4,1,3,2,0,4,0,3,4,0,3,4,0,2,4,0,2,4,0,1,4,0,1,4,0,4,0,3,4,0,3,0,2,0,1,0,2,0,3,0,3,0,4,1,2,3,4,1,4,1,4,1,4,1,4,1,4,1,4,0,1,4,0,6,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,4,0,4,0,4,0,1,2,3,4,0,4,0,4,0,4,0,4,2,3,1,4,0,5,0,5,0,5,0,5,1,4,2,3,0,1,2,3,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,0,0,2,3,4,1,5,0,5,0,0,0,5,1,5,2,3,4,0,1,2,3,4,2,2,2,2,2,2,2,0,4,0,4,1,3,1,3,1,3,2,2,1,3,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,1,2,3,4,5,3,0,5,1,4,1,4,2,3,2,3,1,4,1,4,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,6,6,6,0,4,0,4,0,4,0,4,1,2,3,4,4,4,4,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,7,0,1,2,2,2,2,3,4,2,5,2,5,2,5,2,3,4,0,5,0,5,0,5,0,1,2,5,0,3,5,0,3,5,0,3,5,0,1,2,5,0,0,0,0,1,2,0,3,0,3,0,3,0,1,2,2,3,0,1,4,0,5,3,4,5,5,0,5,0,1,4,2,3,0,4,5,0,2,3,6,0,2,7,0,1,2,7,0,2,7,0,2,7,0,3,6,0,4,5,2,3,4,5,1,5,1,5,2,3,4,5,2,5,2,5,1,5,0,5,0,1,2,3,1,2,3,0,3,0,3,1,2,3,1,2,3,0,0,1,2,0,3,0,3,0,3,0,3,1,2,0,1,2,0,3,0,1,2,0,3,0,3,0,1,2,0,1,2,0,0,0,0,0,1,2,3,1,3,1,3,1,3,0,3,0,1,2,3,4,0,4,0,4,1,2,0,3,0,1,2,3,0,0,3,1,2,0,2,4,5,0,2,4,0,2,4,1,2,3,0,2,4,2,5,1,2,0,2,1,2,0,2,1,0,3,0,2,3,0,2,3,0,1,3,0,1,3,0,3,1,3,2,0,3,0,2,3,0,2,3,0,1,3,0,1,3,0,3,0,3,0,2,0,2,0,1,0,2,0,3,1,2,3,1,3,1,3,1,3,1,3,0,1,3,0,1,3,4,0,1,3,4,0,1,3,4,0,2,4,0,2,4,0,2,4,0,3,0,3,0,1,2,3,0,3,0,3,0,3,1,2,0,3,0,3,0,3,0,3,1,2,0,1,2,3,0,3,0,3,0,3,0,3,0,3,0,2,0,1,3,0,3,0,3,0,1,3,0,2,0,0,1,2,0,3,0,0,0,3,1,2,0,1,2,3,1,1,1,1,1,0,4,1,3,1,3,1,3,2,2,2,1,3,3,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,1,2,3,4,5,3,3,0,4,1,3,2,2,1,3,0,4,0,3,0,3,0,3,0,3,0,3,0,1,2,3,4,4,4,0,3,0,3,0,3,1,2,3,3,3,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,7,0,1,1,1,2,3,1,4,1,4,1,2,3,0,5,0,5,0,1,2,5,0,3,5,0,3,5,0,1,2,5,0,0,0,1,2,0,3,0,3,0,1,2,1,2,0,3,2,3,0,3,0,3,1,2,0,3,4,0,2,5,0,1,2,5,0,2,5,0,2,5,0,3,4,1,2,3,0,3,0,3,1,2,3,1,3,0,3};
               int m_SF8_YA[]={4,5,6,7,8,9,11,4,4,5,5,6,6,4,4,5,5,6,6,6,6,6,7,7,8,8,9,9,9,9,9,10,10,11,11,3,4,4,4,5,5,5,6,6,7,7,7,8,8,9,9,10,10,10,11,11,11,12,4,4,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,11,4,5,5,6,6,7,8,8,8,8,9,9,9,10,10,10,11,11,4,5,6,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,5,5,6,7,7,6,7,8,8,8,8,8,9,10,11,12,13,9,9,11,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,5,5,6,6,7,8,9,10,11,4,4,5,5,6,7,8,9,10,11,11,11,11,4,4,5,5,6,7,7,8,9,10,10,11,11,4,5,5,6,6,7,7,8,8,9,9,9,9,9,10,11,4,4,4,5,6,7,7,7,8,9,10,10,11,11,4,4,5,5,6,7,7,8,8,8,9,9,10,10,11,11,4,4,4,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,7,8,8,9,10,10,11,11,6,11,6,11,12,13,6,7,7,8,9,9,10,7,7,7,7,9,9,9,9,6,7,7,8,9,9,10,4,4,5,5,6,7,8,9,11,4,4,4,5,5,6,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,12,12,13,13,14,14,14,4,5,5,6,6,7,7,8,8,9,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,4,4,4,5,5,6,6,7,8,9,9,10,10,11,11,11,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,7,7,7,7,8,9,10,11,11,11,11,11,4,4,4,4,5,6,7,7,7,8,9,10,11,4,4,4,5,5,6,6,7,8,8,8,8,9,9,10,10,11,11,11,4,4,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,11,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,11,11,4,5,6,7,8,9,10,11,11,11,11,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,8,8,8,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,11,11,11,12,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,4,4,4,5,5,6,7,7,7,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,8,9,10,11,4,4,4,4,4,5,6,7,8,9,10,11,11,11,11,11,4,4,5,6,7,8,9,10,11,12,13,13,4,5,6,7,8,9,10,11,4,4,5,6,7,8,9,10,11,12,13,13,4,5,5,6,6,7,7,12,12,12,12,12,4,5,6,6,6,7,8,8,8,9,9,10,10,11,11,11,4,5,6,6,7,7,7,8,8,9,9,10,10,10,11,11,6,6,7,7,8,9,10,10,11,11,4,5,6,6,7,7,7,8,8,9,9,10,10,10,11,11,6,6,7,7,8,8,8,8,9,10,10,11,11,4,4,5,6,6,7,8,9,10,11,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,13,13,4,5,6,6,7,7,7,8,8,9,9,10,10,11,11,4,6,7,8,9,10,11,4,6,7,8,9,10,11,12,13,4,5,6,6,7,7,8,8,9,9,10,10,11,11,4,5,6,7,8,9,10,11,6,6,6,6,7,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,6,6,7,7,7,8,8,9,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,6,6,7,7,8,9,10,11,6,6,6,7,7,8,9,10,10,11,11,4,5,6,6,7,8,9,10,11,11,6,6,7,7,8,8,9,9,10,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,6,6,7,7,8,9,10,10,11,11,6,6,7,7,8,8,9,9,10,11,12,13,6,6,6,6,7,8,9,10,11,11,11,11,4,4,5,6,7,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,4,5,6,7,8,9,10,11,12,13,13,7,7,7,7,8,8,8,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,11,11,11,1,2,4,4,4,4,5,6,7,8,9,10,11,11,12,3,4,6,6,6,7,8,9,10,11,11,11,12,12,13,11,11,11,4,5,6,6,6,6,6,7,8,9,10,11,12,13,4,5,6,6,6,6,6,7,8,9,10,11,11,11,11,11,12,13,4,4,4,5,6,6,6,6,7,8,8,8,8,9,10,11,11,11,4,4,5,5,5,6,6,6,7,7,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,4,5,5,6,6,7,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,7,8,9,10,11,4,4,5,5,6,6,7,7,7,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,1,2,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,12,13,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,11,11,12,13,13,4,5,6,4,5,4,4,5,5,6,6,4,4,5,5,6,6,6,7,7,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,6,6,6,6,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,7,8,9,10,11,6,6,7,7,8,8,8,8,8,9,9,9,10,10,10,11,11,11,3,4,6,6,7,7,8,8,9,9,10,10,11,11,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,11,11,12,13,1,1,2,4,4,5,5,6,6,7,7,8,8,9,10,11,3,3,4,6,6,7,7,8,8,9,9,10,11,12,13,4,5,6,7,8,9,9,10,10,11,11,6,6,6,6,7,7,8,8,9,9,9,9,2,3,4,4,4,5,6,7,8,9,10,11,4,5,6,7,10,11,12,13,4,4,5,5,6,7,7,8,8,9,9,10,10,11,12,12,13,13,2,2,4,4,4,4,4,5,6,7,7,7,7,7,8,9,10,11,11,11,11,11,4,4,4,5,5,6,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,11,11,11,4,4,5,5,5,6,6,7,7,7,8,9,9,10,10,11,11,7,7,8,8,9,9,10,10,11,11,7,7,7,7,8,9,9,9,4,4,4,5,5,6,6,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,11,11,11,2,2,4,5,6,7,8,9,10,11,4,5,5,6,5,6,7,7,7,7,7,8,9,11,11,11,11,11,4,5,6,7,8,9,10,11,4,6,7,8,9,10,11,4,5,6,6,6,7,8,9,10,11,6,6,7,7,8,8,9,9,10,10,10,10,11,11,12,13,4,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,8,4,4,6,6,7,7,8,8,8,8,9,10,10,11,11,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,11,11,11,11,11,6,6,7,7,8,8,9,9,10,10,11,11,7,7,8,8,9,9,10,10,11,11,4,6,7,8,9,10,11,12,13,4,4,4,5,5,6,7,7,7,8,9,9,10,10,11,11,11,6,6,6,7,7,8,9,10,10,11,11,4,4,6,7,8,9,10,11,4,5,5,6,6,7,7,8,8,9,9,9,10,10,11,11,4,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,4,4,4,4,5,6,7,8,9,10,11,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,12,12,13,13,4,4,4,4,4,5,6,7,7,7,7,7,8,9,10,11,11,11,11,11,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,4,4,5,5,6,6,7,8,9,9,10,10,11,11,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,1,1,2,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,4,4,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,8,8,8,8,9,10,11,4,4,4,5,5,6,6,7,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,10,11,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,12,13,4,4,5,5,6,6,7,7,8,8,8,8,9,10,11,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,11,12,13,4,4,4,5,6,7,7,7,8,8,9,9,10,10,11,11,11,4,4,5,5,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,4,5,6,7,7,7,8,8,9,9,10,10,11,11,11,4,4,5,5,5,6,6,7,7,7,8,9,9,10,10,10,11,11,4,4,4,5,5,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,7,8,8,8,9,9,10,10,11,11,11,4,4,4,5,6,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,8,8,8,9,9,10,10,11,11,11,6,6,6,7,8,9,10,11,6,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,12,12,13,13,6,6,7,7,8,8,8,8,9,10,10,11,11,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,6,6,7,7,8,9,10,10,11,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,3,3,4,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,8,8,9,9,10,10,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,6,6,7,7,8,8,8,8,9,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,6,7,7,8,8,9,9,10,10,11,11,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,6,6,7,7,8,9,10,10,11,11,6,6,6,6,7,8,9,10,11,6,6,7,7,8,8,9,9,10,11,12,13,4,5,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,12,13,6,6,7,7,8,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,12,13,6,6,7,7,8,8,9,9,9,10,11,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,11,12,13,6,6,7,8,8,8,9,9,10,10,11,11,11,6,6,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,11,6,7,8,8,8,9,9,10,10,11,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,6,6,6,7,7,8,8,9,9,9,10,10,11,11};
               CopyFonts(m_SF8_PA,m_SF8_WA,m_SF8_XA,m_SF8_YA);           
         }
         else if(aType==3){
               m_Font="Arial";
               m_FontSize=8;
               m_Space=4;
               int m_A8_PA[]={0,7,13,35,57,81,100,103,113,123,130,139,142,145,146,154,172,182,197,212,228,245,264,276,295,314,316,320,329,339,348,358,403,421,447,461,481,501,516,535,555,563,574,592,604,632,654,672,689,710,732,750,762,780,794,819,835,847,864,876,884,896,903,909,911,928,946,958,976,992,1002,1023,1039,1046,1054,1068,1076,1097,1111,1125,1143,1161,1169,1182,1192,1206,1216,1235,1245,1257,1271,1281,1291,1301,1308,1330,1354,1368,1371,1381,1387,1390,1404,1422,1445,1471,1501,1506,1534,1552,1573,1595,1617,1620,1623,1629,1635,1644,1650,1661,1683,1702,1724,1729,1750,1764,1783,1800,1800,1819,1836,1847,1863,1876,1884,1905,1927,1955,1972,1982,1989,1992,2022,2031,2039,2053,2061,2068,2078,2095,2123,2124,2142,2176,2190,2200,2208,2226,2239,2246,2264,2284,2310,2322,2349,2369,2397,2412,2434,2461,2477,2496,2524,2544,2562,2582,2599,2613,2625,2639,2663,2679,2702,2717,2747,2780,2799,2824,2841,2858,2885,2907,2924,2944,2959,2967,2987,3003,3021,3031,3047,3068,3080,3094,3117,3132,3146,3161,3179,3191,3201,3213,3239,3249,3267,3279,3299,3323,3336,3356,3370,3384,3405,3419};
               int m_A8_WA[]={1,3,5,5,9,6,1,3,3,3,5,1,3,1,3,5,3,5,5,5,5,5,5,5,5,1,1,5,5,5,5,10,7,6,6,6,5,5,7,6,1,4,6,5,7,6,7,5,7,6,6,5,6,7,10,6,7,6,2,3,2,5,6,2,5,5,5,5,5,3,5,5,1,1,4,1,7,5,5,5,5,3,5,2,5,5,9,5,5,5,3,1,3,5,6,9,5,1,3,3,7,5,5,6,11,11,3,9,5,8,6,5,1,1,3,3,3,6,11,6,9,9,3,8,4,5,5,1,5,5,4,6,4,1,5,5,8,6,5,5,3,8,2,3,5,1,1,3,5,6,1,5,11,5,5,1,6,5,2,7,5,6,5,7,5,11,5,6,6,5,6,7,6,7,6,5,6,5,5,7,6,7,5,9,10,7,7,5,6,9,6,5,5,4,3,5,5,7,4,5,5,4,5,7,5,5,5,5,5,5,5,7,5,6,5,5,7,5,7,5,5,7,4};
               int m_A8_XA[]={0,0,0,0,0,0,0,0,2,0,2,0,2,2,4,2,4,0,1,2,3,4,1,3,1,3,0,1,2,3,4,0,2,0,2,1,2,3,0,2,4,0,2,1,2,3,2,4,2,4,0,2,4,1,2,3,2,1,2,6,0,3,5,0,3,5,1,2,4,4,6,7,3,5,8,3,5,8,2,6,7,2,3,1,4,1,4,2,3,1,3,0,4,5,0,4,1,2,3,5,0,0,0,2,1,0,0,0,0,0,0,1,2,0,1,2,2,2,2,2,2,1,0,1,0,1,2,1,0,2,2,2,0,1,2,3,4,2,2,0,0,0,0,1,2,0,2,2,1,1,1,1,0,0,1,2,3,0,4,0,4,0,4,0,4,0,4,0,4,1,2,3,2,1,2,0,2,2,2,2,2,2,1,2,3,0,4,4,4,3,2,1,0,1,2,3,4,1,2,3,0,4,4,2,3,4,4,0,4,1,2,3,3,2,3,1,3,1,3,0,3,0,1,2,3,4,3,3,1,2,3,4,1,0,0,1,2,3,4,4,0,4,1,2,3,1,2,3,0,4,0,0,1,2,3,0,4,0,4,0,4,1,2,3,0,1,2,3,4,3,3,2,2,1,1,1,1,2,3,0,4,0,4,1,2,3,0,4,0,4,0,4,1,2,3,1,2,3,0,4,0,4,0,4,1,2,3,4,4,0,4,1,2,3,0,0,0,0,0,0,4,1,2,3,0,1,2,3,4,0,1,2,3,4,0,1,2,3,4,0,1,2,3,4,1,2,3,0,1,2,3,0,4,4,3,2,2,2,3,4,5,6,7,1,2,8,1,4,5,7,9,0,3,6,7,9,0,2,6,9,0,2,6,9,0,2,5,6,8,0,3,4,6,7,1,9,2,3,4,5,6,7,8,3,2,4,2,4,2,4,1,5,1,2,3,4,5,0,6,0,6,0,1,2,3,4,0,5,0,5,0,1,2,3,4,5,0,5,0,5,0,5,0,1,2,3,4,2,3,4,1,5,0,0,0,0,1,5,2,3,4,0,1,2,3,0,4,0,5,0,5,0,5,0,5,0,4,0,1,2,3,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,0,1,2,3,4,0,0,0,1,2,3,0,0,0,0,2,3,4,1,5,0,6,0,0,4,5,6,0,6,1,5,2,3,4,0,5,0,5,0,5,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,3,1,2,0,5,0,4,0,3,0,2,3,0,1,3,0,4,0,4,0,5,0,0,0,0,0,0,0,0,1,2,3,4,0,6,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,3,6,0,5,0,1,5,0,2,5,0,2,5,0,3,5,0,3,5,0,4,5,0,5,2,3,4,1,5,0,6,0,6,0,6,0,6,1,5,2,3,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,0,0,2,3,4,1,5,0,6,0,6,0,6,0,3,4,6,1,5,2,3,4,6,0,1,2,3,4,0,5,0,5,0,1,2,3,4,0,3,0,4,0,4,0,5,1,2,3,4,0,5,0,1,2,3,4,5,0,5,1,2,3,4,0,1,2,3,4,2,2,2,2,2,2,2,0,5,0,5,0,5,0,5,0,5,0,5,0,5,1,2,3,4,0,6,0,6,1,5,1,5,2,4,2,4,3,3,4,9,3,5,9,0,3,5,8,0,3,5,8,0,2,6,8,0,2,6,8,1,7,1,7,0,5,1,4,1,4,2,3,2,3,1,4,1,4,0,5,0,6,1,5,1,5,2,4,3,3,3,3,1,2,3,4,5,4,3,3,2,2,1,0,1,2,3,4,5,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,2,2,0,1,1,1,1,1,1,1,1,1,0,1,2,1,3,1,3,0,4,0,1,2,3,4,5,0,1,1,2,3,0,4,1,2,3,4,0,4,0,3,4,1,2,4,0,0,0,2,3,0,1,4,0,4,0,4,0,1,4,0,2,3,1,2,3,0,4,0,0,0,4,1,2,3,4,4,1,2,4,0,3,4,0,4,0,4,0,3,4,1,2,4,1,2,3,0,4,0,1,2,3,4,0,0,4,1,2,3,2,1,0,1,2,1,1,1,1,1,1,2,4,0,3,4,0,4,0,4,0,3,4,1,2,4,4,0,1,2,3,0,0,0,2,3,0,1,4,0,4,0,4,0,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,0,1,0,2,0,2,0,3,0,0,0,0,0,0,0,0,0,2,3,4,5,0,1,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,0,4,0,4,0,4,0,4,0,4,1,2,3,0,4,0,4,0,4,0,4,1,2,3,0,2,3,0,1,4,0,4,0,4,0,1,4,0,2,3,0,0,1,2,4,0,3,4,0,4,0,4,0,3,4,1,2,4,4,4,0,2,0,1,0,0,0,0,1,2,3,0,4,1,2,3,0,4,1,2,3,0,0,0,1,0,0,0,0,0,1,0,4,0,4,0,4,0,4,0,3,4,1,2,4,0,4,0,4,1,3,1,3,2,2,0,4,8,0,3,5,8,1,3,5,7,1,3,5,7,2,6,2,6,0,4,1,3,2,2,1,3,0,4,0,4,0,4,1,3,1,3,2,2,2,1,0,1,2,3,4,3,2,2,1,0,1,2,3,4,2,1,1,1,0,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,1,0,0,1,2,4,0,2,3,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,0,1,2,3,4,5,6,3,3,3,4,5,6,7,3,8,3,8,3,8,3,5,6,7,3,2,0,1,2,3,4,0,0,0,0,0,0,0,0,0,0,2,1,0,1,2,0,0,0,0,0,0,2,0,2,0,2,0,3,6,2,2,0,1,2,3,4,2,2,2,2,2,2,2,2,2,0,1,2,3,4,2,2,2,2,0,1,2,3,4,2,2,2,3,4,5,1,0,1,2,3,4,5,1,0,1,2,3,4,5,1,2,3,4,5,1,4,0,2,4,0,2,4,1,3,3,5,9,2,4,6,8,10,2,4,6,8,10,2,5,9,1,2,3,4,5,1,5,1,5,1,5,6,7,8,9,1,5,10,1,5,10,1,5,10,0,5,6,7,8,9,2,1,0,1,2,0,4,0,4,0,4,0,1,2,3,4,5,6,7,0,4,8,0,4,8,0,4,8,0,4,5,6,7,3,2,0,4,0,3,0,2,0,1,0,2,0,3,0,3,0,4,0,1,2,3,4,5,6,3,3,3,4,5,6,3,7,3,7,3,7,3,7,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,3,3,0,1,2,3,0,0,2,3,0,1,4,0,4,0,4,0,4,0,4,4,3,4,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,1,2,0,1,2,0,1,2,0,1,2,3,4,5,0,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,0,1,2,4,8,1,4,5,7,8,1,4,5,7,8,1,4,6,8,1,2,3,4,5,1,5,1,5,6,7,1,5,8,1,5,8,0,1,5,6,7,0,1,2,1,0,0,4,0,4,0,1,2,3,4,5,6,0,4,7,0,4,7,0,4,5,6,3,2,0,3,0,2,0,1,0,2,0,2,0,3,0,1,2,3,0,0,2,3,0,1,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,2,2,1,3,1,2,3,0,4,0,4,1,3,1,3,2,3,2,2,0,1,1,3,1,2,3,0,4,0,4,1,3,1,3,2,2,2,1,3,3,3,3,3,0,3,0,3,1,2,0,5,1,2,3,4,1,4,1,4,1,2,3,4,0,5,3,3,0,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,0,4,1,0,1,2,0,3,1,4,2,4,3,0,4,1,2,3,2,4,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,2,3,4,5,1,6,0,3,4,5,7,0,2,7,0,2,5,7,0,3,4,7,1,6,2,3,4,5,2,3,4,1,5,0,0,1,2,3,0,0,1,5,2,3,4,2,4,1,3,0,2,1,3,2,4,0,1,2,3,4,4,4,0,1,2,2,3,4,5,1,6,0,2,3,4,7,0,2,5,7,0,2,3,4,7,0,2,5,7,1,6,2,3,4,5,1,0,0,0,0,0,0,0,0,0,1,2,0,2,0,1,2,2,2,0,1,2,3,4,2,2,0,1,2,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,1,2,0,0,0,0,0,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,0,0,1,2,3,4,5,0,1,2,4,0,1,2,4,1,2,4,2,4,2,4,2,4,2,4,2,4,2,4,0,1,3,1,2,3,0,4,0,1,2,3,4,0,0,4,1,2,3,0,5,0,1,5,8,9,0,1,5,7,10,0,2,5,7,10,0,3,5,8,9,0,4,5,0,4,5,7,8,9,10,0,5,1,2,3,0,4,0,1,2,0,0,4,1,2,3,0,2,1,3,2,4,1,3,0,2,0,0,0,0,0,0,0,0,1,2,3,4,0,5,0,1,2,3,4,5,0,5,1,2,3,4,1,2,3,0,4,1,2,3,0,4,1,2,3,1,0,0,0,0,0,0,3,2,4,2,4,2,4,1,5,1,2,3,4,5,0,6,0,6,0,1,2,3,0,0,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,1,2,3,4,0,5,0,5,0,1,2,3,4,5,0,5,0,5,0,5,0,1,2,3,4,0,1,2,3,4,0,0,0,0,0,0,0,2,3,4,5,2,5,2,5,2,5,2,5,2,5,1,5,0,1,2,3,4,5,6,0,6,0,6,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,0,1,5,9,10,2,5,8,2,5,8,3,4,5,6,7,2,5,8,2,5,8,1,5,9,0,5,10,1,2,3,0,4,4,2,3,4,4,0,4,1,2,3,0,5,0,4,5,0,3,5,0,3,5,0,2,5,0,2,5,0,1,5,0,5,2,4,2,3,4,0,5,0,4,5,0,3,5,0,3,5,0,2,5,0,2,5,0,1,5,0,5,0,4,0,3,0,2,0,1,0,2,0,3,0,3,0,4,1,2,3,4,5,1,5,1,5,1,5,1,5,1,5,1,5,0,5,0,6,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,3,6,0,5,0,5,0,5,0,1,2,3,4,5,0,5,0,5,0,5,0,5,2,3,4,1,5,0,6,0,6,0,6,0,6,1,5,2,3,4,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,0,0,2,3,4,1,5,0,0,0,0,1,5,2,3,4,0,1,2,3,4,2,2,2,2,2,2,2,0,4,0,4,1,3,1,3,2,3,2,2,0,1,3,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,1,2,3,4,5,3,0,5,1,4,1,4,2,3,2,3,1,4,1,4,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,6,6,6,0,4,0,4,0,4,0,4,1,2,3,4,4,4,4,0,4,8,0,4,8,0,4,8,0,4,8,0,4,8,0,4,8,0,4,8,0,1,2,3,4,5,6,7,8,0,4,8,0,4,8,0,4,8,0,4,8,0,4,8,0,4,8,0,4,8,0,1,2,3,4,5,6,7,8,9,9,9,0,1,2,2,2,2,3,4,5,2,6,2,6,2,6,2,3,4,5,0,6,0,6,0,6,0,1,2,3,6,0,4,6,0,4,6,0,4,6,0,1,2,3,6,0,0,0,0,1,2,3,0,4,0,4,0,4,0,1,2,3,1,2,3,0,4,5,2,3,4,5,5,5,0,4,1,2,3,0,4,5,6,0,3,7,0,2,8,0,2,8,0,1,2,8,0,2,8,0,3,7,0,4,5,6,1,2,3,4,5,0,5,0,5,1,2,3,4,5,2,5,1,5,0,5,0,5,1,2,3,0,4,1,2,3,4,0,4,0,3,4,1,2,4,1,2,3,4,0,0,1,2,3,0,4,0,4,0,4,0,4,1,2,3,0,1,2,0,3,0,1,2,0,3,0,3,0,1,2,0,1,2,0,0,0,0,0,1,2,3,1,3,1,3,1,3,0,3,0,1,2,3,4,0,4,0,4,1,2,3,0,4,0,1,2,3,4,0,0,4,1,2,3,0,3,6,1,3,5,2,3,4,1,3,5,1,3,5,0,3,6,1,2,0,3,2,3,0,3,1,2,0,4,0,3,4,0,2,4,0,2,4,0,1,4,0,4,1,3,1,2,3,0,4,0,3,4,0,2,4,0,2,4,0,1,4,0,4,0,3,0,2,0,1,0,2,0,2,0,3,1,2,3,4,1,4,1,4,1,4,1,4,0,4,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,4,0,4,0,1,2,3,4,0,4,0,4,0,4,1,2,3,0,4,0,4,0,4,0,4,1,2,3,0,1,2,3,4,0,4,0,4,0,4,0,4,0,4,0,2,3,0,1,4,0,4,0,4,0,1,4,0,2,3,0,0,1,2,3,0,4,0,0,0,4,1,2,3,0,1,2,3,4,2,2,2,2,2,0,4,0,4,1,3,1,3,2,2,2,1,3,3,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,1,2,3,4,5,3,3,0,4,1,3,2,2,1,3,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,5,5,5,0,4,0,4,0,4,1,2,3,4,4,4,0,2,4,0,2,4,0,2,4,0,2,4,0,2,4,0,1,2,3,4,0,2,4,0,2,4,0,2,4,0,2,4,0,2,4,0,1,2,3,4,5,6,6,6,0,1,1,1,2,3,1,4,1,4,1,2,3,0,6,0,6,0,1,2,3,6,0,4,6,0,4,6,0,1,2,3,6,0,0,0,1,2,3,0,4,0,4,0,1,2,3,1,2,3,0,4,2,3,4,4,0,4,1,2,3,0,3,4,5,0,2,6,0,1,2,6,0,2,6,0,2,6,0,3,4,5,1,2,3,0,3,0,3,1,2,3,0,3,0,3};
               int m_A8_YA[]={3,4,5,6,7,8,10,3,3,4,4,5,5,3,3,4,4,5,5,5,5,5,6,6,7,7,8,8,8,8,8,9,9,10,10,3,3,3,4,4,4,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,3,3,4,4,5,5,6,6,7,7,8,8,8,9,9,10,10,10,10,3,4,5,3,4,5,6,7,8,9,10,11,12,3,4,5,6,7,8,9,10,11,12,3,4,4,4,5,6,6,5,6,7,7,7,7,7,8,9,10,11,12,8,8,8,10,3,4,5,6,7,8,9,10,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,3,4,4,5,5,6,7,8,9,10,3,3,3,4,4,5,6,7,8,9,10,10,10,10,10,3,3,3,4,4,5,6,6,7,8,9,9,10,10,10,3,4,4,5,5,6,6,7,7,8,8,8,8,8,9,10,3,3,3,3,4,5,6,6,6,6,7,8,9,9,10,10,10,3,3,3,4,4,5,6,6,6,6,7,7,8,8,9,9,10,10,10,3,3,3,3,3,4,5,6,7,8,9,10,3,3,3,4,4,5,5,6,6,6,7,7,8,8,9,9,10,10,10,3,3,3,4,4,5,5,6,6,7,7,7,7,8,9,9,10,10,10,5,10,5,10,11,12,5,6,6,6,7,8,8,8,9,6,6,6,6,6,8,8,8,8,8,5,6,6,6,7,8,8,8,9,3,3,3,4,4,5,6,7,8,10,3,3,3,3,3,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,12,12,12,12,12,12,12,3,4,4,5,5,6,6,7,7,8,8,8,8,8,9,9,10,10,3,3,3,3,3,4,4,5,5,6,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,3,3,3,4,4,5,6,7,8,9,9,10,10,10,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,3,3,3,3,3,4,5,6,6,6,6,6,7,8,9,10,10,10,10,10,3,3,3,3,3,4,5,6,6,6,6,7,8,9,10,3,3,3,4,4,5,5,6,7,7,7,7,8,8,9,9,10,10,10,3,3,4,4,5,5,6,6,6,6,6,6,7,7,8,8,9,9,10,10,3,4,5,6,7,8,9,10,3,4,5,6,7,8,8,9,9,10,10,3,3,4,4,5,5,6,6,6,7,7,7,8,8,9,9,10,10,3,4,5,6,7,8,9,10,10,10,10,10,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,10,10,10,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,3,3,3,3,4,4,5,5,6,6,7,7,7,7,8,9,10,3,3,3,4,4,5,5,6,6,7,7,8,8,8,8,9,9,10,10,10,10,3,3,3,3,3,4,4,5,5,6,6,6,6,6,7,7,8,8,9,9,10,10,3,3,3,3,4,4,5,6,6,7,7,8,9,9,10,10,10,10,3,3,3,3,3,4,5,6,7,8,9,10,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,3,3,4,4,5,5,6,6,7,7,8,8,9,10,3,3,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,10,10,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,3,3,4,4,5,5,6,6,7,8,9,10,3,3,3,3,3,4,5,6,7,8,9,10,10,10,10,10,10,3,3,4,5,6,7,8,9,10,11,12,12,3,4,5,6,7,8,9,10,3,3,4,5,6,7,8,9,10,11,12,12,3,4,4,5,5,6,6,12,12,12,12,12,12,3,4,5,5,5,6,6,7,7,7,7,8,8,9,9,9,10,10,10,3,4,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,5,5,5,6,6,7,8,9,9,10,10,10,3,4,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,5,5,5,6,6,7,7,7,7,7,8,9,9,10,10,10,3,4,5,5,5,6,7,8,9,10,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,12,12,12,12,3,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,3,5,6,7,8,9,10,3,5,6,7,8,9,10,11,3,4,5,5,6,6,7,7,8,8,9,9,10,10,3,4,5,6,7,8,9,10,5,5,5,5,5,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,5,5,5,5,6,6,7,7,8,8,9,9,10,10,5,5,5,6,6,7,7,8,8,9,9,10,10,10,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,12,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,12,5,5,6,6,7,8,9,10,5,5,5,6,6,7,7,8,9,9,10,10,10,3,4,5,5,6,7,8,9,10,10,5,5,6,6,7,7,8,8,9,9,9,10,10,10,5,5,6,6,7,7,8,8,9,10,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,10,10,5,5,6,6,7,8,9,9,10,10,5,5,6,6,7,7,8,8,9,10,11,12,5,5,5,5,5,6,7,8,9,10,10,10,10,10,3,4,5,6,7,8,9,10,11,12,3,4,5,6,7,8,9,10,11,12,3,4,5,6,7,8,9,10,11,12,6,6,6,6,7,7,7,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,3,3,4,5,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,0,1,3,3,3,3,3,4,5,6,7,8,9,10,10,11,12,2,3,5,5,5,6,7,8,9,10,10,10,11,11,12,12,10,10,10,3,4,5,5,5,5,5,6,7,8,9,10,11,12,3,4,5,5,5,5,5,6,7,8,9,10,10,10,10,10,11,12,3,3,3,3,4,5,5,5,5,5,5,6,7,7,7,7,7,7,8,9,10,10,10,3,3,4,4,4,5,5,5,6,6,7,7,7,8,8,8,8,8,9,9,9,9,9,10,10,10,3,3,3,3,3,4,4,5,5,6,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,6,7,8,9,10,3,3,4,4,5,5,6,6,6,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,0,1,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,3,3,3,3,3,3,3,4,5,6,6,6,6,7,7,8,8,9,9,10,10,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,11,12,3,3,3,3,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,11,12,12,3,4,5,3,4,5,3,3,4,4,5,5,3,3,4,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,5,5,5,5,5,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,10,6,7,8,9,10,5,5,6,6,7,7,7,7,7,7,7,8,8,8,9,9,9,10,10,10,10,2,3,5,5,6,6,7,7,8,8,9,9,10,10,3,3,3,3,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,11,12,0,0,1,1,1,3,3,4,4,5,5,6,6,7,7,8,9,10,10,2,2,3,3,3,5,5,6,6,7,7,8,8,9,10,11,12,3,4,5,6,7,8,8,9,9,10,10,4,4,5,5,5,5,6,6,7,7,8,8,8,8,9,9,1,2,3,3,3,3,4,5,6,7,8,9,10,3,4,5,6,9,10,11,12,3,3,3,4,4,5,6,6,6,7,7,8,8,9,9,10,11,11,12,12,12,1,1,3,3,3,3,3,4,5,6,6,6,6,6,7,8,9,10,10,10,10,10,3,3,3,3,4,4,5,5,5,5,5,6,6,6,7,7,7,7,8,8,8,8,9,9,10,10,10,10,3,3,3,4,4,5,6,6,6,6,7,8,9,9,10,10,10,6,6,7,7,8,8,9,9,10,10,6,6,6,6,6,7,8,8,8,8,3,3,3,3,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,10,10,10,10,1,3,4,5,6,7,8,9,10,3,3,3,4,4,5,5,5,4,5,6,6,6,6,6,7,8,10,10,10,10,10,3,4,5,6,7,8,9,10,3,5,6,7,8,9,10,3,4,5,5,5,6,7,8,9,10,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,11,12,3,3,3,3,3,4,4,4,4,5,5,5,5,6,6,6,7,7,8,8,9,9,10,10,11,11,12,12,7,3,3,5,5,5,6,6,7,7,7,7,7,8,9,9,10,10,10,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,9,9,9,9,9,9,9,10,10,5,5,5,6,6,7,7,7,8,9,9,10,10,10,6,6,7,7,8,8,9,9,10,10,3,5,6,7,8,9,10,11,3,3,3,3,4,4,5,6,6,7,7,8,9,9,10,10,10,10,5,5,5,6,6,7,7,8,9,9,10,10,10,3,5,6,7,8,9,10,3,4,4,5,5,6,6,7,7,8,8,8,8,8,9,9,10,10,3,3,3,3,4,5,6,6,6,6,7,7,8,8,9,9,10,10,10,10,3,3,3,3,3,4,4,5,5,6,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,3,3,3,3,3,4,5,6,7,8,9,10,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,11,11,12,12,3,3,3,3,3,4,5,6,6,6,6,6,7,8,9,10,10,10,10,10,3,3,3,3,3,4,4,4,5,5,5,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,3,3,3,4,4,5,6,6,7,8,9,9,10,10,10,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,0,0,1,1,1,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,3,3,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,10,10,10,3,3,4,4,5,5,6,6,6,6,6,6,7,7,8,8,9,9,10,10,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,3,3,3,3,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,3,3,3,3,4,4,5,5,6,6,7,7,7,7,8,9,10,3,3,3,4,4,5,6,7,8,9,9,10,10,10,3,3,3,3,3,4,5,6,7,8,9,10,3,3,4,4,5,5,6,6,7,7,8,9,10,10,3,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,9,9,10,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,11,12,3,3,4,4,5,5,6,6,7,7,7,7,8,9,10,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,10,10,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,10,10,10,11,12,3,3,3,4,5,6,6,6,6,7,7,8,8,9,9,10,10,10,10,3,3,4,4,5,5,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,3,4,5,6,6,6,6,7,7,8,8,9,9,10,10,10,10,3,3,3,4,4,5,6,6,6,6,7,8,9,9,10,10,10,3,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,3,3,3,3,3,4,4,5,5,6,6,6,6,6,7,7,8,8,9,9,10,10,5,5,5,6,6,7,7,7,7,8,8,9,9,9,10,10,10,3,3,3,3,4,5,5,5,5,6,6,7,7,8,8,9,9,10,10,10,5,5,5,6,6,7,7,7,8,8,9,9,10,10,10,5,5,5,6,7,8,9,10,5,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,11,11,12,12,5,5,5,6,6,7,7,7,7,7,8,9,9,10,10,10,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,5,5,6,6,7,8,9,9,10,10,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,2,2,3,3,3,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,5,5,6,6,7,7,8,8,9,9,10,10,5,5,5,5,6,6,7,7,8,8,9,9,10,10,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,5,5,5,6,6,7,7,8,8,9,9,10,10,10,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,12,5,5,5,6,6,7,8,9,9,10,10,10,5,5,5,5,5,6,7,8,9,10,5,5,6,6,7,7,8,8,9,10,11,12,3,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,11,12,5,5,6,6,7,8,9,9,10,10,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,11,12,5,5,6,6,7,7,8,8,8,8,9,10,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,11,12,5,5,6,7,7,7,8,8,9,9,10,10,10,5,5,6,6,7,7,7,7,7,8,8,8,9,9,9,10,10,10,10,10,5,6,7,7,7,7,8,8,9,9,10,10,10,10,5,5,5,6,6,7,7,7,8,9,9,10,10,10,5,5,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,5,5,5,6,6,7,7,8,8,8,9,9,10,10};
               CopyFonts(m_A8_PA,m_A8_WA,m_A8_XA,m_A8_YA);
         }
         else if(aType==4){
               m_Font="Arial Narrow";
               m_FontSize=8;            
               m_Space=3;
               int m_AN8_PA[]={0,7,13,35,58,78,96,99,109,119,126,135,138,140,141,149,165,175,188,201,217,231,247,258,274,290,292,296,303,311,318,327,365,381,403,419,437,457,470,489,508,516,527,544,555,584,606,622,639,658,678,695,707,723,738,767,783,794,810,822,830,842,849,854,856,870,886,896,912,925,935,953,968,975,984,998,1006,1027,1040,1052,1068,1084,1092,1103,1113,1126,1137,1158,1168,1180,1192,1202,1212,1224,1231,1247,1267,1280,1282,1292,1297,1300,1314,1332,1350,1376,1404,1409,1436,1455,1474,1495,1515,1518,1520,1526,1531,1537,1542,1551,1567,1588,1607,1612,1630,1644,1661,1677,1677,1693,1708,1719,1731,1743,1751,1769,1791,1815,1832,1842,1848,1850,1878,1888,1892,1906,1914,1921,1931,1947,1975,1976,1991,2022,2034,2044,2053,2070,2081,2089,2105,2125,2147,2158,2184,2204,2230,2244,2266,2291,2308,2327,2356,2375,2391,2410,2427,2443,2455,2468,2492,2508,2531,2546,2574,2605,2622,2645,2660,2678,2704,2724,2738,2755,2770,2778,2798,2811,2829,2838,2854,2873,2885,2899,2920,2934,2946,2960,2976,2986,2995,3007,3033,3043,3060,3071,3093,3118,3131,3149,3161,3173,3192,3206};
               int m_AN8_WA[]={1,3,5,5,7,5,1,2,2,3,5,2,2,1,3,4,3,4,4,5,4,4,4,4,4,1,2,4,4,4,4,8,5,5,6,5,5,4,6,5,1,4,5,4,7,6,6,5,6,6,5,5,6,5,7,6,5,5,2,3,2,3,5,2,4,4,4,4,4,2,4,4,1,1,4,1,7,4,4,4,4,3,4,2,4,5,7,5,5,4,2,1,3,5,3,7,4,1,3,3,7,5,5,4,10,9,3,8,5,7,5,4,2,1,4,3,2,5,9,3,8,7,3,6,4,4,4,1,5,5,4,4,3,1,4,5,7,6,5,4,2,7,3,3,5,1,1,3,4,6,1,4,9,4,5,1,5,4,3,5,5,5,4,6,5,7,4,5,5,5,5,7,5,6,5,5,6,5,5,7,6,7,5,7,8,6,6,4,6,8,6,4,4,4,3,5,4,6,3,4,4,4,4,5,4,4,4,4,4,4,5,7,5,5,4,7,8,5,6,4,4,6,4};
               int m_AN8_XA[]={0,0,0,0,0,0,0,0,2,0,2,0,2,1,3,1,3,0,1,2,3,4,1,3,0,2,0,1,2,3,4,0,2,0,2,2,1,2,3,0,2,4,0,2,1,2,3,2,4,2,4,0,2,4,1,2,3,2,1,5,0,2,4,0,2,4,1,3,3,5,3,4,6,2,4,6,2,5,2,1,3,1,3,2,0,1,2,4,0,3,4,0,3,4,1,2,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,0,1,2,1,0,2,2,2,0,1,2,3,4,2,2,1,1,0,0,1,0,2,2,2,1,1,0,0,0,1,2,0,3,0,3,0,3,0,3,0,3,0,3,1,2,2,1,2,0,2,2,2,2,2,2,1,2,0,3,3,3,2,1,0,0,1,2,3,1,2,0,3,3,1,2,3,3,0,3,1,2,3,2,3,1,3,1,3,0,3,0,1,2,3,4,3,3,1,2,3,1,0,0,1,2,3,3,0,3,1,2,1,2,0,3,0,0,2,0,1,3,0,3,0,3,1,2,0,1,2,3,3,2,2,2,1,1,1,1,2,0,3,0,3,1,2,0,3,0,3,0,3,1,2,1,2,0,3,0,3,0,2,3,1,3,3,0,3,1,2,0,0,1,1,1,0,3,1,2,0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3,1,2,0,1,2,0,3,3,2,1,1,1,3,4,5,2,6,1,3,4,6,7,0,2,5,7,0,2,5,7,0,2,5,7,0,2,5,7,0,3,4,5,6,1,7,2,6,3,4,5,2,1,3,1,3,1,3,1,3,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,2,3,4,1,5,0,5,0,0,0,5,1,5,2,3,4,0,1,2,0,3,0,4,0,4,0,4,0,4,0,3,0,1,2,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,0,1,2,3,0,0,0,1,2,0,0,0,0,2,3,4,1,5,0,5,0,0,3,4,5,0,5,1,5,2,3,4,0,4,0,4,0,4,0,1,2,3,4,0,4,0,4,0,4,0,4,0,0,0,0,0,0,0,0,3,3,3,3,3,0,3,0,3,1,2,0,4,0,3,0,2,0,1,2,0,2,0,3,0,3,0,4,0,0,0,0,0,0,0,0,1,2,3,0,6,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,5,0,1,5,0,2,5,0,2,5,0,3,5,0,3,5,0,4,5,0,5,2,3,1,4,0,5,0,5,0,5,0,5,1,4,2,3,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,0,0,2,3,1,4,0,5,0,5,0,5,0,5,1,3,4,2,3,5,5,0,1,2,3,0,4,0,4,0,1,2,3,0,2,0,3,0,4,0,5,1,2,3,0,4,0,1,2,3,4,0,4,0,4,1,2,3,0,1,2,3,4,2,2,2,2,2,2,2,0,5,0,5,0,5,0,5,0,5,0,5,1,4,2,3,0,4,0,4,1,3,1,3,1,3,1,3,1,3,2,0,3,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,1,5,0,5,1,4,1,4,2,3,2,3,1,4,1,4,0,5,0,4,1,3,1,3,2,2,2,2,2,0,1,2,3,4,4,3,2,2,1,0,0,1,2,3,4,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,2,2,0,1,1,1,1,1,1,1,1,1,0,1,1,0,2,0,2,0,2,0,1,2,3,4,0,1,0,1,2,3,1,2,3,0,3,0,3,1,2,3,0,0,0,2,0,1,3,0,3,0,3,0,1,3,0,2,1,2,0,3,0,0,0,3,1,2,3,3,1,3,0,2,3,0,3,0,3,0,2,3,1,3,1,2,0,3,0,1,2,3,0,0,3,1,2,0,1,0,0,1,0,0,0,0,0,1,3,0,2,3,0,3,0,3,0,2,3,1,3,3,0,1,2,0,0,0,2,0,1,3,0,3,0,3,0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,0,1,0,2,0,3,0,3,0,0,0,0,0,0,0,0,0,2,5,6,0,1,3,4,6,0,3,6,0,3,6,0,3,6,0,3,6,0,2,0,1,3,0,3,0,3,0,3,0,3,1,2,0,3,0,3,0,3,0,3,1,2,0,2,0,1,3,0,3,0,3,0,1,3,0,2,0,0,1,3,0,2,3,0,3,0,3,0,2,3,1,3,3,3,0,2,0,1,0,0,0,0,0,1,2,0,3,1,2,0,3,1,2,0,0,0,1,0,0,0,0,0,1,0,3,0,3,0,3,0,3,0,2,3,1,3,0,4,0,4,1,3,1,3,1,3,2,0,3,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,1,5,0,4,1,3,2,2,1,3,0,4,0,4,1,3,1,3,1,3,2,2,2,1,0,1,2,3,3,2,1,0,0,1,2,3,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,1,1,1,1,0,1,0,1,2,4,0,2,3,0,1,2,0,2,0,2,0,2,0,2,0,2,0,1,2,0,1,2,3,4,2,2,2,3,4,5,2,6,2,6,2,6,2,4,5,2,1,0,1,2,3,0,0,0,0,0,0,0,0,0,2,1,0,1,2,0,0,0,0,0,0,2,0,2,1,0,3,6,2,2,0,1,2,3,4,2,2,2,2,2,2,2,2,2,0,1,2,3,4,2,2,2,2,0,1,2,3,4,2,2,1,2,3,0,0,1,2,3,0,0,1,2,3,0,0,1,2,3,1,5,0,2,4,0,2,4,1,3,3,5,8,3,4,6,7,9,2,4,6,7,9,2,5,8,1,2,3,4,1,4,1,4,1,4,5,6,7,1,4,8,1,4,8,1,4,8,0,1,4,5,6,7,2,1,0,1,2,0,3,0,3,0,3,0,1,2,3,4,5,6,0,3,7,0,3,7,0,3,7,0,3,4,5,6,3,2,0,3,4,0,3,0,2,0,1,0,2,0,3,0,3,0,4,0,1,2,3,4,2,2,2,3,4,5,2,6,2,6,2,6,2,6,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,4,2,2,0,0,1,2,0,1,2,0,3,0,3,0,3,0,3,0,3,3,2,3,1,0,0,0,0,1,3,0,2,0,2,0,2,0,2,1,0,1,0,1,0,1,0,1,2,3,4,0,1,2,3,4,5,6,7,8,0,1,2,0,2,0,2,0,2,0,2,0,2,0,1,2,0,1,2,3,4,6,7,1,3,4,6,7,1,3,4,6,7,1,3,5,7,1,2,3,4,1,4,1,4,5,1,4,6,1,4,6,0,1,4,5,0,1,2,1,0,0,3,0,3,0,1,2,3,4,0,3,5,0,3,5,0,3,4,2,1,0,3,0,2,0,2,0,1,0,2,0,3,0,0,1,2,0,1,2,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,1,2,3,2,2,1,3,2,0,4,0,4,1,3,1,3,1,3,2,2,1,1,3,2,0,4,1,3,1,3,1,3,2,2,2,1,3,3,3,3,3,0,3,0,3,1,2,0,1,2,3,0,3,0,3,0,1,2,3,2,2,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,3,0,1,2,0,3,0,3,1,2,3,0,3,1,2,2,4,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,2,3,4,1,5,0,3,4,6,0,2,6,0,2,4,6,0,3,6,1,5,2,3,4,2,3,1,4,5,0,5,0,1,2,0,0,5,1,4,2,3,2,4,1,3,0,2,1,3,2,4,0,1,2,3,3,3,0,1,2,3,4,1,5,0,2,3,4,6,0,2,4,6,0,2,3,4,6,0,2,4,6,1,5,2,3,4,0,2,0,0,0,0,0,0,0,0,1,0,2,1,2,2,0,1,2,3,4,2,2,0,1,2,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,1,2,0,0,0,0,0,0,3,0,3,0,3,0,3,0,1,2,3,0,3,0,0,1,2,3,4,5,0,1,2,4,0,1,2,4,1,2,4,2,4,2,4,2,4,2,4,2,4,2,4,0,1,3,1,2,0,3,0,1,2,3,0,0,3,1,2,0,4,0,1,4,0,1,4,7,0,2,4,6,8,0,2,4,6,8,0,3,4,7,0,3,4,0,4,6,7,8,1,2,0,3,0,1,0,3,0,3,1,2,0,2,1,3,2,4,1,3,0,2,0,0,0,0,0,0,0,0,0,1,2,3,0,4,0,1,2,3,4,0,4,0,4,1,2,3,0,1,2,0,3,1,2,0,3,1,2,0,2,0,0,0,0,0,0,2,1,3,1,3,1,3,1,3,1,2,3,0,4,0,4,0,1,2,3,0,0,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,1,2,3,0,4,0,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,1,2,3,0,0,0,0,0,0,0,1,2,3,4,1,4,1,4,1,4,1,4,1,4,1,4,0,1,2,3,4,5,0,5,0,5,0,1,2,3,4,0,0,0,1,2,3,4,0,0,0,0,1,2,3,4,0,1,3,5,6,1,3,5,1,3,5,2,3,4,1,3,5,1,3,5,1,3,5,0,3,6,1,2,0,3,0,3,2,3,0,3,0,3,1,2,0,4,0,3,4,0,3,4,0,2,4,0,2,4,0,1,4,0,1,4,0,4,1,3,2,0,4,0,3,4,0,3,4,0,2,4,0,2,4,0,1,4,0,1,4,0,4,0,3,4,0,3,0,2,0,1,0,2,0,3,0,3,0,4,1,2,3,4,1,4,1,4,1,4,1,4,1,4,1,4,0,1,4,0,6,0,1,5,6,0,1,5,6,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,3,6,0,4,0,4,0,4,0,1,2,3,4,0,4,0,4,0,4,0,4,2,3,1,4,0,5,0,5,0,5,0,5,1,4,2,3,0,1,2,3,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,1,2,3,0,4,0,4,0,4,0,1,2,3,0,0,0,2,3,4,1,5,0,5,0,0,0,5,1,5,2,3,4,0,1,2,3,4,2,2,2,2,2,2,2,0,4,0,4,1,3,1,3,1,3,2,2,1,3,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,1,2,3,4,5,3,0,5,1,4,1,4,2,3,2,3,1,4,1,4,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,6,6,6,0,4,0,4,0,4,0,4,1,2,3,4,4,4,4,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,7,0,1,2,2,2,2,3,4,2,5,2,5,2,5,2,3,4,0,5,0,5,0,5,0,1,2,5,0,3,5,0,3,5,0,3,5,0,1,2,5,0,0,0,0,1,2,0,3,0,3,0,3,0,1,2,2,3,0,1,4,0,5,3,4,5,5,0,5,0,1,4,2,3,0,4,5,0,2,3,6,0,2,7,0,1,2,7,0,2,7,0,2,7,0,3,6,0,4,5,2,3,4,5,1,5,1,5,2,3,4,5,2,5,2,5,1,5,0,5,0,1,2,3,1,2,3,0,3,0,3,1,2,3,1,2,3,0,0,1,2,0,3,0,3,0,3,0,3,1,2,0,1,2,0,3,0,1,2,0,3,0,3,0,1,2,0,1,2,0,0,0,0,0,1,2,3,1,3,1,3,1,3,0,3,0,1,2,3,4,0,4,0,4,1,2,0,3,0,1,2,3,0,0,3,1,2,0,2,4,5,0,2,4,0,2,4,1,2,3,0,2,4,2,5,1,2,0,2,1,2,0,2,1,0,3,0,2,3,0,2,3,0,1,3,0,1,3,0,3,1,3,2,0,3,0,2,3,0,2,3,0,1,3,0,1,3,0,3,0,3,0,2,0,2,0,1,0,2,0,3,1,2,3,1,3,1,3,1,3,1,3,0,1,3,0,1,3,4,0,1,3,4,0,1,3,4,0,2,4,0,2,4,0,2,4,0,3,0,3,0,1,2,3,0,3,0,3,0,3,1,2,0,3,0,3,0,3,0,3,1,2,0,1,2,3,0,3,0,3,0,3,0,3,0,3,0,2,0,1,3,0,3,0,3,0,1,3,0,2,0,0,1,2,0,3,0,0,0,3,1,2,0,1,2,3,1,1,1,1,1,0,4,1,3,1,3,1,3,2,2,2,1,3,3,1,2,3,4,5,0,3,6,0,3,6,0,3,6,0,3,6,1,2,3,4,5,3,3,0,4,1,3,2,2,1,3,0,4,0,3,0,3,0,3,0,3,0,3,0,1,2,3,4,4,4,0,3,0,3,0,3,1,2,3,3,3,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,0,3,6,0,3,6,0,3,6,0,3,6,0,3,6,0,1,2,3,4,5,6,7,7,7,0,1,1,1,2,3,1,4,1,4,1,2,3,0,5,0,5,0,1,2,5,0,3,5,0,3,5,0,1,2,5,0,0,0,1,2,0,3,0,3,0,1,2,1,2,0,3,2,3,0,3,0,3,1,2,0,3,4,0,2,5,0,1,2,5,0,2,5,0,2,5,0,3,4,1,2,3,0,3,0,3,1,2,3,1,3,0,3};
               int m_AN8_YA[]={4,5,6,7,8,9,11,4,4,5,5,6,6,4,4,5,5,6,6,6,6,6,7,7,8,8,9,9,9,9,9,10,10,11,11,3,4,4,4,5,5,5,6,6,7,7,7,8,8,9,9,10,10,10,11,11,11,12,4,4,5,5,5,6,6,6,7,7,8,8,9,9,9,10,10,10,11,11,4,5,5,6,6,7,8,8,8,8,9,9,9,10,10,10,11,11,4,5,6,4,5,6,7,8,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,5,5,5,6,7,7,6,7,8,8,8,8,8,9,10,11,12,13,9,9,11,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,5,5,6,6,7,8,9,10,11,4,4,5,5,6,7,8,9,10,11,11,11,11,4,4,5,5,6,7,7,8,9,10,10,11,11,4,5,5,6,6,7,7,8,8,9,9,9,9,9,10,11,4,4,4,5,6,7,7,7,8,9,10,10,11,11,4,4,5,5,6,7,7,8,8,8,9,9,10,10,11,11,4,4,4,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,7,8,8,9,10,10,11,11,6,11,6,11,12,13,6,7,7,8,9,9,10,7,7,7,7,9,9,9,9,6,7,7,8,9,9,10,4,4,5,5,6,7,8,9,11,4,4,4,5,5,6,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,12,12,13,13,14,14,14,4,5,5,6,6,7,7,8,8,9,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,4,4,4,5,5,6,6,7,8,9,9,10,10,11,11,11,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,7,7,7,7,8,9,10,11,11,11,11,11,4,4,4,4,5,6,7,7,7,8,9,10,11,4,4,4,5,5,6,6,7,8,8,8,8,9,9,10,10,11,11,11,4,4,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,11,11,4,5,6,7,8,9,10,11,4,5,6,7,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,11,11,4,5,6,7,8,9,10,11,11,11,11,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,8,8,8,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,11,11,11,12,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,4,4,4,5,5,6,7,7,7,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,8,9,10,11,4,4,4,4,4,5,6,7,8,9,10,11,11,11,11,11,4,4,5,6,7,8,9,10,11,12,13,13,4,5,6,7,8,9,10,11,4,4,5,6,7,8,9,10,11,12,13,13,4,5,5,6,6,7,7,12,12,12,12,12,4,5,6,6,6,7,8,8,8,9,9,10,10,11,11,11,4,5,6,6,7,7,7,8,8,9,9,10,10,10,11,11,6,6,7,7,8,9,10,10,11,11,4,5,6,6,7,7,7,8,8,9,9,10,10,10,11,11,6,6,7,7,8,8,8,8,9,10,10,11,11,4,4,5,6,6,7,8,9,10,11,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,13,13,4,5,6,6,7,7,7,8,8,9,9,10,10,11,11,4,6,7,8,9,10,11,4,6,7,8,9,10,11,12,13,4,5,6,6,7,7,8,8,9,9,10,10,11,11,4,5,6,7,8,9,10,11,6,6,6,6,7,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,6,6,7,7,7,8,8,9,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,6,6,7,7,8,9,10,11,6,6,6,7,7,8,9,10,10,11,11,4,5,6,6,7,8,9,10,11,11,6,6,7,7,8,8,9,9,10,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,6,6,7,7,8,9,10,10,11,11,6,6,7,7,8,8,9,9,10,11,12,13,6,6,6,6,7,8,9,10,11,11,11,11,4,4,5,6,7,9,10,11,12,13,4,5,6,7,8,9,10,11,12,13,4,4,5,6,7,8,9,10,11,12,13,13,7,7,7,7,8,8,8,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,11,11,11,1,2,4,4,4,4,5,6,7,8,9,10,11,11,12,3,4,6,6,6,7,8,9,10,11,11,11,12,12,13,11,11,11,4,5,6,6,6,6,6,7,8,9,10,11,12,13,4,5,6,6,6,6,6,7,8,9,10,11,11,11,11,11,12,13,4,4,4,5,6,6,6,6,7,8,8,8,8,9,10,11,11,11,4,4,5,5,5,6,6,6,7,7,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,4,5,5,6,6,7,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,7,8,9,10,11,4,4,5,5,6,6,7,7,7,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,1,2,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,12,13,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,11,11,12,13,13,4,5,6,4,5,4,4,5,5,6,6,4,4,5,5,6,6,6,7,7,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,6,6,6,6,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,7,8,9,10,11,6,6,7,7,8,8,8,8,8,9,9,9,10,10,10,11,11,11,3,4,6,6,7,7,8,8,9,9,10,10,11,11,4,5,5,5,6,6,6,7,7,8,8,9,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,11,11,12,13,1,1,2,4,4,5,5,6,6,7,7,8,8,9,10,11,3,3,4,6,6,7,7,8,8,9,9,10,11,12,13,4,5,6,7,8,9,9,10,10,11,11,6,6,6,6,7,7,8,8,9,9,9,9,2,3,4,4,4,5,6,7,8,9,10,11,4,5,6,7,10,11,12,13,4,4,5,5,6,7,7,8,8,9,9,10,10,11,12,12,13,13,2,2,4,4,4,4,4,5,6,7,7,7,7,7,8,9,10,11,11,11,11,11,4,4,4,5,5,6,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,11,11,11,4,4,5,5,5,6,6,7,7,7,8,9,9,10,10,11,11,7,7,8,8,9,9,10,10,11,11,7,7,7,7,8,9,9,9,4,4,4,5,5,6,6,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,11,11,11,2,2,4,5,6,7,8,9,10,11,4,5,5,6,5,6,7,7,7,7,7,8,9,11,11,11,11,11,4,5,6,7,8,9,10,11,4,6,7,8,9,10,11,4,5,6,6,6,7,8,9,10,11,6,6,7,7,8,8,9,9,10,10,10,10,11,11,12,13,4,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,8,4,4,6,6,7,7,8,8,8,8,9,10,10,11,11,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,11,11,11,11,11,6,6,7,7,8,8,9,9,10,10,11,11,7,7,8,8,9,9,10,10,11,11,4,6,7,8,9,10,11,12,13,4,4,4,5,5,6,7,7,7,8,9,9,10,10,11,11,11,6,6,6,7,7,8,9,10,10,11,11,4,4,6,7,8,9,10,11,4,5,5,6,6,7,7,8,8,9,9,9,10,10,11,11,4,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,4,4,4,4,5,6,7,8,9,10,11,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,12,12,13,13,4,4,4,4,4,5,6,7,7,7,7,7,8,9,10,11,11,11,11,11,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,4,4,5,5,6,6,7,8,9,9,10,10,11,11,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,1,1,2,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,4,4,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,6,6,7,7,8,8,8,8,9,10,11,4,4,4,5,5,6,6,7,8,9,9,10,10,11,11,11,4,4,4,4,4,5,6,7,8,9,10,11,4,4,5,5,6,6,7,7,8,8,9,10,11,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,11,12,13,4,4,5,5,6,6,7,7,8,8,8,8,9,10,11,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,11,12,13,4,4,4,5,6,7,7,7,8,8,9,9,10,10,11,11,11,4,4,5,5,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,4,5,6,7,7,7,8,8,9,9,10,10,11,11,11,4,4,5,5,5,6,6,7,7,7,8,9,9,10,10,10,11,11,4,4,4,5,5,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,7,8,8,8,9,9,10,10,11,11,11,4,4,4,5,6,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,8,8,8,9,9,10,10,11,11,11,6,6,6,7,8,9,10,11,6,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,12,12,13,13,6,6,7,7,8,8,8,8,9,10,10,11,11,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,6,6,7,7,8,9,10,10,11,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,3,3,4,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,8,8,9,9,10,10,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,6,6,7,7,8,8,8,8,9,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,6,7,7,8,8,9,9,10,10,11,11,6,6,7,7,7,8,8,9,9,10,10,10,11,11,12,13,6,6,7,7,8,9,10,10,11,11,6,6,6,6,7,8,9,10,11,6,6,7,7,8,8,9,9,10,11,12,13,4,5,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,12,13,6,6,7,7,8,9,10,10,11,11,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,12,13,6,6,7,7,8,8,9,9,9,10,11,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,11,11,11,11,11,12,13,6,6,7,8,8,8,9,9,10,10,11,11,11,6,6,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,11,6,7,8,8,8,9,9,10,10,11,11,11,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,6,6,6,7,7,8,8,9,9,9,10,10,11,11};
               CopyFonts(m_AN8_PA,m_AN8_WA,m_AN8_XA,m_AN8_YA);
         }
         else if(aType==5){
               m_Font="Arial Black";
               m_FontSize=8;            
               m_Space=3; 
               int m_AB8_PA[]={0,14,26,70,100,124,164,170,186,202,209,229,235,241,245,253,285,305,333,359,389,418,449,470,502,533,541,551,573,593,615,639,675,711,758,790,828,868,894,929,967,983,1007,1040,1062,1110,1150,1182,1216,1253,1295,1328,1352,1388,1420,1467,1499,1523,1555,1579,1587,1611,1625,1631,1635,1658,1688,1708,1738,1760,1782,1814,1842,1856,1875,1904,1920,1957,1981,2005,2035,2065,2080,2099,2120,2146,2168,2202,2224,2251,2269,2292,2302,2325,2336,2358,2400,2426,2432,2451,2463,2475,2503,2539,2571,2597,2652,2662,2716,2758,2796,2838,2873,2879,2885,2897,2909,2921,2927,2938,2960,2984,3019,3029,3063,3094,3124,3156,3156,3189,3222,3246,3278,3304,3312,3346,3388,3420,3455,3477,3493,3499,3535,3553,3561,3593,3609,3623,3643,3673,3725,3729,3753,3817,3838,3856,3875,3908,3927,3941,3977,4021,4068,4090,4146,4186,4248,4280,4321,4365,4403,4442,4490,4528,4560,4598,4632,4664,4688,4716,4768,4800,4844,4877,4933,4995,5037,5089,5125,5160,5212,5254,5277,5309,5333,5351,5391,5413,5457,5478,5508,5542,5569,5598,5636,5664,5688,5714,5744,5764,5784,5811,5867,5889,5923,5944,5984,6030,6052,6082,6100,6121,6161,6186};
               int m_AB8_WA[]={2,5,7,5,9,8,2,3,3,3,6,2,3,2,3,5,4,5,5,6,5,5,5,5,5,2,2,6,5,6,6,8,9,7,7,7,6,5,7,7,2,6,8,5,8,7,7,6,7,8,6,6,7,9,11,9,8,6,3,3,3,6,6,3,5,5,5,5,5,5,5,5,2,3,6,2,8,5,5,5,5,4,5,4,5,7,9,7,7,4,4,1,4,6,6,9,5,2,4,5,9,6,6,7,11,12,3,11,7,9,7,6,2,2,5,5,4,6,11,6,10,10,3,9,6,6,6,1,7,7,6,7,5,1,5,6,9,7,7,5,3,9,3,3,6,2,2,4,5,8,2,5,13,5,7,3,6,5,3,9,7,7,5,9,6,12,6,7,7,7,8,8,7,7,7,6,7,6,7,10,9,8,7,10,11,10,10,7,7,11,8,5,5,5,5,7,5,10,5,6,6,6,7,7,6,5,5,5,5,6,7,10,7,7,5,8,9,7,8,5,5,9,5};
               int m_AB8_XA[]={0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,3,4,0,1,3,4,0,1,3,4,2,3,5,6,2,3,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,1,2,4,5,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,3,4,2,1,2,3,0,1,2,3,4,0,1,2,1,2,3,2,3,4,2,3,4,0,1,2,3,4,1,2,3,2,1,2,6,0,3,5,0,3,5,1,2,4,4,6,7,3,5,8,3,5,8,2,6,7,2,3,4,1,2,3,4,5,1,2,4,5,2,3,4,1,2,3,4,5,6,7,0,1,4,5,6,0,1,2,3,4,5,6,7,1,2,3,4,7,0,1,0,1,0,1,2,1,0,1,0,1,0,1,0,1,0,1,0,1,1,2,0,1,1,2,1,2,1,2,1,2,1,2,1,2,1,0,1,0,1,2,1,0,2,2,3,2,3,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,0,1,0,1,1,0,0,1,2,0,1,2,0,1,0,1,2,2,1,1,1,1,0,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,2,3,1,2,3,0,1,2,3,0,2,3,2,3,2,3,2,3,2,3,1,2,3,0,1,2,3,4,0,1,3,4,3,4,2,3,1,2,0,1,2,3,4,0,1,2,3,4,1,2,3,0,1,2,3,4,3,4,2,3,3,4,0,1,3,4,0,1,2,3,4,1,2,3,3,4,2,3,4,2,3,4,1,2,3,4,0,1,3,4,0,1,2,3,4,5,0,1,2,3,4,5,3,4,1,2,3,4,1,2,3,4,0,1,0,1,2,3,0,1,2,3,4,3,4,0,1,2,3,4,1,2,3,1,2,3,0,1,2,3,4,0,1,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,2,3,4,1,2,3,0,1,2,3,4,0,1,2,3,4,3,2,3,2,3,1,2,1,2,1,2,1,2,3,0,1,2,3,4,0,1,3,4,1,2,3,0,1,2,3,4,0,1,3,4,0,1,2,3,4,1,2,3,1,2,3,0,1,2,3,4,0,1,3,4,0,1,2,3,4,1,2,3,4,3,4,0,1,2,3,4,1,2,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,5,2,3,4,5,0,1,2,3,4,0,1,0,1,2,3,4,2,3,4,5,5,0,1,2,3,4,0,1,2,3,4,0,1,2,3,4,0,1,2,3,4,0,0,1,2,3,1,2,3,4,5,4,5,1,2,3,4,5,0,1,2,3,0,1,2,3,4,0,1,2,3,4,5,0,1,4,5,3,4,5,2,3,4,2,3,2,3,2,3,4,5,1,6,0,3,4,5,7,0,2,4,5,7,0,2,4,7,0,2,4,6,0,2,3,4,5,1,6,7,2,3,4,5,3,4,5,3,4,5,2,3,5,6,2,3,5,6,1,2,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,7,8,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,2,3,4,5,1,2,3,4,5,6,0,1,5,6,0,1,0,1,0,1,5,6,1,2,3,4,5,6,2,3,4,5,0,1,2,3,4,0,1,2,3,4,5,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,0,1,2,3,4,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,3,4,0,1,2,3,4,0,1,0,1,2,3,0,1,2,3,0,1,0,1,0,1,2,3,4,5,1,2,3,4,5,6,0,1,5,6,0,1,0,1,4,5,6,0,1,5,6,1,2,3,4,5,6,2,3,4,5,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,4,5,4,5,4,5,4,5,4,5,0,1,4,5,0,1,2,3,4,5,1,2,3,4,0,1,5,6,0,1,4,5,0,1,3,4,0,1,2,3,4,0,1,4,5,0,1,4,5,0,1,5,6,0,1,6,7,0,1,0,1,0,1,0,1,0,1,0,1,0,1,2,3,4,0,1,2,3,4,0,1,6,7,0,1,2,5,6,7,0,1,2,5,6,7,0,1,2,5,6,7,0,1,2,3,4,5,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,5,6,0,1,2,5,6,0,1,2,5,6,0,1,2,3,5,6,0,1,3,4,5,6,0,1,4,5,6,0,1,4,5,6,0,1,5,6,2,3,4,1,2,3,4,5,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,1,2,3,4,5,2,3,4,0,1,2,3,4,0,1,2,3,4,5,0,1,4,5,0,1,4,5,0,1,2,3,4,5,0,1,2,3,4,0,1,0,1,2,3,4,1,2,3,4,5,0,1,5,6,0,1,5,6,0,1,5,6,0,1,3,4,5,6,1,2,3,4,5,2,3,4,5,6,6,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,0,1,4,5,0,1,5,6,0,1,6,7,1,2,3,4,0,1,2,3,4,5,0,1,0,1,2,3,4,2,3,4,5,4,5,0,1,2,3,4,5,1,2,3,4,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,2,3,2,3,2,3,2,3,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,1,2,3,4,5,0,1,7,8,1,2,6,7,1,2,6,7,1,2,3,5,6,7,2,3,5,6,2,3,5,6,3,4,5,3,4,5,0,1,4,5,6,9,10,0,1,4,5,6,9,10,1,4,5,6,9,1,2,4,6,8,9,1,2,3,4,6,7,8,9,2,3,4,6,7,8,2,3,7,8,2,3,7,8,0,1,7,8,1,2,6,7,2,3,5,6,3,4,5,2,3,4,5,6,2,3,5,6,1,2,6,7,0,1,7,8,0,1,6,7,1,2,5,6,2,3,4,5,2,3,4,5,3,4,3,4,3,4,3,4,0,1,2,3,4,5,0,1,2,3,4,5,3,4,2,3,2,3,1,2,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,0,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,2,0,1,2,0,0,1,1,1,1,2,2,0,1,2,0,1,2,1,2,1,2,1,2,1,2,1,2,1,2,0,1,2,0,1,2,2,3,1,2,3,4,1,2,3,4,0,1,4,5,0,1,2,3,4,5,0,1,1,2,1,2,3,0,1,3,4,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,0,1,0,1,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,0,1,2,3,1,2,3,0,1,2,3,4,0,1,0,1,0,1,2,3,4,1,2,3,3,4,3,4,1,2,3,4,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,4,1,2,3,0,1,3,4,0,1,2,3,4,0,1,0,1,2,3,4,1,2,3,1,2,3,4,1,2,0,1,2,3,0,1,2,3,1,2,1,2,1,2,1,2,1,2,3,4,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,4,3,4,0,1,2,3,0,1,0,1,0,1,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,2,1,2,1,2,1,2,1,2,1,2,1,2,0,1,2,0,1,0,1,0,1,0,1,4,5,0,1,3,4,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,4,5,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,3,5,6,0,1,2,3,4,5,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,0,1,2,3,0,1,0,1,1,2,3,4,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,4,3,4,3,4,0,1,3,0,1,2,3,0,1,0,1,0,1,0,1,1,2,3,0,1,4,0,1,2,3,2,3,4,0,3,4,1,2,3,2,1,2,0,1,2,3,0,1,2,3,1,2,1,2,1,2,3,1,2,3,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,0,1,2,3,4,0,1,5,6,1,2,4,5,1,2,4,5,1,2,4,5,2,3,4,2,3,4,0,1,3,4,5,7,8,0,1,3,4,5,7,8,1,2,3,5,6,7,1,2,3,5,6,7,1,2,3,5,6,7,2,6,0,1,5,6,1,2,4,5,2,3,4,2,3,4,1,2,4,5,0,1,5,6,0,1,5,6,1,2,4,5,1,2,4,5,1,2,4,5,2,3,4,2,3,4,2,3,0,1,2,0,1,2,3,0,1,2,3,2,1,0,1,2,3,0,1,2,3,2,3,1,2,3,1,2,1,2,0,1,0,1,2,1,2,1,2,1,2,3,2,3,0,0,0,0,0,0,0,0,0,0,0,1,0,1,2,1,2,1,2,2,3,1,2,3,1,2,1,2,0,1,2,0,1,1,2,5,0,1,2,3,4,5,3,4,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,4,5,6,7,2,3,4,5,6,7,8,2,3,7,8,2,3,5,6,7,8,2,3,5,6,7,2,3,1,2,0,1,2,3,4,0,1,2,3,4,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,2,3,1,2,0,1,3,0,1,2,3,0,1,0,1,0,1,0,1,0,1,3,4,0,1,3,4,1,4,0,3,0,1,4,5,7,8,0,1,4,5,7,8,2,3,2,3,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,2,3,2,3,2,3,2,3,2,3,2,3,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,3,4,5,2,3,4,5,6,1,2,6,0,1,2,3,4,0,1,2,3,4,1,2,6,2,3,4,5,6,3,4,5,1,5,0,2,4,0,2,4,1,3,3,5,9,2,4,6,8,10,2,4,6,8,10,1,5,9,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,6,7,1,2,6,7,8,9,10,1,2,6,7,8,9,10,11,1,2,6,7,10,11,0,1,2,6,7,8,9,10,11,0,1,6,7,8,9,10,1,2,0,1,0,1,0,1,1,2,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,10,0,1,5,6,9,10,0,1,5,6,7,8,9,10,0,1,5,6,7,8,9,3,4,2,3,0,1,4,5,6,0,1,3,4,5,6,0,1,3,4,0,1,2,3,4,0,1,2,3,4,0,1,3,4,5,0,1,4,5,0,1,5,6,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,5,6,7,2,3,4,5,6,7,8,2,3,7,8,2,3,7,8,2,3,7,8,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,3,4,3,4,0,1,2,3,1,2,1,2,4,1,2,3,4,5,1,2,4,5,1,2,4,5,1,2,4,5,1,2,4,5,3,4,5,3,4,1,0,0,1,0,1,0,1,0,1,1,0,1,4,0,3,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,1,4,0,3,1,2,0,1,2,3,0,1,2,3,1,2,0,1,2,3,4,5,0,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,0,1,2,3,4,5,6,8,9,2,5,6,8,9,2,5,6,7,8,9,2,5,7,9,1,2,3,4,5,6,1,2,3,4,5,6,1,2,5,6,1,2,5,6,7,8,0,1,2,5,6,8,9,0,1,5,6,7,8,0,1,1,2,1,2,1,2,0,1,0,1,4,5,0,1,4,5,0,1,2,3,4,5,0,1,2,3,4,5,6,7,0,1,4,5,7,8,0,1,4,5,6,7,3,4,2,3,0,1,3,4,5,0,1,3,4,5,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,4,5,1,2,0,1,2,3,1,2,4,1,2,3,4,5,1,2,4,5,1,2,4,5,1,2,4,5,1,2,4,5,0,1,4,5,0,1,4,5,0,1,4,5,0,1,4,5,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,1,5,2,3,4,0,1,5,6,1,2,4,5,1,2,4,5,2,3,4,2,3,4,2,3,4,0,1,2,3,0,1,2,1,4,2,3,0,1,5,6,1,2,4,5,1,2,4,5,1,2,4,5,2,3,4,2,3,4,2,3,4,0,1,2,3,4,5,4,5,4,5,4,5,4,5,0,1,4,5,0,1,2,3,4,5,1,2,3,4,1,5,0,1,2,3,4,5,6,1,2,3,4,5,1,2,4,5,1,2,3,4,5,0,1,2,3,4,5,6,1,5,3,4,3,4,0,1,2,3,4,0,1,2,3,4,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,1,2,3,0,1,2,3,4,0,1,1,2,3,0,1,3,4,0,1,3,4,1,2,3,3,4,0,1,2,3,4,1,2,3,2,4,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,2,3,4,5,6,1,7,0,3,4,5,6,8,0,2,8,0,2,8,0,3,4,5,6,8,1,7,2,3,4,5,6,2,3,4,5,1,2,3,4,5,6,0,1,5,0,1,2,3,0,1,2,3,0,1,5,6,1,2,3,4,5,6,2,3,4,5,2,3,4,5,6,1,2,3,4,5,0,1,3,4,1,2,4,5,2,3,5,6,0,1,2,3,4,0,1,2,3,4,3,4,3,4,3,4,0,1,2,0,1,2,2,3,4,5,6,1,7,0,2,3,4,5,6,8,0,2,6,8,0,2,3,4,5,8,0,2,5,6,8,1,7,2,3,4,5,6,0,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,2,0,2,0,1,2,2,3,2,3,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,2,3,2,3,0,1,2,3,0,1,2,3,0,1,0,1,0,1,0,1,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,0,1,2,3,4,0,1,0,1,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,0,1,2,3,5,6,0,1,2,3,5,6,1,2,3,5,6,2,3,5,6,2,3,5,6,2,3,5,6,2,3,5,6,2,3,5,6,0,1,0,1,1,3,1,2,3,0,1,3,4,0,1,2,3,4,0,1,0,1,2,3,4,1,2,3,0,1,5,6,0,1,2,5,6,0,1,2,5,6,9,10,11,0,1,2,3,5,6,8,9,11,12,0,1,3,4,5,6,8,9,11,12,0,1,3,4,5,6,8,9,11,12,0,1,4,5,6,9,10,11,0,1,5,6,8,9,10,11,12,1,2,3,0,1,2,3,4,0,1,2,0,1,0,1,2,3,4,1,2,3,0,1,4,1,2,5,2,3,5,6,1,2,4,5,0,1,3,4,1,2,1,2,1,2,1,2,1,2,1,2,1,2,0,1,2,0,1,1,2,3,4,0,1,2,3,4,5,0,1,0,1,2,3,4,2,3,4,5,4,5,0,1,2,3,4,5,1,2,3,4,1,2,3,0,1,4,0,1,2,3,2,3,4,0,3,4,1,2,3,0,2,0,1,0,1,0,1,0,1,0,1,0,1,3,4,5,3,4,5,2,3,5,6,2,3,5,6,1,2,6,7,1,2,3,4,5,6,7,1,2,3,4,5,6,7,0,1,7,8,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,0,1,2,3,4,0,1,2,3,4,0,1,0,1,0,1,0,1,0,1,0,1,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,6,7,1,2,6,7,1,2,6,7,1,2,6,7,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,0,1,7,8,0,1,7,8,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,0,1,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,5,6,9,10,11,0,1,2,3,5,6,8,9,10,11,1,2,3,5,6,8,9,10,2,3,4,5,6,7,8,9,2,3,4,5,6,7,8,9,1,2,3,5,6,8,9,10,1,2,5,6,9,10,0,1,5,6,10,11,1,2,3,4,0,1,2,3,4,5,4,5,2,3,4,5,2,3,4,5,4,5,0,1,2,3,4,5,1,2,3,4,0,1,5,6,0,1,4,5,6,0,1,4,5,6,0,1,3,4,5,6,0,1,2,3,5,6,0,1,2,3,5,6,0,1,2,5,6,0,1,5,6,2,4,3,0,1,5,6,0,1,4,5,6,0,1,4,5,6,0,1,3,4,5,6,0,1,2,3,5,6,0,1,2,3,5,6,0,1,2,5,6,0,1,5,6,0,1,4,5,6,0,1,3,4,5,6,0,1,3,4,0,1,2,3,4,0,1,2,3,4,0,1,3,4,5,0,1,4,5,0,1,5,6,1,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,6,7,1,2,6,7,1,2,6,7,1,2,6,7,0,1,2,6,7,0,1,6,7,0,1,6,7,0,1,2,5,6,7,0,1,2,5,6,7,0,1,2,5,6,7,0,1,2,3,4,5,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,5,6,0,1,5,6,0,1,5,6,2,3,4,1,2,3,4,5,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,1,2,3,4,5,2,3,4,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,0,1,2,3,4,5,0,1,4,5,0,1,4,5,0,1,2,3,4,5,0,1,2,3,4,0,1,0,1,2,3,4,5,1,2,3,4,5,6,0,1,5,6,0,1,0,1,0,1,5,6,1,2,3,4,5,6,2,3,4,5,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,2,3,2,3,2,3,2,3,0,1,5,6,1,2,4,5,1,2,4,5,2,3,4,2,3,4,2,3,4,0,1,2,3,0,1,2,4,5,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,2,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,4,5,0,1,7,8,1,2,6,7,2,3,5,6,3,4,5,2,3,4,5,6,2,3,5,6,1,2,6,7,0,1,7,8,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,6,7,6,7,0,1,5,6,0,1,5,6,0,1,5,6,0,1,5,6,0,1,2,3,4,5,6,1,2,3,4,5,6,5,6,5,6,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,2,3,4,5,6,7,8,9,10,0,1,2,3,4,5,6,7,8,9,10,9,10,9,10,0,1,2,3,4,0,1,2,3,4,3,4,3,4,5,6,7,8,3,4,5,6,7,8,9,3,4,8,9,3,4,5,6,7,8,9,3,4,5,6,7,8,0,1,8,9,0,1,8,9,0,1,8,9,0,1,2,3,4,5,8,9,0,1,2,3,4,5,6,8,9,0,1,5,6,8,9,0,1,2,3,4,5,6,8,9,0,1,2,3,4,5,8,9,0,1,0,1,0,1,0,1,2,3,4,5,0,1,2,3,4,5,6,0,1,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,1,2,3,4,0,1,2,3,4,5,1,5,6,3,4,5,6,3,4,5,6,0,1,5,6,0,1,2,3,4,5,1,2,3,4,0,1,6,7,8,0,1,5,6,7,8,9,0,1,4,5,9,10,0,1,2,3,4,5,9,10,0,1,2,3,4,5,9,10,0,1,4,5,9,10,0,1,5,6,7,8,9,0,1,6,7,8,2,3,4,5,6,7,1,2,3,4,5,6,7,1,2,6,7,1,2,3,4,5,6,7,2,3,4,5,6,7,2,3,6,7,1,2,6,7,0,1,6,7,1,2,3,0,1,3,4,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,4,0,1,2,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,0,1,2,3,0,1,3,4,0,1,2,3,0,1,3,4,0,1,3,4,0,1,2,3,0,1,2,3,4,0,1,2,3,4,0,1,0,1,0,1,0,1,1,2,3,4,5,1,2,3,4,5,1,2,4,5,1,2,4,5,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,5,6,0,1,5,6,1,2,3,0,1,3,4,0,1,2,3,4,0,1,0,1,2,3,4,1,2,3,0,1,2,4,5,7,8,9,0,1,2,4,5,7,8,9,1,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,1,2,4,5,7,8,0,1,4,5,8,9,1,2,3,4,0,1,2,3,4,2,3,3,4,0,1,2,3,4,1,2,3,0,1,4,5,0,1,3,4,5,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,4,5,0,1,4,5,1,4,2,3,0,1,4,5,0,1,3,4,5,0,1,2,3,4,5,0,1,2,3,4,5,0,1,2,4,5,0,1,4,5,0,1,3,4,5,0,1,3,4,5,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,4,5,1,2,3,4,5,6,1,2,3,4,5,6,1,2,5,6,1,2,5,6,0,1,2,5,6,0,1,5,6,0,1,2,4,5,6,0,1,2,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,2,3,4,5,6,0,1,3,5,6,0,1,4,5,0,1,4,5,0,1,2,3,4,5,0,1,2,3,4,5,0,1,4,5,0,1,4,5,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,0,1,2,3,4,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,3,4,0,1,2,3,0,1,2,3,4,0,1,3,4,0,1,3,4,0,1,2,3,4,0,1,2,3,0,1,0,1,1,2,3,0,1,2,3,4,0,1,0,1,0,1,2,3,4,1,2,3,0,1,2,3,4,5,0,1,2,3,4,5,2,3,2,3,2,3,2,3,0,1,5,6,1,2,4,5,1,2,4,5,1,2,4,5,2,3,4,2,3,4,2,3,0,1,2,4,5,4,5,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,9,0,1,4,5,8,9,0,1,4,5,8,9,0,1,2,3,4,5,6,7,8,9,1,2,3,4,5,6,7,8,4,5,4,5,0,1,5,6,1,2,4,5,2,3,4,2,3,4,1,2,4,5,0,1,5,6,0,1,4,5,0,1,4,5,0,1,4,5,0,1,4,5,0,1,2,3,4,5,6,0,1,2,3,4,5,6,5,6,5,6,0,1,3,4,0,1,3,4,0,1,2,3,4,1,2,3,4,3,4,3,4,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,3,4,6,7,0,1,2,3,4,5,6,7,8,0,1,2,3,4,5,6,7,8,7,8,7,8,0,1,2,3,0,1,2,3,2,3,2,3,4,5,2,3,5,6,2,3,4,5,0,1,6,7,0,1,6,7,0,1,6,7,0,1,2,3,6,7,0,1,3,4,6,7,0,1,2,3,6,7,0,1,0,1,0,1,0,1,2,3,0,1,3,4,0,1,2,3,1,2,3,0,1,2,3,4,2,3,4,3,4,0,1,2,3,4,1,2,3,0,1,5,6,7,0,1,4,5,6,7,8,0,1,2,3,4,5,7,8,0,1,2,3,4,5,7,8,0,1,4,5,6,7,8,0,1,5,6,7,0,1,2,3,4,0,1,3,4,0,1,3,4,1,2,3,4,1,2,3,4,0,1,3,4};
               int m_AB8_YA[]={4,4,5,5,6,6,7,7,8,8,10,10,11,11,4,4,4,4,5,5,5,5,6,6,6,6,4,4,4,4,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,3,4,4,4,5,5,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,11,11,11,12,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,4,4,5,5,6,6,4,5,6,6,7,7,8,8,9,9,10,10,11,11,12,13,4,5,6,6,7,7,8,8,9,9,10,10,11,11,12,13,4,5,5,5,6,7,7,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,10,10,10,10,11,11,12,13,8,8,8,9,9,9,10,10,11,11,4,5,6,7,8,9,10,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,4,4,5,5,5,6,6,6,6,7,7,7,8,8,9,9,10,10,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,11,11,11,11,11,4,4,4,5,5,5,5,5,6,6,7,7,8,8,9,9,9,9,10,10,10,10,10,11,11,11,4,4,5,5,5,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,4,4,4,4,5,5,5,5,6,6,7,7,7,7,8,8,8,8,8,9,9,10,10,10,10,10,11,11,11,4,4,4,5,5,5,5,5,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,4,4,5,5,5,5,5,6,7,7,8,8,9,9,10,10,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,10,10,10,10,10,11,11,11,6,6,7,7,10,10,11,11,6,6,7,7,10,10,11,11,12,13,5,6,6,6,6,7,7,7,7,7,8,8,9,9,9,9,9,10,10,10,10,11,6,6,6,6,6,7,7,7,7,7,9,9,9,9,9,10,10,10,10,10,5,6,6,6,6,7,7,7,7,7,8,8,9,9,9,9,9,10,10,10,10,11,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,7,8,8,8,9,9,11,11,4,4,4,4,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,12,12,12,12,4,4,4,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,4,5,5,5,5,5,6,6,7,7,7,7,8,8,8,8,9,9,10,10,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,7,7,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,11,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,10,10,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,11,11,11,11,11,12,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,8,8,8,8,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,9,9,10,10,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,13,13,13,4,5,6,7,8,9,10,11,4,4,4,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,13,13,13,4,4,5,5,5,5,6,6,6,6,7,7,7,7,13,13,13,13,13,13,4,4,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,4,4,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,6,6,6,7,7,7,7,7,8,8,9,9,10,10,10,10,10,11,11,11,4,4,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,6,6,6,7,7,7,7,8,8,8,8,8,9,9,10,10,10,10,10,11,11,11,4,4,4,4,5,5,6,6,6,6,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,12,12,13,13,13,13,4,4,5,5,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,6,6,7,7,8,8,9,9,10,10,11,11,4,4,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,13,13,4,4,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,12,12,13,13,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,12,12,13,13,6,6,6,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,4,5,5,6,6,6,6,7,7,7,7,8,8,9,9,10,10,10,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,11,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,6,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,11,12,12,13,13,13,6,6,6,6,7,7,7,7,8,9,10,10,10,10,11,11,11,11,4,4,5,5,5,6,6,7,7,8,8,9,9,9,10,10,11,11,12,12,12,13,13,4,5,6,7,8,9,10,11,12,13,4,4,5,5,5,6,6,7,7,8,8,9,9,9,10,10,11,11,12,12,12,13,13,6,6,6,7,7,7,7,7,7,8,8,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,1,1,2,2,4,4,4,4,4,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,10,10,11,11,12,13,3,3,4,4,6,6,6,7,7,7,7,8,8,9,9,10,10,11,11,10,10,10,10,11,11,11,11,12,12,13,13,10,10,10,10,10,10,11,11,11,11,11,11,4,4,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,9,9,10,10,11,11,12,12,13,13,4,4,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,13,13,4,4,4,5,5,5,5,5,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,10,10,10,10,10,11,11,11,4,4,5,5,5,6,6,6,7,7,8,8,8,9,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,1,1,2,2,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,13,13,4,4,4,4,5,5,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,13,13,4,5,6,6,7,7,4,4,5,5,6,7,4,4,5,5,6,6,6,6,7,7,7,7,4,4,4,4,5,5,5,5,6,6,7,7,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,11,11,11,4,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,7,7,8,8,9,9,10,10,11,11,6,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,3,3,4,4,6,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,11,4,4,5,5,5,5,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,12,12,13,13,1,1,2,2,2,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,11,11,11,3,3,4,4,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,11,12,12,12,13,13,13,13,4,4,5,5,6,6,7,7,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,5,5,6,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,10,10,10,10,11,11,2,2,3,3,4,4,4,4,4,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,5,6,7,10,11,12,13,4,4,4,5,5,5,5,5,6,6,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,12,12,12,12,12,13,13,13,2,2,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,4,5,5,6,6,6,6,6,6,7,7,7,8,8,8,9,9,9,9,9,9,10,10,11,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,6,7,7,7,7,7,8,8,9,9,10,10,8,8,8,9,9,9,4,4,4,4,4,5,5,6,6,6,6,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,10,10,11,11,11,11,11,2,2,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,5,5,6,6,6,3,3,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,8,8,10,10,10,10,10,10,11,11,11,11,11,11,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,6,6,7,7,8,8,9,9,10,10,11,11,4,4,5,5,6,6,6,6,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,11,12,12,13,13,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,12,12,13,13,13,13,7,7,8,8,4,4,6,6,6,7,7,7,7,8,8,8,8,8,9,9,10,10,10,10,10,11,11,11,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,6,6,6,7,7,7,7,7,8,8,8,9,9,10,10,10,10,10,11,11,11,7,7,7,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,6,6,7,7,8,8,9,9,10,10,11,11,12,12,12,13,13,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,8,8,8,8,9,9,10,10,10,10,10,10,11,11,11,11,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,10,11,11,11,4,4,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,4,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,12,12,13,13,13,13,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,7,7,7,7,8,8,8,8,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,11,11,11,11,1,1,2,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,11,11,11,11,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,10,10,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,6,7,7,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,7,8,8,9,9,10,10,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,11,11,11,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,13,13,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,12,12,13,13,4,4,4,4,4,5,5,5,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,4,4,5,5,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,4,4,4,4,5,5,5,5,5,5,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,11,11,11,11,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,7,7,7,7,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,11,4,4,4,4,5,5,5,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,6,7,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,12,12,13,13,13,13,6,6,6,7,7,7,7,8,8,8,8,8,9,9,10,10,10,10,10,11,11,11,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,6,6,6,6,7,7,7,7,7,8,8,9,9,10,10,10,10,10,11,11,11,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,11,11,11,11,3,3,4,4,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,11,11,11,11,6,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,6,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,7,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,11,11,11,11,12,12,13,13,6,6,6,7,7,7,7,7,8,8,9,9,10,10,10,10,10,11,11,11,6,6,6,6,6,6,7,7,7,7,7,7,8,8,9,9,10,10,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,11,11,11,12,12,13,13,13,4,4,5,5,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,12,12,13,13,6,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,11,11,12,12,13,13,6,6,6,6,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,11,11,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,12,12,13,13,6,6,6,6,7,7,7,7,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,6,6,7,7,8,8,9,9,9,9,10,10,10,10,11,11,11,11,6,6,6,7,7,7,7,7,8,8,8,9,9,10,10,10,10,10,11,11,11,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,6,6,6,6,6,7,7,7,7,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11};
               CopyFonts(m_AB8_PA,m_AB8_WA,m_AB8_XA,m_AB8_YA);
         }
         else if(aType==6){
               m_Font="Courier New";
               m_FontSize=8;           
               m_Space=7; 
               int m_CN8_PA[]={0,6,12,34,47,59,72,75,83,91,100,111,116,121,123,131,147,159,173,187,203,218,234,246,263,279,283,290,298,308,316,325,347,365,387,401,419,440,458,475,500,515,528,550,565,592,618,634,651,670,689,706,721,740,758,780,797,813,830,840,848,858,863,870,872,889,907,919,937,952,966,985,1004,1016,1029,1048,1060,1080,1097,1109,1128,1147,1159,1172,1185,1200,1214,1230,1243,1260,1275,1285,1293,1303,1309,1331,1352,1369,1372,1387,1393,1396,1407,1423,1441,1457,1481,1486,1511,1533,1554,1579,1603,1607,1610,1616,1622,1631,1636,1643,1665,1686,1705,1710,1731,1751,1771,1792,1792,1813,1833,1846,1862,1876,1882,1900,1923,1946,1963,1973,1981,1986,2013,2030,2038,2053,2068,2080,2092,2110,2136,2140,2157,2185,2199,2209,2222,2239,2252,2265,2283,2305,2327,2342,2367,2388,2411,2427,2452,2482,2502,2523,2550,2575,2591,2614,2631,2645,2660,2676,2697,2714,2739,2759,2786,2815,2836,2861,2879,2896,2922,2941,2958,2977,2992,3005,3024,3039,3058,3073,3092,3116,3134,3151,3171,3192,3204,3223,3242,3254,3269,3284,3306,3319,3339,3354,3375,3397,3414,3436,3451,3465,3485,3503};
               int m_CN8_WA[]={0};
               int m_CN8_XA[]={3,3,3,3,3,3,2,4,2,4,2,4,3,5,2,4,1,2,3,4,5,2,4,2,4,1,2,3,4,5,2,4,1,3,3,2,3,4,1,2,3,4,1,2,3,2,2,2,1,3,2,1,2,3,4,3,2,4,3,3,4,2,2,1,3,4,1,4,2,3,4,5,3,3,3,4,4,3,3,3,3,4,4,2,2,3,3,3,3,2,2,3,1,2,3,4,5,3,2,4,3,3,3,1,2,3,4,5,3,3,3,3,4,2,3,2,1,2,3,4,5,2,3,5,4,4,3,3,2,2,1,2,3,4,1,5,1,5,1,5,1,5,1,5,2,3,4,2,3,3,3,3,3,3,1,2,3,4,5,2,3,4,1,5,4,3,2,1,1,2,3,4,5,2,3,4,1,5,5,3,4,5,1,5,2,3,4,4,3,4,2,4,1,4,1,2,3,4,5,4,3,4,5,2,3,4,5,2,2,2,3,4,5,1,5,2,3,4,3,4,5,2,1,1,2,3,4,1,5,1,5,2,3,4,1,2,3,4,5,1,5,5,4,4,3,3,2,3,4,1,5,1,5,2,3,4,1,5,1,5,2,3,4,2,3,4,1,5,1,5,2,3,4,5,5,4,1,2,3,2,3,2,3,3,4,3,4,2,3,2,5,3,4,1,2,3,4,5,1,2,3,4,5,1,2,3,4,5,1,2,3,4,5,2,3,1,2,3,1,4,4,3,3,2,3,2,3,4,1,5,1,4,5,1,3,5,1,3,5,1,4,5,1,2,3,4,5,2,3,3,2,4,2,4,2,3,4,1,5,0,1,2,4,5,6,0,1,2,3,4,1,5,1,5,1,2,3,4,1,5,1,5,0,1,2,3,4,2,3,4,5,1,5,1,1,1,1,5,2,3,4,0,1,2,3,1,4,1,5,1,5,1,5,1,4,0,1,2,3,1,2,3,4,5,2,5,2,4,2,3,4,2,4,2,5,1,2,3,4,5,1,2,3,4,5,2,5,2,4,2,3,4,2,4,2,1,2,3,2,3,4,5,1,5,1,1,1,4,5,6,1,5,2,3,4,0,1,2,4,5,6,1,5,1,5,1,2,3,4,5,1,5,1,5,0,1,2,4,5,6,1,2,3,4,5,3,3,3,3,3,1,2,3,4,5,2,3,4,5,4,4,4,1,4,1,4,2,3,0,1,2,4,5,6,1,5,1,4,1,2,3,1,4,1,5,0,1,2,5,6,1,2,3,2,2,2,2,5,2,5,1,2,3,4,5,0,1,2,4,5,6,1,2,4,5,1,2,4,5,1,3,5,1,5,1,5,0,1,2,4,5,6,0,1,2,4,5,6,1,2,5,1,2,5,1,3,5,1,3,5,1,4,5,0,1,2,4,5,2,3,4,1,5,1,5,1,5,1,5,1,5,2,3,4,1,2,3,4,2,5,2,5,2,5,2,3,4,2,1,2,3,2,3,4,1,5,1,5,1,5,1,5,1,5,2,3,4,3,4,5,1,2,3,4,2,5,2,5,2,5,2,3,4,2,5,1,2,3,6,2,3,5,1,4,5,1,2,3,4,5,1,5,1,2,3,4,1,2,3,4,5,1,3,5,3,3,3,3,2,3,4,0,1,2,4,5,6,1,5,1,5,1,5,1,5,1,5,2,3,4,0,1,2,4,5,6,1,5,1,5,1,4,2,4,2,4,2,3,0,1,2,4,5,6,1,5,1,3,5,1,3,5,1,3,5,1,3,5,2,4,0,1,5,6,1,5,2,4,3,2,4,1,5,0,1,5,6,0,1,2,4,5,6,1,5,2,4,3,3,3,2,3,4,1,2,3,4,5,1,5,4,3,2,1,5,1,2,3,4,5,3,4,3,3,3,3,3,3,3,4,1,2,2,3,3,3,4,4,2,3,3,3,3,3,3,3,2,3,3,2,4,1,5,0,1,2,3,4,5,6,2,3,2,3,4,1,5,2,3,4,5,1,5,1,2,3,4,5,6,0,1,1,1,3,4,1,2,5,1,5,1,5,0,1,2,3,4,2,3,4,5,1,5,1,1,2,3,4,5,4,5,5,2,3,5,1,4,5,1,5,1,5,2,3,4,5,6,2,3,4,1,5,1,2,3,4,5,1,2,3,4,5,4,5,3,2,3,4,5,3,3,3,2,3,4,5,2,3,5,6,1,4,5,1,5,1,5,2,3,4,5,5,2,3,4,0,1,1,1,3,4,1,2,5,1,5,1,5,0,1,2,4,5,6,3,1,2,3,3,3,3,1,2,3,4,5,3,1,2,3,4,4,4,4,4,4,1,2,3,0,1,1,1,3,4,5,1,4,1,2,3,1,4,0,1,3,4,5,2,3,3,3,3,3,3,1,2,3,4,5,0,1,2,4,1,3,5,1,3,5,1,3,5,0,1,2,3,4,5,6,0,1,3,4,1,2,5,1,5,1,5,0,1,2,4,5,6,2,3,4,1,5,1,5,1,5,2,3,4,0,1,3,4,1,2,5,1,5,1,5,1,2,3,4,1,0,1,2,2,3,5,6,1,4,5,1,5,1,5,2,3,4,5,5,4,5,6,1,2,4,5,2,3,2,2,1,2,3,4,2,3,4,5,1,2,3,4,5,1,2,3,4,1,0,1,2,3,4,1,1,1,5,2,3,4,0,1,4,5,1,5,1,5,1,4,5,2,3,5,6,0,1,2,4,5,6,1,5,1,4,2,4,2,3,0,1,2,4,5,6,1,5,1,3,5,1,3,5,2,4,1,2,4,5,2,4,3,2,4,1,2,4,5,0,1,2,4,5,6,1,5,2,4,2,4,3,3,1,2,3,1,2,3,4,5,1,4,3,2,5,1,2,3,4,5,4,3,3,3,2,3,3,3,3,4,3,3,3,3,3,3,3,3,2,3,3,3,3,4,3,3,3,2,2,3,5,1,3,4,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,0,1,2,3,4,0,2,2,4,5,2,3,6,2,6,2,6,1,2,3,5,4,3,1,2,3,4,5,2,5,2,5,2,2,2,1,2,3,3,2,1,4,3,1,2,3,4,5,2,5,2,5,2,1,2,3,2,5,1,4,0,3,1,3,5,3,3,1,2,3,4,5,3,3,3,3,3,3,1,2,3,4,5,3,3,1,2,3,4,5,3,3,2,3,4,5,1,5,1,0,1,2,3,4,1,1,5,2,3,4,0,1,0,1,4,2,3,1,1,2,4,5,1,2,4,5,1,2,3,4,5,2,4,2,4,2,4,5,2,4,6,0,2,4,6,0,1,3,4,5,3,2,1,2,3,0,1,3,4,0,3,0,3,0,1,2,3,4,5,0,3,6,0,3,6,0,1,3,4,5,4,3,1,2,3,5,6,2,5,2,4,2,3,2,4,2,5,1,2,3,5,6,0,1,2,3,4,0,2,2,4,2,3,5,2,5,2,5,1,2,3,5,6,0,1,2,4,5,6,1,5,1,5,1,5,1,5,1,5,0,1,2,3,4,5,6,3,3,1,0,1,2,3,1,1,2,3,4,5,1,5,1,5,0,1,2,5,5,2,3,4,5,2,3,3,4,3,2,1,0,3,1,4,2,5,3,6,2,5,1,4,2,3,4,2,3,4,2,3,4,1,2,3,4,5,0,1,2,3,4,5,6,0,1,2,3,4,5,0,5,0,5,0,5,0,5,0,5,0,1,2,3,4,5,0,1,2,3,5,6,0,2,3,5,6,0,2,4,6,0,1,2,3,5,6,0,1,2,3,4,1,3,1,3,4,5,1,3,5,0,1,3,4,5,3,4,5,4,3,0,1,3,4,1,3,1,2,3,4,5,6,1,3,6,0,1,3,4,5,6,3,2,0,1,2,4,5,1,3,5,1,2,3,1,4,0,1,2,4,5,1,0,1,2,3,1,1,2,3,4,1,5,1,5,0,1,2,4,5,6,0,1,2,4,5,6,1,5,1,5,1,5,0,1,2,3,4,5,6,3,3,2,4,2,3,4,0,1,2,4,5,6,1,5,2,4,2,4,3,2,1,2,2,4,2,3,4,1,2,4,5,1,5,2,4,2,4,3,1,3,1,2,2,3,4,5,4,4,4,1,4,1,4,2,3,1,6,2,3,4,5,2,5,2,5,2,3,4,5,1,6,5,1,2,3,4,5,2,2,2,2,2,1,2,3,3,3,3,3,3,3,2,3,4,1,4,1,2,1,3,2,4,3,4,1,4,1,2,3,2,4,1,2,3,4,5,2,5,2,4,2,3,4,2,4,2,5,1,2,3,4,5,2,3,4,1,5,0,2,3,4,6,0,2,6,0,2,3,4,6,1,5,2,3,4,2,3,4,5,1,5,1,1,2,3,4,1,1,2,3,4,5,3,6,2,5,1,4,2,5,3,6,0,1,2,3,4,5,5,5,1,2,3,4,5,2,3,4,1,2,3,4,5,0,2,4,6,0,2,3,6,0,1,2,3,4,6,1,5,2,3,4,2,4,1,2,3,4,5,3,3,3,3,3,1,2,3,4,5,2,3,4,2,4,2,3,4,3,3,3,1,2,3,4,5,3,3,1,2,3,4,5,1,2,3,4,5,3,3,3,3,3,1,2,3,4,5,3,1,2,3,3,3,3,1,2,3,4,5,5,1,2,3,4,5,2,2,2,1,2,3,0,1,4,5,1,5,1,5,1,5,1,2,3,4,5,6,1,1,1,2,3,4,5,6,0,3,5,0,3,5,1,2,3,5,3,5,3,5,3,5,2,3,5,6,2,3,2,3,2,4,2,3,4,1,5,1,2,3,4,5,1,2,3,4,5,0,1,3,4,5,1,2,4,6,1,2,4,6,1,3,4,6,1,3,4,1,3,4,6,0,1,2,4,2,3,4,5,1,5,1,2,3,1,2,3,4,5,0,3,1,4,2,5,1,4,0,3,3,1,2,3,4,4,4,4,4,4,1,2,3,2,3,5,1,4,5,1,2,3,4,5,1,5,1,2,3,4,2,3,4,5,1,2,3,4,5,1,2,3,4,2,4,1,2,3,3,3,3,1,2,3,4,5,2,3,3,2,4,2,4,2,3,4,1,5,0,1,2,4,5,6,0,1,2,3,4,5,1,5,1,1,2,3,4,1,5,1,5,0,1,2,3,4,0,1,2,3,4,1,5,1,5,1,2,3,4,1,5,1,5,0,1,2,3,4,1,2,3,4,5,2,5,2,5,2,2,2,1,2,3,1,2,3,4,5,2,4,2,4,2,4,2,4,1,4,0,1,2,3,4,5,0,5,0,5,1,2,3,4,5,2,5,2,4,2,3,4,2,4,2,5,1,2,3,4,5,0,1,3,5,6,1,3,5,2,3,4,3,2,3,4,1,3,5,0,1,3,5,6,1,3,4,1,2,5,5,2,3,4,5,5,1,2,3,4,0,1,2,5,6,1,4,5,1,3,5,1,3,5,1,2,5,1,2,5,0,1,4,5,6,2,4,2,3,4,0,1,2,5,6,1,4,5,1,3,5,1,3,5,1,2,5,1,2,5,0,1,4,5,6,1,2,3,5,6,2,5,2,4,2,3,2,4,2,5,1,2,3,5,6,1,2,3,4,5,6,2,5,2,5,2,5,2,5,2,5,0,1,4,5,6,0,1,2,4,5,6,1,2,4,5,1,2,4,5,1,3,5,1,5,1,5,0,1,2,4,5,6,0,1,2,4,5,6,1,5,1,5,1,2,3,4,5,1,5,1,5,0,1,2,4,5,6,2,3,4,1,5,1,5,1,5,1,5,1,5,2,3,4,0,1,2,3,4,5,6,1,5,1,5,1,5,1,5,1,5,0,1,2,4,5,6,1,2,3,4,2,5,2,5,2,5,2,3,4,2,1,2,3,2,3,4,5,1,5,1,1,1,1,5,2,3,4,1,2,3,4,5,1,3,5,3,3,3,3,2,3,4,0,1,2,4,5,6,1,5,2,4,2,4,3,2,1,2,2,3,4,3,1,2,3,4,5,1,3,5,1,2,3,4,5,3,2,3,4,0,1,5,6,1,5,2,4,3,2,4,1,5,0,1,5,6,0,1,2,4,5,6,1,5,1,5,1,5,1,5,1,5,0,1,2,3,4,5,6,6,6,0,1,2,4,5,6,1,5,1,5,1,4,5,2,3,5,5,4,5,6,0,1,3,5,6,1,3,5,1,3,5,1,3,5,1,3,5,1,3,5,0,1,2,3,4,5,6,0,1,3,5,6,1,3,5,1,3,5,1,3,5,1,3,5,1,3,5,0,1,2,3,4,5,6,6,6,0,1,2,3,0,2,0,2,2,3,4,5,2,6,2,6,1,2,3,4,5,0,1,2,4,5,6,1,5,1,5,1,2,5,1,3,5,1,3,5,0,1,2,4,5,6,0,1,2,1,1,1,2,3,4,1,5,1,5,0,1,2,3,4,1,2,3,4,1,5,5,2,3,4,5,5,5,1,2,3,4,0,1,2,4,5,1,3,6,1,3,6,1,2,3,6,1,3,6,1,3,6,0,1,2,4,5,3,4,5,6,2,5,2,5,2,5,3,4,5,2,5,1,4,5,6,2,3,4,1,5,2,3,4,5,1,5,1,2,3,4,5,6,4,1,2,3,4,1,1,3,4,1,2,5,1,5,1,5,2,3,4,1,2,3,4,2,5,2,3,4,2,5,1,2,3,4,1,2,3,4,5,2,5,2,5,2,1,2,3,1,2,3,4,5,2,4,2,4,2,4,0,1,2,3,4,5,0,5,2,3,4,1,5,1,2,3,4,5,1,2,3,4,5,0,1,3,5,6,1,3,5,2,3,4,1,3,5,0,1,3,5,6,1,2,3,4,5,5,2,3,4,5,1,2,3,4,5,0,1,2,5,6,1,4,5,1,3,5,1,2,5,0,1,4,5,6,2,4,2,3,4,0,1,2,5,6,1,4,5,1,3,5,1,2,5,0,1,4,5,6,0,1,2,4,5,1,3,5,1,2,3,1,4,0,1,2,4,5,1,2,3,4,5,6,2,5,2,5,2,5,0,1,4,5,6,0,1,5,6,1,2,4,5,1,3,5,1,3,5,0,1,2,4,5,6,0,1,2,4,5,6,1,5,1,2,3,4,5,1,5,0,1,2,4,5,6,2,3,4,1,5,1,5,1,5,2,3,4,0,1,2,3,4,5,6,1,5,1,5,1,5,0,1,2,4,5,6,0,1,3,4,1,2,5,1,5,1,5,1,2,3,4,1,0,1,2,2,3,4,5,1,5,1,1,2,3,4,5,1,2,3,4,5,1,3,5,1,3,5,3,2,3,4,1,2,4,5,1,5,2,4,2,4,3,1,3,1,2,2,3,3,2,3,4,1,3,5,1,3,5,1,3,5,2,3,4,3,2,3,4,1,2,4,5,2,4,3,2,4,1,2,4,5,0,1,2,4,5,6,1,5,1,5,1,5,0,1,2,3,4,5,6,6,0,1,2,4,5,1,4,1,2,3,4,4,3,4,5,0,1,3,5,6,1,3,5,1,3,5,1,3,5,0,1,2,3,4,5,6,0,1,3,5,6,1,3,5,1,3,5,1,3,5,0,1,2,3,4,5,6,6,0,1,2,3,0,2,2,3,4,5,2,5,1,2,3,4,5,0,1,2,4,5,6,1,5,1,2,3,5,1,3,5,0,1,2,3,4,5,6,1,2,3,2,2,3,4,5,2,5,1,2,3,4,5,1,2,3,4,1,5,3,4,5,5,1,2,3,4,0,1,2,4,5,1,3,6,1,2,3,6,1,3,6,0,1,2,4,5,1,2,3,4,5,1,4,1,2,3,4,1,4,0,1,3,4,5};
               int m_CN8_YA[]={4,5,6,7,8,10,4,4,5,5,6,6,4,4,5,5,6,6,6,6,6,7,7,8,8,9,9,9,9,9,10,10,11,11,4,5,5,5,6,7,7,8,9,9,9,10,11,4,5,5,6,7,7,7,7,8,9,9,10,5,5,6,7,8,8,8,9,9,10,10,10,10,4,5,6,4,5,6,7,8,9,10,11,4,5,6,7,8,9,10,11,4,5,5,5,5,5,6,7,7,4,5,6,7,7,7,7,7,8,9,10,10,10,11,11,12,7,7,7,7,7,10,10,4,5,6,7,8,9,10,11,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,4,4,5,6,7,8,9,10,10,10,10,10,4,4,4,5,5,6,7,8,9,10,10,10,10,10,4,4,4,5,5,6,7,7,8,9,9,10,10,10,4,5,5,6,6,7,7,8,8,8,8,8,9,10,10,10,4,4,4,4,5,6,7,7,7,8,9,9,10,10,10,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,10,4,4,4,4,4,5,5,6,7,8,9,10,4,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,10,4,4,4,5,5,6,6,7,7,7,7,8,9,10,10,10,6,6,10,10,6,6,9,9,10,10,11,5,6,6,7,7,8,8,9,6,6,6,6,6,8,8,8,8,8,5,6,6,7,7,8,8,9,4,4,5,5,6,7,8,10,10,4,4,4,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,11,11,11,11,4,4,5,6,6,7,7,8,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,5,5,6,7,8,9,9,10,10,10,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,7,8,8,9,10,10,10,4,4,4,4,5,5,6,7,8,8,8,8,9,9,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,5,6,7,8,9,10,10,10,10,10,4,4,4,4,5,6,7,8,8,9,9,10,10,4,4,4,4,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,5,6,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,4,4,4,4,5,5,6,6,7,7,8,8,8,9,10,10,10,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,11,11,11,4,4,4,4,5,5,6,6,7,7,8,8,8,9,9,10,10,10,10,4,4,4,5,5,5,6,7,7,7,8,9,9,10,10,10,10,4,4,4,4,4,5,5,5,6,7,8,9,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,4,4,4,4,4,4,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,4,4,4,4,5,5,6,6,7,8,8,9,9,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,8,9,10,10,10,4,4,4,4,4,5,5,6,7,8,9,9,10,10,10,10,10,4,4,5,6,7,8,9,10,11,11,4,5,6,7,8,9,10,11,4,4,5,6,7,8,9,10,11,11,4,5,5,6,6,13,13,13,13,13,13,13,4,5,6,6,6,7,7,8,8,8,8,9,9,10,10,10,10,10,10,4,4,5,6,6,6,7,7,7,8,8,9,9,10,10,10,10,10,6,6,6,6,7,7,8,9,10,10,10,10,4,4,5,6,6,6,7,7,7,8,8,9,9,10,10,10,10,10,6,6,6,7,7,8,8,8,8,8,9,10,10,10,10,4,4,5,6,6,6,6,7,8,9,10,10,10,10,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,11,12,12,12,4,4,5,6,6,6,7,7,7,8,8,9,9,10,10,10,10,10,10,4,6,6,6,7,8,9,10,10,10,10,10,4,6,6,6,6,7,8,9,10,11,12,12,12,4,4,5,6,6,6,6,7,7,8,8,8,9,9,10,10,10,10,10,4,4,5,6,7,8,9,10,10,10,10,10,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,10,10,6,6,6,7,7,8,8,9,9,10,10,10,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,11,12,12,12,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,11,12,12,12,6,6,6,6,7,7,8,9,10,10,10,10,6,6,6,6,7,8,8,8,9,10,10,10,10,5,6,6,6,6,6,7,8,9,9,10,10,10,6,6,6,6,7,7,8,8,9,9,9,10,10,10,10,6,6,6,6,6,6,7,7,8,8,9,9,10,10,6,6,6,6,6,6,7,7,8,8,8,9,9,9,10,10,6,6,6,6,7,7,8,9,9,10,10,10,10,6,6,6,6,6,6,7,7,8,8,9,9,10,11,12,12,12,6,6,6,6,6,7,7,8,9,9,10,10,10,10,10,4,5,6,7,8,8,9,10,11,12,4,5,6,7,8,9,10,11,4,5,6,7,8,8,9,10,11,12,7,7,7,8,8,8,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,5,5,6,6,6,7,7,7,8,8,9,9,10,10,10,10,1,2,4,4,4,4,4,5,5,6,6,7,8,9,10,10,10,10,11,12,3,4,6,6,6,6,6,7,7,8,8,9,10,10,10,10,10,11,11,12,12,10,10,10,4,5,6,6,6,6,6,7,8,9,10,4,5,6,6,6,6,6,7,8,9,9,9,9,9,10,11,4,4,4,4,5,5,6,7,7,7,7,7,8,9,9,10,10,10,4,4,5,5,5,6,6,7,9,9,9,9,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,7,8,8,8,9,9,9,9,10,10,10,10,10,6,7,8,9,10,4,4,4,4,5,5,6,6,7,7,7,7,7,7,8,8,8,9,9,9,10,10,10,10,10,1,2,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,11,12,4,5,5,5,5,6,7,7,7,7,7,8,8,9,9,10,10,10,10,11,12,12,12,12,4,4,5,6,4,5,6,4,4,5,5,6,6,4,4,5,5,6,6,6,6,6,7,7,7,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,7,7,6,6,6,6,6,7,7,8,8,8,8,9,9,9,10,10,10,10,10,6,7,8,9,10,6,6,6,6,7,7,8,8,8,8,8,8,9,9,9,10,10,10,10,10,10,3,4,6,6,6,6,6,7,7,7,8,8,8,9,9,10,10,10,10,10,4,5,5,5,5,6,7,7,7,7,8,8,9,9,10,10,10,10,10,10,6,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,11,12,1,1,2,2,2,4,4,4,4,4,4,5,5,6,6,7,7,8,9,10,10,3,3,4,4,4,6,6,6,6,7,7,8,8,9,9,10,11,11,12,12,4,4,4,4,5,6,7,8,8,9,9,10,10,5,5,6,6,6,6,7,7,8,8,9,9,9,9,10,10,3,4,4,4,4,4,5,6,7,8,9,10,10,10,4,5,6,9,10,11,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,11,2,2,4,4,4,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,5,5,6,6,6,6,6,7,7,7,8,8,8,8,8,9,9,10,10,10,4,4,4,4,5,5,6,7,7,7,7,8,9,10,10,10,10,6,6,7,7,8,8,9,9,10,10,7,7,7,7,7,7,8,9,7,7,7,7,7,4,4,4,5,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,8,8,8,9,9,10,10,10,2,2,4,4,4,4,4,5,6,7,8,9,10,10,10,10,10,3,3,3,4,4,5,5,5,4,5,6,7,7,7,7,7,8,9,10,10,10,10,10,4,4,4,4,4,5,6,7,8,9,10,10,10,10,10,4,6,6,6,7,8,9,10,10,10,10,10,5,6,6,6,6,6,7,8,9,10,10,10,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,10,11,12,4,4,4,4,4,4,5,5,5,6,6,6,7,7,7,7,8,8,9,9,10,10,11,11,11,11,6,6,7,7,4,4,6,6,6,7,7,8,8,8,8,8,9,10,10,10,10,4,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,7,8,8,8,9,9,9,9,10,10,10,10,6,6,6,6,7,7,8,8,8,9,10,10,10,10,6,6,7,7,8,8,9,9,10,10,4,6,6,6,6,7,8,9,10,11,12,12,12,4,4,4,5,5,5,6,7,7,7,8,9,9,10,10,10,10,6,6,6,6,7,8,8,8,9,10,10,10,10,4,4,6,6,6,7,8,9,10,10,10,10,10,4,4,5,6,6,7,7,8,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,4,5,5,6,7,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,5,5,6,6,7,8,9,10,10,10,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,11,11,12,12,4,4,4,4,4,5,5,6,6,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,5,5,5,6,6,6,7,8,8,8,9,9,9,10,10,10,10,10,4,4,4,5,5,5,6,7,7,7,8,9,10,10,10,10,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,1,1,2,2,2,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,4,5,5,5,5,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,7,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,4,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,4,4,4,4,5,5,6,6,7,7,8,8,8,9,10,10,10,4,4,4,4,5,5,6,7,8,9,9,10,10,10,4,4,4,4,4,5,5,5,6,7,8,9,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,9,10,10,4,4,4,5,6,6,6,6,6,7,7,7,8,8,8,8,8,9,10,10,10,4,4,4,4,5,5,6,6,7,8,8,9,9,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,11,12,4,4,4,4,4,4,5,5,6,6,7,7,7,8,8,8,9,10,10,10,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,11,12,4,4,4,4,5,5,6,6,7,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,4,4,5,5,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,4,4,4,5,6,7,7,7,7,8,8,9,9,10,10,10,10,10,4,4,4,4,5,5,6,7,7,7,7,8,9,10,10,10,10,4,4,4,4,4,5,5,5,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,10,4,4,4,4,5,5,6,6,7,7,8,8,8,9,9,10,10,10,10,6,6,6,7,7,8,8,8,8,9,9,10,10,10,10,10,10,3,4,4,4,4,5,6,6,6,7,7,7,8,8,9,9,10,10,10,6,6,6,6,7,7,8,8,8,9,9,10,10,10,10,6,6,6,6,6,7,7,8,8,9,10,10,10,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,10,11,11,6,6,6,7,7,8,8,8,8,8,9,10,10,10,10,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,6,6,6,6,6,7,8,8,8,9,10,10,10,10,10,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,3,3,4,4,4,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,6,6,6,6,6,7,7,7,8,8,8,9,9,10,10,10,10,10,6,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,6,6,6,6,7,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,6,6,6,6,6,6,7,7,8,8,8,8,8,9,9,10,10,10,10,10,10,6,6,6,7,7,8,8,9,9,10,10,10,6,6,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,10,6,6,6,6,7,7,7,8,8,9,9,10,10,10,10,11,12,12,12,6,6,6,6,7,7,8,9,10,10,10,10,6,6,6,6,6,7,7,7,8,8,8,9,10,10,10,6,6,6,6,7,7,8,8,9,9,10,11,11,12,12,4,4,5,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,11,12,12,12,6,6,6,6,7,7,8,9,9,10,10,10,10,6,6,6,6,6,6,7,7,8,8,9,9,10,10,10,10,10,10,10,11,6,6,6,6,6,7,7,8,8,8,8,9,10,10,10,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,6,6,6,6,6,7,7,7,8,8,8,9,9,9,10,10,10,10,10,10,10,11,6,6,6,6,7,7,8,8,8,8,9,9,10,10,10,10,10,6,6,6,6,6,6,7,7,8,8,8,8,9,9,9,10,10,10,10,10,10,10,6,6,6,7,8,8,8,8,9,9,10,10,10,10,10,6,6,6,6,7,7,8,8,8,9,10,10,10,10,6,6,6,6,6,7,7,7,8,8,8,8,9,9,9,10,10,10,10,10,6,6,6,6,6,7,7,8,8,8,8,9,9,10,10,10,10,10};
               CopyFonts(m_CN8_PA,m_CN8_WA,m_CN8_XA,m_CN8_YA);
         }               
      }
      string GetFont(){
         return(m_Font+"-"+IntegerToString(m_FontSize));
      }
      
      void DrawPoligon(int & aXY[]){
         if(m_Filled){
         
         }
         else{
            int sz=ArraySize(aXY)-2;
               for(int i=0;i<sz;i+=2){
                  DrawLine(aXY[i],aXY[i+1],aXY[i+2],aXY[i+3]);
               }
         }
      }
      
         
};







