//+------------------------------------------------------------------+
//|                                            Skype_Test_Script.mq4 |
//|                                                        avoitenko |
//|                        https://login.mql5.com/en/users/avoitenko |
//+------------------------------------------------------------------+
#property copyright  "avoitenko"
#property link       "https://login.mql5.com/en/users/avoitenko"
#property script_show_inputs
#property strict

//--- include
#include <SkypeMQL.mqh>

//--- input parameters
input string InpSkypeName="echo123";//Skype name
input string InpTextMessage="Hello :)";//Text message
input string InpPhoneNumber="+380123456789";//Phone number
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   int err;

//--- change status to online
   SkypeSetStatus(STATUS_ONLINE);

//--- send IM
   err=SkypeSendIM(InpSkypeName,InpTextMessage,STATUS_ONLINE|STATUS_AWAY);
   if(err==ERROR_NO_ERRORS)
      printf("Sent IM to %s, message: '%s'.",InpSkypeName,InpTextMessage);
   else
      printf("Error sending IM to %s, error: '%s'.",InpSkypeName,SkypeErrorDescription(err));

//--- change status to away
   Sleep(500);
   SkypeSetStatus(STATUS_AWAY);

//--- send SMS
   err=SkypeSendSMS(InpPhoneNumber,InpTextMessage);
   if(err==ERROR_NO_ERRORS)
      printf("Sent SMS to %s, text: '%s'.",InpPhoneNumber,InpTextMessage);
   else
      printf("Error sending SMS to %s, error: '%s'.",InpPhoneNumber,SkypeErrorDescription(err));
  }

//+------------------------------------------------------------------+
