//+------------------------------------------------------------------+
//|                                                     SkypeMQL.mqh |
//|                                                        avoitenko |
//|                        https://login.mql5.com/en/users/avoitenko |
//+------------------------------------------------------------------+
#property copyright  "avoitenko"
#property link       "https://login.mql5.com/en/users/avoitenko"
#property strict

//--- skype status
#define STATUS_OFFLINE       1
#define STATUS_ONLINE        2
#define STATUS_AWAY          4
#define STATUS_DONT_DISTURB  16
#define STATUS_INVISIBLE     32

//--- skype errors
#define ERROR_UNKNOWN     -1
#define ERROR_NO_ERRORS   0
#define ERROR_ATTACH      1
#define ERROR_AUTHORIZED  2
#define ERROR_STATUS      3
#define ERROR_TIMEOUTS    4
#define ERROR_RUNNING     5
#define ERROR_SENDING     6
#define ERROR_VALUE       7
#define ERROR_ACCESS      8
#define ERROR_SKYPE4COM   9

//--- import functions
#import "SkypeMQL.dll"
int SkypeSendIM(string skype_name,string message,int status);
int SkypeSendSMS(string phone_number,string message);
int SkypeSetStatus(int status);
int SkypeGetStatus(int &status);
#import
//+------------------------------------------------------------------+
//|   SkypeErrorDescription                                          |
//+------------------------------------------------------------------+
string SkypeErrorDescription(int error)
  {
   switch(error)
     {
      case ERROR_UNKNOWN:     return("Unknown error");
      case ERROR_NO_ERRORS:   return("No error");
      case ERROR_ATTACH:      return("Do not attach");
      case ERROR_AUTHORIZED:  return("User not authorized");
      case ERROR_STATUS:      return("Wrong status");
      case ERROR_TIMEOUTS:    return("Timeout is over");
      case ERROR_RUNNING:     return("Skype is not running");
      case ERROR_SENDING:     return("Error sending");
      case ERROR_VALUE:       return("Wrong value");
      case ERROR_ACCESS:      return("Access denied");
      case ERROR_SKYPE4COM:   return("Skype4COM not registered");
      default: return("Error #"+IntegerToString(error));
     }
  }
//+------------------------------------------------------------------+
