//+------------------------------------------------------------------+
//|                                                    PriceGrid.mq5 |
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2016, Nikolay Kositsin"
//----    
#property link      "farria@mail.redcom.ru"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 0
//----    
#property indicator_plots  0
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Number
  {
   Number_0,
   Number_1,
   Number_2,
   Number_3
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+  
enum Width
  {
   Width_1=1, //1
   Width_2,   //2
   Width_3,   //3
   Width_4,   //4
   Width_5    //5
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum STYLE
  {
   SOLID_,// 
   DASH_,// 
   DOT_,// 
   DASHDOT_,//- 
   DASHDOTDOT_   //-    
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input string  SirName="PriceGrid";          //    
input uint  Digits_=2;                      // 
input uint  Total=20;                        //       
input color  Color_ = clrBlueViolet;        // 
input STYLE  Style_ = DASHDOTDOT_;          //  
input Width  Width_ = Width_1;              //   
//+----------------------------------------------+
int middle,size;
string ObjectNames[];
double Pow10,PointPow10,PriceGrid[],Price[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----       
   size=int(Total*2);
   ArrayResize(ObjectNames,size);
   ArrayResize(PriceGrid,size);
   ArrayResize(Price,size);
//----  
   for(int count=0; count<size; count++) ObjectNames[count]=SirName+" PriceLine "+string(count);
//----           
   Pow10=MathPow(10,Digits_);
   PointPow10=_Point*Pow10;
   middle=(size/2)-1;
//----           
   for(int count=middle; count<size; count++) PriceGrid[count]=+PointPow10*(count-middle);  
   for(int count=middle-1; count>=0; count--) PriceGrid[count]=-PointPow10*(middle-count);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   for(int count=0; count<size; count++) ObjectDelete(0,ObjectNames[count]);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----   
  double res=PointPow10*MathFloor(close[rates_total-1]/PointPow10);
  for(int count=0; count<size; count++) Price[count]=res+PriceGrid[count];    
  for(int count=0; count<size; count++) SetHline(0,ObjectNames[count],0,Price[count],Color_,Style_,Width_,ObjectNames[count]+DoubleToString(Price[count],_Digits));
//----
   ChartRedraw(0);
//----   
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|   ,                         |
//+------------------------------------------------------------------+
void CreateHline
(
 long   chart_id,      //  
 string name,          //  
 int    nwin,          //  
 double price,         //  
 color  Color,         //  
 int    style,         //  
 int    width,         //  
 string text           // 
 )
//---- 
  {
//----
   ObjectCreate(chart_id,name,OBJ_HLINE,0,0,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetInteger(chart_id,name,OBJPROP_STYLE,style);
   ObjectSetInteger(chart_id,name,OBJPROP_WIDTH,width);
   ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
//----
  }
//+------------------------------------------------------------------+
//|   ,                    |
//+------------------------------------------------------------------+
void SetHline
(
 long   chart_id,      //  
 string name,          //  
 int    nwin,          //  
 double price,         //  
 color  Color,         //  
 int    style,         //  
 int    width,         //  
 string text           // 
 )
//---- 
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateHline(chart_id,name,nwin,price,Color,style,width,text);
   else
     {
      //ObjectSetDouble(chart_id,name,OBJPROP_PRICE,price);
      ObjectSetString(chart_id,name,OBJPROP_TEXT,text);
      ObjectMove(chart_id,name,0,0,price);
     }
//----
  }
//+------------------------------------------------------------------+
