//+------------------------------------------------------------------+
//|                                        Price_Channel_Central.mq5 |
//|                             Copyright  2015, Yuriy Tokman (YTG) |
//|                                               http://ytg.com.ua/ |
//+------------------------------------------------------------------+
//----  
#property copyright "Yuriy Tokman (YTG)"
//----    
#property link      "http://ytg.com.ua/"
//----   
#property version   "1.00"
#property description "Price Channel Central" 
//----     
#property indicator_chart_window 
//----       5 
#property indicator_buffers 5
//----     
#property indicator_plots   5
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----   
#property indicator_label1  "Chanell Upper"
//----      
#property indicator_color1 clrLime
//----   - 
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----   
#property indicator_label2  "Chanell Middle"
//----      
#property indicator_color2 clrBlue
//----   - 
#property indicator_style2  STYLE_SOLID
//----     2
#property indicator_width2  2
//+----------------------------------------------+ 
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----   
#property indicator_label3  "Chanell Lower"
//----      
#property indicator_color3 clrRed
//----   - 
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   4   
#property indicator_type4   DRAW_ARROW
//---         
#property indicator_color4  clrMagenta
//---    4  5
#property indicator_width4  5
//---    
#property indicator_label4  "Price_Channel_Central Sell"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//---   5   
#property indicator_type5   DRAW_ARROW
//---         
#property indicator_color5  clrDodgerBlue
//---    5  5
#property indicator_width5  5
//---    
#property indicator_label5 "Price_Channel_Central Buy"
//+----------------------------------------------+ 
//|                            |
//+----------------------------------------------+ 
#define RESET 0 //        
//+----------------------------------------------+ 
//|                    |
//+----------------------------------------------+ 
input uint Bars_Count=32;
input color  Upper_color=clrTeal;
input color  Middle_color=clrBlue;
input color  Lower_color=clrRed;
//+----------------------------------------------+
//----   ,    
//----      
double LowestBuffer[];
double HighestBuffer[];
double MiddleBuffer[];
double SellBuffer[];
double BuyBuffer[];
//----      
int min_rates_total;
//----      
int ATR_Handle;
//----      
string upper_name,middle_name,lower_name;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   int ATR_Period=15;
   min_rates_total=int(MathMax(Bars_Count,ATR_Period))+1;
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//----   
   upper_name="Price_Channel_Central upper text lable";
   middle_name="Price_Channel_Central middle text lable";
   lower_name="Price_Channel_Central lower text lable";
//----          
   SetIndexBuffer(0,HighestBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,MiddleBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,LowestBuffer,INDICATOR_DATA);
   SetIndexBuffer(3,SellBuffer,INDICATOR_DATA);
   SetIndexBuffer(4,BuyBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,0.0);
//----          
   ArraySetAsSeries(LowestBuffer,true);
   ArraySetAsSeries(HighestBuffer,true);
   ArraySetAsSeries(MiddleBuffer,true);
   ArraySetAsSeries(SellBuffer,true);
   ArraySetAsSeries(BuyBuffer,true);
//----  ,    
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string shortname;
   StringConcatenate(shortname,"Price_Channel_Central(",Bars_Count,")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---   
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//----
   ObjectDelete(0,upper_name);
   ObjectDelete(0,middle_name);
   ObjectDelete(0,lower_name);
//----
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total)return(RESET);
//----    
   int limit,to_copy,bar;
   double ATR[];
//----    limit        
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+1;
//----        
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(time,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(ATR,true);
//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);
//----     
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      double HH=high[ArrayMaximum(high,bar,Bars_Count)];
      double LL=low[ArrayMinimum(low,bar,Bars_Count)];
      double MM=(HH+LL)/2;
      HighestBuffer[bar]=HH;
      LowestBuffer[bar]=LL;
      MiddleBuffer[bar]=MM;
      //---
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(close[bar]>HighestBuffer[bar+1]) BuyBuffer[bar]=low[bar]-ATR[bar]*3/8;
      if(close[bar]<LowestBuffer[bar+1]) SellBuffer[bar]=high[bar]+ATR[bar]*3/8;
     }
   SetRightPrice(0,upper_name,0,time[0],HighestBuffer[0],Upper_color,"Georgia");
   SetRightPrice(0,middle_name,0,time[0],MiddleBuffer[0],Middle_color,"Georgia");
   SetRightPrice(0,lower_name,0,time[0],LowestBuffer[0],Lower_color,"Georgia");
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|  RightPrice creation                                             |
//+------------------------------------------------------------------+
void CreateRightPrice(long chart_id,// chart ID
                      string   name,              // object name
                      int      nwin,              // window index
                      datetime time,              // price level time
                      double   price,             // price level
                      color    Color,             // Text color
                      string   Font)              // Text font
  {
//----
   ObjectCreate(chart_id,name,OBJ_ARROW_RIGHT_PRICE,nwin,time,price);
   ObjectSetInteger(chart_id,name,OBJPROP_COLOR,Color);
   ObjectSetString(chart_id,name,OBJPROP_FONT,Font);
   ObjectSetInteger(chart_id,name,OBJPROP_BACK,true);
//----
  }
//+------------------------------------------------------------------+
//|  RightPrice reinstallation                                       |
//+------------------------------------------------------------------+
void SetRightPrice(long chart_id,              // chart ID
                   string   name,              // object name
                   int      nwin,              // window index
                   datetime time,              // price level time
                   double   price,             // price level
                   color    Color,             // Text color
                   string   Font)              // Text font
  {
//----
   if(ObjectFind(chart_id,name)==-1) CreateRightPrice(chart_id,name,nwin,time,price,Color,Font);
   else ObjectMove(chart_id,name,0,time,price);
//----
  }
//+------------------------------------------------------------------+
