 //+--------------------------------------------------------------------+
//|                                          LinearRegSlope_V2_Sign.mq5 | 
//|                     Linear regression value  - time series forecast |
//|                          Linear regression value - tsf with Trigger |
//|                                                              mladen |
//|                                                                     |
//|                Modified from Linear regression value - tsf by Toshi |
//|                                     http://toshi52583.blogspot.com/ |
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2006, mladen"
#property link      "mladenfx@gmail.com"
//----   
#property version   "1.02"
//----     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        
#property indicator_color1  clrCoral
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "LinearRegSlope_V1 Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        
#property indicator_color2  clrDodgerBlue
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "LinearRegSlope_V1 Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method SlMethod=MODE_SMA; // 
input int SlLength=12; //                     
input int SlPhase=15; // ,
                      // JJMA    -100 ... +100,     ;
//  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;// 
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input int TriggerShift=1; // c   
//+----------------------------------------------+

//----      
int min_rates_total;
//----   ,    
//      
double SellBuffer[],BuyBuffer[];
//----   
int TriggerShift_,TrigShift,TrigShift_;
double SumX,Divisor;
//----   ,    
//      
int Count1[],Count2[];
double Smooth[],RegSlope[];
//----      
int ATR_Handle;
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos1
(
 int &CoArr[],//        
 int Size //     
 )
// Recount_ArrayZeroPos(count, SlLength)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+
//|                       |
//+------------------------------------------------------------------+   
void Recount_ArrayZeroPos2
(
 int &CoArr[],//        
 int Size //     
 )
// Recount_ArrayZeroPos(count, SlLength)
//+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+
  {
//----
   int numb,Max1,Max2;
   static int count=1;

   Max2=Size;
   Max1=Max2-1;

   count--;
   if(count<0) count=Max1;

   for(int iii=0; iii<Max2; iii++)
     {
      numb=iii+count;
      if(numb>Max1) numb-=Max2;
      CoArr[iii]=numb;
     }
//----
  }
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   int ATR_Period=15;
   min_rates_total=GetStartBars(SlMethod,1,SlPhase)+SlLength+TriggerShift;
   min_rates_total=int(MathMax(ATR_Period,min_rates_total))+1;
   
//----    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }

//----       
   XMA1.XMALengthCheck("SlLength", SlLength);
   XMA1.XMAPhaseCheck("SlPhase", SlPhase, SlMethod);
   if(TriggerShift>SlLength-2)
     {
      Print("   TriggerShift      SlLength-2");
      TrigShift=1;
      TrigShift_=SlLength-2;
     }
   else
     {
      TrigShift=SlLength-1-TriggerShift;
      TrigShift_=TriggerShift;
     }

//----     
   SumX=SlLength *(SlLength-1)*0.5;
   double SumXSqr=(SlLength-1.0)*SlLength *(2.0*SlLength-1.0)/6.0;
   Divisor=SumX*SumX-SlLength*SumXSqr;
   TriggerShift_=int(min_rates_total);

//----       
   ArrayResize(Count1,SlLength);
   ArrayResize(Smooth,SlLength);
   ArrayResize(Count2,TriggerShift+1);
   ArrayResize(RegSlope,TriggerShift+1);

//----   
   ArrayInitialize(Count1,0);
   ArrayInitialize(Count2,0);
   ArrayInitialize(Smooth,0.0);
   ArrayInitialize(RegSlope,0.0);
   
//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);

//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(SlMethod);
   StringConcatenate(shortname,"Linear Reg Slope(",SlLength,", ",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//---     
 IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
   
//----       
   double price_,SumY,SumXY,Intercept,Slope,ATR[1],Trigger,trend;
   static double trend_;
//----        
   int first,bar,iii;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
      trend_=0.0;
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      Smooth[Count1[0]]=XMA1.XMASeries(0,prev_calculated,rates_total,SlMethod,SlPhase,SlLength,price_,bar,false);

      SumY=0;
      SumXY=0;

      if(bar>=SlLength)
         for(iii=0; iii<SlLength; iii++)
           {
            SumY+=Smooth[Count1[iii]];
            SumXY+=iii*Smooth[Count1[iii]];
           }

      if(Divisor!=0) Slope=(SlLength*SumXY-SumX*SumY)/Divisor;
      else           Slope=EMPTY_VALUE;

      if(bar>=SlLength)
        {
         Intercept=(SumY-Slope*SumX)/SlLength;
         RegSlope[Count2[0]]=Intercept+Slope*TrigShift;
        }

      if(bar>TriggerShift_) Trigger=2.0*RegSlope[Count2[0]]-RegSlope[Count2[TriggerShift]];
      else                  Trigger=EMPTY_VALUE;
      
      //----   
      trend=RegSlope[Count2[0]]-Trigger;
      //----
      SellBuffer[bar]=0.0;
      BuyBuffer[bar]=0.0;
      //----
      if(trend_<=0 && trend>0)
        {
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0)  return(RESET);
         BuyBuffer[bar]=low[bar]-ATR[0]*3/8;
        }
      //----
      if(trend_>=0 && trend<0)
        {
         if(CopyBuffer(ATR_Handle,0,time[bar],1,ATR)<=0)  return(RESET);
         SellBuffer[bar]=high[bar]+ATR[0]*3/8;
        }
      //----
      if(bar<rates_total-1)
        {
         //----       Smooth[]
         Recount_ArrayZeroPos1(Count1,SlLength);
         //----       RegSlope[]
         Recount_ArrayZeroPos2(Count2,TriggerShift+1);
         //----   
         if(trend) trend_=trend;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
