//+------------------------------------------------------------------+
//|                                                  iFXAnalyser.mq5 |
//|                           Copyright  2006, Renato P. dos Santos |
//|                   inspired on 4xtraderCY's and SchaunRSA's ideas |
//|   http://www.strategybuilderfx.com/forums/showthread.php?t=16086 |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Renato P. dos Santos"
#property link "http://www.strategybuilderfx.com/forums/showthread.php?t=16086"
//----   
#property version   "1.00"
//----  
#property description ""
//----     
#property indicator_separate_window  
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|     1          |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1  clrBlue
//----   1 -  
#property indicator_style1  STYLE_SOLID
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "Div"
//+----------------------------------------------+
//|    2                  |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2  clrRed
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----   
#property indicator_label2  "Slope"
//+----------------------------------------------+
//|    3                  |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_LINE
//----        
#property indicator_color3  clrGreen
//----   3 -  
#property indicator_style3  STYLE_SOLID
//----    3  1
#property indicator_width3  1
//----   
#property indicator_label3  "Acel"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint                FastMAPeriod=4;
input  ENUM_MA_METHOD     FastMAType=MODE_SMA;
input ENUM_APPLIED_PRICE  FastMAPrice=PRICE_CLOSE;
input uint                SlowMAPeriod=6;
input  ENUM_MA_METHOD     SlowMAType=MODE_SMA;
input ENUM_APPLIED_PRICE  SlowMAPrice=PRICE_CLOSE;
input int    Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double Ind1Buffer[];
double Ind2Buffer[];
double Ind3Buffer[];
//----      
int min_rates_total;
//----      
int FsMA_Handle,SlMA_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//----     
   min_rates_total=int(MathMax(FastMAPeriod,SlowMAPeriod)+3);
//----    Fast iMA
   FsMA_Handle=iMA(_Symbol,PERIOD_CURRENT,FastMAPeriod,0,FastMAType,FastMAPrice);
   if(FsMA_Handle==INVALID_HANDLE)
     {
      Print("      Fast iMA");
      return(INIT_FAILED);
     }
//----    Slow iMA
   SlMA_Handle=iMA(_Symbol,PERIOD_CURRENT,SlowMAPeriod,0,SlowMAType,SlowMAPrice);
   if(SlMA_Handle==INVALID_HANDLE)
     {
      Print("      Slow iMA");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,Ind1Buffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(Ind1Buffer,true);
//----      
   SetIndexBuffer(1,Ind2Buffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(Ind2Buffer,true);
//----      
   SetIndexBuffer(2,Ind3Buffer,INDICATOR_DATA);
//----    3    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       3  min_rates_total
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(Ind3Buffer,true);
//----      
   string shortname;
   StringConcatenate(shortname,"i-iFXAnalyser(",FastMAPeriod,",",SlowMAPeriod,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(FsMA_Handle)<rates_total
      || BarsCalculated(SlMA_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----    
   int to_copy,limit,bar;
   double FsMA[],SlMA[];
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_total; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }
   to_copy=limit+3;
//----      
   if(CopyBuffer(FsMA_Handle,0,0,to_copy,FsMA)<=0) return(RESET);
   if(CopyBuffer(SlMA_Handle,0,0,to_copy,SlMA)<=0) return(RESET);
//----         
   ArraySetAsSeries(FsMA,true);
   ArraySetAsSeries(SlMA,true);
//----    
   for(bar=0; bar<limit && !IsStopped(); bar++)
     {
      Ind1Buffer[bar]=FsMA[bar]-SlMA[bar];
      double diff=FsMA[bar+1]-SlMA[bar+1];
      Ind2Buffer[bar]=Ind1Buffer[bar]-diff;
      Ind3Buffer[bar]=Ind2Buffer[bar]-diff-(FsMA[bar+2]-SlMA[bar+2]);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
