//+------------------------------------------------------------------+ 
//|                                     ForexProfitBoost_2nbSign.mq5 | 
//|                               Copyright  2015, TradeLikeaPro.ru | 
//|                                         http://tradelikeapro.ru/ | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, TradeLikeaPro.ru"
#property link "http://tradelikeapro.ru/"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_ARROW
//---        Gold 
#property indicator_color1  clrGold
//---    1  4
#property indicator_width1  4
//---    
#property indicator_label1  "ForexProfitBoost_2nb Sell"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_ARROW
//---        SpringGreen 
#property indicator_color2  clrSpringGreen
//---    2  4
#property indicator_width2  4
//---    
#property indicator_label2 "ForexProfitBoost_2nb Buy"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0    //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
//---    1
input uint   MAPeriod1=7;
input  ENUM_MA_METHOD   MAType1=MODE_EMA;
input ENUM_APPLIED_PRICE   MAPrice1=PRICE_CLOSE;
//---    2
input uint   MAPeriod2=21;
input  ENUM_MA_METHOD   MAType2=MODE_SMA;
input ENUM_APPLIED_PRICE   MAPrice2=PRICE_CLOSE;
input int Shift=0;                              //       
//+-----------------------------------+
//---      
int  min_rates_total;
//---   ,   
//---      
double SellBuffer[];
double BuyBuffer[];
//---      
int MA1_Handle,MA2_Handle,BB_Handle,ATR_Handle;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---     
   int ATR_Period=10;
   min_rates_total=int(MathMax(MAPeriod1,MAPeriod2))+1;
   min_rates_total=int(MathMax(min_rates_total,ATR_Period));
//---    iMA 1
   MA1_Handle=iMA(NULL,0,MAPeriod1,0,MAType1,MAPrice1);
   if(MA1_Handle==INVALID_HANDLE)
     {
      Print("      iMA 1");
      return(INIT_FAILED);
     }
//---    iMA 2
   MA2_Handle=iMA(NULL,0,MAPeriod2,0,MAType2,MAPrice2);
   if(MA2_Handle==INVALID_HANDLE)
     {
      Print("      iMA 2");
      return(INIT_FAILED);
     }
//---    ATR
   ATR_Handle=iATR(NULL,0,ATR_Period);
   if(ATR_Handle==INVALID_HANDLE)
     {
      Print("      ATR");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(0,PLOT_ARROW,172);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(SellBuffer,true);
//---      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---   
   PlotIndexSetInteger(1,PLOT_ARROW,172);
//---    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       
   ArraySetAsSeries(BuyBuffer,true);
//---      
   string shortname="ForexProfitBoost_2nbSign";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//---       
   if(BarsCalculated(MA1_Handle)<rates_total
      || BarsCalculated(MA2_Handle)<rates_total
      || BarsCalculated(ATR_Handle)<rates_total
      || rates_total<min_rates_total)
      return(RESET);
//---       
   double MA1[],MA2[],ATR[1];
//---   
   int limit,to_copy;
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1;  //      
   else limit=rates_total-prev_calculated;  //       
//---         
   ArraySetAsSeries(MA1,true);
   ArraySetAsSeries(MA2,true);
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
//---
   to_copy=limit+2;
//---      
   if(CopyBuffer(MA1_Handle,0,0,to_copy,MA1)<=0) return(RESET);
   if(CopyBuffer(MA2_Handle,0,0,to_copy,MA2)<=0) return(RESET);
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      BuyBuffer[bar]=0.0;
      SellBuffer[bar]=0.0;
      //---
      if(MA1[bar]>MA2[bar])
        {
         if(MA1[bar+1]<=MA2[bar+1])
           {
            //---      
            if(CopyBuffer(ATR_Handle,0,bar,1,ATR)<=0) return(RESET);
            BuyBuffer[bar]=Low[bar]-ATR[0]*3/8;
           }
        }
      else
        {
         if(MA1[bar+1]>=MA2[bar+1])
           {
            //---      
            if(CopyBuffer(ATR_Handle,0,bar,1,ATR)<=0) return(RESET);
            SellBuffer[bar]=High[bar]+ATR[0]*3/8;
           }
        }
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
